C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE NONLADV(JB, JE, DTA, DIV, PHI, UCOS, VCOS, FWS, RHS)
C                                                                              
C This procedure evaluates non-linear product and forcing terms and old
C timelevel of vorticity, divergence, geopotential for one explicit
C timestep when solving the advection equation.
C                                                                              
C called by: ADVECT
C calls: FORCE
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
C problem and algorithm parameters
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C constants and timesteps
#     include "consts.i"
C domain decomposition information
#     include "physical.i"
C time dependent fields
#     include "tdvars.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C latitude loop bounds
      INTEGER JB, JE
C timestep
      REAL DTA
C divergence field
      REAL DIV(MXLLON_P,NLVER_P,NLLAT_P,6)
C geopotential field
      REAL PHI(MXLLON_P,NLVER_P,NLLAT_P,6)
C eastward wind field (scaled by COS(THETA))
      REAL UCOS(MXLLON_P,NLVER_P,NLLAT_P)
C northward wind field (scaled by COS(THETA))
      REAL VCOS(MXLLON_P,NLVER_P,NLLAT_P)
C
C     Work Space
C
C forcing terms
      REAL FWS(NLLON_P,NLVER_P,3)
C
C     Output
C
C nonlinear terms 
      REAL RHS(MXLLON_P,NLVER_P,NLLAT_P,3)
C
C---- Local Variables --------------------------------------------------
C
C longitude, latitude, and vertical layer indices
      INTEGER I, J, JV
C
C---- Executable Statements --------------------------------------------
C 
C     Evaluate non-linear advection terms and old timelevel of
C     divergence and geopotential.
      DO J=JB,JE
        DO JV=1,NLVER_P
          DO I=1,NLLON_P
            RHS(I,JV,J,1) = UCOS(I,JV,J)*PHI(I,JV,J,LN)
            RHS(I,JV,J,2) = VCOS(I,JV,J)*PHI(I,JV,J,LN)
          ENDDO
        ENDDO
      ENDDO
C
      DO J=JB,JE
        DO JV=1,NLVER_P
          DO I=1,NLLON_P
            RHS(I,JV,J,3) = PHI(I,JV,J,LNM1) 
     &                    - DTA*PHIBAR*DIV(I,JV,J,LN)
          ENDDO
        ENDDO
      ENDDO
C
      IF (FORCED) THEN
C       Compute the geopotential forcing term.
        DO J=JB,JE
          CALL FORCE(J, FWS(1,1,1), FWS(1,1,2), FWS(1,1,3))
          DO JV=1,NLVER_P
            DO I=1,NLLON_P
              RHS(I,JV,J,3) = RHS(I,JV,J,3) + DTA*FWS(I,JV,3)
            ENDDO
          ENDDO
        ENDDO
      ENDIF
C
      RETURN
      END
