C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE COMP1(DTA, ALP, DALP, WTS, WTACSJ, ANNP1, A2NNP1, 
     &                 TRIGS, MOUNT, TOPOSC, DIV, ZETA, PHI, UCOS, 
     &                 VCOS, WS1, WS2, WS3, DIVSC, ZETASC, PHISC)
C                                                                              
C This routine selects the timestepping algorithm (semi-implicit or
C explicit) and calls the advection subroutine for test case 1.
C  
C called by: STEP
C calls: ADVECT, EXPLIC, SIMPLIC,
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
#     include "problem.i"
C constants & timesteps
#     include "consts.i"
C domain decomposition information
#     include "physical.i"
#     include "spectral.i"
C transform arrays
#     include "trnsfm.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C timestep
      REAL DTA
C associated Legendre polynomials
      REAL ALP(NFSPEC_S,NLLATH_S)
C deriv. associated Legendre polynomials
      REAL DALP(NFSPEC_S,NLLATH_S)
C Gaussian weights
      REAL WTS(NLAT)
C 1.0/(A*COS(LAT)**2)
      REAL WTACSJ(NLAT)
C A/(N*(N+1))
      REAL ANNP1(0:KK)
C (N*(N+1))/A**2
      REAL A2NNP1(0:KK)
C trigonometric function values used by RFTLON 
      COMPLEX TRIGS(NTRIGS)
C mountain height
      REAL MOUNT(NLLON_P,NLLAT_P)
C spectral coefficients of mountains
      COMPLEX TOPOSC(MXLSPEC_S)
C
C     Input/Output
C
C divergence field
      REAL DIV(MXLLON_P,NLVER_P,NLLAT_P,6)
C vorticity field
      REAL ZETA(MXLLON_P,NLVER_P,NLLAT_P,6)
C geopotential field
      REAL PHI(MXLLON_P,NLVER_P,NLLAT_P,6)
C eastward wind field (scaled by COS(THETA))
      REAL UCOS(MXLLON_P,NLVER_P,NLLAT_P)
C northward wind field (scaled by COS(THETA))
      REAL VCOS(MXLLON_P,NLVER_P,NLLAT_P)
C
C     Work Space
C
C work array 1
C (big enough for REAL (MXLLON_P,NLVER_P,NLLAT_P,8) 
C             and COMPLEX (MXLFC_S,NLVER_S,NLLAT_S,8)
C             and COMPLEX (4,MXLSPEC_S,NLVER_S))
      REAL WS1(1)
C work array 2
C (big enough for REAL (MXLLON_P,MXLVER_P,MXLLAT_P,8,BUFSWS2) 
C             and REAL (MXLLON_F,MXLVER_F,MXLLAT_F,8,BUFSWS2) 
C             and COMPLEX (MXLFC_S,MXLVER_S,MXLLAT_S,8,BUFSWS2) 
C             and REAL (NLLON_P,NLVER_P,3) or
C             and COMPLEX (16,MXLFC_S,NLVER_S,NLLATH_S)
C             and REAL (0:KK,3))
      REAL WS2(1)
C work array 3
C (big enough for COMPLEX (MXLSPEC_S,NLVER_S,3,BUFSWS3))
      REAL WS3(1)
C
C     Output
C
C computed divergence at new timelevel
      COMPLEX DIVSC(MXLSPEC_S,NLVER_S)
C computed vorticity new timelevel
      COMPLEX ZETASC(MXLSPEC_S,NLVER_S)                        
C computed geopotential new timestep
      COMPLEX PHISC(MXLSPEC_S,NLVER_S)                        
C
C---- Executable Statements --------------------------------------------
C
      IF (SITS) THEN
C       semi-implicit timestepping
        CALL SIMPLIC(DTA, ALP, DALP, WTS, WTACSJ, ANNP1, A2NNP1, 
     &               TRIGS, MOUNT, TOPOSC, DIV, ZETA, PHI, UCOS, 
     &               VCOS, WS1, WS2, WS3, DIVSC, ZETASC, PHISC)
      ELSE
C       explicit timestepping
        IF (ICOND .EQ. 1) THEN
C         advection equation
          CALL ADVECT(DTA, ALP, DALP, WTS, WTACSJ, TRIGS,
     &                DIV, PHI, UCOS, VCOS, WS1, WS2, WS3, PHISC)
        ELSE
C         full equations 
          CALL EXPLIC(DTA, ALP, DALP, WTS, WTACSJ, ANNP1, A2NNP1, 
     &                TRIGS, MOUNT, TOPOSC, DIV, ZETA, PHI, UCOS, 
     &                VCOS, WS1, WS2, WS3, DIVSC, ZETASC, PHISC)
        ENDIF
      ENDIF
C
      RETURN
      END

