C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"                                                 
C#######################################################################
      SUBROUTINE ADVECT(DTA, ALP, DALP, WTS, WTACSJ, TRIGS, DIV, PHI, 
     &                  UCOS, VCOS, WS1, WS2, WS3, PHISC)
C                                                                              
C This is the main computational procedure for one explicit timestep
C when solving the advection equation. Timestepping is calculated  
C for the prognostic variable geopotential using leapfrog timestepping 
C with a spectral transform algorithm. The old timelevel is LNM1, the 
C derivative is evaluated at timelevel LN, and the computed values go 
C into timelevel LNP1.
C
C The nonlinear products and forcing terms (for test case 4) are 
C evaluated at the gridpoints by routine NONLADV. A real Fourier 
C transform (RFTLON) is then used for each latitude and vertical layer.
C The new timelevel spectral coefficients are computed by the routine 
C FTRNPE. The routine ITRNPE computes the grid U,V wind fields from 
C divergence and vorticity spectral coefficients and inverse transforms 
C the prognostic variables to gridpoint space. An Asselin filter can be
C also be used to prevent modal splitting.
C                                                                              
C called by: COMP1
C calls: NONLADV, RFTLON, FTRNPE, ITRNPE
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
#     include "problem.i"
C constants & timesteps
#     include "consts.i"
C domain decomposition information
#     include "physical.i"
#     include "spectral.i"
C time dependent fields
#     include "tdvars.i"
C transform arrays
#     include "trnsfm.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C timestep
      REAL DTA
C associated Legendre polynomials
      REAL ALP(NFSPEC_S,NLLATH_S)
C deriv. associated Legendre polynomials
      REAL DALP(NFSPEC_S,NLLATH_S)
C Gaussian weights
      REAL WTS(NLAT)
C 1.0/(A*COS(LAT)**2)
      REAL WTACSJ(NLAT)
C trigonometric function values used by RFTLON 
      COMPLEX TRIGS(NTRIGS)
C
C     Input/Output
C
C divergence field
      REAL DIV(MXLLON_P,NLVER_P,NLLAT_P,6)
C geopotential field
      REAL PHI(MXLLON_P,NLVER_P,NLLAT_P,6)
C eastward wind field (scaled by COS(THETA))
      REAL UCOS(MXLLON_P,NLVER_P,NLLAT_P)
C northward wind field (scaled by COS(THETA))
      REAL VCOS(MXLLON_P,NLVER_P,NLLAT_P)
C
C     Work Space
C
C work array 1
C (big enough for REAL (MXLLON_P,NLVER_P,NLLAT_P,3)
C             and COMPLEX (MXLFC_S,NLVER_S,NLLAT_S,3))
      REAL WS1(1)
C work array 2
C (big enough for REAL (MXLLON_P,MXLVER_P,MXLLAT_P,3,BUFSWS2)
C             and REAL (MXLLON_F,MXLVER_F,MXLLAT_F,3,BUFSWS2)
C             and COMPLEX (MXLFC_S,MXLVER_S,MXLLAT_S,3,BUFSWS2)
C             and REAL (NLLON_P,NLVER_P,3)
C             and COMPLEX (4,MXLFC_S,NLVER_S,NLLAT_S,3))
      REAL WS2(1)
C work array 3
C (big enough for COMPLEX (MXLSPEC_S,NLVER_S,BUFSWS3)
C             and REAL (NLLON_P,NLVER_P))
      REAL WS3(1)
C
C     Output
C
C computed geopotential new timestep
      COMPLEX PHISC(MXLSPEC_S,NLVER_S)                        
C
C---- Local Variables --------------------------------------------------
C
C latitude, vertical layer, and longitude indices
      INTEGER J, JV, I
C Asselin filter coefficient
      REAL FAC
C
C---- Executable Statements --------------------------------------------
C
C     Evaluate non-linear product and forcing terms 
C     and old timelevel of vorticity, divergence, and geopotential.
C     (results in WS1)
      CALL TRACEEVENTF('entry', 1, 1, NSTEP)
        CALL NONLADV(1, NLLAT_P, DTA, DIV, PHI, UCOS, VCOS, WS2, WS1)
      CALL TRACEEVENTF('exit', 1, 1, NSTEP)
C
C     Fourier transform non-linear terms in place.
C     (results in WS1)
      CALL TRACEEVENTF('entry', 2, 1, NSTEP)
        CALL RFTLON(-1, 3, TRIGS, WS2, WS1)
      CALL TRACEEVENTF('exit', 2, 1, NSTEP)
C
C     Evaluate the right hand side of the shallow water equations            
C     for the geopotential prognostic equation.
C     (data in WS1)
      CALL TRACEEVENTF('entry', 3, 1, NSTEP)
        CALL FTRNPE(DTA, ALP, DALP, WTS, WTACSJ, WS1, WS2, WS3, PHISC)
      CALL TRACEEVENTF('exit', 3, 1, NSTEP)
C
C     Compute first half of Asselin filter.
      CALL TRACEEVENTF('entry', 5, 1, NSTEP)
        IF (AFC .NE. 0.0) THEN
          FAC = 1.0 - 2.0*AFC
          DO J=1,NLLAT_P
            DO JV=1,NLVER_P
              DO I=1,NLLON_P
                PHI(I,JV,J,LN) = FAC*PHI(I,JV,J,LN) 
     &                         + AFC*PHI(I,JV,J,LNM1) 
              ENDDO
            ENDDO
          ENDDO
        ENDIF
      CALL TRACEEVENTF('exit', 5, 1, NSTEP)
C
C     Transform advected geopotential back to grid space:
C      1) inverse Legendre transform
C      2) inverse FFT
      CALL TRACEEVENTF('entry', 6, 1, NSTEP)
        CALL ITRNPE(ALP, PHISC, WS3, PHI(1,1,1,LNP1))
      CALL TRACEEVENTF('exit', 6, 1, NSTEP)
C
      CALL TRACEEVENTF('entry', 7, 1, NSTEP)
        CALL RFTLON(+1, 1, TRIGS, WS2, PHI(1,1,1,LNP1))
      CALL TRACEEVENTF('exit', 7, 1, NSTEP)
C
C     Compute second half of Asselin filter.
      CALL TRACEEVENTF('entry', 8, 1, NSTEP)
        IF (AFC .NE. 0.0) THEN
          DO J=1,NLLAT_P
            DO JV=1,NLVER_P
              DO I=1,NLLON_P
                PHI(I,JV,J,LN) = PHI(I,JV,J,LN) 
     &                         + AFC*PHI(I,JV,J,LNP1) 
              ENDDO
            ENDDO
          ENDDO
        ENDIF
      CALL TRACEEVENTF('exit', 8, 1, NSTEP)
C
      RETURN
      END
