       SUBROUTINE DOALL(N,NFLOP,KPOLRP)
C
C *************************************************************
C     N     - VECTOR LENGTH
C     NFLOP  - NUMBER OF VECTOR OPS TIMED
C -------------------------------------------------------------
C
        INTEGER N, NFLOP, KPOLRP
C
        INTEGER NNMAX
        PARAMETER(NNMAX=10000)
	INTEGER I,JPOLRP,K
        COMMON /SHDATA/ A(NNMAX),B(NNMAX)
        REAL*8 A,B
        COMMON /COEFFS/ S0,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11
        REAL*8 S0,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11
C
C The Computed GOTO is used here deliberately so as
C to keep the overhead of entering each alternative as nearly 
C the same as possible. The prospect of searching down a chain of
C IF-THEN-ELSEs seemed too hard on the last alternative.
C
         K=NFLOP/2
         GOTO (1,2,3,4,5,6,7,8,9,10),K
C
C        IF (NFLOP .EQ. 2) THEN
C
 1       CONTINUE
         DO 110 I=1,N
           A(I)=S0+B(I)*S1
  110    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 4) THEN
C
 2       CONTINUE
         DO 210 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*S2)
  210    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 6) THEN
C
 3       CONTINUE
         DO 310 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*S3))
  310    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 8) THEN
C
 4       CONTINUE
         DO 410 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)*S4)))
  410    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 10) THEN
C
 5       CONTINUE
         DO 510 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*S5
     2                             ))))
  510    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 12) THEN
C
 6       CONTINUE
         DO 610 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*S6
     2                             )))))
  610    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 14) THEN
C
 7       CONTINUE
         DO 1210 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                 *S7
     2                             ))))))
 1210    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 16) THEN
C
 8       CONTINUE
         DO 1810 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                 *(S7+B(I)*S8
     2                             )))))))
 1810    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 18) THEN
C
 9       CONTINUE
         DO 2410 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                 *(S7+B(I)*(S8+B(I)*S9
     2                             ))))))))
 2410    CONTINUE
         RETURN
C
C        ELSEIF (NFLOP .EQ. 20) THEN
C
 10      CONTINUE
C  Repeat 10th order polynomial KPOLRP times
        DO 3010 JPOLRP=1,KPOLRP
        CALL DUMMY(JPOLRP) 
        DO 3010 I=1,N
           A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                 *(S7+B(I)*(S8+B(I)*(S9+B(I)
     1                 *S10
     2                             )))))))))
 3010    CONTINUE
         RETURN
C
C   end of IF-NFLOP alternatives
C       ENDIF
C
C       RETURN
        END
