      PROGRAM POLY1
C
      INCLUDE 'poly1.inc'
C
C     =================================================
C     ===                                           ===
C     ===   Program:  In-cache (r-hat f-half)       ===
C     ===   Version:  Standard Fortran 77           ===
C     ===   Author:   Roger Hockney                 ===
C     ===                                           ===
C     =================================================
C
C     /* Program name */
      CHARACTER*10  NAME 
      DATA NAME /'POLY1'/
C
C     /* Timer routine */
C
      EXTERNAL DWALLTIME00
      REAL*8 DWALLTIME00
C
C     /* maximum length of arrays */
C
      INTEGER NNMAX
      PARAMETER(NNMAX=10000)
C
      COMMON /SHDATA/ A(NNMAX),B(NNMAX),C(NNMAX),D(NNMAX)
      REAL*8 A,B,C,D
C
      COMMON /PARM/ IOUT,NMAX,T0,NTIMES,NTIM,KFSEL,NP,NREPT,NSEL
      INTEGER IOUT,NMAX,NTIMES,NTIM,KFSEL,NP,NREPT,NSEL
      REAL*8 T0
C
      CHARACTER*80 LABEL
      INTEGER I,ICASE,MREF,N,NCASE,NFLOP
      REAL*8 FHALF,FRAT(50),PER,RHAT,RINF,RLAST(50),RMFLPS,
     &                 S12,ST0,STIME,T1,T2,T10,T11,TN,TOTIME,X,XN,
     &                 XN12,XNLAST(50),Y
C
      NTIMES=1000000
      IOUT=11
      NCASE=1
      NMAX=10000
      NREPT=NITER
C
C     %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C
      OPEN(IOUT, FILE = 'poly1.res')
      REWIND(IOUT)
C
      CALL HEADER(IOUT,NAME)
C
      PRINT *
      PRINT *,'      POLY1:  In-cache Test'
      PRINT *,'      ---------------------'
      PRINT *
      WRITE(6,347) 
  347 FORMAT(' This benchmark tests severity of memory bottlenecks',/,
     1 ' by varying the amount of arithmetic per memory reference',/,
     1 ' which is called the computational intensity of the loop.',//,
     1 ' The performance for long loop (vector) lengths, RINF, is',/,
     2 ' represented as :',//,
     3 '                RINF = RHAT/(1 + FHALF/F)',//,
     4 ' where   RHAT = peak Mflop/s rate of arithmetic pipeline',/,
     4 '                approached as F goes to infinity',/,
     5 '   and      F = computational intensity',/,
     6 '              = ratio floating operations/memory references',/,
     7 '        FHALF = F required to obtain RINF=RHAT/2',//,
     8 ' The loop executed is polynomial evaluation by Horners rule,',/,
     9 ' F varies as the order increases from 1 to 10.')
      PRINT *,'      ---------------------'
      PRINT *
C
      WRITE(6,*)
      WRITE(6,*)'The calculation is in progress.  Please, wait...'
      WRITE(6,*)
C
C     INITIALIZE TIMER
C
      T0 = 0.0
      T1 = 0.0
      T2 = 0.0
C
      CALL SATIME
      T10 = DWALLTIME00()
C
C     INITIALIZE ARRAYS :
C
      DO 30 I=1,NMAX
         A(I)=5.842*I
         B(I)=3.9675*I
         C(I)=4.5693/I
         D(I)=3.3671/I
30    CONTINUE
C
      ICASE=1
      NP=1
C
      WRITE(IOUT,997)NP
  997 FORMAT(/,
     2  1X,'       -------------------------------',/,
     3  1X,'       POLY1: FHALF and RHAT In-cache',/,
     4  1X,'       -------------------------------',/,
     5  1X,'                 Result Summary       ',/,
     6  1X,'                 --------------       ',//,
     7  1X,'       Number of processes = ',I6,//,
     8  1X,'       -------------------------------',/)
C
C     /* Polynomial Evaluation by Horners Rule */
C
      LABEL='POLYNOMIALS :  A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*S3))'
C
      WRITE(IOUT,667)LABEL,ICASE,NCASE,NMAX,NTIMES,NP
667   FORMAT(///,3X,A80,/,3X,'ICASE=',I4,3X,'NCASE=',I4,3X,
     1         'NMAX=',I6,3X,'NTIMES=',I8,6X,'NP=',I3)
C
      DO 21 KFSEL=1,10,1
        IF(KFSEL .EQ. 1) NFLOP=2
        IF(KFSEL .EQ. 2) NFLOP=4
        IF(KFSEL .EQ. 3) NFLOP=6
        IF(KFSEL .EQ. 4) NFLOP=8
        IF(KFSEL .EQ. 5) NFLOP=10
        IF(KFSEL .EQ. 6) NFLOP=12
        IF(KFSEL .EQ. 7) NFLOP=14
        IF(KFSEL .EQ. 8) NFLOP=16
        IF(KFSEL .EQ. 9) NFLOP=18
        IF(KFSEL .EQ. 10)NFLOP=20
C
        MREF=2
        FRAT(KFSEL)=NFLOP/MREF
C
        WRITE(IOUT,345)
345     FORMAT(1X,//)
C
        WRITE(IOUT,*) 'COMPUTATIONAL INTENSITY = flop per mem ref',
     2                 FRAT(KFSEL)
        WRITE(IOUT,*) '------------------------------------------'
C
        WRITE(IOUT,346) NFLOP,MREF
 346    FORMAT(1X,/,'Floating operations per iteration =',I4,//,
     1              'Memory references   per iteration =',I4)
C
C       INITIALIZE LEAST SQUARES
C
        CALL LSTSQ(0,XN,TN,RINF,XN12,PER)
C
        WRITE(IOUT,668)
668     FORMAT(//,2X,'LOOP',7X,'LOOP',8X,'RINF',8X,
     1      'N1/2',7X,'S1/2',
     1    5X,'ERROR',4X,'R-AVERAGE',6X,'T0',6X,'NTIM',
     2     /,1X,'LENGTH',6X,'SECS',7X,'MFLOP/S',4X,'VEC.LEN',6X,'FLOP',
     3       7X,'%',7X,'MFLOP/S',6X,'SECS',4X,'repeat')
C
       DO 20 NSEL=1,12,1

C
C        SELECT VECTOR LENGTH
C
         IF (NSEL .EQ. 1) N=1
         IF (NSEL .EQ. 2) N=5
         IF (NSEL .EQ. 3) N=10
         IF (NSEL .EQ. 4) N=20
         IF (NSEL .EQ. 5) N=50
         IF (NSEL .EQ. 6) N=100
         IF (NSEL .EQ. 7) N=200
         IF (NSEL .EQ. 8) N=300
         IF (NSEL .EQ. 9) N=400
         IF (NSEL .EQ. 10) N=600
         IF (NSEL .EQ. 11) N=800
         IF (NSEL .EQ. 12) N=1000
         IF (N .GT. NMAX) GOTO 20
C
C        TIME VECTOR OPERATION
C
         CALL DOALL(ICASE,N,TN,NFLOP)
C
C        /* ESCAPE IF VECTOR TOO LONG */
C
         IF (N .EQ.0) GOTO 20
C
C        /* UPDATE LEAST SQUARES */
C
         XN=N
         CALL LSTSQ(1,XN,TN,RINF,XN12,PER)
C
C        /* CONVERT TO MFLOP/S */
C
         RINF=RINF*1.0E-6
C
C        /* AVERAGE MFLOP/S */
C
         RMFLPS= N/TN*1.0E-6
CCC          SFLOP = NFLOP*N
         S12   = NFLOP*XN12
         STIME = NFLOP*TN
         ST0   = 0.0
         IF(RINF .NE. 0.0) ST0 = (S12/RINF)*1.0E-06
         IF(NSEL .EQ. 1) ST0 = STIME
C
         WRITE(IOUT,100) N,STIME,RINF,XN12,S12,PER		
     2                  ,RMFLPS,ST0,NTIM
100      FORMAT(1X,I6,1PE12.3,0PF12.6,F12.3,1PE12.3,F7.2,
     1        0PF12.6,1PE12.3,I8)
C
C        /* END OF NSEL LOOP */
C
20    CONTINUE
C
      RLAST(KFSEL)=RINF
      XNLAST(KFSEL)=XN12
C
C     /* END OF KFSEL LOOP */
C
21    CONTINUE
C
C     /* Work out f-half */
C     /* INITIALIZE LEAST SQUARES - first */
C
      CALL LSTSQ(0,X,Y,RHAT,FHALF,PER)
C
      WRITE(IOUT,401)
401   FORMAT(//,'     CALCULATION OF FHALF',/,
     1              '     --------------------',//,
     2    1X,'  F  ',7X,'RINF',8X,' RHAT  ',2X,'  FHALF  ',2X,
     3    'ERROR',/,2X,'f/m',6X,'Mflop/s',6X,'Mflop/s',3X,
     4    'flop/mref',4X,'%')
C
      DO 41 KFSEL=1,10
         Y=FRAT(KFSEL)/RLAST(KFSEL)
         X=FRAT(KFSEL)
C
C        /* UPDATE LEAST SQUARES*/
C
         CALL LSTSQ(1,X,Y,RHAT,FHALF,PER)
         WRITE(IOUT,400) FRAT(KFSEL),RLAST(KFSEL),RHAT,FHALF,PER        
400      FORMAT(1X,F4.1,1X,0PF12.6,1X,0PF12.6,1X,F9.4,1X,F7.2)
41    CONTINUE
C
      WRITE(IOUT,402) RHAT,FHALF
402   FORMAT(///10X,'LAST VALUES :    RHAT =',0PF12.6,' Mflop/s',//,
     1         10X,'                FHALF =',F12.4,' flop/mref')
C 
      T11 = DWALLTIME00()
C
      TOTIME=T11-T10
      WRITE(IOUT,25) TOTIME
25    FORMAT(//,5X,'TOTAL EXECUTION TIME IS ',1PE20.10,' SECONDS.')
C
      CLOSE(IOUT)
C
      PRINT *,'Benchmark completed.'
C
      STOP
      END
