       SUBROUTINE DOALL(ICASE,N,TN,NFLOP)
C
C **********************************************************************
C
C     ICASE - CASE NUMBER, INPUT PARAM
C     N     - VECTOR LENGTH
C     TN    - TIME PER VECTOR OPERATION, OUTPUT PARAM
C     NFLOP  - NUMBER OF VECTOR OPS TIMED
C
C ----------------------------------------------------------------------
C
      INTEGER ICASE,N,NFLOP
      REAL*8 TN
C
      EXTERNAL DWALLTIME00
      REAL*8 DWALLTIME00
C
      INTEGER NNMAX
      PARAMETER(NNMAX=10000)
C
      COMMON /SHDATA/ A(NNMAX),B(NNMAX),C(NNMAX),D(NNMAX)
      REAL*8 A,B,C,D
C
      COMMON /PARM/ IOUT,NMAX,T0,NTIMES,NTIM,KFSEL,NP,NREPT,NSEL
      INTEGER IOUT,NMAX,NTIMES,NTIM,KFSEL,NP,NREPT,NSEL
      REAL*8 T0
C
      INTEGER I,JT
      REAL*8 S,S0,S1,S2,S3,S4,S5,S6,S7,S8,S9,S10,S11,
     &                 T1,T2,T10,T11,TS
C
C     /* SELECT REPEAT*/			
C
      NTIM=NTIMES/(NFLOP*N)
      IF(NTIM .LT. 1) NTIM=1
C
C     /* inserted to avoid compiler warning of 'not used' */
C
      T10=0.0
      T11=0.0
C
      IF (N .EQ. 0) RETURN
C
C     /* Measure overhead */
C
      T1 = DWALLTIME00()
      DO 16 JT=1,NTIM
        CALL DUMMY(JT)
16    CONTINUE
      T2 = DWALLTIME00()
      T0=T2-T1
C
C     /* Time loop for one  CPU only */
C
      S0=3.12
      S1=2.13
      S2=1.65
      S3=8.32
      S4=1.76
      S5=3.09
      S6=1.82
      S7=2.41
      S8=3.69
      S9=4.11
      S10=8.51
      S11=1.66
C
      IF (NFLOP .EQ. 2) THEN
C
        T1 = DWALLTIME00()
        DO 116 JT=1,NTIM
          CALL DUMMY(JT)
          DO 110 I=1,N
            A(I)=S0+B(I)*S1
110       CONTINUE
116     CONTINUE
        T2 = DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 4) THEN
C
        T1 = DWALLTIME00()
        DO 216 JT=1,NTIM
          CALL DUMMY(JT)
           DO 210 I=1,N
             A(I)=S0+B(I)*(S1+B(I)*S2)
210        CONTINUE
216     CONTINUE
        T2 = DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 6) THEN
C
         T1 = DWALLTIME00()
         DO 316 JT=1,NTIM
           CALL DUMMY(JT)
           DO 310 I=1,N
             A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*S3))
310        CONTINUE
316      CONTINUE
         T2 = DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 8) THEN
C
         T1 = DWALLTIME00()
         DO 416 JT=1,NTIM
           CALL DUMMY(JT)
           DO 410 I=1,N
             A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)*S4)))
410        CONTINUE
416      CONTINUE
         T2 = DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 10) THEN
C
          T1 = DWALLTIME00()
          DO 516 JT=1,NTIM
            CALL DUMMY(JT)
            DO 510 I=1,N
               A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*S5))))
510         CONTINUE
516       CONTINUE
          T2 = DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 12) THEN
C
         T1 = DWALLTIME00()
         DO 616 JT=1,NTIM
           CALL DUMMY(JT)
           DO 610 I=1,N
             A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                 *(S4+B(I)*(S5+B(I)*S6)))))
610        CONTINUE
616      CONTINUE
         T2 = DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 14) THEN
C
         T1 = DWALLTIME00()
         DO 1216 JT=1,NTIM
           CALL DUMMY(JT)
           DO 1210 I=1,N
             A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                   *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                    *S7))))))
1210       CONTINUE
1216     CONTINUE
         T2 =  DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 16) THEN
C
         T1 = DWALLTIME00()
         DO 1816 JT=1,NTIM
           CALL DUMMY(JT)
           DO 1810 I=1,N
             A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                   *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                   *(S7+B(I)*S8)))))))
1810       CONTINUE
1816     CONTINUE
         T2 = DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 18) THEN
C
         T1 = DWALLTIME00()
         DO 2416 JT=1,NTIM
           CALL DUMMY(JT)
           DO 2410 I=1,N
             A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                   *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                   *(S7+B(I)*(S8+B(I)*S9))))))))
2410       CONTINUE
2416     CONTINUE
         T2 = DWALLTIME00()
C
      ELSEIF (NFLOP .EQ. 20) THEN
C
         T1 = DWALLTIME00()
         DO 3016 JT=1,NTIM
           CALL DUMMY(JT)
           DO 3010 I=1,N
             A(I)=S0+B(I)*(S1+B(I)*(S2+B(I)*(S3+B(I)
     1                   *(S4+B(I)*(S5+B(I)*(S6+B(I)
     1                   *(S7+B(I)*(S8+B(I)*(S9+B(I)
     1                   *S10)))))))))
3010       CONTINUE
3016    CONTINUE
        T2 = DWALLTIME00()
C
C       /* end if NFLOP alternatives */
C
      ENDIF
C
C     /*   Total flops in loop, S */
C

      S=N*NFLOP
C
C     /* Average loop time, TS */
C
      TS=((T2-T1)-T0)/NTIM
C
C     /* Convert to time per vector operation */
C
      TN=TS/NFLOP
C
      RETURN
      END
