      PROGRAM COMMS1

      INCLUDE 'fpvm3.h'
      INCLUDE 'dattyp.inc'
      INCLUDE 'comms1.inc'

C     =================================================
C     ===                                           ===
C     ===   Program:  Message Pingpong              ===
C     ===   Version:  PVM3 + Fortran 77             ===
C     ===                                           ===
C     =================================================

C     /* Program name */
      CHARACTER*10  NAME 
      DATA NAME /'comms1_pvm'/


C     /* Timer and result file placement routines */
      EXTERNAL DWALLTIME00
      REAL*8 DWALLTIME00
C
C     PVM Variables:
C
      CHARACTER*6  GROUP
      DATA GROUP   /'comms1'/

      INTEGER I, INFO, ME, MYTID, TIDS(0:MAXNOD)
C     /* Maximum message length and unit number of output file */
      INTEGER NMAX, NW1
      PARAMETER(NMAX=MAXLEN/IDPLEN, NW1=11)
C     /* Logical unit number for message length defining file */
      INTEGER IOLDEF
      PARAMETER(IOLDEF=10)
      CHARACTER*20  INFILE 
      DATA INFILE /'comms1.dat'/
C     /* Number of nodes, slave node, max length of short messages */
      INTEGER NNODES,NSLAVE,NSBYTE
C     /* Number of test cases, their lengths, and current case */
      INTEGER NTESTS, LEN(MAXTST), ILEN
      INTEGER NCASE, NREPT
C     /* Ignore zero length messages in least squares fitting? */
      LOGICAL USE0
      INTEGER IUSE0
C     /* Measurement time for each test case and estimated loop overhead */
      REAL*8 MTIME, EOVER
C     /* Estimated R-infinity and startup time */
      REAL*8 ERINF, ESTART
C     /* TN is measured average time to send message of length XN */
      REAL*8 XN, TN, RINF, XN12, PER
C     /* Timer overhead, start time and stop time */
      REAL*8 T0, T1, T2, T3, T4
C     /* Array to send to the slave + checker value*/
      REAL*8 A(NMAX), DVAL
      REAL*8 RMBPS(2),XNHALF(2),TSTART(2)


c     This call launches all processes (if necessary)
c     and distributes the variables NNODES, ME, MYTID, TIDS

      call launch(NAME, GROUP, IOLDEF, INFILE, MAXNOD,
     &                  NNODES, ME, MYTID, TIDS)


C     Read in data and Broadcast them

      IF( ME .EQ. 0 ) THEN  

         CALL GETOPT(IOLDEF,INFILE,NNODES,NSLAVE,NSBYTE,USE0,MTIME,
     &        MAXLEN,INFO)
         IF (INFO .LT. 0) THEN
            CALL PVMFEXIT(INFO)
            STOP
         ENDIF

         CALL GETLEN(IOLDEF, INFILE, LEN, NTESTS, MAXLEN, MAXTST)
         IF (NSBYTE .NE. 0) CALL ADDLEN(LEN, NTESTS, NSBYTE, MAXTST)

C
C     /* Define IUSE0, to avoid the hassle of having an extra */
C     /* parameter defining the number of bytes in a LOGICAL   */
C     /* variable, so could send USE0 */
C
         IUSE0=0
         IF (USE0) IUSE0=1

C     /* Send NSLAVE to each node */
C     /* Send NSBYTE to each node */
C     /* Send number of test cases to each node */
C     /* Send IUSE0 to each node */
C     /* Send the lengths of each test case to each node */
C     /* Send the value of MTIME to each node */

         CALL PVMFINITSEND(PVMDEFAULT,INFO )
         CALL PVMFPACK(ITYPE,NSLAVE,1,1,INFO)
         CALL PVMFPACK(ITYPE,NSBYTE,1,1,INFO)
         CALL PVMFPACK(ITYPE,NTESTS,1,1,INFO)
         CALL PVMFPACK(ITYPE,IUSE0,1,1,INFO)
         CALL PVMFPACK(ITYPE,LEN,NTESTS,1,INFO)
         CALL PVMFPACK(DTYPE,MTIME,1,1,INFO)
         CALL PVMFMCAST(NNODES,TIDS,1,INFO)
C
         PRINT *,'Messages sent...benchmark progressing...'
C
      ELSE

         CALL PVMFRECV(TIDS(0),1,INFO)
         CALL PVMFUNPACK(ITYPE,NSLAVE,1,1,INFO)
         CALL PVMFUNPACK(ITYPE,NSBYTE,1,1,INFO)
         CALL PVMFUNPACK(ITYPE,NTESTS,1,1,INFO)
         CALL PVMFUNPACK(ITYPE,IUSE0,1,1,INFO)
         CALL PVMFUNPACK(ITYPE,LEN,NTESTS,1,INFO)
         CALL PVMFUNPACK(DTYPE,MTIME,1,1,INFO)
C
C        /* Define USE0 after receiving IUSE0 */
C
         USE0 = .FALSE.
	 IF (IUSE0 .EQ. 1) USE0 = .TRUE.
C
      ENDIF

C     ======================

      IF( ME.EQ.0 ) THEN

C        /* Initialize least squares fit */

         CALL LSTSQ(0,XN,TN,RINF,XN12,PER)

C        /* Call the timer routine to make sure it's initialised */

         T1 = DWALLTIME00()
         PRINT *,'Estimating loop overhead...'
         CALL ESTOV(EOVER,MTIME)
         PRINT *,'Estimated loop overhead = ',EOVER,' seconds'
         PRINT *
         PRINT *,'Estimating communication parameters...'
      ENDIF

      IF( ME.EQ.0 .OR. ME.EQ.NSLAVE ) THEN
         CALL ESTCOM(ERINF,ESTART,EOVER,MTIME,
     &               MYTID,TIDS(0),TIDS(NSLAVE),A)
      ENDIF

      IF( ME.EQ.0 ) THEN
         PRINT *,'Estimated R-infinity    = ',ERINF/1.0E6,' Mbyte/s'
         PRINT *,'Estimated start up time = ',ESTART,' seconds'
         PRINT *
      ENDIF

C     ======================

      IF( ME.EQ.0 ) THEN      
         OPEN(NW1,FILE='comms1.res')

C        /* Print header */

         CALL HEADER(NW1,NAME)
         WRITE(NW1,981) MTIME
  981    FORMAT(' The measurement time requested for each test',
     &         ' case was ',1P,E9.2,' seconds.')
         IF(NSBYTE .NE. 0) THEN
            WRITE(NW1,995) NSBYTE
  995       FORMAT(/,' SHORT MESSAGES  <= ',I6,'B (B=Byte)')
         ELSE
            WRITE(NW1,980)
  980       FORMAT(/,' No distinction was made between ',
     &             'long and short messages.')
         ENDIF
         IF(USE0) THEN
            WRITE(NW1,982)
  982       FORMAT(/,' Zero length messages were used in',
     &             ' least squares fitting.')
         ELSE
            WRITE(NW1,983)
  983       FORMAT(/,' Zero length messages were not used in',
     &             ' least squares fitting.')
         ENDIF
         WRITE(NW1,998)
  998    FORMAT(/,2X,'  Case  LENGTH(B)   TIME(sec)   RINF(B/s)',
     &         '    N1/2(B)    %error fit  ')
      ENDIF
C
      IF( ME.EQ.0 .OR. ME.EQ.NSLAVE ) THEN
C
C        /* Copy DVAL into send/recv buffer  A */
C
         DVAL = 2.0D0
         CALL DCOPY(NMAX, DVAL, A, 1)
C
C
C
         DO 50 NCASE = 1,NTESTS
C
           ILEN = LEN(NCASE)
C
C          /* Decide how many iterations - at least one! */
C
           NREPT = MAX(INT(MTIME/(ESTART + ILEN/ERINF)/2), 1)
C
C          Master code...
C
           IF( ME.EQ.0 ) THEN
C
C             /* I'm the master */
C	
              WRITE(*,100) NCASE,ILEN
  100         FORMAT ('Case ',I3,', length ',I7,' bytes')
C
C             /* Measure timing overhead, T0 */
C
              CALL TOVER(T0,EOVER,MTIME)
              T1 = DWALLTIME00()
C
              DO 20 I = 1,NREPT
                CALL DUMMY(I)
                CALL PVMFINITSEND(PVMDEFAULT,INFO)
C
C             /* PACK, SEND, RECV and UNPACK buffer A */
C
                CALL PVMFPACK(BYTE1,A,ILEN,1,INFO)
                CALL PVMFSEND(TIDS(NSLAVE),10,INFO)
                CALL PVMFRECV(TIDS(NSLAVE),20,INFO)
                CALL PVMFUNPACK(BYTE1,A,ILEN,1,INFO)
C
C             /* Check that buffer A contains DVAL */
C             /* no data to check in zero lenth message */
C
                T2 = DWALLTIME00()
                IF( ILEN.NE.0 )
     &             CALL CHECK(A, ILEN/IDPLEN, DVAL)
                T3 = DWALLTIME00()
C
   20          CONTINUE
              T4 = DWALLTIME00()
C
C             T0 = loop overhead time
C             T1 = start time
C             T3 - T2 = CHECK time
C             T4 = finish time, 
C
C             /* Divide by 2 because a message goes there and back */
C	
              TN = (T4 - T1 - (((T3-T2) + T0) * NREPT))/(NREPT*2)
              WRITE(*,101) TN, FLOAT(NREPT),(ILEN/(TN*1000000.0))
  101         FORMAT(1P,E9.3,' sec/message, in ',E8.2,' iterations (',
     &               E8.2,' Mbytes/s)'/)
C
C             /* Update least squares fit */
C
              XN = ILEN
              IF( ILEN.GT.0 .OR. USE0 )
     &           CALL LSTSQ(1,XN,TN,RINF,XN12,PER)
C
C              /* Write latest values */
C
              WRITE(NW1,999) NCASE,ILEN,TN,RINF,XN12,PER
  999         FORMAT(1X,I6,I9,3X,4(1PE12.3))
              IF( ILEN.EQ.NSBYTE .AND. NSBYTE.NE.0 ) THEN
C
C                /* store short message result */
C
                 RMBPS(1)=RINF*1.0E-06
                 XNHALF(1)=XN12
                 TSTART(1)=XNHALF(1)/RMBPS(1)
C
C                /* reset when changing to long messages */
C
                 CALL LSTSQ(0,XN,TN,RINF,XN12,PER)
                 WRITE(NW1,994) NSBYTE
  994            FORMAT(/,' LONG MESSAGES  > ',I6,'B (B=Byte)')
                 WRITE(NW1,998)
              ENDIF
C
C 	   Slave code... Take a message of ILEN bytes and reflect it to master.
C
           ELSEIF( ME.EQ.NSLAVE ) THEN
              DO 30 I = 1,NREPT
                CALL PVMFRECV(TIDS(0),10,INFO)
                CALL PVMFUNPACK(BYTE1,A,ILEN,1,INFO)
C
C               /* Copy DVAL into send/recv buffer  A */
C
C               DVAL = 2.0D0
C               CALL DCOPY(ILEN, DVAL, A, 1)
C
                CALL PVMFINITSEND(PVMDEFAULT,INFO)
                CALL PVMFPACK(BYTE1,A,ILEN,1,INFO)
                CALL PVMFSEND(TIDS(0),20,INFO)
   30         CONTINUE
           ENDIF
 50      CONTINUE
      ENDIF
C
C     /* Print result summary */
C
      IF( ME.EQ.0 ) THEN
C
C        /* Store long message result */
C
         RMBPS(2)=RINF*1.0E-06
         XNHALF(2)=XN12
         TSTART(2)=XNHALF(2)/RMBPS(2)
C
C
C
         WRITE(NW1,990)
  990    FORMAT(/,22X,'------------------------',/,
     &           22X,'COMMS1: Message Pingpong',/,
     &           22X,'------------------------',/,
     &           22X,'     Result Summmary    ',/,
     &           22X,'     ---------------    ',/)
         IF(NSBYTE .EQ. 0) THEN
            WRITE(NW1,996) RMBPS(2),XNHALF(2),TSTART(2)
  996       FORMAT(' rinf =',F10.3,' MByte/s,  nhalf = ',
     &           F10.3,' Byte,  startup =',F10.3,' us',/)
         ELSE
            WRITE(NW1,997) NSBYTE,RMBPS(1),XNHALF(1),TSTART(1),
     &                 NSBYTE,RMBPS(2),XNHALF(2),TSTART(2)
  997       FORMAT(' Short Messages, <= ',I4,' Byte',/,
     &           ' rinf =',F10.3,' MByte/s,  nhalf = ',
     &           F10.3,' Byte,  startup =',F10.3,' us',//,
     &           ' Long Messages, > ',I4,' Byte',/,
     &           ' rinf =',F10.3,' MByte/s,  nhalf = ',
     &           F10.3,' Byte,  startup =',F10.3,' us',/)
         ENDIF
C
         CLOSE(NW1)
C
         PRINT *,'Benchmark completed.'
C
      ENDIF
C
C     /* Global synchronisation */
C
      CALL PVMFBARRIER(GROUP,NNODES,INFO)
      IF( INFO.LT.0 ) PRINT *,'ERROR: pvmfbarrier returned ',INFO  
C
C     Program finished. Leave group and PVM before exiting
C
      CALL PVMFLVGROUP(GROUP,INFO)
      CALL PVMFEXIT(INFO)
      STOP
      END
