#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "u_defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

struct win_info windows[];
extern char number[][4];    
extern GC u_gc[]; 
extern Display *mydisplay;  
extern Window u_window, menu_win, button_win;  
extern XEvent myevent;
extern int num_nodes; 
extern int order[], u_colors1[], u_colors2[], win_width, win_height, 
	   user_men, uopen, tracemarks;
unsigned long u_foreground,u_background;
u_event()
/* if event is an expose, it draws the inital configuration in the window */
{
   if (myevent.type==Expose){
     if(myevent.xexpose.window==u_window)
       u_expose();
     if(myevent.xexpose.window==menu_win)
       XFillRectangle(mydisplay, menu_win, u_gc[66], 0, 0, 98, 24);
     if(myevent.xexpose.window==button_win){
       if(uopen)
         XFillRectangle(mydisplay, button_win, u_gc[67], 0, 0, 90, 16);
       XDrawString(mydisplay, button_win, u_gc[0], 18, 10, "Transpose", 9);
     }
   }else if (myevent.type==ConfigureNotify){
     if(myevent.xexpose.window==u_window){
       win_height=myevent.xconfigure.height;
       win_width=myevent.xconfigure.width;
     }
   }else if(myevent.type==ButtonPress){
     if(myevent.xbutton.window==button_win){
       if(uopen){
         XUnmapWindow(mydisplay, u_window);
         XFillRectangle(mydisplay, button_win, u_gc[65], 0, 0, 90, 16);
         uopen=0;
       }else{
         XMapWindow(mydisplay, u_window);
         XFillRectangle(mydisplay, button_win, u_gc[67], 0, 0, 90, 16);
         uopen=1;
       }
       XDrawString(mydisplay, button_win, u_gc[0], 18, 10, "Transpose", 9);
     }
     if(myevent.xbutton.window==windows[73].window){
       if(user_men){
         XUnmapWindow(mydisplay, menu_win);
         user_men=0;
       }else{
         user_men=1;
         XMapWindow(mydisplay, menu_win);
         XMapSubwindows(mydisplay, menu_win);
       }
     }
  }
}

u_expose()

{
       int i,j;   /* loop control variables */

  XClearWindow(mydisplay, u_window);
  if(tracemarks){
        if(num_nodes<=16){
/*draw numbers for processors and data*/
        for (j = 0; j < num_nodes; j++) {
            XDrawImageString(mydisplay, u_window, u_gc[0],
                7-3*strlen(number[j]), 17+(order[j])*
		((win_height-30)/num_nodes)+(win_height-30)/(num_nodes*2),
		number[j], strlen(number[j]));
            XDrawImageString(mydisplay, u_window, u_gc[0], 12+(order[j])*
		((win_width-30)/num_nodes)+(win_width-30)/(num_nodes*2),
		11, number[j], strlen(number[j]));
        }
        }else{
          for (j = 0; j < 16; j++) {
            XDrawImageString(mydisplay, u_window, u_gc[0],
                7-3*strlen(number[j*num_nodes/16]), 17+j*((win_height- 30)/16)+
                (win_height- 30)/ (num_nodes*2), number[j*num_nodes/16],
                strlen(number[j*num_nodes/16]));
            XDrawImageString(mydisplay, u_window, u_gc[0],
                12+j*((win_width-30)/16)+(win_width-30)/(num_nodes*2), 11,
                number[j*num_nodes/16], strlen(number[j*num_nodes/16]));
          }
        for (i=1;i<=num_nodes;i++) {
            j=(i-1);
            XSetForeground(mydisplay,u_gc[i],
                   u_colors2[j]);
            }
	}


/*draw labels on axes */

        XDrawString(mydisplay, u_window, u_gc[0], win_width/2-24,
            win_height-3, "D  A  T  A", strlen("D  A  T  A"));
        XDrawString(mydisplay, u_window, u_gc[0], win_width-11, win_height/2-46,
            "P", strlen("P"));
        XDrawString(mydisplay, u_window, u_gc[0], win_width-11, win_height/2-32,
            "R", strlen("R"));
        XDrawString(mydisplay, u_window, u_gc[0], win_width-11, win_height/2-14,
            "O", strlen("O"));
        XDrawString(mydisplay, u_window, u_gc[0], win_width-11, win_height/2,
            "C", strlen("C"));
        XDrawString(mydisplay, u_window, u_gc[0], win_width-11, win_height/2+28,
            "N", strlen("N"));
        XDrawString(mydisplay, u_window, u_gc[0], win_width-11, win_height/2+42,
            "O", strlen("O"));

        XDrawLine(mydisplay, u_window, u_gc[0], win_width-15, 15, win_width-15,
            win_height-15);
        XDrawLine(mydisplay, u_window, u_gc[0], 15, win_height-15, win_width-15,
            win_height-15);
        XDrawLine(mydisplay, u_window, u_gc[0], 0, 0, 15, 15);
        XDrawLine(mydisplay, u_window, u_gc[0], 15, 15, win_width-15, 15);
        XDrawLine(mydisplay, u_window, u_gc[0], 15, 15, 15, win_height-15);
        XDrawLine(mydisplay, u_window, u_gc[0], 0, win_height, 15,
            win_height);
        XDrawLine(mydisplay, u_window, u_gc[0], win_width, 0, win_width-15,
            15);
        XDrawLine(mydisplay, u_window, u_gc[0], win_width, win_height,
            win_width-15, win_height-15);

  }else XDrawImageString(mydisplay,u_window, u_gc[0], 50,50,
       "NO DATA FOUND FOR THIS DISPLAY",
       strlen("NO DATA FOUND FOR THIS DISPLAY"));
}
