#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "u_defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern struct win_info windows[];
extern GC u_gc[MAXNODE+2]; 
extern Display *mydisplay;
extern Window u_window, menu_win, button_win;    
extern XEvent myevent;
extern int num_nodes, task_colors[], user_men, uopen, win_height, 
	   win_width, tracemarks;
u_event()
/* if event is an expose, it draws the inital configuration in the window */
{
   if (myevent.type==Expose){
     if(myevent.xexpose.window==u_window)
       u_expose();
     if(myevent.xexpose.window==menu_win)
       XFillRectangle(mydisplay, menu_win, u_gc[66], 0, 0, 98, 24);
     if(myevent.xexpose.window==button_win){
       if(uopen)
	 XFillRectangle(mydisplay, button_win, u_gc[67], 0, 0, 90, 16);
       XDrawString(mydisplay, button_win, u_gc[0], 27, 10, "Matrix", 6);
     }
   }else if (myevent.type==ConfigureNotify){
     if(myevent.xexpose.window==u_window){
      win_height=myevent.xconfigure.height-30;
      win_width=myevent.xconfigure.width-30;
     }
   }else if(myevent.type==ButtonPress){
     if(myevent.xbutton.window==button_win){
       if(uopen){
	 XUnmapWindow(mydisplay, u_window);
	 XFillRectangle(mydisplay, button_win, u_gc[65], 0, 0, 90, 16);
	 uopen=0;
       }else{
	 XMapWindow(mydisplay, u_window);
	 XFillRectangle(mydisplay, button_win, u_gc[67], 0, 0, 90, 16);
	 uopen=1;
       }
       XDrawString(mydisplay, button_win, u_gc[0], 27, 10, "Matrix", 6);
     }
     if(myevent.xbutton.window==windows[73].window){
       if(user_men){
	 XUnmapWindow(mydisplay, menu_win);
	 user_men=0;
       }else{
	 user_men=1;
	 XMapWindow(mydisplay, menu_win);
	 XMapSubwindows(mydisplay, menu_win);
       }
     }
   }
}

u_expose()

{
       int i,j;   /* loop control variables */

  XClearWindow(mydisplay, u_window);
  if(tracemarks){
        XDrawImageString(mydisplay,u_window, u_gc[0], win_width/2-21 ,12,
           "COLUMN INDEX", strlen("COLUMN INDEX"));
        XDrawImageString(mydisplay,u_window, u_gc[0], 5 ,win_height/2-31,
           "R", strlen("R"));
        XDrawImageString(mydisplay,u_window, u_gc[0], 5 ,win_height/2-19,
           "O", strlen("O"));
        XDrawImageString(mydisplay,u_window, u_gc[0], 5 ,win_height/2-7,
           "W", strlen("W"));
        XDrawImageString(mydisplay,u_window, u_gc[0], 5 ,win_height/2+19,
           "I", strlen("I"));
        XDrawImageString(mydisplay,u_window, u_gc[0], 5 ,win_height/2+31,
           "N", strlen("N"));
        XDrawImageString(mydisplay,u_window, u_gc[0], 5 ,win_height/2+43,
           "D", strlen("D"));
        XDrawImageString(mydisplay,u_window, u_gc[0], 5 ,win_height/2+55,
           "E", strlen("E"));
        XDrawImageString(mydisplay,u_window, u_gc[0], 5 ,win_height/2+67,
           "X", strlen("X"));
        XDrawLine(mydisplay, u_window, u_gc[0], 15, 15, 15, win_height+15);
        XDrawLine(mydisplay, u_window, u_gc[0], 15, 15, win_width+15, 15);
        XDrawLine(mydisplay, u_window, u_gc[0], 0, 0, 15, 15);
        XDrawLine(mydisplay, u_window, u_gc[0], 15, win_height+15,
	    win_width+15, win_height+15);
        XDrawLine(mydisplay, u_window, u_gc[0], win_width+15, 15,
	    win_width+15, win_height+15);
        XDrawLine(mydisplay, u_window, u_gc[0], 0, win_height+30,
	    15, win_height+15);
        XDrawLine(mydisplay, u_window, u_gc[0], win_width+30, win_height+30,
	    win_width+15, win_height+15);
        XDrawLine(mydisplay, u_window, u_gc[0], win_width+30, 0,
	    win_width+15, 15);
        if(num_nodes>16){
        for (i=1;i<=num_nodes;i++) {
            j=(i-1);
            XSetForeground(mydisplay,u_gc[i],
                   task_colors[j]);
            }
	}

  }else XDrawImageString(mydisplay,u_window, u_gc[0], 50,50,
       "NO DATA FOUND FOR THIS DISPLAY",
       strlen("NO DATA FOUND FOR THIS DISPLAY"));
}
