#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <malloc.h>
#include <math.h>
#include "u_defines.h"

int u_win = 1;              /*Global variable to signal user defined window*/
int u_scroll = 0;
GC u_gc[68];   
extern Display *mydisplay;  
extern int color[], task_colors[];     
Window u_window, menu_win, button_win;      
extern FILE *tfptr;
extern Font font1;   
unsigned long u_foreground, u_background;
extern int depth;           /*Depth of window  */
extern int num_nodes;          /*number of nodes*/
char title[]= {"Graph"};/*namestripe of window*/
int maxr, mind, *tempr, radius, numlines, numnodes, win_width, win_height;
float minx, miny, maxx, maxy, *tempx, *tempy, *x1, *x2, *yl1, *y2;
extern Cursor hand_cursor;

u_init()
{
 /* declarations */
        XSizeHints u_hint;    /*Variables*/
        int type, radiusx, radiusy, rec_type, i,j, myscreen;
	char line[MAXLINE];

        if (num_nodes>MAXNODE)
          u_win=0;
        else
	  u_win=1;

/* pixel values */
  myscreen = DefaultScreen(mydisplay);

        u_background = WhitePixel(mydisplay, myscreen);
        u_foreground = BlackPixel(mydisplay, myscreen);

     mind=1000000;minx=miny=1000000.0;
     maxr=0;maxx=maxy=0.0;
     u_hint.x = 0; u_hint.y = 0;
     win_width = u_hint.width = 400; win_height = u_hint.height = 453;

  if ((tempx = (float *)malloc(numnodes*sizeof(float))) == NULL){
    printf("memory allocation failed: %d bytes requested\n",
      numnodes*sizeof(float));
    exit(1);
  }
  if ((tempy = (float *)malloc(numnodes*sizeof(float))) == NULL){
    printf("memory allocation failed: %d bytes requested\n",
      numnodes*sizeof(float));
    exit(1);
  }
  if ((tempr = (int *)malloc(numnodes*sizeof(int))) == NULL){
    printf("memory allocation failed: %d bytes requested\n",
      numnodes*sizeof(int));
    exit(1);
  }
  if ((x1 = (float *)malloc(numlines*sizeof(float))) == NULL){
    printf("memory allocation failed: %d bytes requested\n",
      numlines*sizeof(float));
    exit(1);
  }
  if ((x2 = (float *)malloc(numlines*sizeof(float))) == NULL){
    printf("memory allocation failed: %d bytes requested\n",
      numlines*sizeof(float));
    exit(1);
  }
  if ((yl1 = (float *)malloc(numlines*sizeof(float))) == NULL){
    printf("memory allocation failed: %d bytes requested\n",
      numlines*sizeof(float));
    exit(1);
  }
  if ((y2 = (float *)malloc(numlines*sizeof(float))) == NULL){
    printf("memory allocation failed: %d bytes requested\n",
      numlines*sizeof(float));
    exit(1);
  }
  i=j=0;
  for(i=0; i<numnodes; i++)
    tempx[i] = tempy[i] = tempr[i] = 1.0;
 if(tfptr!=NULL){
  rewind(tfptr);
  while (fgets(line, MAXLINE, tfptr)) {
    sscanf(line, "%*d %d" , &rec_type);
     if(rec_type==USER){
     sscanf(line, "%*d %*d %*f %*d %*d %*d %d", &type);
     if( type==0){
      sscanf(line, "%*d %*d %*f %*d %*d %*d %*d %f %f %*d %d", &tempx[i],
        &tempy[i], &tempr[i]);
      if(tempx[i]>maxx) maxx=tempx[i];
      if(tempx[i]<minx) minx=tempx[i];
      if(tempy[i]>maxy) maxy=tempy[i];
      if(tempy[i]<miny) miny=tempy[i];
      if(tempr[i]>maxr) maxr=tempr[i];
      i++;
     }else if(type==1){
      sscanf(line, "%*d %*d %*f %*d %*d %*d %*d %f %f %f %f", &x1[j],
        &yl1[j], &x2[j], &y2[j]);
      j++;
     }
    }
   }
   for(i=0; i<numnodes; i++)
     for(j=i+1; j<numnodes; j++){
       if((maxr*2*((int)ceil(sqrt((double)(tempx[i]-tempx[j])*(double)(tempx[i]-
         tempx[j])+(double)(tempy[i]-tempy[j])*(double)(tempy[i]-tempy[j])))))/
	 (tempr[i]+tempr[j])<mind)
       mind=(maxr*2*((int)ceil(sqrt((double)(tempx[i]-tempx[j])*
	 (double)(tempx[i]-tempx[j])+(double)(tempy[i]-tempy[j])*
	 (double)(tempy[i]-tempy[j])))))/(tempr[i]+tempr[j]);
     }
   if(mind==0) mind = 1;
   if(maxr==0) maxr = 1;
   if(maxx==0.0 && minx==0.0) maxx=1.0;
   radiusx=(mind*(win_width-20))/(4*(int)maxx-4*(int)minx+2*mind);
   radiusy=(mind*(win_height-40))/(4*(int)maxy-4*(int)miny+2*mind);
   if(radiusx<radiusy) radius=radiusx;
   else radius=radiusy;
  if(radius<3){
    radius=3;
    win_width=(radius*(4*(int)maxx-4*(int)minx+2*mind))/mind+20;
    win_height=(radius*(4*(int)maxy-4*(int)miny+2*mind))/mind+30;
  }
  rewind(tfptr);
 }
       
        u_hint.flags = PPosition | PSize;
        u_window = XCreateSimpleWindow(mydisplay,
                DefaultRootWindow(mydisplay),
                u_hint.x, u_hint.y, u_hint.width, u_hint.height,
                2, u_foreground, u_background);
        XChangeProperty(mydisplay, u_window, XA_WM_NAME,
                XA_STRING, 8, PropModeReplace, title, strlen(title));
        menu_win = XCreateSimpleWindow(mydisplay, DefaultRootWindow(mydisplay),
                u_hint.x, u_hint.y, 98, 24, 2, u_foreground, u_background);
        XChangeProperty(mydisplay, menu_win, XA_WM_NAME,
                XA_STRING, 8, PropModeReplace, "User Menu", 9);
        button_win = XCreateSimpleWindow(mydisplay, menu_win,
                2, 2, 90, 16, 2, u_foreground, u_background);


/*initialize gc's*/
        for (i=0; i<=68; i++){
          u_gc[i] = XCreateGC(mydisplay, DefaultRootWindow(mydisplay), 0, 0);
          XSetBackground(mydisplay,u_gc[i],u_background);
          }
        XSetFont(mydisplay, u_gc[0], font1);
        XSetForeground(mydisplay,u_gc[0],u_foreground);
        XSetForeground(mydisplay,u_gc[64 +1],
                       u_background);
        XSetForeground(mydisplay,u_gc[66], color[7]);
        XSetForeground(mydisplay,u_gc[67], color[10]);

    XSelectInput(mydisplay, u_window, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, menu_win, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, button_win, ExposureMask |StructureNotifyMask|
      ButtonPressMask);
    XDefineCursor(mydisplay, u_window, hand_cursor);
    XDefineCursor(mydisplay, menu_win, hand_cursor);
    XDefineCursor(mydisplay, button_win, hand_cursor);

   if (depth!=1){
        for (i=1;i<=64;i++) {
            j=(i-1);
            XSetForeground(mydisplay,u_gc[i],
                   task_colors[(j%8)*8+j/8]);
            }
  }

}
