#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <math.h>
#include "u_defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern GC u_gc[];   
extern Display *mydisplay;
extern struct win_info windows[];
extern Window menu_win, button_win, u_window; 
extern Font font1;  
extern XEvent myevent;
extern int win_width, win_height, numnodes, numlines, tracemarks,
	   user_men, radius, *tempr, maxr, mind;
extern float *tempx, *tempy, minx, maxx, miny, maxy, *x1, *x2, *yl1, *y2;
int uopen;
u_event()
{
int radiusx, radiusy;

  if (myevent.type==Expose){
     if(myevent.xexpose.window==u_window)
       u_expose();
     if(myevent.xexpose.window==menu_win)
       XFillRectangle(mydisplay, menu_win, u_gc[66], 0, 0, 98, 24);
     if(myevent.xexpose.window==button_win){
       if(uopen)
         XFillRectangle(mydisplay, button_win, u_gc[67], 0, 0, 90, 16);
       XDrawString(mydisplay, button_win, u_gc[0], 30, 10, "Graph", 5);
     }
  } else if (myevent.type==ConfigureNotify){
     if(myevent.xexpose.window==u_window){
       win_height=myevent.xconfigure.height;
       win_width=myevent.xconfigure.width;
       radiusx=(mind*(win_width-20))/(4*(int)maxx-4*(int)minx+2*mind);
       radiusy=(mind*(win_height-40))/(4*(int)maxy-4*(int)miny+2*mind);
       if(radiusx<radiusy) radius=radiusx;
       else radius=radiusy;
       if(radius<3){
         radius=3;
         win_width=(radius*(4*(int)maxx-4*(int)minx+2*mind))/mind+20;
         win_height=(radius*(4*(int)maxy-4*(int)miny+2*mind))/mind+30;
       }
     }
   }else if(myevent.type==ButtonPress){
     if(myevent.xbutton.window==button_win){
       if(uopen){
         XUnmapWindow(mydisplay, u_window);
         XFillRectangle(mydisplay, button_win, u_gc[65], 0, 0, 90, 16);
         uopen=0;
       }else{
         XMapWindow(mydisplay, u_window);
         XFillRectangle(mydisplay, button_win, u_gc[67], 0, 0, 90, 16);
         uopen=1;
       }
       XDrawString(mydisplay, button_win, u_gc[0], 30, 10, "Graph", 5);
     }
     if(myevent.xbutton.window==windows[73].window){
       if(user_men){
         XUnmapWindow(mydisplay, menu_win);
         user_men=0;
       }else{
         user_men=1;
         XMapWindow(mydisplay, menu_win);
         XMapSubwindows(mydisplay, menu_win);
       }
     }
  }
}

u_expose()

{
       int i,j;   /* loop control variables */

  XClearWindow(mydisplay, u_window);
  if(tracemarks){
    XDrawLine( mydisplay, u_window, u_gc[0], 0, win_height-20,
      win_width, win_height-20);
    for(i=0; i<numnodes; i++){
      XDrawArc(mydisplay, u_window, u_gc[0], 9+radius+((int)(tempx[i]-minx)*
        (win_width-2*radius-20))/(int)(maxx-minx)-(tempr[i]*radius)/maxr,
        win_height-radius-31-((int)(tempy[i]-miny)*(win_height-2*radius-40))/
        (int)(maxy-miny)-(tempr[i]*radius)/maxr, 2*(tempr[i]*radius)/maxr+2,
        2*(tempr[i]*radius)/maxr+2, 0, 360*64);
    }
    for(j=0; j<numlines; j++){
      XDrawLine(mydisplay,u_window, u_gc[0], 10+radius+((int)(x1[j]-minx)*
        (win_width-2*radius-20))/(int)(maxx-minx), win_height-radius-30-
        ((int)(yl1[j]-miny)*(win_height-2*radius-40))/(int)(maxy-miny), 
	10+radius+((int)(x2[j]-minx)*(win_width-2*radius-20))/(int)(maxx-minx),
	win_height-radius-30-((int)(y2[j]-miny)*(win_height-2*radius-40))/
	(int)(maxy-miny));
    }
  }else XDrawImageString(mydisplay,u_window, u_gc[0], 50,50,
       "NO DATA FOUND FOR THIS DISPLAY",
       strlen("NO DATA FOUND FOR THIS DISPLAY"));
}
