#include <stdio.h>
#include <math.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

Window button_win, menu_win, u_window;
extern Display *mydisplay;
extern int last_t, num_nodes, count, depth, monochrome, time_unit, 
  times[], values[], color[];
int u_win = 1;
int u_scroll = 0;
int u_cum;
int u_position = 0;
int uopen, win_height, win_width;
float u_rate, max_rate;
GC u_gc[6];
extern float max_rates[];
extern Font font1;
extern Cursor hand_cursor;

u_init()
{
    int i, j, myscreen;

    uopen=0;

    myscreen = DefaultScreen(mydisplay);
    u_window = XCreateSimpleWindow(mydisplay, DefaultRootWindow(mydisplay),
        0, 0, 600, 600, 2, BlackPixel(mydisplay, myscreen), 
        WhitePixel(mydisplay, myscreen));
    menu_win = XCreateSimpleWindow(mydisplay, DefaultRootWindow(mydisplay),
        0, 0, 98, 24, 2, BlackPixel(mydisplay, myscreen), 
	WhitePixel(mydisplay, myscreen));
    XChangeProperty(mydisplay, menu_win, XA_WM_NAME, XA_STRING, 8, 
        PropModeReplace, "User Menu", 9);
    button_win = XCreateSimpleWindow(mydisplay, menu_win, 2, 2, 90, 16, 2, 
        BlackPixel(mydisplay, myscreen), WhitePixel(mydisplay, myscreen));

    win_width=600; win_height=285;
    u_cum=0;
    u_rate=0.0;
    max_rate=0.0;
    last_t=0;
    count=0;
    for(i=0; i<512; i++)
      times[i]=values[i]=0;

    for(i=0; i<num_nodes; i++)
      max_rate+=max_rates[i];
    max_rate=ceil(max_rate*(float)time_unit);

    for(i=0; i<6; i++){
        u_gc[i] = XCreateGC(mydisplay, DefaultRootWindow(mydisplay), 0, 0);
        XSetFont(mydisplay, u_gc[i], font1);
    }

    XSelectInput(mydisplay, u_window, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, menu_win, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, button_win, ExposureMask |StructureNotifyMask|
      ButtonPressMask);
    XDefineCursor(mydisplay, u_window, hand_cursor);
    XDefineCursor(mydisplay, menu_win, hand_cursor);
    XDefineCursor(mydisplay, button_win, hand_cursor);

    XSetForeground(mydisplay, u_gc[0], WhitePixel(mydisplay,myscreen));
    XSetForeground(mydisplay, u_gc[1], BlackPixel(mydisplay,myscreen));
    XSetBackground(mydisplay, u_gc[1], WhitePixel(mydisplay,myscreen));
    if(depth>1 && monochrome!=1){
      XSetForeground(mydisplay, u_gc[2], color[18]);
      XSetForeground(mydisplay, u_gc[3], color[24]);
      XSetForeground(mydisplay, u_gc[4], color[7]);
      XSetForeground(mydisplay, u_gc[5], color[10]);
    }else{
      XSetForeground(mydisplay, u_gc[2], BlackPixel(mydisplay, myscreen));
      XSetForeground(mydisplay, u_gc[3], BlackPixel(mydisplay, myscreen));
    }
}
