#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/keysym.h>
#include <X11/Intrinsic.h>
#include <math.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern int longf, flbr_width, u_win, lgnd_height, go_flag, no_files;

XEvent myevent;

/* check for user input (kbd and mouse) events and window manager events */

get_event()
{
int i, ibuf, jbuf;
unsigned int nchildren;
XWindowAttributes win_attr;
Window *children, which_win, parent, root;
unsigned long event_mask;

    event_mask = ExposureMask | ButtonPressMask | KeyPressMask |
		 StructureNotifyMask;
    if (go_flag==1){
     while (XCheckMaskEvent(mydisplay, event_mask |
       ButtonMotionMask|PointerMotionHintMask, &myevent) == True) {
      if(u_win>0)
        u_event();
        switch (myevent.type) {
          case Expose:
	   for (i = ANIM; i <= SCLB; i++)
	    if (myevent.xexpose.window==windows[i].window){
	      if(myevent.xexpose.count==0)
	        expose(i);
	        break;
	    }
	  break;

	  case MotionNotify:
	    if(myevent.xbutton.window==windows[SLID].window)
	      slide();
	    if(myevent.xmotion.window==windows[FLBR].window)
	      frame();
	    break;

	  case ButtonPress:
	   for (i = ANIM; i <= SCLB; i++)
	    if (myevent.xbutton.window == windows[i].window) {
	        button(i);
	        break;
	    }
	  break;

          case ConfigureNotify:
	   for (i = ANIM; i<= STTS; i++)
	    if (myevent.xconfigure.window == windows[i].window) {
	      resize(myevent.xconfigure.width,myevent.xconfigure.height,i);
	      break;
	    }
	   for (i = ANIM; i<= MENU; i++)
	    if (myevent.xconfigure.window == windows[i].window) {
              parent=which_win=windows[i].window;
              while(parent!=root){
                which_win=parent;
	        if(XQueryTree(mydisplay, which_win, &root, &parent, 
                    &children, &nchildren)){
                  if (children)
                    XFree((XrmString) children);
                }else break;
              }
              XGetWindowAttributes(mydisplay, which_win, &win_attr);
              windows[i].x=win_attr.x-win_attr.border_width;
              windows[i].y=win_attr.y-win_attr.border_width;
	      break;
	     }
	    if (myevent.xconfigure.window == windows[LGND].window) {
	      lgnd_height=myevent.xconfigure.height;
	    }
	    if(myevent.xconfigure.window==windows[FLBR].window){
	      if(flbr_width!=myevent.xconfigure.width-4){
	        flbr_width = myevent.xconfigure.width-4;
                if((ibuf=flbr_width/(longf*6+8))==0) ibuf=1;
                jbuf=no_files/ibuf;
		if(no_files%ibuf>=ibuf/2) jbuf++;
                XResizeWindow(mydisplay, windows[FLBR].window, flbr_width+4, 
                  88+jbuf*18);
	      }else expose(FLBR);
	    }
          break;

	    case MappingNotify:
	        XRefreshKeyboardMapping(&myevent.xmapping);
	        break;

	    case KeyPress:
	        for (i = DELT; i <= QEST; i++)
		    if (myevent.xkey.window == windows[i].window) {
		        keypress(i);
		        break;
		    }
	        for (i = STAR; i <= TFIL; i++)
		    if (myevent.xkey.window == windows[i].window) {
		        keypress(i);
		        break;
		    }
	        for (i = RSTR; i <= RFNP; i++)
		    if (myevent.xkey.window == windows[i].window) {
		        keypress(i);
		        break;
		    }
		if (myevent.xkey.window == windows[PATB].window)
		    keypress(PATB);
		if (myevent.xkey.window == windows[ANFL].window)
		    keypress(ANFL);
	        break;
	    }
        }
    }else {
        XMaskEvent(mydisplay, event_mask| ButtonMotionMask|
	  PointerMotionHintMask, &myevent);
	    if(u_win>0) u_event();
	    switch (myevent.type) {
	    case Expose:
	        for (i = ANIM; i <= SCLB; i++)
		    if(myevent.xexpose.window==windows[i].window){
		     while(myevent.xexpose.count!=0) 
		       XNextEvent(mydisplay, &myevent);
	              /*if(myevent.xexpose.count==0)*/
		        expose(i);
		        break;
	    	    }
	        break;

	    case MotionNotify:
	      if(myevent.xbutton.window==windows[SLID].window)
		slide();
	      if(myevent.xmotion.window==windows[FLBR].window)
	        frame();
	      break;

	    case ButtonPress:
	        for (i = ANIM; i <= SCLB; i++)
		    if (myevent.xbutton.window == windows[i].window) {
		        button(i);
		        break;
		    }
	        break;

            case ConfigureNotify:
	        for (i = ANIM; i<= STTS; i++)
		    if (myevent.xconfigure.window == windows[i].window) {
	           resize(myevent.xconfigure.width,myevent.xconfigure.height,i);
		        break;
		    }
	        for (i = ANIM; i<= MENU; i++)
	         if (myevent.xconfigure.window == windows[i].window) {
                   parent=which_win=windows[i].window;
                   while(parent!=root){
                     which_win=parent;
		     if(XQueryTree(mydisplay, which_win, &root, &parent, 
                         &children, &nchildren)){
                       if (children)
                         XFree((XrmString) children);
                     }else break;
                   }
                   XGetWindowAttributes(mydisplay, which_win, &win_attr);
                   windows[i].x=win_attr.x-win_attr.border_width;
                   windows[i].y=win_attr.y-win_attr.border_width;
	           break;
	          }
	         if (myevent.xconfigure.window == windows[LGND].window) {
	           lgnd_height=myevent.xconfigure.height;
		 }
	         if(myevent.xconfigure.window==windows[FLBR].window){
	           if(flbr_width!=myevent.xconfigure.width-4){
	             flbr_width = myevent.xconfigure.width-4;
                     if((ibuf=flbr_width/(longf*6+8))==0) ibuf=1;
                     jbuf=no_files/ibuf;
		     if(no_files%ibuf>=ibuf/2) jbuf++;
                     XResizeWindow(mydisplay, windows[FLBR].window, 
		       flbr_width+4, 88+jbuf*18);
	           }else expose(FLBR);
		 }
                break;

	    case MappingNotify:
	        XRefreshKeyboardMapping(&myevent.xmapping);
	        break;

	    case KeyPress:
	        for (i = LGN0; i <= LGN3; i++)
		    if (myevent.xkey.window == windows[i].window) {
		        keypress(i);
		        break;
		    }
	        for (i = DELT; i <= QEST; i++)
		    if (myevent.xkey.window == windows[i].window) {
		        keypress(i);
		        break;
		    }
	        for (i = STAR; i <= TFIL; i++)
		    if (myevent.xkey.window == windows[i].window) {
		        keypress(i);
		        break;
		    }
	        for (i = RSTR; i <= RFNP; i++)
		    if (myevent.xkey.window == windows[i].window) {
		        keypress(i);
		        break;
		    }
		if (myevent.xkey.window == windows[PATB].window)
		    keypress(PATB);
		if (myevent.xkey.window == windows[ANFL].window)
		    keypress(ANFL);
	        break;
	    }
    }
}
