#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern GC micro_gc, gc[];
extern FILE *recptr[18];
extern Pixmap tmaps[8][4];
extern int lth_bin[], scroll_width[], scale_width, left_scale[], right_scale[],
           prev_place, prev_draw[], num_nodes, order[], max_time, raw_time,
           go_flag, kx[], ky[], ****sendpoint, num_task, **msg_count, msg_vol[],
	   hypenode1,start_time, total_tasks, cur_time, msg_type, hypenode2,
	   crit_count, proc_height, radius, msg_lth, key_index, max_count,
	   max_lth, comm_count, comm_vol, node, from, dest,min_time, win_edge[],
	   k_delta, k_center_x, k_center_y, last_queue_count[], queu_vol[], 
	   psta_height, queu_count[], proc_width, min_type, **task, max_dist, 
	   max_vol_node[], task_ptr[],skip, anim_state[], state[], queu_height,
	   *tsks_prog, task_num, tsks_dim, which_map, total_tasks, tskc_width,
	   tskc_height,loop_count, phpt_width, phpt_height, u_scroll, u_win, 
	   send_vol[], send_count[], psta_lth_bin[], psta_dim, win_size, depth,
	   *start_task, monochrome, ninf_center, ninf_height, status_origin_x,
	   status_origin_y, tasks_origin_x, tasks_origin_y, sends_origin_x, 
	   sends_origin_y, recvs_origin_x, recvs_origin_y, psta_width, 
	   first_draw, phpt_first_point, start_idle[], tmap_w[], stop_time, 
	   crit_time_send[], crit_time[], time_unit, crit_node[], *task_count, 
	   tsmy_bottom, tsmy_height, ntwk_nodes, ntwk_stages, **ns_inv, 
	   ***ntwk_load, rec_start_time, ***ntwk_total, first_not_draw, check, 
	   start_busy[], k_init[], prev_time, max_type, max_hops, 
	   streak_last_top[], rec_stop_time, streak_last_bottom[];

int pct_busy[MAXP], pct_ovhd[MAXP], pct_busy_sum[MAXP], first_util, 
    num_hops, first_comm, prev_comm_count, util_count, pct_ovhd_sum[MAXP],
    count_busy[MAXP+1], count_ovhd[MAXP+1], count_idle[MAXP+1], cum_comm,
    anim_xl[MAXP], anim_yl[MAXP], anim_x[MAXP], anim_y[MAXP], cum_util, spin,
    prev_count, prev_state[MAXP] , prev_cmmt_load, cmmt_load, queu_max_load, 
    comm_prev_load, comm_max_load, meter_max_load, prev_diff_count, 
    phpt_point[2], phpt_last_point[2], util_diff_count, sum_busy[MAXP], 
    sum_ovhd[MAXP], start_ovhd[MAXP];

extern float node_util[];
extern BOD_STRUCT max_streak[], cur_streak[], max_streaks;

extern char number[MAXP][4];

char buf[10];

extern XPoint pts[16], ctr[16];
XPoint draw_pts[4], erase_pts[4];

struct ns_pt {
        int n;
        int s;
};

extern struct ns_pt *pt_array;
extern float current_util_pct[MAXP];
int traf_prev_load[MAXP], prev_ptr[MAXP], prev_anim_state[MAXP],
    queu_load[MAXP], prev_pct_ovhd[MAXP], prev_pct_busy[MAXP];

/* this file contains all of the functions that do the drawing */

draw()
{
    int avg_util(), avg_comm(), i;
    float kiv();


    if (!skip) {

    /* don't use possibly spurious host time */

        if (node == HOST)
 	    cur_time = prev_time;
    /* have hit user selected start time in tracefile */
    if (prev_time >= start_time)
    {
        util_count=0;
	util_diff_count=0;

        for (i=0; i<num_nodes; i++)
            if (state[i]==1 || state[i] == 2)
                util_count++;
        for (i=0; i<num_nodes; i++)
            if (state[i] == 2)
                util_diff_count++;

        for (i=0; i<num_nodes; i++){
            if (state[i]==1 )
                        pct_busy_sum[i] += 100 * (cur_time-prev_time);
            if (state[i]==2 )
                        pct_ovhd_sum[i] += 100 * (cur_time-prev_time);
            }

	if(first_draw){
            expose(RUNB);
	    XUngrabPointer(mydisplay, CurrentTime);
	    if(windows[NINF].opt1){
	    sprintf(buf, "%d", left_scale[NINF-5]);
	    XDrawImageString(mydisplay, windows[NINF].window,
		gc[NINF], 17, 34+2*ninf_height, buf, strlen(buf));
	    sprintf(buf, "%d", right_scale[NINF-5]);
	    XDrawImageString(mydisplay, windows[NINF].window,
		gc[NINF], win_edge[NINF-5]-6*strlen(buf)+6,
		34+2*ninf_height, buf, strlen(buf));
	    }
	    if(windows[CRIT].opt1){
	    sprintf(buf, "%d", left_scale[CRIT-5]);
	    XDrawImageString(mydisplay, windows[CRIT].window, gc[CRIT],
		27, windows[CRIT].height-15+10, buf, strlen(buf));
	    sprintf(buf, "%d", right_scale[CRIT-5]);
	    XDrawImageString(mydisplay, windows[CRIT].window,
		gc[CRIT], win_edge[CRIT-5]-6*strlen(buf)+6,
		windows[CRIT].height-15+10, buf, strlen(buf));
	    }
	    if(windows[SPTM].opt1){
	    sprintf(buf, "%d", left_scale[SPTM-5]);
	    XDrawImageString(mydisplay, windows[SPTM].window, gc[SPTM],
		27, windows[SPTM].height-15+10, buf, strlen(buf));
	    sprintf(buf, "%d", right_scale[SPTM-5]);
	    XDrawImageString(mydisplay, windows[SPTM].window,
		gc[SPTM], win_edge[SPTM-5]-6*strlen(buf)+6,
		windows[SPTM].height-15+10, buf, strlen(buf));
	    }
	    if(windows[TRAF].opt1){
	    sprintf(buf, "%d", left_scale[TRAF-5]);
            XDrawImageString(mydisplay, windows[TRAF].window, gc[TRAF],
		37,  windows[TRAF].height-4, buf, strlen(buf));
	    sprintf(buf, "%d", right_scale[TRAF-5]);
            XDrawImageString(mydisplay, windows[TRAF].window,
                gc[TRAF], win_edge[TRAF-5]-6*strlen(buf)+6,
		windows[TRAF].height-4, buf, strlen(buf));
	    }
	    if(windows[UTLC].opt1){
	    sprintf(buf, "%d", left_scale[UTLC-5]);
	    XDrawImageString(mydisplay, windows[UTLC].window, gc[UTLC],
	        27, windows[UTLC].height-46, buf, strlen(buf));
	    sprintf(buf, "%d", right_scale[UTLC-5]);
	    XDrawImageString(mydisplay, windows[UTLC].window,
	        gc[UTLC], win_edge[UTLC-5]-6*strlen(buf)+6,
	        windows[UTLC].height-46, buf, strlen(buf));
	    }
	    if(windows[TSKG].opt1){
	    sprintf(buf, "%d", left_scale[TSKG-5]);
	    XDrawImageString(mydisplay, windows[TSKG].window, gc[TSKG],
		27, windows[TSKG].height-38, buf, strlen(buf));
	    sprintf(buf, "%d", right_scale[TSKG-5]);
	    XDrawImageString(mydisplay, windows[TSKG].window,
		gc[TSKG], win_edge[TSKG-5]-6*strlen(buf)+6,
		windows[TSKG].height-38, buf, strlen(buf));
	    }
	    if(windows[UTLG].opt1){
	    sprintf(buf, "%d", left_scale[UTLG-5]);
	    XDrawImageString(mydisplay, windows[UTLG].window, gc[UTLG], 
		27, windows[UTLG].height-38, buf, strlen(buf));
	    sprintf(buf, "%d", right_scale[UTLG-5]);
	    XDrawImageString(mydisplay, windows[UTLG].window,
		gc[UTLG], win_edge[UTLG-5]-6*strlen(buf)+6,
		windows[UTLG].height-38, buf, strlen(buf));
	    }
	  first_draw=0;
	}
	if (windows[NINF].opt1)
	    XDrawLine(mydisplay, windows[NINF].window, gc[NINF], 30, 
		ninf_center, win_edge[NINF-5], ninf_center);
        /* to simulate "real time", this loop is cycled through from time on
           previous trace line to time on current trace line */

	for (spin = 0; spin < cur_time - prev_time; spin++) {
	    /* if at edge of window on windows that scroll (node_info,
	       spacetime, queue_size, comm_load, util, tasks, gantt),
	       move back by scroll width */
	    if(go_flag==1&&spin%check==0&&spin!=0) get_event();
	    if (prev_draw[NINF-5]+win_size/scale_width >= win_edge[NINF-5]-1) {
		prev_draw[NINF-5] -= scroll_width[NINF-5];
		/* increment scale number on left side  */
		left_scale[NINF-5]+=scroll_width[NINF-5]*scale_width/win_size;
		right_scale[NINF-5]+=scroll_width[NINF-5]*scale_width/win_size;
		/* increment scale number on right side */
		/* scroll the screen of the open windows */
		if (windows[NINF].opt1) {
		    XCopyArea(mydisplay, windows[NINF].window, 
		      windows[NINF].window, gc[NINF], 31+scroll_width[NINF-5], 
		      19, win_edge[NINF-5] - 30 - scroll_width[NINF-5],
			2*ninf_height+2, 31, 19);
		    /* area from left edge of screen plus scroll width to
		       right edge of screen is copied to left edge of screen */
		    XClearArea(mydisplay, windows[NINF].window, 
		      win_edge[NINF-5] - scroll_width[NINF-5]+1, 30, 
		      scroll_width[NINF-5], 2*ninf_height-8,False);
		    /* area from left edge plus scroll width to right edge is
		       cleared */
		    sprintf(buf, "%d", left_scale[NINF-5]);
		    XDrawImageString(mydisplay, windows[NINF].window,
			gc[NINF], 17, 34+2*ninf_height, buf, strlen(buf));
		    /* rewrite scale number on left side of screen */
		    sprintf(buf, "%d", right_scale[NINF-5]);
		    XDrawImageString(mydisplay, windows[NINF].window,
			gc[NINF], win_edge[NINF-5]-6*strlen(buf)+6,
			34+2*ninf_height, buf, strlen(buf));
		}
	    }
	    if (prev_draw[CRIT-5]+win_size/scale_width >= win_edge[CRIT-5]-1) {
		prev_draw[CRIT-5] -= scroll_width[CRIT-5];
		/* increment scale number on left side  */
		left_scale[CRIT-5]+=scroll_width[CRIT-5]*scale_width/win_size;
		right_scale[CRIT-5]+=scroll_width[CRIT-5]*scale_width/win_size;
		/* increment scale number on right side */
		/* scroll the screen of the open windows */
		if (windows[CRIT].opt1) {
		    XCopyArea(mydisplay, windows[CRIT].window, 
		      windows[CRIT].window, gc[CRIT], 31 + 
		      scroll_width[CRIT-5], 16, win_edge[CRIT-5]+1 - 31 - 
		      scroll_width[CRIT-5], windows[CRIT].height-15 - 16, 31, 
		      16);
		    /* area from left edge of screen plus scroll width to
		       right edge of screen is copied to left edge of screen */
		    XClearArea(mydisplay, windows[CRIT].window, 
		      win_edge[CRIT-5]+1 - scroll_width[CRIT-5], 16, 
		      scroll_width[CRIT-5], windows[CRIT].height-15 - 16,False);
		    /* area from left edge plus scroll width to right edge is
		       cleared */
		    sprintf(buf, "%d", left_scale[CRIT-5]);
		    XDrawImageString(mydisplay, windows[CRIT].window, gc[CRIT],
			27, windows[CRIT].height-15+10, buf, strlen(buf));
		    /* rewrite scale number on left side of screen */
		    sprintf(buf, "%d", right_scale[CRIT-5]);
		    XDrawImageString(mydisplay, windows[CRIT].window,
			gc[CRIT], win_edge[CRIT-5]-6*strlen(buf)+6,
			windows[CRIT].height-5, buf, strlen(buf));
		}
	    }
	    if (prev_draw[TRAF-5]+win_size/scale_width>=win_edge[TRAF-5]-1){
		prev_draw[TRAF-5] -= scroll_width[TRAF-5];
		/* increment scale number on left side  */
		left_scale[TRAF-5] += scroll_width[TRAF-5] 
		    * scale_width / win_size;
	        right_scale[TRAF-5]+=scroll_width[TRAF-5]
		    *scale_width/win_size;
		/* increment scale number on right side */
		if (windows[TRAF].opt1)
		{
                    XCopyArea(mydisplay, windows[TRAF].window, 
		      windows[TRAF].window, gc[TRAF], 41 + scroll_width[TRAF-5],
			22, win_edge[TRAF-5] - 41 - scroll_width[TRAF-5],
                        windows[TRAF].height-37, 41, 22);
                    XClearArea(mydisplay, windows[TRAF].window, 
		      win_edge[TRAF-5] - scroll_width[TRAF-5], 22, 
		      scroll_width[TRAF-5], windows[TRAF].height-38, False);
		    sprintf(buf, "%d", left_scale[TRAF-5]);
                    XDrawImageString(mydisplay, windows[TRAF].window, gc[TRAF],
			37,  windows[TRAF].height-4, buf, strlen(buf));
		    sprintf(buf, "%d", right_scale[TRAF-5]);
                    XDrawImageString(mydisplay, windows[TRAF].window,
                        gc[TRAF], win_edge[TRAF-5]-6*strlen(buf)+6,
			windows[TRAF].height-4, buf, strlen(buf));
		}
	    }
	    if(prev_draw[SPTM-5]+win_size/scale_width >= win_edge[SPTM-5]-1) {
		prev_draw[SPTM-5] -= scroll_width[SPTM-5];
		/* increment scale number on left side  */
		left_scale[SPTM-5]+=scroll_width[SPTM-5]*scale_width/win_size;
		right_scale[SPTM-5]+=scroll_width[SPTM-5]*scale_width/win_size;
		/* increment scale number on right side */
		/* scroll the screen of the open windows */
		if (windows[SPTM].opt1) {
		    XCopyArea(mydisplay, windows[SPTM].window, 
		      windows[SPTM].window, gc[SPTM], 31 + 
		      scroll_width[SPTM-5], 16, win_edge[SPTM-5]+1 - 31 - 
		      scroll_width[SPTM-5], windows[SPTM].height-15 - 16, 31, 
		      16);
		    /* area from left edge of screen plus scroll width to
		       right edge of screen is copied to left edge of screen */
		    XClearArea(mydisplay, windows[SPTM].window, 
		      win_edge[SPTM-5]+1 - scroll_width[SPTM-5], 16, 
		      scroll_width[SPTM-5], windows[SPTM].height-15 - 16,False);
		    /* area from left edge plus scroll width to right edge is
		       cleared */
		    sprintf(buf, "%d", left_scale[SPTM-5]);
		    XDrawImageString(mydisplay, windows[SPTM].window, gc[SPTM],
			27, windows[SPTM].height-15+10, buf, strlen(buf));
		    /* rewrite scale number on left side of screen */
		    sprintf(buf, "%d", right_scale[SPTM-5]);
		    XDrawImageString(mydisplay, windows[SPTM].window,
			gc[SPTM], win_edge[SPTM-5]-6*strlen(buf)+6,
			windows[SPTM].height-5, buf, strlen(buf));
		}
	    }
	    if(prev_draw[UTLC-5]+win_size/scale_width>=win_edge[UTLC-5]){
		prev_draw[UTLC-5] -= scroll_width[UTLC-5];
		/* increment scale number on left side  */
		left_scale[UTLC-5]+=scroll_width[UTLC-5]*scale_width/win_size;
		right_scale[UTLC-5]+=scroll_width[UTLC-5]*scale_width/win_size;
		/* increment scale number on right side */
		if (windows[UTLC].opt1)
		{
		  XCopyArea(mydisplay, windows[UTLC].window, 
		    windows[UTLC].window, gc[UTLC], 31 + scroll_width[UTLC-5], 
		    14, win_edge[UTLC-5] - 31 - scroll_width[UTLC-5],
		    windows[UTLC].height-70,31, 14);
		  XClearArea(mydisplay, windows[UTLC].window, win_edge[UTLC-5] -
		    scroll_width[UTLC-5], 14, scroll_width[UTLC-5],
		     windows[UTLC].height-70, False);
		  sprintf(buf, "%d", left_scale[UTLC-5]);
		  XDrawImageString(mydisplay, windows[UTLC].window, gc[UTLC],
		    27, windows[UTLC].height-46, buf, strlen(buf));
		  sprintf(buf, "%d", right_scale[UTLC-5]);
		  XDrawImageString(mydisplay, windows[UTLC].window,
		    gc[UTLC], win_edge[UTLC-5]-6*strlen(buf)+6,
		    windows[UTLC].height-46, buf, strlen(buf));
		}
	    }
	    if (prev_draw[TSKG-5]+win_size/scale_width>=win_edge[TSKG-5]){
		prev_draw[TSKG-5] -= scroll_width[TSKG-5];
		which_map+=scroll_width[TSKG-5];
		/* increment scale number on left side  */
		left_scale[TSKG-5]+=scroll_width[TSKG-5]*scale_width/win_size;
		right_scale[TSKG-5]+=scroll_width[TSKG-5]*scale_width/win_size;
		/* increment scale number on right side */
		/* increment scale number on right side */
		if (windows[TSKG].opt1) {
		    XCopyArea(mydisplay, windows[TSKG].window, 
		      windows[TSKG].window, gc[TSKG], 31 + scroll_width[TSKG-5],
		      14, win_edge[TSKG-5] - 31 - scroll_width[TSKG-5],
			windows[TSKG].height-62,31, 14);
		    XClearArea(mydisplay, windows[TSKG].window, 
		      win_edge[TSKG-5] - scroll_width[TSKG-5], 15, 
		      scroll_width[TSKG-5], windows[TSKG].height-63, False);
		    sprintf(buf, "%d", left_scale[TSKG-5]);
		    XDrawImageString(mydisplay, windows[TSKG].window, gc[TSKG],
			27, windows[TSKG].height-38, buf, strlen(buf));
		    sprintf(buf, "%d", right_scale[TSKG-5]);
		    XDrawImageString(mydisplay, windows[TSKG].window,
			gc[TSKG], win_edge[TSKG-5]-6*strlen(buf)+6,
			windows[TSKG].height-38, buf, strlen(buf));
		}
	    }
	    if (prev_draw[UTLG-5]+win_size/scale_width>=win_edge[UTLG-5]){
		prev_draw[UTLG-5] -= scroll_width[UTLG-5];
		/* increment scale number on left side  */
		left_scale[UTLG-5]+=scroll_width[UTLG-5]*scale_width/win_size;
		right_scale[UTLG-5]+=scroll_width[UTLG-5]*scale_width/win_size;
		/* increment scale number on right side */
		/* increment scale number on right side */
		if (windows[UTLG].opt1) {
		    XCopyArea(mydisplay, windows[UTLG].window, 
		      windows[UTLG].window, gc[UTLG], 31 + scroll_width[UTLG-5],
		      14, win_edge[UTLG-5] - 31 - scroll_width[UTLG-5],
			windows[UTLG].height-62,31, 14);
		    XClearArea(mydisplay, windows[UTLG].window, 
		      win_edge[UTLG-5] - scroll_width[UTLG-5], 15, 
		      scroll_width[UTLG-5], windows[UTLG].height-63, False);
		    sprintf(buf, "%d", left_scale[UTLG-5]);
		    XDrawImageString(mydisplay, windows[UTLG].window, gc[UTLG], 
			27, windows[UTLG].height-38, buf, strlen(buf));
		    sprintf(buf, "%d", right_scale[UTLG-5]);
		    XDrawImageString(mydisplay, windows[UTLG].window,
			gc[UTLG], win_edge[UTLG-5]-6*strlen(buf)+6,
			windows[UTLG].height-38, buf, strlen(buf));
		}
	    }
		/* call functions to draw in windows that scroll */
		if (windows[UTLC].opt1)
		    utilization_count();
		if (windows[CRIT].opt1)
		    crit_path_status();
		if (windows[SPTM].opt1 && num_nodes<=128)
		    spacetime_status();
		if (windows[UTLG].opt1)
		    util_gantt();
		if (windows[TSKG].opt1)
		    task_gantt();
		if (windows[TRAF].opt1)
		    traffic();
                if (u_win && u_scroll)
                    u_draw();

		/* increment drawing point (move over) */
		for(i=TSKG;i<=TRAF;i++)
		    prev_draw[i-5] += win_size / scale_width;
	    /* write time in clock window */
	    sprintf(buf, "%d ", prev_time + spin + 1);
	    if (windows[CLOK].opt1)
		XDrawImageString(mydisplay, windows[CLOK].window,
		    gc[CLOK], 64 + (48 - strlen(buf) * 8) / 2, 16, buf,
		    strlen(buf));
		/* fill in time bar */
		if(prev_time<max_time)
		if (((prev_time + spin + 1)*100)/max_time != prev_place) {
                    XFillRectangle(mydisplay, windows[CLOK].window, gc[TMBR],
			6+prev_place, 28, ((prev_time + spin + 1)*100)/
			(max_time) - prev_place , 17);
                    prev_place = ((prev_time + spin + 1) * 100)/
			(max_time);
		}
        }

        if(cur_time>prev_time){
          for(i=0; i<num_nodes; i++){
            if(i!=node){
              if(state[i]==2){
                sum_ovhd[i]+=raw_time-start_ovhd[i];
                cur_streak[i].ovhd_idle+=raw_time-start_ovhd[i];
                cur_streak[i].busy_ovhd+=raw_time-start_ovhd[i];
                start_ovhd[i]=raw_time;
              }
              if(state[i]==1){
                sum_busy[i]+=raw_time-start_busy[i];
                cur_streak[i].busy+=raw_time-start_busy[i];
                cur_streak[i].busy_ovhd+=raw_time-start_busy[i];
                start_busy[i]=raw_time;
              }
              if(state[i]==0){
                cur_streak[i].idle+=raw_time-start_idle[i];
                cur_streak[i].ovhd_idle+=raw_time-start_idle[i];
                start_idle[i]=raw_time;
              }
              if(cur_streak[i].busy_ovhd>max_streak[i].busy_ovhd)
                max_streak[i].busy_ovhd=cur_streak[i].busy_ovhd;
              if(cur_streak[i].busy>max_streak[i].busy)
                max_streak[i].busy=cur_streak[i].busy;
              if(cur_streak[i].idle>max_streak[i].idle)
                max_streak[i].idle=cur_streak[i].idle;
              if(cur_streak[i].ovhd_idle>max_streak[i].ovhd_idle)
                max_streak[i].ovhd_idle=cur_streak[i].ovhd_idle;
            }
          }
        }
          if(prev_state[node]==2){
            sum_ovhd[node]+=raw_time-start_ovhd[node];
            cur_streak[node].ovhd_idle+=raw_time-start_ovhd[node];
            cur_streak[node].busy_ovhd+=raw_time-start_ovhd[node];
          }
          if(prev_state[node]==1){
            sum_busy[node]+=raw_time-start_busy[node];
            cur_streak[node].busy+=raw_time-start_busy[node];
            cur_streak[node].busy_ovhd+=raw_time-start_busy[node];
          }
          if(prev_state[node]==0){
            cur_streak[node].idle+=raw_time-start_idle[node];
            cur_streak[node].ovhd_idle+=raw_time-start_idle[node];
          }
          if(state[node]==2) start_ovhd[node]=raw_time;
          if(state[node]==1) start_busy[node]=raw_time;
          if(state[node]==0) start_idle[node]=raw_time;
          if(cur_streak[node].busy_ovhd>max_streak[node].busy_ovhd)
            max_streak[node].busy_ovhd=cur_streak[node].busy_ovhd;
          if(cur_streak[node].busy>max_streak[node].busy)
            max_streak[node].busy=cur_streak[node].busy;
          if(cur_streak[node].idle>max_streak[node].idle)
            max_streak[node].idle=cur_streak[node].idle;
          if(cur_streak[node].ovhd_idle>max_streak[node].ovhd_idle)
            max_streak[node].ovhd_idle=cur_streak[node].ovhd_idle;

        if(key_index!=TEXIT&&key_index!=CLOSE){
          if(windows[KVTB].opt1==0)
            current_util_pct[node]=kiv(raw_time, sum_busy[node], node);
          else current_util_pct[node]=kiv(raw_time, sum_busy[node]+
            sum_ovhd[node], node);
        }
        else current_util_pct[node]=0;

        count_busy[prev_count-prev_diff_count]+=cur_time-prev_time;
        count_ovhd[prev_diff_count]+=cur_time-prev_time;
        count_idle[num_nodes-prev_count]+=cur_time-prev_time;
	if (windows[MTRB].opt1 == 0)
	    cmmt_load = comm_count;
	else cmmt_load = comm_vol;
        if (windows[SIZB].opt1 == 0){
	    if (windows[TRNB].opt1 <num_nodes)
                traf_prev_load[windows[TRNB].opt1] = 
		  queu_count[windows[TRNB].opt1];
            comm_prev_load = comm_count;
        }else{
	    if (windows[TRNB].opt1 <num_nodes)
                traf_prev_load[windows[TRNB].opt1] = 
		  queu_vol[windows[TRNB].opt1];
	    comm_prev_load = comm_vol;
        }
	if (cur_time-prev_time > 0) {
	    cum_util += (prev_count-prev_diff_count)*(cur_time-prev_time);
	    cum_comm = cum_comm+prev_comm_count*(cur_time-prev_time);
	}
        phpt_point[0]=30+avg_util();
        phpt_point[1]=phpt_height+30-avg_comm();
	if (windows[MESB].opt1 == 0)
	    for(i=0; i<num_nodes; i++)
	       queu_load[i] = queu_count[i];
	else for(i=0; i<num_nodes; i++)
	    queu_load[i] = queu_vol[i];

	for (i = 0; i < num_nodes; i++) {
            prev_pct_busy[i] = pct_busy[i];
            prev_pct_ovhd[i] = pct_ovhd[i];
	    if(cur_time>0){
	      pct_busy[i] = pct_busy_sum[i]/cur_time;
	      pct_ovhd[i] = pct_ovhd_sum[i]/cur_time;
	    }
	}
	 /*call functions to draw in windows that don't scroll */
	if (windows[ANIM].opt1&&((num_nodes<=128&&windows[ATYB].opt1==0)||
	    windows[ATYB].opt1==1||windows[ATYB].opt1==2))
	    animation();
        if (windows[HYPE].opt1 && num_nodes<=16)
	    hypeconnection();
        if (windows[NTWK].opt1 && num_nodes<=128&&
            (((key_index==RECV||key_index==RECVWAKE)&&(node!=HOST&&
              from!=HOST))||((key_index==SEND)&&(node!=HOST&&dest!=HOST))))
	    network();
	if (windows[MTRX].opt1)
	    matrix();
	if (windows[PSTA].opt1)
	    proc_status();
	if (windows[TSKS].opt1)
	    task_completion();
/*	if(windows[TSMY].opt1)
	    task_summary();*/
        if (windows[KIVT].opt1&&current_util_pct[node]!=node_util[order[node]])
	    kiviat();
	if (windows[QUEU].opt1)
	    msg_queues();
        if (windows[STRK].opt1&&cur_time>prev_time)
            draw_streak();
	if (windows[TSKC].opt1)
	    task_cnt();
	if (windows[UTLS].opt1)
	    util_smry();
	if (windows[PHPT].opt1)
	    phase_portrait();
	if (u_win && !u_scroll)
	    u_draw();
	if (windows[CMMT].opt1)
	    communication_meter();
	if (windows[UTMT].opt1)
	    utilization_meter();
        if ((key_index==RECV || key_index==RECVWAKE)){
	    if (windows[CRIT].opt1)
	        crit_path_communication();
        }
        if ((key_index==RECV || key_index==RECVWAKE) && num_nodes<=128){
	    if (windows[SPTM].opt1)
	        spacetime_communication();
        }

        if(node!=HOST&&cur_time>=rec_start_time&&cur_time<=rec_stop_time) 
	  record_data();

        if(prev_state[node]!=state[node]){
          if(state[node]==0){
            cur_streak[node].busy=0;
            cur_streak[node].busy_ovhd=0;
          }else if(state[node]==1){
            cur_streak[node].idle=0;
            cur_streak[node].ovhd_idle=0;
          }else if(state[node]==2){
            cur_streak[node].idle=0;
            cur_streak[node].busy=0;
          }
        }

	/* save old number */
	node_util[order[node]] = current_util_pct[node];
	prev_count = util_count;
	prev_diff_count = util_diff_count;
	prev_comm_count = comm_count;
	prev_cmmt_load = cmmt_load;
	for (i = 0; i < num_nodes; i++) {
	    prev_anim_state[i] = anim_state[i];
	    prev_state[i] = state[i];
	    prev_ptr[i] = task_ptr[i];
        }

	prev_time = cur_time;
    /*now the new point becomes the old point*/
    phpt_last_point[0]=phpt_point[0];
    phpt_last_point[1]=phpt_point[1];
	if (node==windows[SNDB].opt1)
	  if (windows[NINF].opt1 && num_nodes<=256)
	    node_info();
    } else {	/* we have not reached start time */
    if(first_not_draw){
	first_not_draw=0;
        XClearWindow(mydisplay, windows[RUNB].window);
        XDrawImageString(mydisplay, windows[RUNB].window, gc[MENU], 12, 10,
            "Please Wait", strlen("Please Wait"));
    }
        prev_time = cur_time;
        for(i=0; i<num_nodes/2; i++) {
	    kx[order[i*2]]
	        = (int) k_center_x + current_util_pct[i*2] *
		radius*cos(2*PI*order[i*2]/num_nodes);
	    ky[order[i*2]]
		= (int) k_center_y + current_util_pct[i*2] *
		radius*sin(2*PI*order[i*2]/num_nodes);
	    kx[(order[i*2]+1) % num_nodes]
	        = (int) k_center_x + current_util_pct[(i*2+1)%num_nodes] *
		radius*cos(2*PI*order[(i*2+1)%num_nodes]/num_nodes);
	    ky[(order[i*2]+1) % num_nodes]
	        = (int) k_center_y + current_util_pct[(i*2+1)%num_nodes] *
		radius*sin(2*PI*order[(i*2+1)%num_nodes]/num_nodes);
	    kx[(order[i*2]-1+num_nodes) % num_nodes]
	        = (int) k_center_x +
                current_util_pct[(i*2-1+num_nodes)%num_nodes] *
		radius*cos(2*PI*order[(i*2-1+num_nodes)%num_nodes]/num_nodes);
	    ky[(order[i*2]-1+num_nodes) % num_nodes]
	        = (int) k_center_y +
                current_util_pct[(i*2-1+num_nodes)%num_nodes] *
		radius*sin(2*PI*order[(i*2-1+num_nodes)%num_nodes]/num_nodes);
	}
	/* set previous time equal to current time */
	/* set left scale equal to start time */ 
	/* set right scale equal to left scale plus scale width */
	prev_draw[SPTM-5]=31;
	prev_draw[CRIT-5]=31;
	prev_draw[NINF-5]=31;
	prev_draw[TSKG-5]=31;
	prev_draw[UTLG-5]=31;
	prev_draw[UTLC-5]=31;
	prev_draw[TRAF-5]=41;
	for(i=TSKG; i<=TRAF; i++){
	  left_scale[i-5] = prev_time;
	  right_scale[i-5] = left_scale[i-5] + scale_width;
	}
    }
  }
}
phase_portrait()
{
    /*Don't want to draw anything if it is the first point because it will
      always be (0,0)*/
    if(phpt_first_point==1)
	phpt_first_point=0;
    /*Draw only if it is a new point*/
    else if (phpt_point[0]!=phpt_last_point[0] || phpt_point[1]!=phpt_last_point[1]) {
	if(prev_ptr[0]>=0 && monochrome ==0 && depth!=1)
	/*Draw line from old point to new point with task color*/
	XDrawLine(mydisplay, windows[PHPT].window, gc[TSK0+
	  task[0][prev_ptr[0]]%64], phpt_last_point[0], phpt_last_point[1], 
	  phpt_point[0], phpt_point[1]);
	/*Draw line from old point to new point black*/
	else XDrawLine(mydisplay, windows[PHPT].window, gc[PHDL], 
	  phpt_last_point[0], phpt_last_point[1], phpt_point[0], phpt_point[1]);
    }
}
draw_streak()
{
    int i, top_val, bottom_val, mid_val, max_top, max_bottom, num_pix;

    if((num_pix=(windows[STRK].width-64)/num_nodes)==0) num_pix=1;

    if(windows[SRKB].opt1){
      mid_val=23+((max_streaks.busy_ovhd/time_unit+1)*
	(windows[STRK].height-46))/((max_streaks.busy_ovhd+max_streaks.idle)/
	time_unit+1);
      max_top=max_streaks.busy_ovhd/time_unit;
      max_bottom=max_streaks.idle/time_unit;
    }else{
      mid_val=23+((max_streaks.busy/time_unit+1)*(windows[STRK].height-46))/
        ((max_streaks.busy+max_streaks.ovhd_idle)/time_unit+1);
      max_top=max_streaks.busy/time_unit;
      max_bottom=max_streaks.ovhd_idle/time_unit;
    }
    for(i=0; i<num_nodes; i++){
      if(windows[SRKB].opt1){
        top_val=cur_streak[i].busy_ovhd/time_unit;
        bottom_val=cur_streak[i].idle/time_unit;
      }else{
        top_val=cur_streak[i].busy/time_unit;
        bottom_val=cur_streak[i].ovhd_idle/time_unit;
      }

      if(top_val>streak_last_top[i]){
        XFillRectangle(mydisplay, windows[STRK].window, gc[BSYS], 
	  33+order[i]*num_pix, mid_val-1-(top_val*(windows[STRK].height-46))/
	  (max_top+max_bottom+1), num_pix, ((top_val-streak_last_top[i])*
	  (windows[STRK].height-46))/ (max_top+max_bottom+1)+1);
      }else if(top_val<streak_last_top[i]){
        XFillRectangle(mydisplay, windows[STRK].window, gc[ERAS], 
	  33+order[i]*num_pix, mid_val-1-(streak_last_top[i]*
	  (windows[STRK].height-46))/ (max_top+max_bottom+1), num_pix, 
	  ((streak_last_top[i]-top_val)*(windows[STRK].height-46))/
	  (max_top+max_bottom+1)+1);
      }
      if(bottom_val>streak_last_bottom[i]){
        XFillRectangle(mydisplay, windows[STRK].window, gc[IDLS], 
	  33+order[i]*num_pix, mid_val+1+((streak_last_bottom[i])*
	  (windows[STRK].height-46))/(max_top+max_bottom+1), num_pix, 
	  ((bottom_val-streak_last_bottom[i])*(windows[STRK].height-46))/
	  (max_top+max_bottom+1)+1);
      }else if(bottom_val<streak_last_bottom[i]){
        XFillRectangle(mydisplay, windows[STRK].window, gc[ERAS], 
	  33+order[i]*num_pix, mid_val+1+(bottom_val*(windows[STRK].height-46))/
          (max_top+max_bottom+1), num_pix, ((streak_last_bottom[i]-bottom_val)*
          (windows[STRK].height-46))/(max_top+max_bottom+1)+1);
      }
      streak_last_top[i]=top_val;
      streak_last_bottom[i]=bottom_val;
    }
}
msg_queues()
{
    XPoint poly[4];
    int num_pix;

       if((num_pix=(windows[QUEU].width-60)/num_nodes)==0) num_pix=1;
       switch (key_index) {
     
     /*in the case of a send a rectangle is drawn from the bottom of the display
       up to the queu value, translated into pixels*/
       case SEND:

	   if(dest!=HOST){
	   poly[0].x=poly[3].x=31+dest*num_pix;
	   poly[1].x=poly[2].x=31+dest*num_pix+num_pix;
   	   poly[0].y=poly[1].y=windows[QUEU].height-33;
	   poly[2].y=poly[3].y=windows[QUEU].height-33-
	       (windows[QUEU].height-57)*queu_load[dest]/queu_max_load;
	   XFillPolygon(mydisplay, windows[QUEU].window, gc[MSQC], poly, 4, 
	     Convex, CoordModeOrigin);
	   last_queue_count[dest] = queu_load[dest];
	   }
	   break;

     /*in the case of a recv a rectangle is drawn from the queu value, 
       translated into pixels to the last queu value translated into pixels*/
       case RECV:
       case RECVWAKE:

	   if(node!=HOST){
	   poly[0].x=poly[3].x=31+node*num_pix;
	   poly[1].x=poly[2].x=31+node*num_pix+num_pix;
   	   poly[0].y=poly[1].y=windows[QUEU].height-33-
	       (windows[QUEU].height-57)* last_queue_count[node]/queu_max_load;
	   poly[2].y=poly[3].y=windows[QUEU].height-33-
	       (windows[QUEU].height-57)*queu_load[node]/queu_max_load;
	   XFillPolygon(mydisplay, windows[QUEU].window, gc[MSQH], poly, 4, 
	     Convex, CoordModeOrigin);
	   last_queue_count[node] = queu_load[node];
	   }
           break;
       }
}
task_summary()
{
       int i;
	
       for(i=0; i<total_tasks; i++){
         if(start_task[i]<cur_time&&start_task[i]<=prev_time){
	   XFillRectangle(mydisplay, windows[TSMY].window, gc[TSK0+i%64],
	     31+i*(windows[TSMY].width-60)/total_tasks, tsmy_bottom-
	     (prev_time*tsmy_height)/(stop_time-start_time),
	     (windows[TSMY].width-60)/total_tasks, (cur_time-prev_time)*
	     tsmy_height/(stop_time-start_time));

	 }
       }
}
task_cnt()
{
 
       if (key_index == USERBLOCKBEGIN){
       /*draw rectangle with appropriate gc, according to task number,
	 from number of tasks in progress down the width equal to one task,
	 since a USERBLOCKBEGIN adds only one more task to the number of
	 tasks in progress*/
           XFillRectangle(mydisplay, windows[TSKC].window,
                gc[TSK0+task_num%64], 30 + task_num *
                (tskc_width/total_tasks), 20 + tskc_height -
                (tsks_prog[task_num] * tskc_height)/num_nodes,
                tskc_width/total_tasks, tskc_height/num_nodes + 1);
       } else if (key_index == USERBLOCKEND){
       /*draw rectangle with erase gc from number of tasks in progress +1 
	 down the width equal to one task,
	 since a USERBLOCKEND subtracts only one task from the number of
	 tasks in progress*/
           XFillRectangle(mydisplay, windows[TSKC].window, gc[ERAS],
               30 + task_num * (tskc_width/total_tasks),
               20 + tskc_height - (tsks_prog[task_num] + 1)*
               tskc_height/num_nodes, tskc_width/total_tasks,
               tskc_height/num_nodes + 1);
       }
}
traffic()
{
    XPoint poly[4];

/*    if((key_index==SEND||key_index==RECV||key_index==RECVWAKE)&&
	  spin==cur_time-prev_time-1)*/
    if(cur_time!=prev_time){
      if (windows[TRNB].opt1<num_nodes){
	 if(traf_prev_load[windows[TRNB].opt1]>0){
           poly[2].y = poly[3].y = windows[TRAF].height-16;
	   poly[0].x = prev_draw[TRAF-5];
	   poly[0].y = poly[1].y =  windows[TRAF].height-16 -
	       ((windows[TRAF].height-38)*traf_prev_load[windows[TRNB].opt1])/
	       comm_max_load;
	   poly[1].x = prev_draw[TRAF-5]+win_size/scale_width;
	   poly[2].x = prev_draw[TRAF-5]+win_size/scale_width;
	   poly[3].x = prev_draw[TRAF-5];

	   XFillPolygon(mydisplay, windows[TRAF].window, gc[COMH],
	     poly, 4, Convex, CoordModeOrigin);
	 }
	      
      }else if (windows[TRNB].opt1 == num_nodes){

	if (comm_prev_load>0) {
           poly[2].y = poly[3].y = windows[TRAF].height-16;
	   poly[0].x = prev_draw[TRAF-5];
	   poly[0].y = poly[1].y =  windows[TRAF].height-16 -
	       ((windows[TRAF].height-38)*comm_prev_load)/comm_max_load ;
	   poly[1].x = prev_draw[TRAF-5]+win_size/scale_width;
	   poly[2].x = prev_draw[TRAF-5]+win_size/scale_width;
	   poly[3].x = prev_draw[TRAF-5];

	   XFillPolygon(mydisplay, windows[TRAF].window, gc[COMH],
	     poly, 4, Convex, CoordModeOrigin);
	      
        }

    }
  }
}
communication_meter()
{
  int temp1;

	/*draw from current communication load down to last load*/
        if (cmmt_load>prev_cmmt_load){
          if(cmmt_load<0) temp1=0;
          else temp1=cmmt_load;

	   XFillRectangle(mydisplay, windows[CMMT].window, gc[COMH],
	     30, windows[CMMT].height-10-(windows[CMMT].height-46)*
	     temp1/meter_max_load, windows[CMMT].width-39,
	     (windows[CMMT].height-46)*(cmmt_load-prev_cmmt_load)/
	     meter_max_load+1);
	}
	/*erase from last communication load down to current load*/
        if (cmmt_load<prev_cmmt_load){
          if(prev_cmmt_load<0) temp1=0;
          else temp1=prev_cmmt_load;

	   XFillRectangle(mydisplay, windows[CMMT].window, gc[ERAS],
	     30, windows[CMMT].height-10-(windows[CMMT].height-46)*
	     (temp1)/meter_max_load, windows[CMMT].width-39,
	     (windows[CMMT].height-46)*(prev_cmmt_load-cmmt_load)/
	     meter_max_load+1);
        }
}

utilization_meter()
{

        if (util_count>prev_count && util_count-prev_count>0)
	   XFillRectangle(mydisplay, windows[UTMT].window, gc[UTLO],
	     30, windows[UTMT].height-10-(windows[UTMT].height-26)*
	     util_count/num_nodes, windows[UTMT].width-39, 
	     (windows[UTMT].height-26)* (util_count-prev_count)/num_nodes+1);
        if (util_count-util_diff_count>prev_count-prev_diff_count)
	   XFillRectangle(mydisplay, windows[UTMT].window, gc[UTLB],
	     30, windows[UTMT].height-10-(windows[UTMT].height-26)*
	     (util_count-util_diff_count)/num_nodes, windows[UTMT].width-39,
	     (windows[UTMT].height-26)*(util_count-util_diff_count-
	     prev_count+prev_diff_count)/ num_nodes+1);
        if (util_count-util_diff_count<prev_count-prev_diff_count)
	   XFillRectangle(mydisplay, windows[UTMT].window, gc[UTLO],
	     30, windows[UTMT].height-10-(windows[UTMT].height-26)*
	     (prev_count-prev_diff_count)/num_nodes, windows[UTMT].width-39,
	     (windows[UTMT].height-26)*(prev_count-prev_diff_count-
	     util_count+util_diff_count)/ num_nodes+1);
        if (util_count<prev_count)
	   XFillRectangle(mydisplay, windows[UTMT].window, gc[UTLI],
	     30, windows[UTMT].height-10-(windows[UTMT].height-26)*
	     prev_count/num_nodes, windows[UTMT].width-39, 
	     (windows[UTMT].height-26)* (prev_count-util_count)/num_nodes+1);
}

utilization_count()
{
    XPoint poly[4];

    if (cur_time != prev_time) {
	if (prev_count!=0) {
           /* y coordinate of two vertices of utilization polygon are equal to
              bottom of chart */
           poly[2].y = poly[3].y = windows[UTLC].height-56;
	   /* x coord of one vertex is where we were last */
	   poly[0].x = prev_draw[UTLC-5];
	   /* y coord is height of last count */
	   poly[0].y = poly[1].y =  windows[UTLC].height-56-(prev_count*
	      (windows[UTLC].height-71))/num_nodes;
	   /* x coord of vertex is last one incremented */
	   poly[1].x = prev_draw[UTLC-5] + win_size / scale_width;
	   /* x coords of 2 and 3 (bottom of chart) are same as 0 and 1,
	      respectively */
	   poly[2].x = prev_draw[UTLC-5] + win_size / scale_width;
	   poly[3].x = prev_draw[UTLC-5];

	   XFillPolygon(mydisplay, windows[UTLC].window, gc[UTLB],
	     poly, 4, Convex, CoordModeOrigin);
	      
           if (prev_count!=num_nodes) {
	       /* x coord of one vertex is where we were last */
	       poly[0].x = prev_draw[UTLC-5];
	       /* y coord is height of last count */
	       poly[0].y = poly[1].y =  windows[UTLC].height-56-(prev_count*
	          (windows[UTLC].height-71))/num_nodes;
	       /* x coord of vertex is last one incremented */
	       poly[1].x = prev_draw[UTLC-5] + win_size / scale_width;
	       poly[2].x = prev_draw[UTLC-5] + win_size / scale_width;
	       poly[3].x = prev_draw[UTLC-5];
               poly[2].y = poly[3].y = windows[UTLC].height-56-(num_nodes*
		   (windows[UTLC].height-71))/num_nodes;

	   XFillPolygon(mydisplay, windows[UTLC].window, gc[UTLI],
	        poly, 4, Convex, CoordModeOrigin);
	   }
	   if (prev_diff_count){
	      if (prev_diff_count!= prev_count){
	         poly[2].y = poly[3].y =  windows[UTLC].height-56-(prev_count*
	          (windows[UTLC].height-71))/num_nodes;
	         /* x coord of one vertex is where we were last */
	         poly[0].x = prev_draw[UTLC-5];
	         /* y coord is height of last count */
	         poly[0].y = poly[1].y =  windows[UTLC].height-56-
		    ((prev_count-prev_diff_count)*(windows[UTLC].height-71))/
		    num_nodes;
	         /* x coord of vertex is last one incremented */
	         poly[1].x = prev_draw[UTLC-5] + win_size / scale_width;
	         poly[2].x = prev_draw[UTLC-5] + win_size / scale_width;
	         poly[3].x = prev_draw[UTLC-5];

	         XFillPolygon(mydisplay, windows[UTLC].window, gc[UTLO],
	           poly, 4, Convex, CoordModeOrigin);
	      } else {
	      poly[2].y = poly[3].y =  windows[UTLC].height-56-(prev_count*
	        (windows[UTLC].height-71))/num_nodes;
	      /* x coord of one vertex is where we were last */
	      poly[0].x = prev_draw[UTLC-5];
	      /* y coord is height of last count */
	      poly[0].y = poly[1].y =  windows[UTLC].height-56;
	      /* x coord of vertex is last one incremented */
	      poly[1].x = prev_draw[UTLC-5] + win_size / scale_width;
	      /* x coords of 2 and 3 (bottom of chart) are same as 0 and 1,
	         respectively */
	      poly[2].x = prev_draw[UTLC-5] + win_size / scale_width;
	      poly[3].x = prev_draw[UTLC-5];

	      XFillPolygon(mydisplay, windows[UTLC].window, gc[UTLO],
	        poly, 4, Convex, CoordModeOrigin);
	      }
	   }
        } else {
	   /* x coord of one vertex is where we were last */
	   poly[0].x = prev_draw[UTLC-5];
	   /* y coord is height of last count */
	   poly[0].y = poly[1].y = 14;
	   /* x coord of vertex is last one incremented */
	   poly[1].x = prev_draw[UTLC-5] + win_size / scale_width;
	   /* x coords of 2 and 3 (bottom of chart) are same as 0 and 1,
	      respectively */
	   poly[2].x = prev_draw[UTLC-5] + win_size / scale_width;
	   poly[3].x = prev_draw[UTLC-5];
	   poly[2].y = poly[3].y =  windows[UTLC].height-56;

	   XFillPolygon(mydisplay, windows[UTLC].window, gc[UTLI],
	        poly, 4, Convex, CoordModeOrigin);

        }


  }
}

util_gantt()
{
    int i, width, num_pix;

  if((num_pix=(windows[UTLG].height-64)/num_nodes)==0) num_pix=1;
  if(num_nodes<=16) width = 512 / scale_width;
  else width = 800 / scale_width;
    for (i = 0; i < num_nodes; i++) {
        /* if node is on (busy) draw filled rectangle */
            if (prev_state[i] == 1)
                XFillRectangle(mydisplay, windows[UTLG].window, gc[UTLB],
                    prev_draw[UTLG-5], windows[UTLG].height - 48
		    -(order[i]+1)*num_pix, width, num_pix);
            else if (prev_state[i] == 2)
                XFillRectangle(mydisplay, windows[UTLG].window, gc[UTLO],
                    prev_draw[UTLG-5], windows[UTLG].height - 48
		    -(order[i]+1)*(num_pix), width, num_pix);
            else if (!prev_state[i])
                XFillRectangle(mydisplay, windows[UTLG].window, gc[UTLI],
                    prev_draw[UTLG-5], windows[UTLG].height - 48
		    -(order[i]+1)*(num_pix), width, num_pix);
    }
}

task_gantt()
{
    int i, width, num_pix;

    if((num_pix=(windows[TSKG].height-64)/num_nodes)==0) num_pix=1;

    width = win_size / scale_width;
    for (i = 0; i < num_nodes; i++) {
      if ((prev_ptr[i]) >= 0) {
        if(monochrome||depth==1) 
	 XSetStipple(mydisplay, gc[TSK0+task[i][prev_ptr[i]]%64], 
          tmaps[(task[i][prev_ptr[i]]%64)%8][which_map%
	    tmap_w[(task[i][prev_ptr[i]]%64)%8]]);
        XFillRectangle(mydisplay, windows[TSKG].window, gc[TSK0 +
           task[i][prev_ptr[i]]%64], prev_draw[TSKG-5],
           windows[TSKG].height-48-(order[i]+1)*num_pix, width, num_pix);
        if(monochrome||depth==1) 
	 XSetStipple(mydisplay, gc[TSK0+task[i][prev_ptr[i]]%64], 
          tmaps[(task[i][prev_ptr[i]]%64)%8][0]);
      }
    }
}

node_info()
{
    switch(key_index){

    case RECV:
    case RECVWAKE:

      if (from!=HOST){

	switch(windows[STYB].opt1){

	case 0:
	    XDrawLine(mydisplay, windows[NINF].window, gc[CSTH], 
	      prev_draw[NINF-5], ninf_center + 1, prev_draw[NINF-5],
	      ninf_center+((order[from]+1)*ninf_height)/(num_nodes+1));
	    break;
	case 1:
	    XDrawLine(mydisplay, windows[NINF].window, gc[COL0+(msg_type-
	      min_type)%64], prev_draw[NINF-5], ninf_center + 1, 
	      prev_draw[NINF-5], ninf_center + 3 + 2 * (msg_type%64));
	    break;
	case 2:
	    if (msg_lth <= lth_bin[0])
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGND], 
	      prev_draw[NINF-5], ninf_center + 1, prev_draw[NINF-5],
	      ninf_center+1+ (msg_lth*ninf_height)/max_lth);
	    else if (msg_lth <= lth_bin[1])
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGN0], 
	      prev_draw[NINF-5], ninf_center + 1, prev_draw[NINF-5],
	      ninf_center+1+ (msg_lth*ninf_height)/max_lth);
	    else if (msg_lth <= lth_bin[2])
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGN1], 
	      prev_draw[NINF-5], ninf_center + 1, prev_draw[NINF-5],
	      ninf_center+1+ (msg_lth*ninf_height)/max_lth);
	    else if (msg_lth <= lth_bin[3])
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGN2], 
	      prev_draw[NINF-5], ninf_center + 1, prev_draw[NINF-5],
	      ninf_center+1+ (msg_lth*ninf_height)/max_lth);
	    else
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGN3], 
	      prev_draw[NINF-5], ninf_center + 1, prev_draw[NINF-5],
	      ninf_center+1+ (msg_lth*ninf_height)/max_lth);
	    break;
	case 3:
	    XDrawLine(mydisplay, windows[NINF].window, gc[COL0+
	      hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2, 
	      windows[DIMB].opt2, windows[COLB].opt1, from,windows[SNDB].opt1)],
	      prev_draw[NINF-5], ninf_center+1, prev_draw[NINF-5], 
	      ninf_center+1+(hops(windows[DSTB].opt1, num_nodes/
	      windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1, from,
	      windows[SNDB].opt1)* ninf_height)/(max_dist+1));
	    break;
	}
      }
      break;
    case SEND:

      if (dest!=HOST){

	switch(windows[STYB].opt1){

	case 0:
	    XDrawLine(mydisplay, windows[NINF].window, gc[CSTH], 
	      prev_draw[NINF-5], ninf_center - 1, prev_draw[NINF-5],
	      ninf_center-((order[dest]+1)*ninf_height)/(num_nodes+1));
	    break;
	case 1:
	    XDrawLine(mydisplay, windows[NINF].window, gc[COL0+
	      (msg_type-min_type)%64], prev_draw[NINF-5], ninf_center - 1, 
	      prev_draw[NINF-5], ninf_center - 3 - 2 * (msg_type%64));
	    break;
	case 2:
	    if (msg_lth <= lth_bin[0])
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGND], 
	      prev_draw[NINF-5], ninf_center - 1, prev_draw[NINF-5],
	      ninf_center-1-(msg_lth*ninf_height)/max_lth);
	    else if (msg_lth <= lth_bin[1])
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGN0], 
	      prev_draw[NINF-5], ninf_center - 1, prev_draw[NINF-5],
	      ninf_center-1-(msg_lth*ninf_height)/max_lth);
	    else if (msg_lth <= lth_bin[2])
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGN1], 
	      prev_draw[NINF-5], ninf_center - 1, prev_draw[NINF-5],
	      ninf_center-1-(msg_lth*ninf_height)/max_lth);
	    else if (msg_lth <= lth_bin[3])
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGN2], 
	      prev_draw[NINF-5], ninf_center - 1, prev_draw[NINF-5],
	      ninf_center-1-(msg_lth*ninf_height)/max_lth);
	    else
	    XDrawLine(mydisplay, windows[NINF].window, gc[LGN3], 
	      prev_draw[NINF-5], ninf_center - 1, prev_draw[NINF-5],
	      ninf_center-1-(msg_lth*ninf_height)/max_lth);
    	    break;
	case 3:
	    XDrawLine(mydisplay, windows[NINF].window, gc[COL0+
	      hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2, 
	      windows[DIMB].opt2, windows[COLB].opt1, windows[SNDB].opt1,dest)],
	      prev_draw[NINF-5], ninf_center-1, prev_draw[NINF-5], ninf_center-
	      1-(hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2, 
	      windows[DIMB].opt2, windows[COLB].opt1,windows[SNDB].opt1,dest)* 
	      ninf_height)/(max_dist+1));
	    break;
	}
      }
      break;

    }
}

crit_path_status()
{
    int i, num_pix;

    if((num_pix=(windows[CRIT].height-30)/(num_nodes+1))==0) num_pix=1;

    for (i = 0; i < num_nodes; i++) {
        /* if node is on (busy) draw in line segment/point */
        if (prev_state[i] == 1 || prev_state[i] ==2){
	    if(i==crit_node[crit_count]&&raw_time<=crit_time_send[crit_count]){
                XDrawLine(mydisplay, windows[CRIT].window, gc[CRTP],
                        prev_draw[CRIT-5], windows[CRIT].height-15-
			(order[i]+1)*num_pix, prev_draw[CRIT-5] + 
			win_size/scale_width, windows[CRIT].height-15- 
			(order[i]+1)* num_pix);
	     }else if(num_nodes<=32){ 
		 XDrawLine(mydisplay, windows[CRIT].window, gc[NCRP],
                        prev_draw[CRIT-5], windows[CRIT].height-15-
			(order[i]+1)*num_pix, prev_draw[CRIT-5] + 
			win_size/scale_width, windows[CRIT].height-15- 
			(order[i]+1)*num_pix);
	    }
	} 
    }
}
spacetime_status()
{
    int i, num_pix;

    if((num_pix=(windows[SPTM].height-30)/(num_nodes+1))==0) num_pix=1;

    for (i = 0; i < num_nodes; i++) {
        /* if node is on (busy) draw in line segment/point */
        if (prev_state[i] == 1 || prev_state[i] ==2)
                XDrawLine(mydisplay, windows[SPTM].window, gc[SPTH],
                        prev_draw[SPTM-5], windows[SPTM].height-15-
			(order[i]+1)*num_pix, prev_draw[SPTM-5] + 
			win_size/scale_width, windows[SPTM].height-15- 
			(order[i]+1)* num_pix);
    }
}
crit_path_communication()
{
    int time_diff, num_pix;

    if((num_pix=(windows[CRIT].height-30)/(num_nodes+1))==0) num_pix=1;

	if (from != HOST && node != HOST) {

	if (msg_count[from][node] >= 0)
	 time_diff = cur_time - sendpoint[from][node][msg_count[from][node]][0];
        else time_diff = 0;

	if(node==crit_node[crit_count]&&crit_time[crit_count]==raw_time&&from==crit_node[crit_count+1])
	  XDrawLine(mydisplay, windows[CRIT].window, gc[CRTP],
	    prev_draw[CRIT-5] - time_diff * win_size / scale_width,
            windows[CRIT].height-15-(order[from]+1)*num_pix, prev_draw[CRIT-5],
	    windows[CRIT].height-15-(order[node]+1)*num_pix);
	else if (num_nodes<=32)
	  XDrawLine(mydisplay, windows[CRIT].window, gc[NCRP],
	    prev_draw[CRIT-5] - time_diff * win_size / scale_width,
            windows[CRIT].height-15-(order[from]+1)*num_pix, prev_draw[CRIT-5],
	    windows[CRIT].height-15-(order[node]+1)*num_pix);
 	}       
}
spacetime_communication()
{
    int time_diff, num_pix;

    if((num_pix=(windows[SPTM].height-30)/(num_nodes+1))==0) num_pix=1;

    if (from != HOST && node!=HOST) {

	if (msg_count[from][node] >= 0)
	 time_diff = cur_time - sendpoint[from][node][msg_count[from][node]][0];
        else time_diff = 0;

      if(windows[CODB].opt1==0){
	if (msg_lth <= lth_bin[0]){
	  XDrawLine(mydisplay, windows[SPTM].window, gc[SPT0],
	    prev_draw[SPTM-5] - time_diff * win_size / scale_width,
            windows[SPTM].height-15-(order[from]+1)*num_pix, prev_draw[SPTM-5], 
	    windows[SPTM].height-15 - (order[node]+1)*num_pix);
	}
	else if (msg_lth <= lth_bin[1])
	  XDrawLine(mydisplay, windows[SPTM].window, gc[SPT1],
	    prev_draw[SPTM-5] - time_diff * win_size / scale_width,
            windows[SPTM].height-15-(order[from]+1)*num_pix, prev_draw[SPTM-5],
	    windows[SPTM].height-15 - (order[node]+1)*num_pix);
	else if (msg_lth <= lth_bin[2])
	  XDrawLine(mydisplay, windows[SPTM].window, gc[SPT2],
	    prev_draw[SPTM-5] - time_diff * win_size / scale_width,
            windows[SPTM].height-15-(order[from]+1)*num_pix, prev_draw[SPTM-5],
	    windows[SPTM].height-15 - (order[node]+1)*num_pix);
	else if (msg_lth <= lth_bin[3])
	  XDrawLine(mydisplay, windows[SPTM].window, gc[SPT3],
	    prev_draw[SPTM-5] - time_diff * win_size / scale_width,
            windows[SPTM].height-15-(order[from]+1)*num_pix, prev_draw[SPTM-5], 
	    windows[SPTM].height-15 - (order[node]+1)*num_pix);
	else 
	  XDrawLine(mydisplay, windows[SPTM].window, gc[SPT4],
	    prev_draw[SPTM-5] - time_diff * win_size / scale_width,
            windows[SPTM].height-15-(order[from]+1)*num_pix, prev_draw[SPTM-5],
	    windows[SPTM].height-15 - (order[node]+1)*num_pix);
      }else if (windows[CODB].opt1==1){
	XDrawLine(mydisplay, windows[SPTM].window, gc[SPC0+
	  hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2, 
	  windows[DIMB].opt2, windows[COLB].opt1,from,node)], 
	  prev_draw[SPTM-5] - time_diff * win_size / scale_width,
          windows[SPTM].height-15-(order[from]+1)*num_pix, prev_draw[SPTM-5],
	  windows[SPTM].height-15 - (order[node]+1)*num_pix);
      }else{
	XDrawLine(mydisplay, windows[SPTM].window, gc[SPC0+(msg_type-
	  min_type)%64], prev_draw[SPTM-5] - time_diff * win_size / scale_width,
          windows[SPTM].height-15-(order[from]+1)*num_pix, prev_draw[SPTM-5],
	  windows[SPTM].height-15 - (order[node]+1)*num_pix);
      }
    }
}

proc_status()
{
        switch (key_index) {
        case TSTART:
        case RECVBLOCK:
        case IDLE:
        case OVERHEAD:
        /* if node is on (busy) draw filled rectangle */
            if (state[node] == 1)
                XFillRectangle(mydisplay, windows[PSTA].window, gc[UTLB],
                    status_origin_x + (order[node]%psta_dim)*psta_width/
		    psta_dim + 1, status_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1, psta_width / psta_dim, 
		    psta_height / psta_dim);
            else if (state[node] == 2)
                XFillRectangle(mydisplay, windows[PSTA].window, gc[UTLO],
                    status_origin_x + (order[node]%psta_dim)*psta_width/
		    psta_dim + 1, status_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1, psta_width / psta_dim, 
		    psta_height / psta_dim);
            else if (!state[node])
                XFillRectangle(mydisplay, windows[PSTA].window, gc[UTLI],
                    status_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, status_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            break;

        case TEXIT:
        case CLOSE:
            XFillRectangle(mydisplay, windows[PSTA].window, gc[ERAS],
                status_origin_x + (order[node]%psta_dim)* psta_width/
		psta_dim + 1, status_origin_y + (order[node]/psta_dim)*
		psta_height/psta_dim + 1,
                psta_width / psta_dim, psta_height / psta_dim);
            break;
    case RECVWAKE:
        if (node != HOST && from != HOST) {
            if (send_count[from] == 0)
                XFillRectangle(mydisplay, windows[PSTA].window, gc[ERAS],
                    sends_origin_x + (order[from]%psta_dim)* psta_width/
		    psta_dim + 1, sends_origin_y + (order[from]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            if (queu_count[node] == 0)
                /* msg was received, clear square, as long as this msg was
                   only one on queue */
                XFillRectangle(mydisplay, windows[PSTA].window, gc[ERAS],
                    recvs_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, recvs_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            if (state[node] == 1)
                XFillRectangle(mydisplay, windows[PSTA].window, gc[UTLB],
                    status_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, status_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            else if (state[node] == 2)
                XFillRectangle(mydisplay, windows[PSTA].window, gc[UTLO],
                    status_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, status_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            else if (!state[node])
                XFillRectangle(mydisplay, windows[PSTA].window, gc[UTLI],
                    status_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, status_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
        }
        break;

        case USERBLOCKBEGIN:
                XFillRectangle(mydisplay, windows[PSTA].window, gc[TSK0 +
                    task_num%64], tasks_origin_x + (order[node]%psta_dim)*
		    psta_width/psta_dim + 1, tasks_origin_y + 
		    (order[node]/psta_dim)* psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
                break;
        case USERBLOCKEND:
            if ((prev_ptr[node]) > 0)
                XFillRectangle(mydisplay, windows[PSTA].window, gc[TSK0 +
                    task[node][prev_ptr[node]]%64], tasks_origin_x + 
		    (order[node]%psta_dim)* psta_width/psta_dim + 1,
                    tasks_origin_y + (order[node]/psta_dim)* psta_height/
		    psta_dim +1, psta_width / psta_dim, psta_height / psta_dim);
            else XFillRectangle(mydisplay, windows[PSTA].window, gc[ERAS],
                    tasks_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, tasks_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            break;
    case SEND:
        if (node != HOST && dest != HOST) {
            /* fill appropriate square (corresponding to the positions of
               sending and receiving nodes in chart) with appropriate stipple
               (according to size of msg in bytes) */
            if (queu_vol[dest] <= psta_lth_bin[0]){
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGND],
                    recvs_origin_x + (order[dest]%psta_dim)* psta_width/
		    psta_dim + 1, recvs_origin_y + (order[dest]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            else if (queu_vol[dest] <= psta_lth_bin[1]){
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGN0],
                    recvs_origin_x + (order[dest]%psta_dim)* psta_width/
		    psta_dim + 1, recvs_origin_y + (order[dest]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            else if (queu_vol[dest] <= psta_lth_bin[2]){
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGN1],
                    recvs_origin_x + (order[dest]%psta_dim)* psta_width/
		    psta_dim + 1, recvs_origin_y + (order[dest]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            else if (queu_vol[dest] <= psta_lth_bin[3]){
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGN2],
                    recvs_origin_x + (order[dest]%psta_dim)* psta_width/
		    psta_dim + 1, recvs_origin_y + (order[dest]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            else{
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGN3],
                    recvs_origin_x + (order[dest]%psta_dim)* psta_width/
		    psta_dim + 1, recvs_origin_y + (order[dest]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            if (send_vol[node] <= psta_lth_bin[0]){
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGND],
                    sends_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, sends_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            else if (send_vol[node] <= psta_lth_bin[1]){
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGN0],
                    sends_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, sends_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            else if (send_vol[node] <= psta_lth_bin[2]){
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGN1],
                    sends_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, sends_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            else if (send_vol[node] <= psta_lth_bin[3]){
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGN2],
                    sends_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, sends_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
            else{
                XFillRectangle(mydisplay, windows[PSTA].window, gc[LGN3],
                    sends_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, sends_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            }
        }
        break;

    case RECV:
        if (node != HOST && from != HOST) {
            if (send_count[from] == 0)
                XFillRectangle(mydisplay, windows[PSTA].window, gc[ERAS],
                    sends_origin_x + (order[from]%psta_dim)* psta_width/
		    psta_dim + 1, sends_origin_y + (order[from]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
            if (queu_count[node] == 0)
                /* msg was received, clear square, as long as this msg was
                   only one on queue */
                XFillRectangle(mydisplay, windows[PSTA].window, gc[ERAS],
                    recvs_origin_x + (order[node]%psta_dim)* psta_width/
		    psta_dim + 1, recvs_origin_y + (order[node]/psta_dim)*
		    psta_height/psta_dim + 1,
                    psta_width / psta_dim, psta_height / psta_dim);
        }
        break;
    }
}

util_smry()
{
  int i, num_pix;

  if((num_pix=(windows[UTLS].width-62)/num_nodes)==0) num_pix=1;

        for (i=0; i<num_nodes; i++){
            if (pct_busy[i]+pct_ovhd[i]>prev_pct_busy[i]+prev_pct_ovhd[i])
                XFillRectangle(mydisplay, windows[UTLS].window, gc[UTLO],
                   31+order[i]*(num_pix), windows[UTLS].height-75-
		   (windows[UTLS].height-99)*(pct_ovhd[i]+pct_busy[i])/100,
		   num_pix, (windows[UTLS].height-99)*(pct_busy[i]+pct_ovhd[i]-
		   prev_pct_busy[i]-prev_pct_ovhd[i])/100+1);
            if (pct_busy[i]>prev_pct_busy[i])
                XFillRectangle(mydisplay, windows[UTLS].window, gc[UTLB],
                   31+order[i]*(num_pix), windows[UTLS].height-75-
		   (windows[UTLS].height-99)*pct_busy[i]/100, num_pix,
		   (windows[UTLS].height-99)*(pct_busy[i]-prev_pct_busy[i])/
		   100+1);
            if (pct_busy[i]<prev_pct_busy[i])
                XFillRectangle(mydisplay, windows[UTLS].window, gc[UTLO],
                   31+order[i]*(num_pix), windows[UTLS].height-75-
		   (windows[UTLS].height-99)*prev_pct_busy[i]/100, num_pix,
		   (windows[UTLS].height-99)*(prev_pct_busy[i]-pct_busy[i])/
		   100+1);
            if (pct_busy[i]+pct_ovhd[i]<prev_pct_busy[i]+prev_pct_ovhd[i])
                XFillRectangle(mydisplay, windows[UTLS].window, gc[UTLI],
                   31+order[i]*(num_pix), windows[UTLS].height-75-
		   (windows[UTLS].height-99)*(prev_pct_ovhd[i]+
		   prev_pct_busy[i])/100, num_pix, (windows[UTLS].height-99)*
		   abs(prev_pct_busy[i]+prev_pct_ovhd[i]-pct_ovhd[i]-
		   pct_busy[i])/100+1);
         }
}
animation()
{

  int other;

    switch (key_index) {	/* keyword */


    case SEND:
	other=dest;
	if (node != HOST) {
	    if (dest != HOST){
		/* draw "connection" or "msg queue" line between sending and
		   receiving nodes */
	        XDrawLine(mydisplay, windows[ANIM].window, gc[ANIM],
		    anim_xl[order[node]], anim_yl[order[node]],
		    anim_xl[order[dest]], anim_yl[order[dest]]);
	    }
	}
	break;

    case RECVWAKE:
    case RECV:
	other=from;
	if (node != HOST) {
	    if (from != HOST) {
		if (msg_count[from][node] == 0 && msg_count[node][from] == 0)
		    /* erase "connection" line as long as this message
		       received was only one on queue */
		    XDrawLine(mydisplay, windows[ANIM].window, gc[ERAS],
			anim_xl[order[from]], anim_yl[order[from]],
			anim_xl[order[node]], anim_yl[order[node]]);
	    }
	}
	break;

    }
    /* ignore all HOST activity */
	if (node != HOST) {
          if(prev_anim_state[node]!=anim_state[node]){
	    /* fill circle with stipple and redraw
	       number and border of circle */
	    XFillArc(mydisplay, windows[ANIM].window, gc[ANMI + 
	      anim_state[node]], anim_x[order[node]], anim_y[order[node]],
		proc_width, proc_height, 0, 23040);
	    XDrawArc(mydisplay, windows[ANIM].window, gc[ANIM],
		anim_x[order[node]], anim_y[order[node]],
		proc_width, proc_height, 0, 23040);
	    if(num_nodes<=64)
	    XDrawString(mydisplay, windows[ANIM].window, gc[MENU],
		anim_x[order[node]] + proc_width/2 - 
		3*strlen(number[node]), anim_y[order[node]] +
		proc_height/2+4, number[node], strlen(number[node]));
	    else
	    XDrawString(mydisplay, windows[ANIM].window, micro_gc,
		anim_x[order[node]] + proc_width/2 - strlen(number[node]) * 2,
		anim_y[order[node]] + proc_height/2+4, number[node], 
		strlen(number[node]));
	  }
	  if((key_index==SEND||key_index==RECV||key_index==RECVWAKE)&&
	     (other!=HOST)){
	    /* fill circle with stipple and redraw
	       number and border of circle */
	    XFillArc(mydisplay, windows[ANIM].window, gc[ANMI + 
	      anim_state[other]], anim_x[order[other]], anim_y[order[other]],
		proc_width, proc_height, 0, 23040);
	    XDrawArc(mydisplay, windows[ANIM].window, gc[ANIM],
		anim_x[order[other]], anim_y[order[other]],
		proc_width, proc_height, 0, 23040);
	    if(num_nodes<=64)
	    XDrawString(mydisplay, windows[ANIM].window, gc[MENU],
		anim_x[order[other]] + proc_width/2 - 
		3*strlen(number[other]), anim_y[order[other]] +
		proc_height/2+4, number[other], strlen(number[other]));
	    else
	    XDrawString(mydisplay, windows[ANIM].window, micro_gc,
		anim_x[order[other]] + proc_width/2 - strlen(number[other]) * 2,
		anim_y[order[other]] + proc_height/2+4, number[other], 
		strlen(number[other]));
	 }
	}
}

hypeconnection()
{
   if (node!=HOST&&dest!=HOST){
    switch(key_index) /* keyword */
    {
	case SEND:
	
	 /* draw "connection" line when line between the
            communicating nodes does not already exist */
	      if (windows[HTYB].opt1==TORUS||msg_count[node][dest]+
		  msg_count[dest][node]==1)
	         {
		 hypenode1=node; hypenode2=dest;
	         /*Draw communication from smallest node to largest node*/
		   if (node < dest)
		      draw_hype(node,dest,gc[HSLD],gc[HDSH]);
		   else
		      draw_hype(dest,node,gc[HSLD],gc[HDSH]);
		 }
	   break;
	
        case RECVWAKE:
	case RECV:
	  if(node!=HOST)
	     if(from!=HOST)
               if (windows[HTYB].opt1==TORUS||msg_count[from][node]+
		   msg_count[node][from]==0){
		 hypenode1=from; hypenode2=node;

  	     /* erase "connection" line as long as this message
	        received was only one on queue */
               /* erase connection line the same way it was
		  drawn, from smallest node to largest node */
		  if (node < from)
		     draw_hype(node,from,gc[ERAS],gc[ERAS]);
	          else
		     draw_hype(from,node,gc[ERAS],gc[ERAS]);
               }

	  if(node!=HOST)
	     if(from!=HOST) {
               XFillArc(mydisplay, windows[HYPE].window, gc[ANMC],
         	 pts[from].x, pts[from].y, 20, 20, 0, 23040);
               XDrawString(mydisplay, windows[HYPE].window, gc[MENU],
	          ctr[from].x-3*(strlen(number[from])),
	          ctr[from].y+4, number[from], strlen(number[from]));
               XDrawArc(mydisplay, windows[HYPE].window, gc[MENU],
	          pts[from].x, pts[from].y, 20, 20, 0, 23040);
	     }
	  break;

    } /*ends switch statement for keywords*/
   }

    if(node!=HOST)
    {
      /* processor busy, fill circle with busy stipple and
	 redraw number and border of circle */

      if(prev_anim_state[node]!=anim_state[node]){
        XFillArc(mydisplay, windows[HYPE].window, gc[ANMI+anim_state[node]],
	  pts[node].x, pts[node].y, 20, 20, 0, 23040);
        XDrawString(mydisplay, windows[HYPE].window, gc[MENU],
	  ctr[node].x-3*(strlen(number[node])),
	  ctr[node].y+4, number[node], strlen(number[node]));
        XDrawArc(mydisplay, windows[HYPE].window, gc[MENU],
	  pts[node].x, pts[node].y, 20, 20, 0, 23040);
       }
     }
}

network()
{
    int i, j, c, g, which;

    switch(key_index) {
      case SEND:
	route(windows[NTYB].opt1, windows[NOPB].opt1, ntwk_nodes, ntwk_stages, 
	      node, dest, &num_hops);
        for(i=0; i<num_hops; i++){
          if(pt_array[i].n==pt_array[i+1].n||windows[NTYB].opt1==BINARY_TREE||
	    windows[NTYB].opt1==QUADTREE) which=0;
          else which=1;
	  if(windows[NTYB].opt1==CROSSBAR){
            ntwk_load[pt_array[i].s][pt_array[i].n][which]++;
            ntwk_total[pt_array[i].s][pt_array[i].n][which]++;
	  }else{
	  if(pt_array[i].s<pt_array[i+1].s){
            ntwk_load[pt_array[i].s][pt_array[i].n][which]++;
            ntwk_total[pt_array[i].s][pt_array[i].n][which]++;
	  }else if(pt_array[i].s>pt_array[i+1].s){
            ntwk_load[pt_array[i+1].s][pt_array[i+1].n][which]++;
            ntwk_total[pt_array[i+1].s][pt_array[i+1].n][which]++;
	  }else{
	   if(pt_array[i].n<pt_array[i+1].n){
            ntwk_load[pt_array[i].s][pt_array[i].n][which]++;
            ntwk_total[pt_array[i].s][pt_array[i].n][which]++;
	   }else{
            ntwk_load[pt_array[i+1].s][pt_array[i+1].n][which]++;
            ntwk_total[pt_array[i+1].s][pt_array[i+1].n][which]++;
	   }
	  }
	  }
	}
      break;

      case RECV:
      case RECVWAKE:
	route(windows[NTYB].opt1, windows[NOPB].opt1, ntwk_nodes, ntwk_stages, 
	      from, node, &num_hops);
        for(i=0; i<num_hops; i++){
          if(pt_array[i].n==pt_array[i+1].n||windows[NTYB].opt1==BINARY_TREE||
	    windows[NTYB].opt1==QUADTREE) which=0;
          else which=1;
	  if(windows[NTYB].opt1==CROSSBAR){
            ntwk_load[pt_array[i].s][pt_array[i].n][which]--;
	  }else{
	  if(pt_array[i].s<pt_array[i+1].s){
            ntwk_load[pt_array[i].s][pt_array[i].n][which]--;
	  }else if(pt_array[i].s>pt_array[i+1].s){
            ntwk_load[pt_array[i+1].s][pt_array[i+1].n][which]--;
	  }else{
	   if(pt_array[i].n<pt_array[i+1].n){
            ntwk_load[pt_array[i].s][pt_array[i].n][which]--;
	   }else{
            ntwk_load[pt_array[i+1].s][pt_array[i+1].n][which]--;
	   }
	  }
	  }
	}
      break;
    }
    for(i=0; i<num_hops; i++){
      if(pt_array[i].n==pt_array[i+1].n||windows[NTYB].opt1==BINARY_TREE||
	windows[NTYB].opt1==QUADTREE) which=0;
      else which=1;
      if(windows[NTYB].opt1==CROSSBAR){
        if((c=ntwk_load[pt_array[i].s][pt_array[i].n][which])>7) c=7;
      }else{
      if(pt_array[i].s<pt_array[i+1].s){
        if((c=ntwk_load[pt_array[i].s][pt_array[i].n][which])>7) c=7;
      }else if(pt_array[i].s>pt_array[i+1].s){
        if((c=ntwk_load[pt_array[i+1].s][pt_array[i+1].n][which])>7) c=7;
      }else{
	if(pt_array[i].n<pt_array[i+1].n){
          if((c=ntwk_load[pt_array[i].s][pt_array[i].n][which])>7) c=7;
	}else{
          if((c=ntwk_load[pt_array[i+1].s][pt_array[i+1].n][which])>7) c=7;
	}
      }
      }

      if(c<=0) g=NWK8;
      else g=NWK1+c-1;

      switch(windows[NTYB].opt1){
        case CROSSBAR:
	if((depth==1||monochrome==1)&&(key_index==RECV||
	  key_index==RECVWAKE)){
	  if(c<7) j=c+1;
	  else j=7;
	  XSetLineAttributes(mydisplay, gc[NWK8], j, LineSolid, 0, 0);
          XDrawLine(mydisplay, windows[NTWK].window, gc[NWK8], 43+
	    (pt_array[i].s)*(windows[NTWK].width-65)/(ntwk_stages), 39+
	    (pt_array[i].n)*(windows[NTWK].height-108)/(ntwk_nodes), 
	    43+(pt_array[i+1].s)*(windows[NTWK].width-65)/(ntwk_stages), 39+
	    (pt_array[i+1].n)*(windows[NTWK].height-108)/(ntwk_nodes));
	  }
          XDrawLine(mydisplay, windows[NTWK].window, gc[g], 43+(pt_array[i].s)*
            (windows[NTWK].width-65)/(ntwk_stages), 39+
	    (pt_array[i].n)*(windows[NTWK].height-108)/(ntwk_nodes), 
	    43+(pt_array[i+1].s)*(windows[NTWK].width-65)/(ntwk_stages), 39+
	    (pt_array[i+1].n)*(windows[NTWK].height-108)/(ntwk_nodes));
        break;

        case NTWK_MESH:
	 if(windows[NMOB].opt1){
	  if(windows[NMSB].opt2==num_nodes){
	   if((depth==1||monochrome==1)&&(key_index==RECV||
	     key_index==RECVWAKE)){
	    if(c<7) j=c+1;
	    else j=7;
	    XSetLineAttributes(mydisplay, gc[NWK8], j, LineSolid, 0, 0);
            XDrawLine(mydisplay, windows[NTWK].window, gc[NWK8], 
	      windows[NTWK].width/2, 32+(pt_array[i].n+1)*
	      (windows[NTWK].height-100)/(ntwk_nodes+1), 
	      windows[NTWK].width/2, 32+(pt_array[i+1].n+1)*
	      (windows[NTWK].height-100)/(ntwk_nodes+1));
	    }
            XDrawLine(mydisplay, windows[NTWK].window, gc[g], 
	      windows[NTWK].width/2, 32+(pt_array[i].n+1)*
	      (windows[NTWK].height-100)/(ntwk_nodes+1), 
	      windows[NTWK].width/2, 32+(pt_array[i+1].n+1)*
	      (windows[NTWK].height-100)/(ntwk_nodes+1));
	  }else{
	   if((depth==1||monochrome==1)&&(key_index==RECV||
	     key_index==RECVWAKE)){
	    if(c<7) j=c+1;
	    else j=7;
	    XSetLineAttributes(mydisplay, gc[NWK8], j, LineSolid, 0, 0);
            XDrawLine(mydisplay, windows[NTWK].window, gc[NWK8], 43+
	      (pt_array[i].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 32+
	      (pt_array[i].n+1)*(windows[NTWK].height-100)/(ntwk_nodes+1), 
	      43+(pt_array[i+1].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 
	      32+(pt_array[i+1].n+1)*(windows[NTWK].height-100)/(ntwk_nodes+1));
	    }
            XDrawLine(mydisplay, windows[NTWK].window, gc[g], 43+
	      (pt_array[i].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 32+
	      (pt_array[i].n+1)*(windows[NTWK].height-100)/(ntwk_nodes+1), 43+
	      (pt_array[i+1].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 32+
	      (pt_array[i+1].n+1)*(windows[NTWK].height-100)/(ntwk_nodes+1));
	  }
	 }else{
	  if(windows[NMSB].opt2==num_nodes){
	   if((depth==1||monochrome==1)&&(key_index==RECV||
	     key_index==RECVWAKE)){
	    if(c<7) j=c+1;
	    else j=7;
	    XSetLineAttributes(mydisplay, gc[NWK8], j, LineSolid, 0, 0);
            XDrawLine(mydisplay, windows[NTWK].window, gc[NWK8], 
	      windows[NTWK].width/2, 32+(pt_array[i].n+1)*
	      (windows[NTWK].height-100)/(ntwk_nodes+1), 
	      windows[NTWK].width/2, 32+(pt_array[i+1].n+1)*
	      (windows[NTWK].height-100)/(ntwk_nodes+1));
	    }
            XDrawLine(mydisplay, windows[NTWK].window, gc[g], 
	      windows[NTWK].width/2, 32+(pt_array[i].n+1)*
	      (windows[NTWK].height-100)/(ntwk_nodes+1), 
	      windows[NTWK].width/2, 32+(pt_array[i+1].n+1)*
	      (windows[NTWK].height-100)/(ntwk_nodes+1));
	  }else{
	   if((depth==1||monochrome==1)&&(key_index==RECV||
	     key_index==RECVWAKE)){
	    if(c<7) j=c+1;
	    else j=7;
	    XSetLineAttributes(mydisplay, gc[NWK8], j, LineSolid, 0, 0);
            XDrawLine(mydisplay, windows[NTWK].window, gc[NWK8], 43+
	      (pt_array[i].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 32+
	      (pt_array[i].n+1)*(windows[NTWK].height-100)/(ntwk_nodes+1), 43+
	      (pt_array[i+1].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 32+
	      (pt_array[i+1].n+1)*(windows[NTWK].height-100)/(ntwk_nodes+1));
	    }
            XDrawLine(mydisplay, windows[NTWK].window, gc[g], 43+
	      (pt_array[i].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 32+
	      (pt_array[i].n+1)*(windows[NTWK].height-100)/(ntwk_nodes+1), 43+
	      (pt_array[i+1].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 32+
	      (pt_array[i+1].n+1)*(windows[NTWK].height-100)/(ntwk_nodes+1));
	  }
	 }
        break;
        case BINARY_TREE:
        case QUADTREE:
	 if((depth==1||monochrome==1)&&(key_index==RECV||
	   key_index==RECVWAKE)){
	  if(c<7) j=c+1;
	  else j=7;
	  XSetLineAttributes(mydisplay, gc[NWK8], j, LineSolid, 0, 0);
          XDrawLine(mydisplay, windows[NTWK].window, gc[NWK8], 43+
	    (pt_array[i].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 17+
	    (pt_array[i].n+1)*(windows[NTWK].height-85)/(ntwk_nodes+1), 43+
	    (pt_array[i+1].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 17+
	    (pt_array[i+1].n+1)*(windows[NTWK].height-85)/ (ntwk_nodes+1));
	  }
          XDrawLine(mydisplay, windows[NTWK].window, gc[g], 43+(pt_array[i].s)*
            (windows[NTWK].width-86)/(ntwk_stages-1), 17+(pt_array[i].n+1)*
	    (windows[NTWK].height-85)/(ntwk_nodes+1), 43+(pt_array[i+1].s)*
	    (windows[NTWK].width-86)/(ntwk_stages-1), 17+(pt_array[i+1].n+1)*
	    (windows[NTWK].height-85)/ (ntwk_nodes+1));
        break;
        default:
	 if((depth==1||monochrome==1)&&(key_index==RECV||
	   key_index==RECVWAKE)){
	  if(c<7) j=c+1;
	  else j=7;
	  XSetLineAttributes(mydisplay, gc[NWK8], j, LineSolid, 0, 0);
          XDrawLine(mydisplay, windows[NTWK].window, gc[NWK8], 43+
	    (pt_array[i].s)*(windows[NTWK].width-86)/(ntwk_stages-1), 32+
	    (ns_inv[pt_array[i].n][i]+1)*(windows[NTWK].height-100)/
	    (ntwk_nodes+1), 43+(pt_array[i+1].s)*(windows[NTWK].width-86)/
	    (ntwk_stages-1), 32+(ns_inv[pt_array[i+1].n][i+1]+1)*
	    (windows[NTWK].height-100)/ (ntwk_nodes+1));
	  }
          XDrawLine(mydisplay, windows[NTWK].window, gc[g], 43+(pt_array[i].s)*
            (windows[NTWK].width-86)/(ntwk_stages-1), 32+
	    (ns_inv[pt_array[i].n][i]+1)*(windows[NTWK].height-100)/
	    (ntwk_nodes+1), 43+(pt_array[i+1].s)*(windows[NTWK].width-86)/
	    (ntwk_stages-1), 32+(ns_inv[pt_array[i+1].n][i+1]+1)*
	    (windows[NTWK].height-100)/ (ntwk_nodes+1));
        break;
      }
   }
}
matrix()
{
   int pix_width, pix_height;

   if((pix_width=(windows[MTRX].width-50)/num_nodes)==0) pix_width=1;
   if((pix_height=(windows[MTRX].height-50)/num_nodes)==0) pix_height=1;

    /* keyword */
    switch (key_index) {
    case SEND:
      if (node != HOST && dest != HOST) {
    /* fill appropriate square (corresponding to the positions of
       sending and receiving nodes in chart) with appropriate stipple
       (according to size of msg in bytes) */
        if(windows[CODB].opt1==0){
	  if (msg_lth <= lth_bin[0])
	    XFillRectangle(mydisplay, windows[MTRX].window, gc[LGND],
	      25+order[dest]*(pix_width), 25+order[node]*(pix_height),
	      pix_width, pix_height);
	  else if (msg_lth <= lth_bin[1])
	    XFillRectangle(mydisplay, windows[MTRX].window, gc[LGN0],
	      25+order[dest]*(pix_width), 25+order[node]*(pix_height),
	      pix_width, pix_height);
	  else if (msg_lth <= lth_bin[2])
	    XFillRectangle(mydisplay, windows[MTRX].window, gc[LGN1],
	      25+order[dest]*(pix_width), 25+order[node]*(pix_height),
	      pix_width, pix_height);
	  else if (msg_lth <= lth_bin[3])
	    XFillRectangle(mydisplay, windows[MTRX].window, gc[LGN2],
	      25+order[dest]*(pix_width), 25+order[node]*(pix_height),
	      pix_width, pix_height);
	  else
	    XFillRectangle(mydisplay, windows[MTRX].window, gc[LGN3],
	      25+order[dest]*(pix_width), 25+order[node]*(pix_height),
	      pix_width, pix_height);
	}else if (windows[CODB].opt1==1){
	   XFillRectangle(mydisplay, windows[MTRX].window, gc[COL0+
	     hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2, 
	     windows[DIMB].opt2, windows[COLB].opt1,node,dest)], 25+
	     order[dest]*(pix_width), 25+order[node]*
	     (pix_height), pix_width, pix_height);
	}else{
	   XFillRectangle(mydisplay, windows[MTRX].window, gc[COL0+
	     (msg_type-min_type)%64], 25+order[dest]*(pix_width), 
	     25+order[node]*(pix_height), pix_width, pix_height);
	}
      }
      break;

    case RECV:
    case RECVWAKE:

	if (node != HOST && from != HOST) {
	    if (msg_count[from][node] == 0)
		/* msg was received, clear square, as long as this msg was
		   only one on queue */
		XClearArea(mydisplay, windows[MTRX].window,
		    25+order[node]*(pix_width), 25+order[from]*(pix_height),
		    pix_width, pix_height, False);
	}
	break;
    }
}

task_completion()
{
    if (task_num>=0) {
        switch (key_index) {
        case USERBLOCKBEGIN:
	    if ((*(tsks_prog+task_num))==1){
	        XFillRectangle(mydisplay, windows[TSKS].window, gc[BKBG],
	            (task_num%tsks_dim)*windows[TSKS].width/tsks_dim + 1,
	            (task_num/tsks_dim)*(windows[TSKS].height-40)/tsks_dim + 1,
	            windows[TSKS].width / tsks_dim - 1,
		    (windows[TSKS].height-40) / tsks_dim - 1); 
	    }
            if (total_tasks <= 100) {
                sprintf(buf, "%d", task_num);
                XDrawString(mydisplay, windows[TSKS].window, gc[TSKS],
                    (task_num%tsks_dim)*windows[TSKS].width/tsks_dim  +
                    windows[TSKS].width/(2 * tsks_dim) - 4*strlen(buf),
                    (task_num/tsks_dim)*(windows[TSKS].height-40)/tsks_dim +
                    (windows[TSKS].height-40)/(2*tsks_dim)+4, buf, strlen(buf));
            }
            break;

        case USERBLOCKEND:
	    if (!(*(tsks_prog+task_num))){
	        XFillRectangle(mydisplay, windows[TSKS].window, gc[BKED],
	            (task_num%tsks_dim)*windows[TSKS].width/tsks_dim + 1,
	            (task_num/tsks_dim)*(windows[TSKS].height-40)/tsks_dim + 1,
	            windows[TSKS].width / tsks_dim - 1,
		    (windows[TSKS].height-40) / tsks_dim - 1); 
	    }
            if (total_tasks <= 100) {
                sprintf(buf, "%d", task_num);
                XDrawString(mydisplay, windows[TSKS].window, gc[TSKS],
                    (task_num%tsks_dim)*windows[TSKS].width/tsks_dim  +
                    windows[TSKS].width/(2 * tsks_dim) - 4*strlen(buf),
                    (task_num/tsks_dim)*(windows[TSKS].height-40)/tsks_dim +
                    (windows[TSKS].height-40)/(2*tsks_dim)+4, buf, strlen(buf));
            }
            break;
        }
    }
}
kiviat()
{
    /* if utilization is 0 set coords to center of graph */

    if (key_index!=TEXIT) {
        if (node != HOST) {

            erase_pts[1].x = draw_pts[3].x = kx[order[node]];
            erase_pts[1].y = draw_pts[3].y = ky[order[node]];

            erase_pts[3].x = draw_pts[1].x = kx[order[node]]
                = k_center_x - (int)ceil(current_util_pct[node] *
                radius*cos(PI/2+2*PI*order[node]/num_nodes));
            erase_pts[3].y = draw_pts[1].y = ky[order[node]]
                = k_center_y - (int)ceil(current_util_pct[node] *
                radius*sin(PI/2+2*PI*order[node]/num_nodes));

            erase_pts[0].x = draw_pts[0].x
                = kx[(order[node] + num_nodes - 1) % num_nodes];
            erase_pts[0].y = draw_pts[0].y
                = ky[(order[node] + num_nodes - 1) % num_nodes];
            erase_pts[2].x = draw_pts[2].x
                = kx[(order[node] + 1) % num_nodes];
            erase_pts[2].y = draw_pts[2].y
                = ky[(order[node] + 1) % num_nodes];

            if (current_util_pct[node] < node_util[order[node]])
                XFillPolygon(mydisplay, windows[KIVT].window, gc[KIVH],
                    erase_pts, 4, Complex, CoordModeOrigin);
            else
                XFillPolygon(mydisplay, windows[KIVT].window, gc[KIVC],
                    draw_pts, 4, Complex, CoordModeOrigin);

        }
    }else{
        if (node != HOST) {

            erase_pts[1].x = k_center_x;
            erase_pts[1].y = k_center_y;
            erase_pts[0].x = kx[(order[node] + num_nodes - 1) % num_nodes];
            erase_pts[0].y = ky[(order[node] + num_nodes - 1) % num_nodes];
            erase_pts[2].x = kx[(order[node] + 1) % num_nodes];
            erase_pts[2].y = ky[(order[node] + 1) % num_nodes];
            erase_pts[3].x = kx[order[node]];
            erase_pts[3].y = ky[order[node]];
            XFillPolygon(mydisplay, windows[KIVT].window, gc[KIVH],
                erase_pts, 4, Complex, CoordModeOrigin);

            node_util[order[node]] = current_util_pct[node] = 0;
            kx[order[node]] = k_center_x;
            ky[order[node]] = k_center_y;

        }
    }
}
int avg_util()
{
    static int last_x, x, u_last_t, u_last_cum;

    if (first_util){
	first_util = 0;
	u_last_t = 0;
	u_last_cum =0;
	last_x = 0;
    }
    if (cur_time-u_last_t>=k_delta){
        x = ((cum_util - u_last_cum)*phpt_width)/((cur_time-u_last_t)*
	  num_nodes);
        u_last_cum = cum_util;
        u_last_t = cur_time;
	last_x = x;
	return(x);
    } else{
	return(last_x);
	}
}
int avg_comm()
{
    static int last_y, y, c_last_t, c_last_cum;

    if (first_comm){
	first_comm = 0;
	c_last_t = 0;
	c_last_cum =0;
	last_y = 0;
    }
    if (cur_time-c_last_t>=k_delta){
        y = ((cum_comm- c_last_cum)*phpt_height)/((cur_time-c_last_t)*
	  max_count);
        c_last_cum = cum_comm;
        c_last_t = cur_time;
	last_y = y;
	return(y);
    } else{
	return(last_y);
	}
}
record_data()
{
  if (phpt_point[0]!=phpt_last_point[0] || phpt_point[1]!=phpt_last_point[1])
    if(windows[PHPT+REC_OFF].opt1)
      fprintf(recptr[PHPT], "%d %d %d\n", raw_time, (100*phpt_point[0])/
      windows[PHPT].width, (100*phpt_point[1])/windows[PHPT].height);
  if(windows[UTLC+REC_OFF].opt1&&(prev_count!=util_count||
     prev_diff_count!=util_diff_count))
    fprintf(recptr[UTLC], "%d %d %d %d\n", raw_time, util_count-util_diff_count,
      util_diff_count, num_nodes-util_count);
  if(windows[UTLG+REC_OFF].opt1 && prev_state[node]!=state[node]){
    if(state[node]==0)
      fprintf(recptr[UTLG], "%d %d idle\n", raw_time, node);
    else if(state[node]==1)
      fprintf(recptr[UTLG], "%d %d busy\n", raw_time, node);
    else if(state[node]==2)
      fprintf(recptr[UTLG], "%d %d ovhd\n", raw_time, node);
   }
   if(prev_ptr[node]!=task_ptr[node] && windows[TSKG+REC_OFF].opt1)
     fprintf(recptr[TSKG], "%d %d %d\n", raw_time, node, task_num);
   if(windows[SPTM+REC_OFF].opt1){
     if(key_index==RECV || key_index==RECVWAKE)
       fprintf(recptr[SPTM], "%d %d recv from %d %d %d %d\n", raw_time, node,
         from, msg_lth, msg_type, hops(windows[DSTB].opt1, num_nodes/
	 windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1,node,from));
     else if(key_index==SEND)
       fprintf(recptr[SPTM], "%d %d send to %d %d %d %d\n", raw_time, node,
         dest, msg_lth, msg_type, hops(windows[DSTB].opt1, num_nodes/
	 windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1,node,dest));
     else if(state[node]!=prev_state[node] &&
         (state[node]==0 || prev_state[node]==0)){
       if(state[node]==1 || state[node]==2)
         fprintf(recptr[SPTM], "%d %d busy\n", raw_time, node);
       else if(state[node]==0)
         fprintf(recptr[SPTM], "%d %d idle\n", raw_time, node);
     }
   }
   if(node==crit_node[crit_count]&&crit_time[crit_count]==raw_time&&
     from==crit_node[crit_count+1])
     if(windows[CRIT+REC_OFF].opt1)
       fprintf(recptr[CRIT], "%d %d\n", raw_time, node);
   if(windows[UTLS+REC_OFF].opt1 && (prev_pct_busy[node]!=pct_busy[node]||
     pct_ovhd[node]!=prev_pct_ovhd[node]))
      fprintf(recptr[UTLS], "%d %d %d %d %d\n", raw_time, node, pct_busy[node],
        pct_ovhd[node], 100-pct_busy[node]-pct_ovhd[node]);
   if (windows[ANIM+REC_OFF].opt1){
     switch(anim_state[node]){

     case 0:
       fprintf(recptr[ANIM], " %d %d  idle\n", raw_time, node);
       break;

     case 1:
       fprintf(recptr[ANIM], " %d %d  busy\n", raw_time, node);
       break;

     case 2:
       fprintf(recptr[ANIM], " %d %d  send %d\n", raw_time, node, dest);
       break;

     case 3:
       fprintf(recptr[ANIM], " %d %d  recv %d\n", raw_time, node, from);
       break;

     }
   }
   if (windows[HYPE+REC_OFF].opt1){
     switch(anim_state[node]){

     case 0:
       fprintf(recptr[HYPE], " %d %d  idle\n", raw_time, node);
       break;

     case 1:
       fprintf(recptr[HYPE], " %d %d  busy\n", raw_time, node);
       break;

     case 2:
       fprintf(recptr[HYPE], " %d %d  send %d\n", raw_time, node, dest);
       break;

     case 3:
       fprintf(recptr[HYPE], " %d %d  recv %d\n", raw_time, node, from);
       break;

     }
   }

   if (current_util_pct[node]!=node_util[order[node]] && 
       windows[KIVT+REC_OFF].opt1)
     fprintf(recptr[KIVT], " %d %d %d\n", raw_time, node,
       (int)(100.0*current_util_pct[node]));
  switch(key_index)
  {
    case RECV:
    case RECVWAKE:
      if(node!=HOST&&windows[QUEU+REC_OFF].opt1)
        fprintf(recptr[QUEU], "%d %d %d %d\n", raw_time, node, queu_count[node],
          queu_vol[node]);
      if(windows[TRAF+REC_OFF].opt1)
        fprintf(recptr[TRAF], "%d %d %d\n", raw_time, comm_count, comm_vol);
      if(windows[NINF+REC_OFF].opt1&&from!=HOST)
        fprintf(recptr[NINF], "%d %d from %d %d %d %d\n", raw_time, node, from,
          msg_lth, msg_type, hops(windows[DSTB].opt1, num_nodes/
	  windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1,
	  node,from));
      if(windows[MTRX+REC_OFF].opt1&& from!=HOST)
        fprintf(recptr[MTRX], "%d %d %d %d %d from %d\n", raw_time, node, 
	  msg_lth, msg_type, hops(windows[DSTB].opt1, num_nodes/
	  windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1,node,
	  from), from);
      if(windows[PSTA+REC_OFF].opt1)
       if(task_ptr[node]){
	  fprintf(recptr[PSTA], "%d %d %d recv %d %d %d %d\n", raw_time, node, 
	    task_num, from, msg_lth, msg_type, hops(windows[DSTB].opt1, 
	    num_nodes/windows[DIMB].opt2, windows[DIMB].opt2, 
	    windows[COLB].opt1,node,from));
       }else{
	  fprintf(recptr[PSTA], "%d %d recv %d %d %d %d\n", raw_time, node, 
	    from, msg_lth, msg_type, hops(windows[DSTB].opt1, num_nodes/
	    windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1,
	    node,from));
       }
    break;

    case SEND:
      if(dest!=HOST&&windows[QUEU+REC_OFF].opt1)
        fprintf(recptr[QUEU], "%d %d %d %d\n", raw_time, dest, queu_count[dest],
          queu_vol[dest]);
      if(windows[TRAF+REC_OFF].opt1)
        fprintf(recptr[TRAF], "%d %d %d\n", raw_time, comm_count, comm_vol);
      if(windows[NINF+REC_OFF].opt1&&dest!=HOST)        
        fprintf(recptr[NINF], "%d %d to %d %d %d %d\n", raw_time, node, dest,
          msg_lth, msg_type, hops(windows[DSTB].opt1, num_nodes/
	  windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1,
	  node,dest));
      if(windows[MTRX+REC_OFF].opt1&&dest!=HOST)
        fprintf(recptr[MTRX], "%d %d to %d %d %d %d\n", raw_time, node, dest,
          msg_lth, msg_type, hops(windows[DSTB].opt1, num_nodes/
	  windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1,
	  node,dest));
      if(windows[PSTA+REC_OFF].opt1)
       if(task_ptr[node]){
	  fprintf(recptr[PSTA], "%d %d %d send %d %d %d %d\n", raw_time, node, 
	    task_num, dest, msg_lth, msg_type, hops(windows[DSTB].opt1, 
	    num_nodes/windows[DIMB].opt2, windows[DIMB].opt2, 
	    windows[COLB].opt1,node,dest));
       }else{
	  fprintf(recptr[PSTA], "%d %d send %d %d %d %d\n", raw_time, node, 
	    dest, msg_lth, msg_type, hops(windows[DSTB].opt1, num_nodes/
	    windows[DIMB].opt2, windows[DIMB].opt2, windows[COLB].opt1,
	    node,dest));
       }
    break;

    case USERBLOCKBEGIN:
      if(windows[TSKC+REC_OFF].opt1)
        fprintf(recptr[TSKC], "%d %d %d\n", raw_time, task_num, tsks_prog[task_num]);
      if ((*(tsks_prog+task_num))==1&&windows[TSKS+REC_OFF].opt1)
        fprintf(recptr[TSKS], "%d %d started\n", raw_time, task_num);
      if(windows[PSTA+REC_OFF].opt1 && prev_state[node]!=state[node])
       if(task_ptr[node]){
         if(state[node]==1)
	  fprintf(recptr[PSTA], "%d %d %d busy\n", raw_time, node, task_num);
         else if(state[node]==0)
	  fprintf(recptr[PSTA], "%d %d %d idle\n", raw_time, node, task_num);
         else if(state[node]==2)
	  fprintf(recptr[PSTA], "%d %d %d ovhd\n", raw_time, node, task_num);
       }else{
         if(state[node]==1)
	  fprintf(recptr[PSTA], "%d %d busy\n", raw_time, node);
         else if(state[node]==0)
	  fprintf(recptr[PSTA], "%d %d idle\n", raw_time, node);
         else if(state[node]==2)
	  fprintf(recptr[PSTA], "%d %d ovhd\n", raw_time, node);
       }
    break;
    case USERBLOCKEND:
      if(windows[TSKC+REC_OFF].opt1)
        fprintf(recptr[TSKC], "%d %d %d\n", raw_time, task_num, tsks_prog[task_num]);
      if (!(*(tsks_prog+task_num))&&windows[TSKS+REC_OFF].opt1)
        fprintf(recptr[TSKS], "%d %d finished\n", raw_time, task_num);
      if(windows[PSTA+REC_OFF].opt1 && prev_state[node]!=state[node])
       if(task_ptr[node]){
         if(state[node]==1)
	  fprintf(recptr[PSTA], "%d %d %d busy\n", raw_time, node, task_num);
         else if(state[node]==0)
	  fprintf(recptr[PSTA], "%d %d %d idle\n", raw_time, node, task_num);
         else if(state[node]==2)
	  fprintf(recptr[PSTA], "%d %d %d ovhd\n", raw_time, node, task_num);
       }else{
         if(state[node]==1)
	  fprintf(recptr[PSTA], "%d %d busy\n", raw_time, node);
         else if(state[node]==0)
	  fprintf(recptr[PSTA], "%d %d idle\n", raw_time, node);
         else if(state[node]==2)
	  fprintf(recptr[PSTA], "%d %d ovhd\n", raw_time, node);
       }
    break;

    default:
      if(windows[PSTA+REC_OFF].opt1 && prev_state[node]!=state[node])
       if(task_ptr[node]){
         if(state[node]==1)
	  fprintf(recptr[PSTA], "%d %d %d busy\n", raw_time, node, task_num);
         else if(state[node]==0)
	  fprintf(recptr[PSTA], "%d %d %d idle\n", raw_time, node, task_num);
         else if(state[node]==2)
	  fprintf(recptr[PSTA], "%d %d %d ovhd\n", raw_time, node, task_num);
       }else{
         if(state[node]==1)
	  fprintf(recptr[PSTA], "%d %d busy\n", raw_time, node);
         else if(state[node]==0)
	  fprintf(recptr[PSTA], "%d %d idle\n", raw_time, node);
         else if(state[node]==2)
	  fprintf(recptr[PSTA], "%d %d ovhd\n", raw_time, node);
       }
    break;
  }
}
route(net, opt, p, s, src, dst, hops)
        int net, opt, p, s, src, dst, *hops;
/*
   Compute route from src to dst in a network with p processors.

   Input: network choice, routing option, number of processors,
   number of stages, source and destination nodes.

   --------------------------------------------------------
   net = 0 : Butterfly   |
         1 : Gray Code   |  opt=0 : left-to-right bit order
         2 : Hypercube   |
         3 : Omega       |  opt=1 : right-to-left bit order
         4 : Baseline    |
   --------------------------------------------------------
         5 : Binary Tree |  opt : none
         6 : Quadtree    |  opt : none
   --------------------------------------------------------
         7 : Mesh        |  opt=0 : row-then-column
                         |  opt=1 : column-then-row
   --------------------------------------------------------
         8 : Crossbar    |  opt : none
   --------------------------------------------------------

   Output: number of hops, and pt_array containing hops+1
   points through which message passes, including original
   source and final destination.
*/
{
        int next, i, j, fac, src_n, src_s, dst_n, dst_s;
        extern int max_hops;
        extern struct ns_pt *pt_array;
        struct ns_pt *temp_pt_array;

switch (net) {

case 0 :        /* butterfly */
case 1 :        /* gray code */
case 2 :        /* hypercube */
case 3 :        /* omega     */
case 4 :        /* baseline  */
        pt_array[0].n = src;
        pt_array[0].s = 0;
        i = 1;
        if (src != dst) {
        if (!opt) {     /* left-to-right bit order */
                for (j = p>>1; j > 0; j >>= 1, i++) {
                        next = ((src & j) == (dst & j)) ? src :
                                src^j ;
                        pt_array[i].n = next;
                        pt_array[i].s = i;
                        src = next;
                }
        }
        else {          /* right-to-left bit order */
                for (j = 1; j < p; j <<= 1, i++) {
                        next = ((src & j) == (dst & j)) ? src :
                                src^j ;
                        pt_array[i].n = next;
                        pt_array[i].s = i;
                        src = next;
                }
        }
        }
        *hops = i - 1;
        break;

case 5 :        /* binary tree */
case 6 :        /* quadtree */
        pt_array[0].n = src;
        pt_array[0].s = 0;
        if (src != dst) {
        temp_pt_array = (struct ns_pt *)malloc((max_hops/2 + 1)*
                sizeof(struct ns_pt));
        temp_pt_array[0].n = dst;
        temp_pt_array[0].s = 0;
        fac = (net == 5) ? 2 : 4;
        j = fac;
        for (i = 1; i < s; i++, j *= fac) {
                next = src - src%j + (j/2) - 1;
                pt_array[i].n = next;
                pt_array[i].s = i;
                src = next ;

                next = dst - dst%j + (j/2) - 1;
                temp_pt_array[i].n = next;
                temp_pt_array[i].s = i;
                dst = next;
                if (src == dst) break;
        }
        i++;
        for (j = i-2; j >= 0; j--, i++) {
                pt_array[i].n = temp_pt_array[j].n;
                pt_array[i].s = temp_pt_array[j].s;
        }
        free(temp_pt_array);
        }
        *hops = i - 1;
        break;

case 7 :        /* mesh */
        if (windows[NMOB].opt1) {  /* column-major order */
                src_n = src % p;
                src_s = src / p;
                dst_n = dst % p;
                dst_s = dst / p;
        }
        else {          /* row-major order */
                src_n = src / s;
                src_s = src % s;
                dst_n = dst / s;
                dst_s = dst % s;
        }
        i = 0;
        if (!opt) {     /* move to dest row, then dest column */
                if (src_n < dst_n) {
                        for (j = src_n; j <= dst_n; j++, i++) {
                                pt_array[i].n = j;
                                pt_array[i].s = src_s;
                        }
                }
                else {
                        for (j = src_n; j >= dst_n; j--, i++) {
                                pt_array[i].n = j;
                                pt_array[i].s = src_s;
                        }
                }
                if (src_s < dst_s) {
                        for (j = src_s+1; j <= dst_s; j++, i++) {
                                pt_array[i].n = dst_n;
                                pt_array[i].s = j;
                        }
                }
                else {
                        for (j = src_s-1; j >= dst_s; j--, i++) {
                                pt_array[i].n = dst_n;
                                pt_array[i].s = j;
                        }
                }
        }
        else {          /* move to dest column, then dest row */
                if (src_s < dst_s) {
                        for (j = src_s; j <= dst_s; j++, i++) {
                                pt_array[i].n = src_n;
                                pt_array[i].s = j;
                        }
                }
                else {
                        for (j = src_s; j >= dst_s; j--, i++) {
                                pt_array[i].n = src_n;
                                pt_array[i].s = j;
                        }
                }
                if (src_n < dst_n) {
                        for (j = src_n+1; j <= dst_n; j++, i++) {
                                pt_array[i].n = j;
                                pt_array[i].s = dst_s;
                        }
                }
                else {
                        for (j = src_n-1; j >= dst_n; j--, i++) {
                                pt_array[i].n = j;
                                pt_array[i].s = dst_s;
                        }
                }
        }
        *hops = i - 1;
        break;

case 8 :        /* crossbar */
        for (i = 0; i <= dst+1; i++) {
                pt_array[i].n = src + 1;
                pt_array[i].s = i;
        }
        for (j = src; j >= 0; j--, i++) {
                pt_array[i].n = j;
                pt_array[i].s = dst + 1;
        }
        *hops = src + dst + 2;
        break;
}

}
   float kiv(t, b, n)
       int t, b, n;
   {
       float y;
       static int k_oldt[MAXP], k_oldb[MAXP];
       static float k_oldy[MAXP];

       if (k_init[n]) {
         if ((t - k_oldt[n])/time_unit >= k_delta) {
           y = ((float) (b - k_oldb[n])) /
               ((float) (t - k_oldt[n]));
           k_oldt[n] = t;
           k_oldb[n] = b;
           k_oldy[n] = y;
         } else
             y = k_oldy[n];
     } else {
         y = 0;
         k_init[n] = 1;
         k_oldt[n] = t;
         k_oldb[n] = b;
         k_oldy[n] = y;
     }
     if (y>1.0)
         y = 1.0;
     return (y);
   }

