c ===========================================================================
c
      subroutine mscale(colpnt,rowidx,nonzeros,
     x obj,rhs,ubound,vcstat,scale,scalen,scalmet,scpass,scdiff,
     x ddsup,ddsupn,dxs,snhead)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 colpnt(n1),rowidx(nz),vcstat(mn),
     x scalmet,scpass,snhead(mn)
      real*8    nonzeros(cfree),obj(n),rhs(m),ubound(mn),scale(mn),
     x scalen(mn),scdiff,ddsup(mn),ddsupn(mn),dxs(mn)
c
      integer*4 i
      character*99 buff
c
      write(buff,'(1x)')
      call mprnt(buff)
      write(buff,'(1x,a)')'Process: scaling'
      call mprnt(buff)
c
      do i=1,mn
        scalen(i)=1.0d+0
      enddo
c
      if((scalmet.eq.2).or.(scalmet.eq.4))then
        call scale1(ubound,nonzeros,colpnt,obj,scalen,vcstat,
     x  rowidx,rhs,ddsup,scpass,scdiff,snhead,nonzeros(nz+1))
      endif
      if((scalmet.eq.3).or.(scalmet.eq.5))then
        call scale2(ubound,nonzeros,colpnt,obj,scalen,vcstat,
     x  rowidx,rhs,scpass,scdiff,ddsup,ddsupn,dxs,snhead)
      endif
      if((scalmet.gt.0).and.(scalmet.le.3))then
        call sccol2(ubound,nonzeros,colpnt,obj,scalen,
     x  vcstat,rowidx)
        call scrow2(rhs,ubound,nonzeros,rowidx,colpnt,ddsup,
     x  scalen,vcstat)
      endif
c
      do i=1,mn
        scale(i)=scale(i)*scalen(i)
      enddo
c
      write(buff,'(1x,a)')'Scaling done...'
      call mprnt(buff)
      return
      end
c
c ============================================================================
c
      subroutine scale1(bounds,rownzs,colpnt,obj,scale,
     x vcstat,rowidx,rhs,work1,scpass,scdif,veclen,
     x lognz)

      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      common/numer/ tplus,tzer
      real*8        tplus,tzer

      real*8 bounds(mn),rownzs(cfree),obj(n),scale(mn),
     x  rhs(m),work1(mn),scdif,lognz(nz)
      integer*4 rowidx(cfree),colpnt(n1),vcstat(mn),scpass,veclen(mn)
c
      real*8 defic,odefic
      integer*4 pass,i,j,pnt1,pnt2,nonz
      character*99 buff
c
      pass=0
      nonz=0
      defic= 1.0d+0
      odefic=0.0d+0
      do i=1,mn
        veclen(i)=0
      enddo
      do i=1,n
        if(vcstat(i).gt.-2)then
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            if((abs(rownzs(j)).gt.tzer).and.
     x      (vcstat(rowidx(j)+n).gt.-2))then
              lognz(j)=log(abs(rownzs(j)))
              veclen(i)=veclen(i)+1
              veclen(rowidx(j)+n)=veclen(rowidx(j)+n)+1
              nonz=nonz+1
              odefic=odefic+abs(lognz(j))
            else
              lognz(j)=0.0d+0
            endif
          enddo
        endif
      enddo
      do i=1,mn
        if(veclen(i).eq.0)veclen(i)=1
        scale(i)=0.0d+0
      enddo
      if(nonz.eq.0)goto 999
      odefic=exp(odefic/dble(nonz))
      if(odefic.le.scdif)goto 999
  10  write(buff,'(1x,a,i2,a,d12.6)')'Pass',pass,'. Average def.',odefic
      call mprnt(buff)
      call sccol1(colpnt,scale,
     x vcstat,rowidx,veclen,lognz)
      pass=pass+1
      call scrow1(rowidx,colpnt,work1,scale,vcstat,defic,veclen,lognz)
      defic=exp(defic/dble(nonz))
      if(defic.le.scdif)goto 999
      if(pass.ge.scpass)goto 999
      if(odefic.le.defic)goto 999
      odefic=defic
      goto 10
 999  write(buff,'(1x,a,i2,a,d12.6)')'Pass',pass,'. Average def.',defic
      call mprnt(buff)
c
c Scaling
c
      do i=1,mn
        scale(i)=exp(scale(i))
      enddo
      do i=1,n
        pnt1=colpnt(i)
        pnt2=colpnt(i+1)-1
        do j=pnt1,pnt2
          rownzs(j)=rownzs(j)/scale(i)/scale(rowidx(j)+n)
        enddo
        obj(i)=obj(i)/scale(i)
        bounds(i)=bounds(i)*scale(i)
      enddo
      do i=1,m
        rhs(i)=rhs(i)/scale(i+n)
        bounds(i+n)=bounds(i+n)/scale(i+n)
      enddo
      return
      end
c
c ============================================================================
c
      subroutine scrow1(rowidx,colpnt,
     x maxi,scale,excld,ss,veclen,lognz)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      real*8 lognz(nz),maxi(mn),scale(mn),ss
      integer*4 rowidx(cfree),colpnt(n1),excld(mn),veclen(mn)
      common/numer/ tplus,tzer
      real*8        tplus,tzer
c ---------------------------------------------------------------------------
      integer*4 i,j,pnt1,pnt2
      real*8 sol
c ---------------------------------------------------------------------------
      ss=0
      do i=1,m
        maxi(i)=0.0d+0
      enddo
      do i=1,n
        if(excld(i).gt.-2)then
          sol=scale(i)
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            if(excld(rowidx(j)+n).gt.-2)then
              maxi(rowidx(j))=maxi(rowidx(j))+lognz(j)-sol
              ss=ss+abs(lognz(j)-sol-scale(rowidx(j)+n))
            endif
          enddo
        endif
      enddo
      do i=1,m
        scale(n+i)=maxi(i)/veclen(i+n)
      enddo
      return
      end
c
c ===========================================================================
c
      subroutine sccol1(colpnt,scale,
     x excld,rowidx,veclen,lognz)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      real*8 scale(mn),lognz(nz)
      integer*4 colpnt(n1),excld(mn),rowidx(cfree),veclen(mn)
      common/numer/ tplus,tzer
      real*8        tplus,tzer
c ---------------------------------------------------------------------------
      integer*4 i,j,pnt1,pnt2
      real*8 ma
c ---------------------------------------------------------------------------
      do i=1,n
        ma=0.0d+0
        if(excld(i).gt.-2)then
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            ma=ma+lognz(j)-scale(rowidx(j)+n)
          enddo
          scale(i)=ma/veclen(i)
        endif
      enddo
      return
      end
c
c ===========================================================================
c
      subroutine scrow2(rhs,bounds,rownzs,rowidx,
     x colpnt,maxi,scale,excld)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      common/numer/ tplus,tzer
      real*8        tplus,tzer
c
      real*8 rownzs(cfree),bounds(mn),rhs(m),maxi(m),scale(mn)
      integer*4 rowidx(cfree),colpnt(n1),excld(mn)
c ---------------------------------------------------------------------------
      integer*4 i,j,pnt1,pnt2,k
      real*8 sol
c ---------------------------------------------------------------------------
      do i=1,m
        maxi(i)=0
      enddo
      do i=1,n
        if(excld(i).gt.-2)then
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            k=rowidx(j)
            sol=abs(rownzs(j))
            if (maxi(k).lt.sol)maxi(k)=sol
          enddo
        endif
      enddo
      do i=1,m
        if(maxi(i).le.tzer)maxi(i)=1.0d+0
        scale(n+i)=maxi(i)*scale(n+i)
        rhs(i)=rhs(i)/maxi(i)
        bounds(i+n)=bounds(i+n)/maxi(i)
      enddo
      do i=1,n
        pnt1=colpnt(i)
        pnt2=colpnt(i+1)-1
        do j=pnt1,pnt2
          k=rowidx(j)
          rownzs(j)=rownzs(j)/maxi(k)
        enddo
      enddo
      return
      end
c
c ===========================================================================

c
      subroutine sccol2(bounds,rownzs,colpnt,obj,scale,
     x excld,rowidx)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      real*8 rownzs(cfree),bounds(mn),obj(n),scale(mn)
      integer*4 colpnt(n1),excld(mn),rowidx(cfree)
      common/numer/ tplus,tzer
      real*8        tplus,tzer
c ---------------------------------------------------------------------------
      integer*4 i,j,pnt1,pnt2
      real*8 sol,ma
c ---------------------------------------------------------------------------
      do i=1,n
        if(excld(i).gt.-2)then
          ma=0
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            if(excld(rowidx(j)+n).gt.-2)then
              sol=abs(rownzs(j))
              if (ma.lt.sol)ma=sol
            endif
          enddo
          if (ma.le.tzer)ma=1.0d+0
          scale(i)=ma*scale(i)
          do j=pnt1,pnt2
            rownzs(j)=rownzs(j)/ma
          enddo
          obj(i)=obj(i)/ma
          bounds(i)=bounds(i)*ma
        endif
      enddo
      return
      end
c
c ===========================================================================
c
      subroutine scalobj(obj,scobj,excld,objnor)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      real*8 obj(n),scobj,objnor
      integer*4 excld(n),i
      character*99 buff
c ---------------------------------------------------------------------------
      scobj=0.0d+0
      do i=1,n
        if(excld(i).gt.-2)then
          if (abs(obj(i)).gt.scobj)scobj=abs(obj(i))
        endif
      enddo
      scobj=scobj/objnor
      if(scobj.lt.1.0d-08)scobj=1.0d-08
      write(buff,'(1x,a,d8.2)')'Obj. scaled ',scobj
      call mprnt(buff)
      do i=1,n
        obj(i)=obj(i)/scobj
      enddo
      return
      end
c
c ===========================================================================
c
      subroutine scalrhs(rhs,scrhs,excld,rhsnor,bounds,xs,up )
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      real*8 rhs(m),scrhs,rhsnor,bounds(mn),xs(mn),up(mn)
      integer*4 excld(mn),i
      character*99 buff
c ---------------------------------------------------------------------------
      scrhs=0.0d+0
      do i=1,m
        if(excld(i+n).gt.-2)then
          if(abs(rhs(i)).gt.scrhs)scrhs=abs(rhs(i))
        endif
      enddo
      scrhs=scrhs/rhsnor
      if(scrhs.lt.1.0d-08)scrhs=1.0d-08
      write(buff,'(1x,a,d8.2)')'Rhs. scaled ',scrhs
      call mprnt(buff)
      do i=1,m
        rhs(i)=rhs(i)/scrhs
      enddo
      do i=1,mn
        bounds(i)=bounds(i)/scrhs
        xs(i)=xs(i)/scrhs
        up(i)=up(i)/scrhs
      enddo
      return
      end
c
c ============================================================================
c Curtis-Reid Scaling algorithm
c ============================================================================
c
      subroutine scale2(bounds,rownzs,colpnt,obj,sc,
     x  vcstat,rowidx,rhs,scpass,scdif,scm1,rk,logsum,count)

      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      common/numer/ tplus,tzer
      real*8        tplus,tzer
c
      real*8 bounds(mn),rownzs(cfree),obj(n),sc(mn),
     x  rhs(m),scdif,scm1(mn),rk(mn),logsum(mn)
      integer*4 rowidx(cfree),colpnt(n1),vcstat(mn),scpass,count(mn)
c
      integer*4 i,j,in,pnt1,pnt2,pass
      real*8 logdef,s,qk,qkm1,ek,ekm1,ekm2,sk,skm1
      character*99 buff
c
      pass=0
      do i=1,mn
       count(i)=0
       logsum(i)=0.0d+0
      enddo
      logdef=0.0d+0
      in=0
      do i=1,n
        if(vcstat(i).gt.-2)then
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            if(vcstat(rowidx(j)+n).gt.-2)then
              if(abs(rownzs(j)).gt.tzer)then
                s=log(abs(rownzs(j)))
                count(rowidx(j)+n)=count(rowidx(j)+n)+1
                count(i)=count(i)+1
                logsum(i)=logsum(i)+s
                logsum(rowidx(j)+n)=logsum(rowidx(j)+n)+s
                logdef=logdef+s*s
                in=in+1
              endif
            endif
          enddo
        endif
      enddo
      do i=1,mn
       if((vcstat(i).le.-2).or.(count(i).eq.0))count(i)=1
      enddo
      logdef=sqrt(logdef)/dble(in)
      logdef=exp(logdef)
      write(buff,'(1x,a,i2,a,d12.6)')'Pass',pass,'. Average def.',logdef
      call mprnt(buff)
      if(logdef.le.scdif)then
        do i=1,mn
          sc(i)=1.0d+0
        enddo
        goto 999
      endif
c
c Initialize
c
      do i=1,m
        sc(i+n)=logsum(i+n)/count(i+n)
        rk(i+n)=0
      enddo
      sk=0
      do i=1,n
        if(vcstat(i).gt.-2)then
          s=logsum(i)
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            s=s-logsum(rowidx(j)+n)/count(rowidx(j)+n)
          enddo
        else
          s=0
        endif
        rk(i)=s
        sk=sk+s*s/count(i)
        sc(i)=0.0d+0
      enddo
      do i=1,mn
        scm1(i)=sc(i)
      enddo
      ekm1=0
      ek=0
      qk=1.0d+0
c
c Curtis-Reid scaling
c
  10  pass=pass+1
        do i=1,m
          rk(i+n)=ek*rk(i+n)
        enddo
        do i=1,n
          if(vcstat(i).gt.-2)then
            pnt1=colpnt(i)
            pnt2=colpnt(i+1)-1
            s=rk(i)/count(i)
            do j=pnt1,pnt2
              if(vcstat(rowidx(j)+n).gt.-2)
     x        rk(rowidx(j)+n)=rk(rowidx(j)+n)+s
            enddo
          endif
        enddo
        skm1=sk
        sk=0.0d+0
        do i=1,m
          rk(i+n)=-rk(i+n)/qk
          sk=sk+rk(i+n)*rk(i+n)/count(i+n)
        enddo
        ekm2=ekm1
        ekm1=ek
        ek=qk*sk/skm1
        qkm1=qk
        qk=1-ek
        if(pass.gt.scpass)goto 20
c
c Update Column-scale factors
c
        do i=1,n
          if(vcstat(i).gt.-2)then
            s=sc(i)
            sc(i)=s+(rk(i)/count(i)+ekm1*ekm2*(s-scm1(i)))/qk/qkm1
            scm1(i)=s
          endif
        enddo
c
c even pass
c
        do i=1,n
          if(vcstat(i).gt.-2)then
            s=ek*rk(i)
            pnt1=colpnt(i)
            pnt2=colpnt(i+1)-1
            do j=pnt1,pnt2
              if(vcstat(rowidx(j)+n).gt.-2)
     x        s=s+rk(rowidx(j)+n)/count(rowidx(j)+n)
            enddo
            s=-s/qk
          else
            s=0
          endif
          rk(i)=s
        enddo
        skm1=sk
        sk=0.0d+0
        do i=1,n
          sk=sk+rk(i)*rk(i)/count(i)
        enddo
        ekm2=ekm1
        ekm1=ek
        ek=qk*sk/skm1
        qkm1=qk
        qk=1-ek
c
c Update Row-scale factors
c
        do i=1,m
          j=i+n
          if(vcstat(j).gt.-2)then
            s=sc(j)
            sc(j)=s+(rk(j)/count(j)+ekm1*ekm2*(s-scm1(j)))/qk/qkm1
            scm1(j)=s
          endif
        enddo
      goto 10
c
c Syncronize Column factors
c
  20  do i=1,n
        if(vcstat(i).gt.-2)then
          sc(i)=sc(i)+(rk(i)/count(i)+ekm1*ekm2*(sc(i)-scm1(i)))/qkm1
        endif
      enddo
c
c Scaling
c
      logdef=0
      do i=1,mn
        if(vcstat(i).gt.-2)then
          sc(i)=exp(sc(i))
        else
          sc(i)=1.0d+0
        endif
      enddo
      do i=1,n
        pnt1=colpnt(i)
        pnt2=colpnt(i+1)-1
        do j=pnt1,pnt2
          rownzs(j)=rownzs(j)/sc(i)/sc(rowidx(j)+n)
          if((vcstat(rowidx(j)+n).gt.-2).and.
     x      (abs(rownzs(j)).gt.tzer))then
            s=log(abs(rownzs(j)))
            logdef=logdef+s*s
          endif
        enddo
        obj(i)=obj(i)/sc(i)
        bounds(i)=bounds(i)*sc(i)
      enddo
      do i=1,m
        rhs(i)=rhs(i)/sc(i+n)
        bounds(i+n)=bounds(i+n)/sc(i+n)
      enddo
      logdef=sqrt(logdef)/dble(in)
      logdef=exp(logdef)
      pass=pass-1
      write(buff,'(1x,a,i2,a,d12.6)')'Pass',pass,'. Average def.',logdef
      call mprnt(buff)
 999  return
      end
c
c ============================================================================
