c  Callable interface
c
c  Standard form: ax-s=b    u>=x,s>=l
c
c  remarks:
c          EQ  rows    0  >= s >=   0
c          GT  rows  +inf >= s >=   0
c          LT  rows    0  >= s >= -inf
c          FR  rows  +inf >= s >= -inf
c
c  input:   obj           objective function (to be minimize)       (n)
c           rhs           right-hand side                           (m)
c           lbound        lower bounds                              (m+n)
c           ubound        upper bounds                              (m+n)
c           colpnt        pointer to the columns                    (n+1)
c           rowidx        row indices                               (nz)
c           nonzeros      nonzero values                            (nz)
c           big           practical +inf
c
c  output: code           termination code
c          xs             primal values
c          dv             dual values
c          dspr           dual resuduals
c
c Input arrays will be destroyed !
c
c ===========================================================================
c
      subroutine solver(
     x obj,rhs,lbound,ubound,diag,odiag,xs,dxs,dxsn,up,dspr,ddspr,
     x ddsprn,dsup,ddsup,ddsupn,dv,ddv,ddvn,prinf,upinf,duinf,scale,
     x nonzeros,
     x vartyp,slktyp,colpnt,ecolpnt,count,vcstat,pivots,invprm,
     x snhead,nodtyp,inta1,prehis,rowidx,rindex,
     x code,opt,iter,corect,fixn,dropn,fnzmax,fnzmin,addobj,
     x bigbou,big,ft)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      common/initv/ prmin,upmax,dumin,stamet,safmet,premet,regul
      real*8        prmin,upmax,dumin
      integer*4     stamet,safmet,premet,regul
c
      integer*4 fixn,dropn,code,iter,corect,fnzmin,fnzmax,ft
      real*8  addobj,opt,big,
     x obj(n),rhs(m),lbound(mn),ubound(mn),scale(mn),diag(mn),odiag(mn),
     x xs(mn),dxs(mn),dxsn(mn),up(mn),dspr(mn),ddspr(mn),ddsprn(mn),
     x dsup(mn),ddsup(mn),ddsupn(mn),dv(m),ddv(m),ddvn(m),
     x nonzeros(cfree),prinf(m),upinf(mn),duinf(mn),bigbou
      integer*4 vartyp(n),slktyp(m),colpnt(n1),ecolpnt(mn),
     x count(mn),vcstat(mn),pivots(mn),invprm(mn),snhead(mn),
     x nodtyp(mn),inta1(mn),prehis(mn),rowidx(cfree),rindex(rfree)
c
      common/numer/ tplus,tzer
      real*8        tplus,tzer
      common/ascal/ objnor,rhsnor,scdiff,scpass,scalmet
      real*8        objnor,rhsnor,scdiff
      integer*4     scpass,scalmet
c ---------------------------------------------------------------------------
      integer*4 i,j,k,active,pnt1,pnt2,prelen,freen
      real*8 scobj,scrhs,sol,lbig
      character*99 buff
c ---------------------------------------------------------------------------
c
c inicializalas
c
      if(cfree.le.(nz+1)*2)then
        write(buff,'(1x,a)')'Not enough memory, realmem < nz !'
        call mprnt(buff)
        code=-2
        goto 50
      endif
      if(rfree.le.nz)then
        write(buff,'(1x,a)')'Not enough memory, intmem < nz !'
        call mprnt(buff)
        code=-2
        goto 50
      endif
      iter=0
      corect=0
      prelen=0
      fnzmin=cfree
      fnzmax=-1
      scobj=1.0d+0
      scrhs=1.0d+0
      code=0
      lbig=0.9d+0*big
      if(bigbou.gt.lbig)then
        lbig=bigbou
        big=lbig/0.9d+0
      endif
      do i=1,mn
        scale(i)=1.0d+0
      enddo
c
c Remove fix variables and free rows
c
      do i=1,n
        vartyp(i)=0
        if(abs(ubound(i)-lbound(i)).le.tplus*(abs(lbound(i)+1.0d0)))then
          vartyp(i)= 1
          vcstat(i)=-2-1
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            rhs(rowidx(j))=rhs(rowidx(j))-ubound(i)*nonzeros(j)
          enddo
          addobj=addobj+obj(i)*lbound(i)
        else
          vcstat(i)=0
        endif
      enddo
      do i=1,m
        slktyp(i)=0
        j=i+n
        if((ubound(j).gt.lbig).and.(lbound(j).lt.-lbig))then
          vcstat(j)=-2-1
        else
          vcstat(j)=0
        endif
      enddo
c
c   p r e s o l v e r
c
      call timer(k)
      if(premet.gt.0)then
        write(buff,'(1x)')
        call mprnt(buff)
        write(buff,'(1x,a)')'Process: presolv'
        call mprnt(buff)
        call presol(colpnt,rowidx,nonzeros,rindex,nonzeros(nz+1),
     x  snhead,snhead(n1),nodtyp,nodtyp(n1),vcstat,vcstat(n1),
     x  ecolpnt,count,ecolpnt(n1),count(n1),
     x  vartyp,dxsn(n1),dxs(n1),diag(n1),odiag(n1),
     x  ubound,lbound,ubound(n1),lbound(n1),rhs,obj,prehis,prelen,
     x  addobj,big,pivots,invprm,dv,ddv,dxsn,dxs,diag,odiag,premet,code)
        write(buff,'(1x,a)')'Presolv done...'
        call mprnt(buff)
        if(code.ne.0)goto 45
      endif
c
c Remove lower bounds
c
      call stndrd(ubound,lbound,rhs,obj,nonzeros,
     x vartyp,slktyp,vcstat,colpnt,rowidx,addobj,tplus,tzer,lbig,big)
c
c Scaling before aggregator
c
      i=iand(scalmet,255)
      j=iand(scpass,255)
      if(i.gt.0)call mscale(colpnt,rowidx,nonzeros,obj,rhs,ubound,
     x vcstat,scale,upinf,i,j,scdiff,ddsup,dxsn,dxs,snhead)
c
c Aggregator
c
      if(premet.gt.127)then
        write(buff,'(1x)')
        call mprnt(buff)
        write(buff,'(1x,a)')'Process: aggregator'
        call mprnt(buff)
        call aggreg(colpnt,rowidx,nonzeros,rindex,
     x  vcstat,vcstat(n1),ecolpnt,count,ecolpnt(n1),count(n1),
     x  rhs,obj,prehis,prelen,pivots,vartyp,slktyp,invprm,snhead,
     x  nodtyp,inta1,inta1(n1),dv,addobj,premet,code)
        write(buff,'(1x,a)')'Aggregator done...'
        call mprnt(buff)
        if(code.ne.0)goto 55
      endif
c
c Scaling after aggregator
c
      i=scalmet/256
      j=scpass/256
      if(i.gt.0)call mscale(colpnt,rowidx,nonzeros,obj,rhs,
     x ubound,vcstat,scale,upinf,i,j,scdiff,ddsup,dxsn,dxs,snhead)
c
      call timer(j)
      write(buff,'(1x)')
      call mprnt(buff)
      write(buff,'(1x,a,f8.2,a)')
     x 'Time for presolv, scaling and aggregator: ',0.01*(j-k),' sec.'
      call mprnt(buff)
c
c cleaning
c
      do i=1,mn
        xs(i)=0.0d+0
        dspr(i)=0.0d+0
        dsup(i)=0.0d+0
        up(i)=0.0d+0
      enddo
      do i=1,m
        dv(i)=0.0d+0
      enddo
c
c Is the problem solved ?
c
      fixn=0
      dropn=0
      freen=0
      do i=1,n
        if(vcstat(i).le.-2)then
          fixn=fixn+1
        else if(vartyp(i).eq.0) then
          freen=freen+1
        endif
      enddo
      do i=1,m
        if(vcstat(i+n).le.-2)dropn=dropn+1
      enddo
      active=mn-fixn-dropn
      if(active.eq.0)code=2
      if(code.gt.0)then
        opt=addobj
        write(buff,'(1x,a)')'Problem is solved by the pre-solver'
        call mprnt(buff)
        if(code.gt.0)goto 55
        goto 50
      endif
c
c Presolve statistics
c
      if(premet.gt.0)then
        i=0
        j=0
        do k=1,n
          if(vcstat(k).gt.-2)then
            i=i+count(k)-ecolpnt(k)+1
            if(j.lt.count(k)-ecolpnt(k)+1)j=count(k)-ecolpnt(k)+1
          endif
        enddo
        write(buff,'(1x,a22,i8)')'Number of rows       :',(m-dropn)
        call mprnt(buff)
        write(buff,'(1x,a22,i8)')'Number of columns    :',(n-fixn)
        call mprnt(buff)
        write(buff,'(1x,a22,i8)')'Free variables       :',freen
        call mprnt(buff)
        write(buff,'(1x,a22,i8)')'No. of nonzeros      :',i
        call mprnt(buff)
        write(buff,'(1x,a22,i8)')'Longest column count :',j
        call mprnt(buff)
      endif
c
c Incrase rowidx by n
c
      j=colpnt(1)
      k=colpnt(n+1)-1
      do i=j,k
        rowidx(i)=rowidx(i)+n
      enddo
      active=mn-fixn-dropn
c
c Normalize obj and rhs
c
      if(objnor.gt.tzer)then
        call scalobj(obj,scobj,vcstat,objnor)
      endif
      if(rhsnor.gt.tzer)then
        call scalrhs(rhs,scrhs,vcstat,rhsnor,ubound,xs,up)
      endif
c
c Calling phas12
c
      sol=scobj*scrhs
      i=mn+mn
      call timer(k)
      call phas12(
     x obj,rhs,ubound,diag,odiag,xs,dxs,dxsn,up,dspr,ddspr,
     x ddsprn,dsup,ddsup,ddsupn,dv,ddv,ddvn,nonzeros,prinf,upinf,duinf,
     x vartyp,slktyp,colpnt,ecolpnt,count,vcstat,pivots,invprm,
     x snhead,nodtyp,inta1,rowidx,rindex,
     x dxs,dxsn,ddspr,ddsprn,ddsup,ddsupn,
     x code,opt,iter,corect,fixn,dropn,active,fnzmax,fnzmin,addobj,
     x sol,ft,i)
      call timer(j)
      write(buff,'(1x,a,f11.2,a)')'Solver time ',0.01*(j-k),' sec.'
      call mprnt(buff)
c
c Decrease rowidx by n
c
      j=colpnt(1)
      k=colpnt(n+1)-1
      do i=j,k
        rowidx(i)=rowidx(i)-n
      enddo
c
c Rescaling
c
  55  do i=1,m
        rhs(i)=rhs(i)*scrhs*scale(i+n)
        ubound(i+n)=ubound(i+n)*scrhs*scale(i+n)
        xs(i+n)=xs(i+n)*scrhs*scale(i+n)
        up(i+n)=up(i+n)*scrhs*scale(i+n)
        dv(i)=dv(i)*scobj/scale(i+n)
        dspr(i+n)=dspr(i+n)/scale(i+n)*scobj
        dsup(i+n)=dsup(i+n)/scale(i+n)*scobj
      enddo
c
      do i=1,n
        obj(i)=obj(i)*scobj*scale(i)
        ubound(i)=ubound(i)*scrhs/scale(i)
        pnt1=colpnt(i)
        pnt2=colpnt(i+1)-1
        do j=pnt1,pnt2
          nonzeros(j)=nonzeros(j)*scale(i)*scale(rowidx(j)+n)
        enddo
c
        xs(i)=xs(i)/scale(i)*scrhs
        up(i)=up(i)/scale(i)*scrhs
        dspr(i)=dspr(i)*scale(i)*scobj
        dsup(i)=dsup(i)*scale(i)*scobj
      enddo
c
c Postprocessing
c
  45  call pstsol(colpnt,rowidx,nonzeros,vcstat,vcstat(n1),
     x vartyp,slktyp,ubound,lbound,ubound(n1),lbound(n1),rhs,obj,xs,
     x inta1,ddvn,prehis,prelen,big)
c
  50  return
      end
c
c ===========================================================================
c
      subroutine stndrd(ubound,lbound,rhs,obj,nonzeros,
     x vartyp,slktyp,vcstat,colpnt,rowidx,addobj,tplus,tzer,lbig,big)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 vartyp(n),slktyp(m),vcstat(mn),colpnt(n1),rowidx(nz)
      real*8 ubound(mn),lbound(mn),rhs(m),obj(n),nonzeros(nz),
     x addobj,tplus,tzer,lbig,big
c
      integer*4 i,j,k,pnt1,pnt2
c
c generate standard form, row modification
c
      k=0
      do 150 i=1,m
        j=i+n
        if(vcstat(j).gt.-2)then
          if(abs(ubound(j)-lbound(j)).le.tplus*(abs(lbound(j))+1d0))then
            slktyp(i)=0
            ubound(j)=0.0d+00
            rhs(i)=rhs(i)+lbound(j)
            goto 150
          endif
ccc          if((ubound(j).gt.lbig).and.(lbound(j).lt.-lbig))then
ccc            vcstat(j)=-2
ccc            slktyp(i)=0
ccc            goto 150
ccc          endif
          if(lbound(j).lt.-lbig)then
            slktyp(i)=2
            lbound(j)=-ubound(j)
            ubound(j)=big
            rhs(i)=-rhs(i)
            k=k+1
          else
            slktyp(i)=1
          endif
          rhs(i)=rhs(i)+lbound(j)
          ubound(j)=ubound(j)-lbound(j)
          if(ubound(j).lt.lbig)slktyp(i)=-slktyp(i)
        else
          slktyp(i)=0
        endif
 150  continue
c
c negate reverse rows
c
      if(k.gt.0)then
        do i=1,n
          pnt1=colpnt(i)
          pnt2=colpnt(i+1)-1
          do j=pnt1,pnt2
            if(abs(slktyp(rowidx(j))).ge.2)nonzeros(j)=-nonzeros(j)
          enddo
        enddo
      endif
c
c column modification
c
      do 155 i=1,n
        if(vcstat(i).gt.-2)then
ccc          if(abs(ubound(i)-lbound(i)).le.tplus*(abs(lbound(i))+1d0))then
ccc            vcstat(i)=-2
ccc            vartyp(i)= 1
ccc            do j=colpnt(i),colpnt(i+1)-1
ccc              rhs(rowidx(j))=rhs(rowidx(j))-nonzeros(j)*lbound(i)
ccc            enddo
ccc            addobj=addobj+obj(i)*lbound(i)
ccc            goto 155
ccc          endif
          if((ubound(i).gt.lbig).and.(lbound(i).lt.-lbig))then
            vartyp(i)=0
            goto 155
          endif
          if(lbound(i).lt.-lbig)then
            vartyp(i)=2
            lbound(i)=-ubound(i)
            ubound(i)=big
            obj(i)=-obj(i)
            do j=colpnt(i),colpnt(i+1)-1
              nonzeros(j)=-nonzeros(j)
            enddo
          else
            vartyp(i)=1
          endif
          if(abs(lbound(i)).gt.tzer)then
            if(ubound(i).lt.lbig)ubound(i)=ubound(i)-lbound(i)
            do j=colpnt(i),colpnt(i+1)-1
              rhs(rowidx(j))=rhs(rowidx(j))-nonzeros(j)*lbound(i)
            enddo
            addobj=addobj+obj(i)*lbound(i)
          endif
          if(ubound(i).lt.lbig)vartyp(i)=-vartyp(i)
        endif
 155  continue
      return
      end
c
c ===========================================================================
