c Computing the starting point  xs,up in the primal space,
c                       dv, dspr,dsup in the dual   space.
c
c ===========================================================================
c
      subroutine initsol(xs,up,dv,dspr,dsup,rhs,obj,bounds,vartyp,
     x slktyp,vcstat,colpnt,ecolpnt,pivots,rowidx,nonzeros,diag,
     x updat1,count)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      common/initv/ prmin,upmax,dumin,stamet,safmet,premet,regul
      real*8        prmin,upmax,dumin
      integer*4     stamet,safmet,premet,regul
c
      common/mscal/ varadd,slkadd,scfree
      real*8        varadd,slkadd,scfree
c
      common/numer/  tplus,tzer
      real*8         tplus,tzer
c
      integer*4 ecolpnt(mn),vcstat(mn),colpnt(n1),rowidx(cfree),
     x pivots(mn),vartyp(n),slktyp(m),count(mn)
      real*8  xs(mn),up(mn),dv(m),dspr(mn),dsup(mn),rhs(m),obj(n),
     x bounds(mn),diag(mn),updat1(mn),nonzeros(cfree)
c
      integer*4 i,j,pnt1,pnt2
      real*8    sol,sb,spr,sdu,prlo,dulo,ngap
      logical   addall
c
c ---------------------------------------------------------------------------
c
c Reset all values
c
      do i=1,mn
        xs(i)=0.0d+0
        up(i)=0.0d+0
        dspr(i)=0.0d+0
        dsup(i)=0.0d+0
        if(i.le.m)dv(i)=0.0d+0
      enddo
c
c RHS for XS ans UP
c
      do i=1,m
        if(slktyp(i).lt.0)then
          if(bounds(i+n).gt.upmax)then
            sol=upmax/2
          else
            sol=bounds(i+n)/2
          endif
        else
          sol=0.0d+0
        endif
        updat1(i+n)=rhs(i)+sol
      enddo
      do i=1,n
        if(vartyp(i).lt.0)then
          if(bounds(i).gt.upmax)then
            sol=-upmax
          else
            sol=-bounds(i)
          endif
        else
          sol=0.0d+0
        endif
        updat1(i)=sol
      enddo
c
      call augftr(ecolpnt,
     x vcstat,rowidx,pivots,count,nonzeros,diag,updat1)
      call augbtr(ecolpnt,
     x vcstat,rowidx,pivots,count,nonzeros,diag,updat1)
c
c Initial values for xs, up
c
      do i=1,n
        if(vcstat(i).gt.-2)then
          xs(i)=updat1(i)
          if(vartyp(i).lt.0)then
            up(i)=bounds(i)-xs(i)
          endif
        endif
      enddo
      do i=1,m
        j=i+n
        if((vcstat(j).gt.-2).and.(slktyp(i).ne.0))then
          xs(j)=-updat1(j)
          if(slktyp(i).lt.0)then
            xs(j)=(bounds(j)-updat1(j))/2
            up(j)=bounds(j)-xs(j)
          endif
        endif
      enddo
c
c Initial dual variables, stamet=2
c
      if(stamet.eq.1)then
        do i=1,m
          dv(i)=0
          dspr(i+n)=0
          dsup(i+n)=0
        enddo
        do i=1,n
          if((vcstat(i).gt.-2).and.(vartyp(i).ne.0))then
            if(vartyp(i).lt.0)then
              dspr(i)=obj(i)/2
              dsup(i)=-obj(i)/2
            else
              dspr(i)=obj(i)
            endif
          endif
        enddo
      else if(stamet.eq.2)then
        do i=1,m
          updat1(i+n)=0.0d+0
        enddo
        do i=1,n
          updat1(i)=obj(i)
        enddo
        call augftr(ecolpnt,
     x  vcstat,rowidx,pivots,count,nonzeros,diag,updat1)
        call augbtr(ecolpnt,
     x  vcstat,rowidx,pivots,count,nonzeros,diag,updat1)
        do i=1,m
          if(vcstat(i+n).gt.-2)then
            dv(i)=updat1(i+n)
          else
            dv(i)=0.0d+0
          endif
          if(slktyp(i).ne.0)then
            dspr(i+n)=-dv(i)
            if(slktyp(i).lt.0)then
              dspr(i+n)=-dv(i)/2
              dsup(i+n)=dv(i)/2
            endif
          endif
        enddo
        do i=1,n
          if((vcstat(i).gt.-2).and.(vartyp(i).ne.0))then
            if(vartyp(i).lt.0)then
              dspr(i)=-updat1(i)
              dsup(i)=updat1(i)
            else
              dspr(i)=-updat1(i)
            endif
          endif
        enddo
      endif
c
c Compute prmin,dumin
c
      if(safmet.lt.0)then
        safmet=-safmet
        addall=.true.
      else
        addall=.false.
      endif
c
c Marsten et al.
c
      if(safmet.eq.2)then
        do i=1,m
          updat1(i)=0
        enddo
        do i=1,n
          if(vcstat(i).gt.-2)then
            pnt1=colpnt(i)
            pnt2=colpnt(i+1)-1
            sol=0.0d+0
            sb=obj(i)
            do j=pnt1,pnt2
              if(vcstat(rowidx(j)).gt.-2)then
                sol=sol+rhs(rowidx(j)-n)*nonzeros(j)
                updat1(rowidx(j)-n)=updat1(rowidx(j)-n)+nonzeros(j)*sb
              endif
            enddo
            if(prmin.lt.sol)prmin=sol
          endif
        enddo
        do i=1,m
          if(dumin.lt.abs(updat1(i)))dumin=abs(updat1(i))
        enddo
      endif
c
c Mehrotra
c
      if(safmet.eq.3)then
        spr=1.0d+0/tzer
        sdu=1.0d+0/tzer
        do i=1,mn
          if(i.le.n)then
             j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if((vcstat(i).gt.-2).and.(j.ne.0))then
            if(spr.gt.xs(i))spr=xs(i)
            if(sdu.gt.dspr(i))sdu=dspr(i)
            if(j.lt.0)then
              if(spr.gt.up(i))spr=up(i)
              if(sdu.gt.dsup(i))sdu=dsup(i)
            endif
          endif
        enddo
        spr=-1.5d+0*spr
        sdu=-1.5d+0*sdu
        if(spr.lt.0.001d+0)spr=0.001d+0
        if(sdu.lt.0.001d+0)sdu=0.001d+0
        prlo=0.0d+0
        dulo=0.0d+0
        ngap=0.0d+0
        do i=1,mn
          if(i.le.n)then
             j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if((vcstat(i).gt.-2).and.(j.ne.0))then
             sol=xs(i)+spr
             sb=dspr(i)+sdu
             ngap=ngap+sol*sb
             prlo=prlo+sol
             dulo=dulo+sb
             if(j.lt.0)then
               sol=up(i)+spr
               sb=dsup(i)+sdu
               ngap=ngap+sol*sb
               prlo=prlo+sol
               dulo=dulo+sb
             endif
          endif
        enddo
        prmin=spr+0.5d+0*ngap/dulo
        dumin=sdu+0.5d+0*ngap/prlo
      endif
      if(addall.and.(safmet.lt.3))then
        sol=1.0d+0/tzer
        sb=1.0d+0/tzer
        do i=1,mn
          if(vcstat(i).gt.-2)then
            if(i.le.n)then
              j=vartyp(i)
            else
              j=slktyp(i-n)
            endif
            if(j.ne.0)then
              if(sol.gt.xs(i))sol=xs(i)
              if(sb.gt.dspr(i))sb=dspr(i)
            endif
            if(j.lt.0)then
              if(sol.gt.up(i))sol=up(i)
              if(sb.gt.dsup(i))sb=dsup(i)
            endif
          endif
        enddo
        if(sol.lt.0)prmin=prmin-sol
        if(sb.lt.0)dumin=dumin-sb
      endif
c
c Correcting
c
      if(addall)then
        spr=1.0d+0/tzer
        sdu=1.0d+0/tzer
        sol=1.0d+0
      else
        spr=prmin
        sdu=dumin
        sol=0.0d+0
      endif
      do i=1,mn
        if(vcstat(i).gt.-2)then
          if(i.le.n)then
            j=vartyp(i)
          else
            j=slktyp(i-n)
          endif
          if(j.ne.0)then
            if(xs(i).lt.spr)then
              xs(i)=sol*xs(i)+prmin
            endif
            if(dspr(i).lt.sdu)then
              dspr(i)=sol*dspr(i)+dumin
            endif
            if(j.lt.0)then
              if(up(i).lt.spr)then
                up(i)=sol*up(i)+prmin
              endif
              if(dsup(i).lt.sdu)then
                dsup(i)=sol*dsup(i)+dumin
              endif
            endif
          endif
        endif
      enddo
c
      return
      end
c
c ===========================================================================
c
c     Set up the initial scaling matrix
c     (for the computation of the initial solution)
c
      subroutine fscale(vcstat,diag,odiag,vartyp,slktyp)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      common/mscal/ varadd,slkadd,scfree
      real*8        varadd,slkadd,scfree
c
      integer*4 vcstat(mn),vartyp(n),slktyp(m)
      real*8 diag(mn),odiag(mn)
c
      integer*4 i,j
      real*8 sol
c
      do i=1,mn
        sol=0.0d+0
        if(vcstat(i).gt.-2)then
          if(i.le.n)then
            j=vartyp(i)
            if(j.gt.0)then
              sol=-1.0d0
            else if(j.lt.0)then
              sol=-2.0d0
            else
              sol=-scfree
            endif
          else
            j=slktyp(i-n)
            if(j.gt.0)then
              sol=1.0d0
            else if(j.lt.0)then
              sol=0.5d+0
            else
              sol=0.0d+0
            endif
          endif
        endif
        diag(i)=sol
        odiag(i)=sol
      enddo
      return
      end
c
c ============================================================================
