c Multi-centrality corrections
c
c ===========================================================================
c
      subroutine cpdccd(xs,up,dspr,dsup,upinf,
     x dxsn,ddvn,ddsprn,ddsupn,dxs,ddv,ddspr,ddsup,bounds,
     x ecolpnt,count,pivots,vcstat,diag,odiag,rowidx,nonzeros,
     x colpnt,vartyp,slktyp,barpar,corr,prstpl,dustpl)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree

      common/numer/ tplus,tzer
      real*8        tplus,tzer

      common/predc/ target,tsmall,tlarge,center,corstp,mincc,maxcc
      real*8        target,tsmall,tlarge,center,corstp
      integer*4     mincc,maxcc
c
      integer*4 ecolpnt(mn),count(mn),vcstat(mn),rowidx(cfree),
     x pivots(mn),colpnt(n1),vartyp(n),slktyp(m),corr
      real*8 xs(mn),up(mn),dspr(mn),dsup(mn),
     x upinf(mn),dxsn(mn),ddvn(m),ddsprn(mn),ddsupn(mn),
     x dxs(mn),ddv(m),ddspr(mn),ddsup(mn),bounds(mn),
     x diag(mn),odiag(mn),nonzeros(cfree),barpar,prstpl,dustpl
c
      integer*4 i,j,cr,maxccx
      real*8 s,ss,ostp,ostd,prs,dus,dp
c
c ---------------------------------------------------------------------------
      maxccx=maxcc
      cr=0
      ostp=prstpl
      ostd=dustpl
      if(maxcc.le.0)goto 999      
      cr=1
c
c Define Target
c
   1  prs=prstpl*(target+1.0d+0)+target
      dus=dustpl*(target+1.0d+0)+target
      if (prs.ge.1.0d+0)prs=1.0d+0
      if (dus.ge.1.0d+0)dus=1.0d+0

      do 10 j=1,n
        if(vcstat(j).le.-2)then
          dxsn(j)=0.0d+0
          goto 10
        endif
        if(vartyp(j).eq.0)then
          dxsn(j)=0.0d+0
          goto 10
        endif
        dp=(xs(j)+prs*dxs(j))*(dspr(j)+dus*ddspr(j))
        if (dp.le.tsmall*barpar)then
          s=barpar-dp
        else if(dp.ge.tlarge*barpar)then
          s=-center*barpar
        else
          s=0.0d+0
        endif

        if(vartyp(j).gt.0)then
          dxsn(j)=-s/xs(j)
          goto 10
        endif

        dp=(up(j)+prs*(upinf(j)-dxs(j)))*(dsup(j)+dus*ddsup(j))
        if (dp.le.tsmall*barpar)then
          ss=barpar-dp
        else if(dp.ge.tlarge*barpar)then
          ss=-center*barpar
        else
          ss=0.0d+0
        endif
        dxsn(j)=-s/xs(j)+ss/up(j)
  10  continue
c
      do 20 i=1,m
        j=i+n
        if(vcstat(j).le.-2)then
          dxsn(j)=0.0d+0
          goto 20
        endif
        if(slktyp(i).eq.0)then
          dxsn(j)=0.0d+0
          goto 20
        endif
c
c Bounded variable
c
        dp=(xs(j)+prs*dxs(j))*(dspr(j)+dus*ddspr(j))
        if (dp.le.tsmall*barpar)then
          s=barpar-dp
        else if (dp.ge.tlarge*barpar)then
          s=-center*barpar
        else
          s=0.0d+0
        endif
        if(slktyp(i).gt.0)then
          dxsn(j)=s/xs(j)*odiag(j)
          goto 20
        endif
c
c upper bounded variable
c
        dp=(up(j)+prs*(upinf(j)-dxs(j)))*(dsup(j)+dus*ddsup(j))
        if (dp.le.tsmall*barpar)then
          ss=barpar-dp
        else if(dp.ge.tlarge*barpar)then
          ss=-center*barpar
        else
          ss=0.0d+0
        endif
        dxsn(j)=(s/xs(j)-ss/up(j))*odiag(j)
  20  continue
c
c solve the augmented system
c
      call citref(diag,odiag,pivots,rowidx,nonzeros,colpnt,
     x ecolpnt,count,vcstat,dxsn,ddsprn,ddsupn,upinf,
     x bounds,xs,up,vartyp,slktyp)
c
c Primal and dual variables
c
      do 30 i=1,m
        j=i+n
        if(vcstat(j).le.-2)goto 30
        ddvn(i)=ddv(i)+dxsn(j)
        if(slktyp(i).eq.0)goto 30
        dp=(xs(j)+prs*dxs(j))*(dspr(j)+dus*ddspr(j))
        if (dp.le.tsmall*barpar)then
          s=barpar-dp
        else if (dp.ge.tlarge*barpar)then
          s=-center*barpar
        else
          s=0.0d+0
        endif
        if(slktyp(i).gt.0)then
          dxsn(j)=-odiag(j)*(dxsn(j)-s/xs(j))
          goto 30
        endif
        dp=(up(j)+prs*(upinf(j)-dxs(j)))*(dsup(j)+dus*ddsup(j))
        if (dp.le.tsmall*barpar)then
          ss=barpar-dp
        else if(dp.ge.tlarge*barpar)then
          ss=-center*barpar
        else
          ss=0.0d+0
        endif
        dxsn(j)=-odiag(j)*(dxsn(j)-s/xs(j)+ss/up(j))
  30  continue
c
c Primal upper bounds, dual slacks
c
      do 40 i=1,mn
        if(vcstat(i).le.-2)goto 40
        if(i.le.n)then
          j=vartyp(i)
        else
          j=slktyp(i-n)
        endif
        if(j.eq.0)then
          if(i.le.n)then
            ddsprn(i)=ddsprn(i)+ddspr(i)
          endif
          goto 45
        endif
        dp=(xs(i)+prs*dxs(i))*(dspr(i)+dus*ddspr(i))
        if (dp.le.tsmall*barpar)then
          s=barpar-dp
        else if(dp.ge.tlarge*barpar)then
          s=-center*barpar
        else
          s=0.0d+0
        endif
        ddsprn(i)=(s-dspr(i)*dxsn(i))/xs(i)+ddspr(i)
        if(j.lt.0)then
          dp=(up(i)+prs*(upinf(i)-dxs(i)))*(dsup(i)+dus*ddsup(i))
          if (dp.le.tsmall*barpar)then
            ss=barpar-dp
          else if(dp.ge.tlarge*barpar)then
            ss=-center*barpar
          else
            ss=0.0d+0
          endif
          ddsupn(i)=(ss+dsup(i)*dxsn(i))/up(i)+ddsup(i)
        endif
  45    dxsn(i)=dxsn(i)+dxs(i)
  40  continue
c
c Compute primal and dual steplengths
c
      call cstpln(prstpl,xs,dxsn,up,upinf,
     x dustpl,dspr,ddsprn,dsup,ddsupn,vartyp,slktyp,vcstat)
c
c Check corrections criteria
c
      if(cr.gt.mincc)then
        if(min(prstpl,dustpl).lt.corstp*min(ostp,ostd))then
          if(min(prstpl,dustpl).lt.min(ostp,ostd))then
            prstpl=ostp
            dustpl=ostd
            cr=cr-1
            goto 999
          else
            maxccx=cr
          endif
        endif
      endif
c
c Continue correcting, change the actual search direction
c
      ostp=prstpl
      ostd=dustpl
      do i=1,mn
        dxs(i)=dxsn(i)
        ddspr(i)=ddsprn(i)
        ddsup(i)=ddsupn(i)
      enddo
      do i=1,m
        ddv(i)=ddvn(i)
      enddo     
      if(cr.lt.maxccx)then
        cr=cr+1
        goto 1
      endif
c
c End of the correction loop, save the number of the corrections
c
 999  corr=cr
      return
      end
c
c ============================================================================
