function [A,s] = nogap(n)

%  <Purpose>
%     Construct a matrix whose singular values are steadily decaying;
%
%  <Syntax>
%     [A,sv] = nogap(n);
%
%  <Description>
%     Matrix A is of size n-by-n and its singular values are distributed
%     geometrically between 1 and 1e-15
%
%  <Input>
%     n -- size of the n-by-n matrix (default: n = 800);
%
%  <Output>
%       A  -- the n-by-n matrix;
%       sv -- the vector containing all singular values of A;
%

% Check the required input arguments.
if (nargin == 0)
    n = 800;
end

if ( n <= 20 )
    error('size is too small. (n > 20 is required)')
end

% Compute target matrix
m = n;
a = 2*rand(m,10)-1; b = 2*rand(n,10)-1;
[U,~] = qr(a);
[V,~] = qr(b);

s = zeros(n,1);

k = n;
tmp = k-1; p = 15;
r = 0.1^(p/tmp);
s(1) = 1;
for j = 2:tmp
    s(j) = r^(j-1);
end;
s(k) = 0.1^p;

S = zeros(m,n);
for j = 1:n
    S(j,j) = s(j);
end;
A = U(:,1:n)*(S(1:n,:)*V');
