function [A,B,tol] = lrowup02

%  <Purpose>
%     Construct a low rank initial matrix and a matrix whose rows are
%     linearly combinations of rows of the initial matrix for testing row
%     updating (numerical rank is invariant at each step);
%
%  <Syntax>
%     [A,B,tol] = lrowup02;
%
%  <Description>
%     The initial matrix A is of size 1000x500 and its singular values are
%     distributed geometrically between 1 and 1e-6, and between 1e-10 and
%     1e-15 (numerical rank is 10 w.r.t. threshold 1e-8). For testing row
%     updating algorithms, the rows of matrix B will be inserted into A.
%
%  <Output>
%       A -- initial matrix ( size: 1000x500 );
%       B -- 30-by-500 matrix whose rows are linearly combinations of row
%            vectors of A;
%     tol -- the suggested threshold;
%

nv = 30;

% Compute base matrix
m = 1000; n = 500;
a = 2*rand(m,10)-1; b = 2*rand(n,10)-1;
[U,~] = qr(a);
[V,~] = qr(b);

s = zeros(n,1);

k = 10;
tmp = k-1; p = 6;
r = 0.1^(p/tmp);
s(1) = 1;
for j = 2:tmp
    s(j) = r^(j-1);
end;
s(k) = 0.1^p;

tmp = n-k-1; q = 10;
r = 0.1^((15-q)/tmp);
s(k+1) = 0.1^q;
for j = 2:n-k
    s(k+j) = (0.1^q)*r^(j-1);
end;

S = zeros(m,n);
for j = 1:n
    S(j,j) = s(j);
end;
A = U(:,1:n)*(S(1:n,:)*V');

% Compute additional vectors
Q = orth(rand(nv,nv));
B = Q*A(1:nv,:);

tol = 1e-8;

