function [A,s1] = imagemx(filename,fmt)

%  <Purpose>
%     Construct an image matrix from a graphics file;
%
%  <Syntax>
%     [A,s1] = imagemx(FILENAME,FMT);
%
%  <Description>
%    Matrix A is a greyscale image from the file specified by the string
%    FILENAME, where the string FMT specifies the format of the file. If
%    the file is not in the current directory or in a directory, specify
%    the full pathname of the location on your system.
%    For example:  [A,s1] = imagemx('image01.jpg','jpg');
%
%  <Input>
%    FILENAME -- the file name of graphics file (string);
%         FMT -- the format of the file (string);
%
%  <Output>
%     A -- image matrix with double precision values;
%    s1 -- the largest singular value;
%

if (nargin ~= 2)
    error('The syntax: [A,s1] = imagemx(FILENAME,FMT); ')
end

A = imread(filename,fmt);
A = (1/255)*double(A);
s1 = norm(A);

