function [A,tol] = hrowdw01

%  <Purpose>
%     Construct a high rank matrix for testing row downdating
%     (numerical rank decreases at each step);
%
%  <Syntax>
%     [A,tol] = hrowdw01;
%
%  <Description>
%     The initial matrix is of size 1000-by-500 and its singular values are
%     distributed geometrically between 1 and 1e-6, and between 1e-10 and
%     1e-15 (numerical rank is 490 w.r.t. threshold 1e-8). Matrix A is
%     constructed by stacking 30 randomly generated row vectors on the top
%     of the initial matrix.
%
%  <Output>
%       A -- 1030-by-500 matrix;
%     tol -- the suggested threshold;
%

nv = 30;

% Compute base matrix
m = 1000; n = 500;
a = 2*rand(m,10)-1; b = 2*rand(n,10)-1;
[U,~] = qr(a);
[V,~] = qr(b);

s = zeros(n,1);

k = 490;
tmp = k-1; p = 6;
r = 0.1^(p/tmp);
s(1) = 1;
for j = 2:tmp
    s(j) = r^(j-1);
end;
s(k) = 0.1^p;

tmp = n-k-1; q = 10;
r = 0.1^((15-q)/tmp);
s(k+1) = 0.1^q;
for j = 2:n-k
    s(k+j) = (0.1^q)*r^(j-1);
end;

S = zeros(m,n);
for j = 1:n
    S(j,j) = s(j);
end;
A = U(:,1:n)*(S(1:n,:)*V');

% Compute additional vectors
B = zeros(nv,n);
for j = 1:nv
    a = rand(1,n); nrma = norm(a);
    B(j,:) = (sqrt(n)/nrma)*a;
end

A = [B;A];
tol = 1e-8;

