function [A,tol,Y] = hlnois(n)

%  <Purpose>
%     Construct a high rank matrix with low noise level;
%
%  <Syntax>
%     [A,tol,Y] = hlnois(n);
%
%  <Description>
%     Matrix A is of size 2n-by-n and its singular values are distributed
%     geometrically between 1 and 1e-11, and between 1e-13 and 1e-15
%     (numerical rank is n-10 within threshold 1e-12).
%
%  <Input>
%     n -- size of the 2n-by-n matrix (default: n = 800);
%
%  <Output>
%       A -- the 2n-by-n matrix;
%     tol -- the suggested threshold;
%       Y -- the orthogonal complement of the numerical kernel;
%

% Check the required input arguments.
if (nargin == 0)
    n = 800;
end

if ( n <= 20 )
    error('size is too small. (n > 20 is required)')
end

% Compute target matrix
m = 2*n;
a = 2*rand(m,10)-1; b = 2*rand(n,10)-1;
[U,~] = qr(a);
[V,~] = qr(b);

s = zeros(n,1);

k = n-10;
tmp = k-1; p = 11;
r = 0.1^(p/tmp);
s(1) = 1;
for j = 2:tmp
    s(j) = r^(j-1);
end;
s(k) = 0.1^p;

tmp = n-k-1; q = 13; 
r = 0.1^((15-q)/tmp);
s(k+1) = 0.1^q;
for j = 2:n-k
    s(k+j) = (0.1^q)*r^(j-1);
end;

S = zeros(m,n);
for j = 1:n
    S(j,j) = s(j);
end;
A = U(:,1:n)*(S(1:n,:)*V');

tol = 1e-12;
%----------------------------------
clear U S;
if (nargout == 3)
   Y = V(:,1:k);
end
clear V;

