function [A,s1] = cranfield

%  <Purpose>
%     Construct a 3000x1400 term-by-document matrix from CRANFIELD;
%
%  <Syntax>
%     [A,s1] = cranfield;
%
%  <Description>
%     CRANFIELD is a standard document collection in Cornell SMART system.
%     This function takes the first 3,000 terms and 1,400 documents to
%     form a 3000x1400 term-by-document matrix.
%
%  <Output>
%      A -- the 3000-by-1400 matrix;
%     s1 -- the largest singular value;
%

B =  [ 1     297       1;
       1    1054       2;
       1    1373       1;
       1    1783       1;
       1    2478       1;
       2      65       1;
       2     283       2;
       2     356       1;
       2    1071       4;
       2    1596       2;
       2    1783       2;
       3    1071       1;
       4     816       1;
       5     152       2;
       5    1524       1;
       6     152       1;
       6    1524       2;
       7      99       1;
       7     283       1;
       7     286       2;
       7     437       2;
       7     816       1;
       7    1003       1;
       7    2011       1;
       7    2209       1;
       7    2294       2;
       8     816       1;
       8    1003       3;
       8    1373       2;
       8    1783       1;
       9       8       1;
       9     356       1;
       9     893       1;
       9    1003       1;
       9    1309       1;
       9    1783       1;
       9    2337       1;
      10      65       1;
      11    1636       1;
      11    1783       1;
      11    2406       1;
      12     108       2;
      12     155       1;
      12     356       4;
      12    1459       1;
      12    1524       1;
      12    1636       1;
      12    2320       2;
      13      65       1;
      13     816       1;
      13    1616       1;
      14       8       1;
      14      65       1;
      14      93       1;
      14     177       1;
      14     248       1;
      14     356       1;
      14     816       2;
      14    1010       1;
      14    1100       1;
      14    1323       1;
      14    1373       2;
      14    1459       1;
      14    1478       1;
      14    1636       1;
      14    2011       1;
      14    2062       1;
      14    2296       1;
      14    2320       4;
      14    2557       1;
      14    2580       1;
      14    2925       1;
      15      65       1;
      15    1270       1;
      15    1459       1;
      16      65       1;
      16     283       1;
      16     438       1;
      16    1010       1;
      17     283       2;
      17     286       1;
      17     995       2;
      17    1054       1;
      17    1596       1;
      17    1783       1;
      18     437       1;
      18    1459       1;
      18    1604       1;
      18    2273       4;
      19       8       1;
      19     356       1;
      19    1596       1;
      20     177       1;
      20    1116       1;
      20    1270       3;
      20    1596       4;
      20    2406       1;
      21     155       2;
      21     665       1;
      21    1270       1;
      21    1783       1;
      22     155       1;
      22    1076       1;
      22    1604       1;
      23      65       1;
      23     155       2;
      23     223       3;
      24      65       2;
      24     155       3;
      24     156       1;
      24     356       1;
      24     461       2;
      24    1459       3;
      24    1493       1;
      24    1548       1;
      24    1596       1;
      24    1642       5;
      25     223       2;
      25     816       1;
      25     850       1;
      25     893       2;
      25    1373       1;
      25    1493       1;
      25    1596       8;
      25    1783       1;
      25    2296       1;
      25    2635       1;
      26     816       1;
      26     893       1;
      26    1373       1;
      26    2406       1;
      27      65       1;
      27     248       1;
      27    1071       1;
      27    1373       1;
      27    1596       4;
      27    1604       1;
      27    2296       1;
      28      65       1;
      28    2315       1;
      28    2580       1;
      28    2776       1;
      29     152       4;
      29     155       2;
      29     816       1;
      29    1054       1;
      29    1783       1;
      29    2534       2;
      30     152       1;
      30    1309       1;
      30    1412       1;
      32     356       1;
      32     485       3;
      32    1366       1;
      33     102       1;
      33     356       2;
      33    1447       1;
      33    1479       1;
      33    1548       1;
      33    1604       3;
      33    1636       1;
      33    1783       2;
      33    2822       1;
      34     303       1;
      34    1493       1;
      34    1604       1;
      34    2296       1;
      34    2822       1;
      35    1373       1;
      35    1548       1;
      35    1596       3;
      35    2062       1;
      35    2296       1;
      35    2580       3;
      36      65       1;
      36     155       2;
      36     356       1;
      36     959       1;
      36    1054       1;
      36    1596       3;
      36    2571       1;
      37       7       1;
      37     111       1;
      37     155       3;
      37    1493       1;
      37    1596       1;
      37    1783       1;
      37    2721       1;
      38      65       1;
      38     356       1;
      38    1054       1;
      38    1127       1;
      38    1447       2;
      38    1478       1;
      39       7       4;
      39      65       1;
      39    1040       1;
      39    1071       1;
      39    1783       1;
      39    2296       1;
      40      89       1;
      40     111       2;
      40    1003       1;
      40    1599       1;
      40    1698       2;
      40    2011       1;
      41     156       1;
      41    1548       1;
      41    1783       1;
      41    2729       1;
      41    2813       1;
      42     979       1;
      42     996       1;
      42    1054       6;
      42    1320       1;
      42    1783       1;
      43     283       1;
      43    1003       1;
      43    1116       2;
      43    1373       1;
      43    1459       1;
      43    1548       1;
      43    1596       1;
      44      98       1;
      44     155       2;
      44     942       1;
      44    1071       1;
      44    1373       1;
      44    1596       5;
      44    1611       1;
      44    2406       1;
      44    2534       1;
      45     155       3;
      45     816       2;
      45    1054       2;
      45    1373       1;
      45    1783       2;
      45    2224       1;
      46      65       1;
      46    1270       2;
      46    1459       1;
      46    2296       1;
      46    2469       1;
      46    2809       1;
      47     155       2;
      47    1323       1;
      47    1493       1;
      47    1523       2;
      47    1616       1;
      47    2823       1;
      48     582       1;
      48    1373       1;
      48    2492       2;
      49      65       2;
      49      89       1;
      49     108       1;
      49     155       6;
      49     354       1;
      49     933       3;
      49    1373       1;
      49    1604       1;
      49    1844       1;
      49    2721       1;
      50     155       1;
      50     283       2;
      51      65       1;
      51     152       1;
      51    1783       1;
      51    1960       1;
      52     356       3;
      52     816       1;
      52     933       1;
      52    1695       2;
      53     223       1;
      53    1373       1;
      53    1636       1;
      53    2280       1;
      54      65       1;
      54     155       1;
      54     283       1;
      54     354       2;
      54     850       1;
      54    1373       1;
      54    1599       1;
      55     155       3;
      55     283       1;
      55    1599       1;
      55    1783       1;
      56     223       3;
      56    1596       3;
      56    1783       2;
      57     223       3;
      57    1596       1;
      57    2193       1;
      58       7       1;
      58     223       1;
      58     356       1;
      58    2193       3;
      58    2273       1;
      59     816       1;
      59    1003       1;
      59    1054       1;
      59    1459       1;
      59    2534       1;
      60    1373       1;
      60    2296       1;
      61     155       2;
      61    1548       1;
      61    1783       2;
      62      65       1;
      62     155       2;
      62     283       1;
      62     385       1;
      62    1010       2;
      62    1599       1;
      63    1373       1;
      63    2193       1;
      65     304       1;
      65    1040       1;
      65    2534       1;
      66     112       1;
      66     155       2;
      66     816       2;
      66     874       2;
      66    1912       6;
      67     356       1;
      67     485       2;
      67     967       1;
      67    1076       1;
      68    1604       1;
      68    2635       4;
      69     356       1;
      69    1010       1;
      69    1373       1;
      69    1493       1;
      69    1596       1;
      69    1604       1;
      69    1884       1;
      69    2296       1;
      70       7       2;
      70     356       1;
      70     816       3;
      70     850       1;
      70     997       2;
      70    1459       1;
      70    1493       1;
      70    1783       2;
      71     155       1;
      71     665       1;
      71    1783       1;
      71    2839       2;
      72     155       1;
      72     248       5;
      72     816       3;
      72    1493       1;
      72    2193       1;
      72    2839       1;
      73      65       1;
      73     283       3;
      73     972       1;
      73    1054       2;
      73    1604       1;
      73    1783       2;
      74     155       1;
      74     874       1;
      74    1447       1;
      74    1783       1;
      75     942       1;
      75    1524       2;
      75    1783       1;
      76     816       1;
      76     996       1;
      76    1010       1;
      76    1459       1;
      76    1555       1;
      76    1851       2;
      76    2813       1;
      77     155       2;
      77    1002       1;
      77    1270       1;
      77    1366       6;
      77    1596       2;
      77    1783       3;
      77    2534       3;
      77    2788       2;
      77    2822       1;
      77    2904       1;
      78     356       1;
      78     979       2;
      78     996       1;
      78    2320       1;
      78    2884       2;
      79      65       1;
      79     942       1;
      79    1596       1;
      79    1599       1;
      79    1783       1;
      80     283       2;
      80     541       1;
      80     816       1;
      80    1447       2;
      80    1493       1;
      80    2296       1;
      80    2813       1;
      81     155       3;
      81     283       1;
      82     152       1;
      82     155       1;
      82     283       2;
      82     356       1;
      82     816       2;
      82    1366       2;
      82    1459       1;
      82    1548       1;
      82    2840       1;
      83       5       7;
      83     286       1;
      83     532       1;
      83    1054       1;
      83    1220       1;
      83    1429       1;
      83    1493       1;
      83    1548       1;
      83    1732       1;
      83    1783       2;
      83    2193       1;
      83    2296       2;
      83    2908       1;
      84     155       3;
      84     893       2;
      84    1493       1;
      84    1596       1;
      84    2635       1;
      85      65       1;
      85     112       1;
      85     248       2;
      85     893       1;
      85    1010       1;
      85    1317       2;
      85    1373       1;
      85    1596       4;
      85    1604       1;
      85    2296       2;
      85    2492       1;
      86     816       2;
      86     906       1;
      86    1459       2;
      86    2815       1;
      87      98       1;
      87    1071       2;
      87    1596       1;
      87    2534       2;
      88      65       1;
      88     155       1;
      88    1309       2;
      88    1851       1;
      88    2305       1;
      88    2534       3;
      89     155       1;
      89     297       1;
      89     816       2;
      89    1054       1;
      89    1116       1;
      89    1127       1;
      89    1373       1;
      89    1447       1;
      89    1523       1;
      89    1572       1;
      89    1596       1;
      90    1372       1;
      90    1783       1;
      91     152       1;
      91    1373       1;
      91    1524       1;
      92     155       1;
      92     248       1;
      92     356       2;
      92     392       1;
      92    1459       1;
      92    1478       1;
      92    1493       1;
      92    1524       1;
      93      65       1;
      93     112       1;
      93     177       1;
      93    1309       1;
      93    1596       3;
      94      65       5;
      94     155       2;
      94     223       2;
      94     248       1;
      94     354       1;
      94     816       1;
      94    1002       2;
      94    1010       1;
      94    1071       1;
      94    1596       3;
      94    1698       1;
      94    2208       1;
      94    2273       1;
      95     152       1;
      95     286       1;
      95     301       1;
      95    2534       1;
      96     177       2;
      96     356       2;
      96     816       3;
      96     893       1;
      96    1003       8;
      96    1703       1;
      97      65       1;
      97     874       1;
      97    1002       1;
      97    1101       1;
      97    1373       3;
      97    1447       1;
      97    1596       3;
      98     155       2;
      98     438       1;
      99     303       1;
      99     354       1;
      99    1323       1;
      99    1459       2;
      99    2296       2;
      99    2406       1;
      99    2492       1;
      99    2653       1;
     100    1054       1;
     100    1596       2;
     100    2296       2;
     100    2469       1;
     100    2564       1;
     100    2667       1;
     101     155       5;
     101     354       2;
     101     356       1;
     101     461       1;
     101    1220       1;
     101    1596       3;
     101    1604       1;
     101    1642       1;
     101    1783       1;
     102     108       1;
     102     155       2;
     102    2822       1;
     103      65       1;
     103     244       2;
     103     356       1;
     104    1270       1;
     104    2534       3;
     105      65       1;
     105     223       3;
     105     816       1;
     105    1323       1;
     105    1548       1;
     105    1596       1;
     105    1698       1;
     105    1783       1;
     105    2016       1;
     105    2273       1;
     106      65       2;
     106    1071       2;
     106    1596       3;
     107      65       1;
     108    1604       1;
     108    2294       1;
     109     286       1;
     109     893       1;
     109    1459       1;
     109    1884       1;
     110      65       1;
     110    1002       1;
     110    1054       1;
     110    1071       1;
     110    1373       2;
     110    1459       1;
     110    1596       2;
     110    1604       5;
     110    1615       1;
     110    2212       1;
     110    2840       1;
     111    1373       1;
     111    1819       1;
     111    1884       1;
     111    2280       2;
     112     310       2;
     112    1002       1;
     112    1783       1;
     113     432       1;
     113     687       1;
     113     874       1;
     113    1323       1;
     113    1478       4;
     113    1493       1;
     113    1698       1;
     114      65       3;
     114     356       8;
     114    2534       6;
     115     283       1;
     115     532       1;
     115     816       1;
     115    1309       1;
     116     223       5;
     116    1071       1;
     117      65       1;
     117    1071       2;
     117    1149       1;
     117    1688       2;
     117    1884       1;
     118       7       1;
     118     305       1;
     118     957       1;
     118    1572       2;
     118    1783       1;
     118    2776       1;
     119    1596       1;
     119    2296       1;
     120     155       4;
     120    2534       3;
     121     248       1;
     121    1373       3;
     121    1884       1;
     122     850       1;
     122    1003       2;
     122    1373       1;
     122    1596       8;
     123       8       1;
     123     155       7;
     123     893       2;
     123    1783       2;
     123    1912       1;
     123    2635       2;
     124       8       2;
     124     108       2;
     124     248       1;
     124     356       1;
     124    1373       3;
     124    1439       1;
     124    1493       2;
     124    1596       2;
     125      65       1;
     125     874       2;
     125    1309       1;
     125    1373       1;
     125    1604       5;
     125    2478       1;
     125    2635       1;
     126      65       1;
     126     248       1;
     126     432       1;
     126    1373       3;
     126    2813       1;
     127       7       2;
     127     789       2;
     127    1366       1;
     127    1572       1;
     127    1636       1;
     128     248       6;
     128     354       1;
     128    1688       1;
     128    1783       2;
     129      65       1;
     129     356       2;
     129     893       1;
     129     995       1;
     129    1447       1;
     129    2534       1;
     129    2557       2;
     130     177       1;
     131      65       3;
     131     248       1;
     131    1054       3;
     131    1309       1;
     131    1323       1;
     131    1493       1;
     131    1884       1;
     131    2062       1;
     131    2492       1;
     132     283       3;
     132    1010       1;
     132    1220       2;
     132    1270       2;
     132    1373       2;
     132    1548       1;
     132    2296       1;
     132    2478       1;
     132    2534       2;
     132    2839       1;
     132    2904       1;
     133    2296       1;
     134     816       1;
     134    1373       1;
     134    1596       3;
     134    2062       1;
     134    2296       1;
     134    2406       2;
     135      65       1;
     135     155       2;
     135    1003       3;
     135    1010       1;
     136     248       2;
     136     432       1;
     136    1270       1;
     136    1373       1;
     136    1434       2;
     137     108       1;
     137    1447       1;
     137    2296       1;
     137    2557       1;
     138      93       2;
     138    1004       1;
     138    1071       1;
     138    1446       1;
     138    1459       3;
     138    2331       1;
     139    1373       2;
     139    1459       1;
     139    2167       1;
     139    2273       3;
     140     392       1;
     140     816       1;
     140    1373       3;
     140    1459       3;
     140    1555       1;
     140    1884       1;
     140    2294       1;
     141       7       1;
     141     356       2;
     141     996       1;
     141    1555       1;
     141    1636       1;
     141    2320       1;
     142      65       1;
     142     111       1;
     142     155       3;
     142     177       1;
     142    1596       1;
     142    2534       1;
     142    2710       1;
     143    1220       1;
     143    1373       1;
     144     108       1;
     144     155       3;
     144     816       3;
     144    1373       1;
     144    2273       1;
     145     155       4;
     145     223       1;
     145    1599       1;
     146    1071       1;
     146    1116       1;
     146    1373       2;
     146    1447       1;
     146    1548       1;
     146    1596      12;
     146    2273       1;
     146    2331       2;
     147     354       1;
     147     392       1;
     147    1071       1;
     147    1493       2;
     147    1851       2;
     147    2406       1;
     148     710       1;
     148     816       3;
     149      49       1;
     149      65       1;
     149     223       2;
     149     248      11;
     149     972       1;
     149    1071       2;
     149    1149       1;
     149    1323       1;
     149    1688       5;
     149    1884       1;
     149    2273       1;
     150     108       1;
     150     223       1;
     150     248       1;
     150     484       1;
     150     850       1;
     150     893       1;
     150    1071       1;
     150    2011       1;
     151      65       1;
     151     248       1;
     151     283       1;
     151     286       1;
     151     354       1;
     151     995       1;
     151    1149       1;
     151    1783       1;
     152     283       1;
     152    1071       1;
     152    1548       1;
     153    2904       1;
     154     155       1;
     154    1270       1;
     154    1373       1;
     154    1555       1;
     154    1596       2;
     155    2509       1;
     156      49       1;
     156     149       2;
     156     356       9;
     156    1002       1;
     156    1459       2;
     156    1548       1;
     156    1851       1;
     157       7       4;
     157      65       1;
     157     108       1;
     157     797       1;
     157    1054       1;
     157    1270       4;
     157    1746       1;
     157    1783       2;
     157    2406       1;
     157    2776       2;
     158      65       2;
     158     223       2;
     158    1596       2;
     159     152       1;
     159     735       1;
     159    2296       1;
     159    2534       1;
     159    2776       1;
     160      49       2;
     160     109       1;
     160    1071       1;
     160    1596      11;
     160    1783       1;
     160    2492       1;
     161     108       1;
     161    1071       1;
     161    1596       2;
     161    1604       1;
     161    1615       1;
     162      65       1;
     162     155       3;
     162     485       1;
     162    1076       2;
     162    1520       1;
     162    1849       1;
     162    2273       1;
     163      65       1;
     163     155       1;
     163     441       1;
     163     736       1;
     163    1076       1;
     163    1323       1;
     163    1373       1;
     163    1493       1;
     163    2184       2;
     163    2534       1;
     163    2710       1;
     163    2711       1;
     163    2788       1;
     163    2925       2;
     164     441       1;
     164     899       1;
     164     998       1;
     164    1366       1;
     164    1373       1;
     164    1783       3;
     164    2212       1;
     164    2908       1;
     165     468       1;
     165     874       3;
     165    1003       3;
     165    1373       2;
     165    1546       1;
     165    2070       1;
     165    2193       1;
     166      65       1;
     166     354       1;
     166     441       1;
     166    1572       1;
     166    1604       5;
     166    1884       1;
     166    2534       1;
     166    2776       1;
     167    1071       2;
     167    1493       1;
     167    1604       4;
     167    1783       1;
     167    2721       1;
     168      65       2;
     168     155       2;
     168     690       1;
     168     816       1;
     168    1309       1;
     168    1604       2;
     168    2813       1;
     169      99       2;
     169     248       1;
     169     356       1;
     169    1373       1;
     169    1604       5;
     169    2813       1;
     170      65       1;
     170     283       1;
     170     850       1;
     170    1373       1;
     170    1459       2;
     170    1604       1;
     170    1783       1;
     170    2011       1;
     171     223       2;
     171     283       2;
     171     816       2;
     171    1064       1;
     171    1076       1;
     171    1459       1;
     171    1548       1;
     171    1688       1;
     171    1783       1;
     171    2635       1;
     172     156       1;
     172     356       1;
     172    1520       1;
     172    1596       1;
     172    2194       1;
     172    2296       1;
     172    2925       1;
     173     354       1;
     173    1010       1;
     173    1323       1;
     173    1373      11;
     173    1459       2;
     173    1596       2;
     173    2171       1;
     173    2776       2;
     174       7       2;
     174      65       1;
     174    1010       1;
     174    1373       8;
     174    1429       1;
     174    1459       6;
     174    1596       1;
     175     893       1;
     175    1459       2;
     175    2492       1;
     175    2805       1;
     176     223       1;
     176     248       1;
     176    1373       8;
     176    1447       2;
     176    2062       1;
     177     248       1;
     177     356       1;
     177     995       1;
     177    1054       1;
     177    1309       1;
     177    2062       1;
     178    1076       1;
     178    1309       1;
     179      65       1;
     179     850       1;
     179    1054       3;
     179    1373       8;
     179    1548       1;
     179    1596       3;
     179    1615       1;
     181       5       1;
     181     354       1;
     181    1596       2;
     182     155       1;
     182    2011       1;
     183     850       1;
     183    1604       3;
     184    1054       1;
     184    1548       1;
     184    1636       1;
     184    2320       3;
     184    2813       1;
     184    2925       1;
     185     155       1;
     185     283       2;
     185     801       2;
     185     899       1;
     185    1149       1;
     185    1373       1;
     185    1604       9;
     185    1636       5;
     185    1783       1;
     185    1884       1;
     185    2110       1;
     185    2424       1;
     185    2822       2;
     186       8       1;
     186     177       1;
     186     223       1;
     186     816       1;
     186     850       1;
     186    1373       6;
     186    1548       1;
     186    1596       5;
     186    2296       1;
     187     356       1;
     187    1373       1;
     187    1447       2;
     187    1459       1;
     187    1523       1;
     187    1636       1;
     187    1851       1;
     187    2280       1;
     187    2296       1;
     187    2839       1;
     188      65       1;
     188     850       1;
     188    1054       3;
     188    1373       8;
     188    1548       1;
     188    1596       2;
     189     354       1;
     189     816       7;
     189    1373      12;
     189    2280       1;
     189    2904       2;
     190     893       1;
     190    1002       1;
     190    1309       1;
     190    1604       2;
     190    2280       1;
     190    2721       2;
     191    1071       1;
     191    1373       2;
     192     354       1;
     192     797       1;
     192     816       5;
     192     990       1;
     192    1054       1;
     192    1071       2;
     192    1596       5;
     193      93       1;
     193     248       4;
     193     816       1;
     193     874       1;
     193    1010       1;
     193    1493       1;
     193    1604       4;
     193    1783       1;
     193    2193       2;
     193    2208       1;
     193    2522       1;
     194    1884       1;
     195     152       1;
     195     356       1;
     195     532       1;
     195    1548       1;
     196      98       1;
     196    1054       2;
     196    1548       1;
     196    1596       5;
     196    1912       1;
     197     356       2;
     197    1373       1;
     197    1596       6;
     197    2062       1;
     198      95       2;
     198     356       1;
     198     433      13;
     198    1054       1;
     198    1373       1;
     198    1493       1;
     198    1636       1;
     198    1783       2;
     198    2424       2;
     199      65       3;
     199      93       1;
     199    1459       1;
     199    2509       1;
     200    1309       1;
     200    1447       2;
     201     438       1;
     201     816       4;
     201    1071       1;
     201    1116       1;
     201    2062       1;
     202    1054       8;
     202    1116       1;
     202    1270       1;
     202    1493       1;
     202    1636       1;
     202    2320       1;
     202    2509       1;
     202    2710       1;
     203     356       1;
     204     323       1;
     204     356       2;
     204    1373       3;
     204    1447       1;
     204    1478       1;
     204    1596       1;
     204    1783       2;
     205     297       1;
     205     979       1;
     205    1447       1;
     205    1459       1;
     205    1596       2;
     205    2193       1;
     206     223       1;
     206     356       1;
     206     816       1;
     206     850       1;
     206    1270       1;
     206    1447       2;
     206    2354       1;
     206    2721       1;
     206    2822       1;
     207      65       1;
     207     177       1;
     207    1054       1;
     207    1373       1;
     207    1783       3;
     208    1054       1;
     208    1309       1;
     208    1604       3;
     208    2567       2;
     208    2721       1;
     209      49       1;
     209     356       1;
     209     816       3;
     209     996       1;
     209    1040       1;
     209    1373       1;
     209    1447       2;
     209    1479       1;
     209    1493       1;
     209    2318       6;
     210      65       1;
     210     433       1;
     210     614       1;
     210     850       1;
     210     979       6;
     210    1548       1;
     210    2273       1;
     210    2573       1;
     210    2839       1;
     210    2904       2;
     211     356       3;
     211    1040       1;
     211    1447       1;
     211    1596       2;
     211    2062       3;
     212       8       1;
     212      95       3;
     212     354       1;
     212     420       5;
     212     432       3;
     212    1054       1;
     212    1116       1;
     212    1373       1;
     212    1446       1;
     212    1820       1;
     212    2930       3;
     213     286       1;
     213     420       5;
     213     893       2;
     213    1040       1;
     213    1446       1;
     213    1447       2;
     213    1459       2;
     213    1493       1;
     213    1604       2;
     213    1884       1;
     213    2296       2;
     213    2721       1;
     213    2776       1;
     213    2788       1;
     213    2805       1;
     213    2930       1;
     214     356       1;
     214    1010       1;
     214    1548       1;
     214    1884       2;
     215     420       5;
     215    1446       3;
     215    1604       1;
     216     356       3;
     216    1010       1;
     216    1446       3;
     216    1447       1;
     216    1459       1;
     216    1596       2;
     216    1783       2;
     216    2193       1;
     216    2787       1;
     216    2930       1;
     217     248       1;
     217     356       1;
     217    1010       1;
     217    1040       2;
     217    1054       1;
     217    1572       1;
     217    1604       2;
     217    2721       1;
     217    2776       2;
     218     174       1;
     218     893       3;
     218    1447       1;
     218    1459       1;
     218    2193       1;
     218    2721       1;
     218    2813       1;
     219     156       2;
     219     304       1;
     219     893       1;
     219    1010       1;
     219    1054       1;
     219    1309       1;
     219    1478       1;
     219    1548       1;
     219    2557       1;
     219    2788       1;
     220    1636       1;
     220    1783       1;
     221     223       2;
     221     354       1;
     221    1323       1;
     221    1783       1;
     221    2171       1;
     221    2721       2;
     222      98       1;
     222     356       1;
     223     177       1;
     224      87       1;
     224    1874       1;
     225     816       1;
     225    1373       2;
     225    1596       3;
     225    1783       2;
     225    2822       1;
     227       7       2;
     227      65       1;
     227     850       1;
     227    1309       1;
     227    1373       1;
     227    1447       1;
     227    1478       2;
     228    1596       1;
     228    1688       1;
     229     893       1;
     229     979       3;
     229    1446       1;
     229    1596       4;
     229    2963       1;
     230     108       1;
     230    1373       1;
     230    1596       3;
     231      65       1;
     231     108       1;
     231    1071       2;
     231    1373       1;
     231    1596       3;
     231    1953       1;
     232     248       3;
     232    1596       4;
     233     177       1;
     233     223       1;
     233    1116       1;
     233    1596       4;
     234     248       6;
     234    1373       2;
     234    1596      10;
     235    1373       1;
     235    1596       3;
     236      89       1;
     236     156       1;
     236     354       1;
     236    1493       1;
     236    1604       2;
     237     420       1;
     237     874       1;
     237    1446       1;
     237    1604       1;
     237    1636       1;
     237    1953       2;
     238     354       1;
     238     356       1;
     238    1459       1;
     238    1493       1;
     239       8       1;
     239     356       1;
     239     979       2;
     239    1317       3;
     239    1459       9;
     239    2805       1;
     240     155       2;
     240     356       1;
     241      49       1;
     242    1373       2;
     243    1447       2;
     244       8       1;
     244     111       1;
     244     156       1;
     244     959       1;
     244    1310       1;
     244    1317       1;
     244    1323       2;
     244    1459       2;
     244    1478       4;
     244    1493       1;
     244    1610       1;
     244    1636       2;
     244    1884       2;
     244    2011       1;
     244    2813       1;
     244    2822       1;
     245    1054       2;
     245    2711       1;
     246    1373       1;
     246    2203       1;
     247     354       1;
     247     816       2;
     247    1447       1;
     247    1596       3;
     248      65       1;
     248     356       1;
     248     816       1;
     248    1373       2;
     248    1596       3;
     248    2557       2;
     249     286       1;
     251    1054       1;
     251    2710       1;
     251    2809       1;
     252     248       1;
     252     356       3;
     252    1310       2;
     252    1317       4;
     252    1447       2;
     252    1596       1;
     252    1698       1;
     252    2925       1;
     253      65       1;
     253     532       1;
     253     816       1;
     253    1317       1;
     253    1615       1;
     253    1884       1;
     253    2565       1;
     253    2822       1;
     254      65       1;
     254      98       2;
     254     177       1;
     255     283       3;
     255     816       2;
     255     995       4;
     255    1373       1;
     256     816       1;
     256    1783       2;
     256    2296       1;
     257     354       1;
     257     933       1;
     257    1548       1;
     257    1783       1;
     257    2494       1;
     257    2729       1;
     258    1373       1;
     259     112       1;
     259     354       1;
     259     461       2;
     259    1013       2;
     259    1071       1;
     259    1373       2;
     259    1596       1;
     260     155       3;
     260     177       2;
     261     223       2;
     261     816       1;
     261    1596       1;
     261    2273       1;
     261    2494       1;
     262       8       4;
     262      99       2;
     262     108       1;
     262     248       2;
     262     286       1;
     262     461       2;
     262    1548       1;
     262    1604       2;
     262    1636       1;
     262    2171       1;
     262    2273       1;
     262    2806       1;
     263      65       1;
     263      99       1;
     263     356       1;
     263    2273       2;
     263    2509       1;
     264    1447       1;
     265     177       1;
     265    1054       1;
     266      95       1;
     266      98       1;
     266     356       1;
     266     850       1;
     266    1373       1;
     266    1493       1;
     266    1596       6;
     267     152       1;
     267     155       2;
     267     438       1;
     267     816       1;
     267    1054       1;
     267    1783       2;
     267    1851       1;
     267    2534       3;
     267    2813       1;
     268     155       1;
     268    2534       3;
     269     155       4;
     269    1548       1;
     269    2534       2;
     270     155       2;
     270     354       1;
     270     867       1;
     270    1040       1;
     270    1309       2;
     270    1636       1;
     270    1701       1;
     270    1783       4;
     270    2534       5;
     272       7       2;
     272       8       1;
     272      65       1;
     272     155       1;
     272     223       9;
     272     816       2;
     272    1148       3;
     272    1373       2;
     272    1493       1;
     272    1596       3;
     272    1636       1;
     272    1783       1;
     272    2296       1;
     273     177       1;
     273     582       2;
     273     816       1;
     273    1071       1;
     273    1447       1;
     273    1596       2;
     273    1622       1;
     274     152       2;
     274     155       4;
     274     286       1;
     274     356       1;
     274    1054       1;
     274    1317       1;
     274    1366       1;
     274    2834       1;
     274    2840       1;
     275     155       1;
     275    1010       1;
     275    1076       2;
     275    1912       1;
     276      95       1;
     276     248       1;
     276     420       4;
     276    1459       1;
     276    2167       1;
     276    2280       1;
     276    2776       2;
     277       8       1;
     277     248       1;
     277     420       2;
     277     432       1;
     277     893       4;
     277    1459       3;
     277    1572       1;
     277    1783       2;
     277    2930       2;
     278      89       1;
     278    1002       1;
     278    1054       1;
     279      87       1;
     279    1596       2;
     279    1783       1;
     280     356       2;
     280     816       1;
     280    1040       1;
     280    1493       1;
     281     438       1;
     282     432       1;
     282    1373       7;
     282    1459       1;
     282    2492       1;
     282    2776       1;
     282    2813       1;
     283     155       5;
     283    1373       1;
     283    1596       4;
     283    2813       1;
     284     297       1;
     284    1323       1;
     284    1459       1;
     284    2320       1;
     284    2787       1;
     285    2776       1;
     286    1459       1;
     286    2062       1;
     287      98       1;
     287     356       1;
     287    1884       1;
     288      65       1;
     288    1010       1;
     288    1054       1;
     288    1309       1;
     288    1447       2;
     288    2296       1;
     289     177       1;
     289    1116       1;
     289    1373       1;
     289    1596       2;
     289    1783       2;
     290     108       1;
     291    1912       1;
     291    2280       1;
     292     356       1;
     292     816       1;
     292    1270       1;
     292    1309       1;
     292    1493       1;
     292    1523       4;
     292    1596       1;
     292    1912       1;
     293     356       1;
     293    1596       1;
     293    1666       1;
     293    1783       2;
     294      65       2;
     294     155       4;
     294     816       1;
     294    1309       2;
     294    1373       3;
     294    1596       2;
     294    2280       1;
     295     155       3;
     295    1373       1;
     295    1478       1;
     295    1596       1;
     295    2721       1;
     296     103       1;
     296     112       1;
     296     156       2;
     296     249       1;
     296     356       1;
     296    1040       2;
     296    1054       1;
     296    1076       1;
     296    1442       2;
     296    1548       1;
     296    1596       2;
     296    2567       1;
     296    2884       2;
     297     122       1;
     297     156       1;
     297     356       2;
     297    1071       2;
     297    1270       1;
     297    1596       2;
     297    1783       2;
     297    2721       1;
     298    1071       1;
     299      49       1;
     299    1071       2;
     300      65       2;
     300    1412       1;
     300    1596       1;
     300    1688       1;
     300    2534       5;
     300    2776       1;
     301     906       1;
     302     283       1;
     302     356       1;
     302     582       1;
     302    1054       1;
     302    1309       1;
     303      65       1;
     303     155       2;
     303     461       2;
     303     874       1;
     303    1373       1;
     303    1642       2;
     303    1783       1;
     304      65       1;
     304    1373       1;
     304    2406       1;
     304    2492       1;
     304    2635       2;
     305     155       4;
     305     816       1;
     305    1478       1;
     306     155       2;
     306     283       1;
     306     438       1;
     306    1447       1;
     307     283       1;
     307     816       1;
     307    1270       1;
     307    1596       1;
     308      98       5;
     308     354       1;
     308     816       1;
     308    1071       2;
     309      65       3;
     309     356       1;
     309    1071       1;
     309    1309       1;
     309    2224       1;
     310     155       1;
     310     816       1;
     310     893       1;
     310    1604       1;
     310    2520       1;
     311     354       1;
     311     356       1;
     311    1373       1;
     311    1446       2;
     311    1459       1;
     311    1493       1;
     312     816       1;
     313    1270       1;
     313    1373       1;
     313    2424       1;
     314     155       1;
     314     996       2;
     314    1373       1;
     315      65       1;
     315     156       1;
     315     354       1;
     315     641       1;
     315     816       1;
     315     850       2;
     315    1309       2;
     315    1323       1;
     315    1373       1;
     315    1447       2;
     315    1636       1;
     315    1953       1;
     315    2296       1;
     315    2764       2;
     315    2839       1;
     316     736       1;
     317    1071       1;
     317    1596       1;
     317    1604       3;
     317    1642       1;
     317    2492       1;
     317    2557       2;
     318      65       1;
     318    1071       1;
     318    1323       1;
     318    1596       5;
     318    1604       1;
     319      65       1;
     319    1447       1;
     319    1523       1;
     319    1604       3;
     319    1783       1;
     319    2296       1;
     320    1478       1;
     320    2729       1;
     321     248       1;
     321     356       1;
     321    1373       1;
     321    1478       1;
     321    1953       1;
     323      65       1;
     323    1596       1;
     323    1688       1;
     323    2557       1;
     325     155       3;
     325     403       1;
     325     924       1;
     325    2904       1;
     326    1596       1;
     327      65       1;
     327    1373       1;
     327    1783       1;
     328      65       1;
     328     283       1;
     328     356       1;
     328     816       1;
     328    1071       1;
     328    1270       1;
     328    1373       1;
     328    1459       1;
     328    1596       1;
     328    1604       1;
     328    1851       1;
     328    2296       1;
     328    2396       1;
     328    2557       1;
     329      65       2;
     329     155       4;
     329     223       3;
     329     356       1;
     329     816       1;
     329    1076       1;
     329    1309       1;
     329    1373       1;
     329    1459       1;
     329    1596       2;
     329    1604       2;
     329    1688       4;
     330    1446       1;
     331     283       2;
     332     354       1;
     332    1373       1;
     332    1596       4;
     332    1604       3;
     333     155       1;
     333     979       4;
     334    1783       1;
     334    2296       1;
     334    2635       1;
     335    1040       2;
     335    1071       1;
     335    1459       1;
     336     979       1;
     336    1478       1;
     336    1596       1;
     337       8       1;
     337    1604       2;
     337    1783       1;
     337    2296       1;
     338       8       1;
     338     155       3;
     338    2635       2;
     339     155       1;
     340    1604       1;
     340    2635       1;
     341       7       1;
     341    1054       2;
     341    1572       2;
     341    1604       1;
     341    2788       3;
     342     155       1;
     342     354       1;
     342     432       1;
     342    1116       1;
     342    1309       1;
     342    1323       1;
     342    1604       1;
     342    2534       1;
     342    2635       1;
     342    2925       1;
     343     155       3;
     343    1604       1;
     343    2635       1;
     344     155       5;
     344     177       2;
     344     690       2;
     344    1270       5;
     344    1301       1;
     344    1323       1;
     344    1459       1;
     344    1604       2;
     344    1636       2;
     344    1783       1;
     345     356       1;
     345    1459       1;
     345    1493       1;
     345    2296       1;
     346     816       3;
     346    1003       1;
     346    1459       1;
     347     155       3;
     347     816       1;
     347    1127       1;
     347    1220       1;
     347    1373       1;
     347    1783       1;
     348     155       4;
     348     354       1;
     349     354       1;
     349    1149       1;
     349    1493       1;
     349    1596       3;
     349    1604       4;
     349    1884       1;
     350    2296       1;
     351      65       1;
     351     354       1;
     351    1270       1;
     351    2776       1;
     352     155       1;
     352     283       1;
     352     356       1;
     352     420       2;
     352    1373       1;
     352    1783       1;
     352    2406       1;
     353     155       3;
     353     441       1;
     353    1604       2;
     353    2534       1;
     353    2635       1;
     354     155       2;
     354     369       1;
     354    1373       1;
     354    1459       1;
     355     155       1;
     355     354       1;
     355     461       1;
     355    1504       2;
     355    1604       1;
     356     111       1;
     356    1003       1;
     356    1079       1;
     356    1149       1;
     356    1270       1;
     356    1596       1;
     357      65       1;
     357     111       2;
     357     441       2;
     357    2062       1;
     358     893       1;
     358    1101       1;
     359    1596       1;
     360    1054       1;
     360    1478       1;
     360    1596       5;
     360    2212       1;
     360    2296       1;
     360    2509       1;
     361     871       1;
     361    1071       1;
     361    1270       2;
     363       8       1;
     363     432       1;
     363     816       2;
     363    1040       1;
     363    1451       1;
     363    1478       1;
     363    2721       1;
     364     155       2;
     364     356       1;
     364     816       2;
     364     893       4;
     364     933       1;
     364    1054       1;
     364    1459       1;
     364    1596       1;
     364    2280       3;
     364    2406       2;
     364    2710       1;
     365      65       1;
     365     155       2;
     365     816       1;
     365     893       1;
     365    1373       1;
     365    1604       1;
     365    1783       1;
     365    2406       1;
     365    2492       1;
     366      65       2;
     366     155       2;
     366     816       1;
     366     893       1;
     366    1493       1;
     366    1604       1;
     366    1783       1;
     366    2492       1;
     366    2635       2;
     367     152       1;
     367    1010       1;
     367    1414       1;
     368     354       1;
     368     979       1;
     368    2721       1;
     368    2806       1;
     369       8       1;
     369      65       1;
     369     155       1;
     369    1054       1;
     369    1323       2;
     369    1478       1;
     369    1596       7;
     369    1783       1;
     369    2296       1;
     370     223       2;
     370     248       1;
     370    1369       1;
     370    1373       1;
     370    1596       3;
     370    1604       1;
     370    2406       1;
     371    1783       1;
     371    2406       1;
     371    2776       1;
     371    2936       1;
     372     223       1;
     372    1596       3;
     373      65       1;
     373     248       3;
     373     432       1;
     373     441       1;
     373    1054       1;
     373    1493       2;
     373    1548       1;
     373    1596       4;
     373    1615       1;
     373    2011       1;
     373    2048       1;
     373    2296       1;
     373    2315       1;
     374     873       1;
     374    1003       1;
     374    2565       2;
     375      65       1;
     375     223       2;
     375     283       1;
     375    1071       2;
     375    1100       1;
     375    1459       1;
     375    1604       4;
     375    2534       1;
     376      65       1;
     377      65       1;
     377    1884       1;
     378     155       2;
     378     356       1;
     378    1373       2;
     379    1116       6;
     379    1152       1;
     379    1373       1;
     380     356       1;
     380     386       1;
     380     438       1;
     380    2296       1;
     381     223       5;
     381     816       1;
     381     893       1;
     381    1373       1;
     381    2273       2;
     381    2494       1;
     381    2767       1;
     382     223       2;
     382     816       2;
     383     155       1;
     383     972       1;
     383    1071       1;
     383    1832       1;
     383    2776       1;
     384     223       3;
     384     248       2;
     384    1596       3;
     385     156       1;
     385    1459       1;
     386      98       2;
     386    2062       1;
     387     155       2;
     388    1071       1;
     388    1270       2;
     388    1548       1;
     388    1734       2;
     388    2296       1;
     388    2942       1;
     389     283       1;
     389    1071       1;
     389    2492       1;
     390     266       1;
     390    1493       1;
     390    1548       1;
     390    1783       1;
     390    2320       1;
     391     816       1;
     391     850       1;
     391    1459       1;
     392     266       1;
     392    2010       1;
     393      98       2;
     393    1270       1;
     393    1688       1;
     394    1688       1;
     395     152       1;
     395     155       1;
     395    1054       1;
     395    1884       1;
     395    2478       1;
     395    2667       1;
     396     155       2;
     396    1459       1;
     396    2534       1;
     398     155       3;
     400     266       2;
     400     874       1;
     400    2193       1;
     401     248       2;
     401     461       1;
     401    1317       3;
     401    1504       2;
     401    1596       1;
     401    1642       1;
     401    1783       1;
     401    2273       1;
     401    2296       3;
     401    2478       1;
     402     310       1;
     402     354       1;
     403      65       2;
     403     156       2;
     403     457       1;
     403     690       1;
     403    2406       1;
     404     816       1;
     404    1010       1;
     404    1071       2;
     404    2062       1;
     404    2787       1;
     406      65       1;
     406     155       1;
     406    1323       1;
     406    2839       1;
     407     286       1;
     407    1783       1;
     407    2534       3;
     408    2534       2;
     409       7       3;
     409      65       1;
     409    1373       3;
     409    1447       2;
     410      89       1;
     410     156       1;
     410    1010       1;
     410    1596       4;
     410    2280       1;
     411    1054       1;
     412      65       1;
     413    1003       1;
     413    1010       1;
     413    2635       2;
     414       8       1;
     414    1002       1;
     414    1459       2;
     414    1596       3;
     414    2509       3;
     415     177       1;
     415     651       1;
     415     850       1;
     415    1373       1;
     415    1447       1;
     415    2925       1;
     416      98       1;
     416     356       1;
     416     899       1;
     416    1636       1;
     416    2011       1;
     416    2296       1;
     416    2925       1;
     417      49       1;
     417     283       1;
     417     387       1;
     417     816       1;
     417    1002       1;
     417    1054       2;
     417    1270       5;
     417    1373       1;
     417    1548       1;
     417    2296       1;
     417    2776       1;
     417    2787       1;
     417    2884       4;
     418     177       1;
     418    1002       1;
     418    1446       1;
     418    1783       1;
     419     286       1;
     419    1220       1;
     419    2296       2;
     420     246       1;
     420     432       2;
     420    1783       1;
     420    1851       1;
     420    2209       1;
     421    1596       2;
     421    1604       1;
     421    1783       3;
     421    2635       2;
     422     266       1;
     423     979       3;
     423    1003       1;
     423    1101       1;
     423    1459       1;
     423    1596       1;
     423    1615       1;
     423    2273       1;
     424     266       1;
     424    1270       2;
     425     152       1;
     425     816       1;
     425    1459       1;
     425    1783       1;
     426      95       1;
     426     103       1;
     426    1373       1;
     426    1446       1;
     426    1447       1;
     426    1459       5;
     426    2193       1;
     426    2930       1;
     427       7       1;
     427      65       1;
     427     149       1;
     427     392       1;
     427     420       1;
     427     665       1;
     427    1447       5;
     427    1604       4;
     428     223       6;
     428     816       2;
     428     990       1;
     428    1596       2;
     428    1874       1;
     429     177       1;
     429     356       2;
     430     356       2;
     430    1317       4;
     430    1989       1;
     431      65       2;
     431    1373       4;
     431    1447       1;
     431    1596       2;
     432      65       1;
     432     899       2;
     432    1373       1;
     432    1596      10;
     432    2193       3;
     433     297       1;
     433     392       1;
     433     850       1;
     433    1447       2;
     433    1523       1;
     433    1596      13;
     433    1783       1;
     433    2273       2;
     433    2296       1;
     434     223       1;
     434    1373       2;
     434    1596       4;
     435      65       1;
     435     155       4;
     435     223       2;
     435     356       2;
     435     979       2;
     435    1459       1;
     435    1596       3;
     435    1604       1;
     436     111       1;
     436     155       2;
     436     461       1;
     436    1317       1;
     437     155       1;
     437     461       1;
     437    1054       1;
     437    1604       2;
     438     111       1;
     438     155       1;
     438    1317       2;
     438    1493       1;
     438    1596       1;
     439    1040       3;
     439    2296       2;
     440     816       1;
     440    1071       1;
     440    1373       1;
     440    1447       1;
     440    1493       1;
     441     149       2;
     441     177       1;
     441     356       1;
     441     874       1;
     441    1127       1;
     441    1451       7;
     441    1493       1;
     441    2571       1;
     442      65       1;
     442     354       1;
     442     356       2;
     442    1373       1;
     442    1851       1;
     443      65       1;
     443    1783       1;
     443    2062       1;
     444    1054       1;
     444    1451       3;
     445       8       1;
     445      65       1;
     445     438       1;
     445    1071       2;
     445    1447       2;
     446     112       1;
     446     249       1;
     446     816       1;
     446    1596       2;
     446    1783       1;
     447     112       2;
     447    1596       6;
     448       5       1;
     448      65       1;
     448     249       2;
     448     692       2;
     448    1127       1;
     448    1270       1;
     448    2727       2;
     449     249       1;
     449     692       1;
     449    1002       1;
     449    2727       1;
     450     156       2;
     450    1040       2;
     451      65       1;
     452      65       1;
     452     223       2;
     452     816       1;
     452     972       1;
     452    1040       1;
     452    1270       1;
     452    1596       1;
     453     356       3;
     453     874       1;
     453    1636       1;
     453    1689       1;
     453    2011       1;
     453    2296       1;
     454     266       1;
     454     850       1;
     454     933       1;
     454    1373       1;
     454    1548       1;
     454    2478       1;
     455      65       1;
     455     149       1;
     455     356       1;
     455     850       2;
     455    1010       2;
     455    1127       1;
     455    1373       1;
     455    1484       1;
     455    1783       1;
     455    2167       1;
     455    2925       1;
     456     156       2;
     456    1596       4;
     456    1604       5;
     456    1783       1;
     456    2424       1;
     456    2478       1;
     457     893       1;
     457    2280       1;
     458     283       1;
     458     304       1;
     458     354       2;
     458    1054       1;
     458    1373       1;
     458    2492       2;
     459     248       1;
     459     532       1;
     459     706       1;
     459     709       1;
     459     816       1;
     459    1010       1;
     459    1523       2;
     459    2011       1;
     459    2280       1;
     460     283       1;
     461    1334       1;
     461    1478       1;
     462      99       2;
     462     108       1;
     462     152       1;
     462     248       1;
     462    1845       1;
     462    2787       1;
     463     248       1;
     463    2296       1;
     463    2406       1;
     464     899       1;
     464    1054       1;
     464    1646       3;
     464    1783       3;
     464    1874       1;
     465    1447       1;
     465    1596       1;
     465    2925       1;
     466      65       1;
     466    1040       1;
     466    1317       2;
     466    1447       1;
     466    1459       1;
     466    1599       1;
     466    1884       1;
     466    1989       2;
     467      65       1;
     467    1373       1;
     467    1447       1;
     468       7       1;
     468     356       1;
     468    1002       1;
     468    1010       1;
     468    1596       2;
     468    2246       1;
     469    1054       1;
     469    1270       1;
     469    1478       2;
     469    1596       3;
     469    2246       1;
     470    1373       1;
     472    1447       1;
     472    1523       2;
     472    1783       1;
     472    2280       1;
     473     354       1;
     473     972       1;
     473    1008       2;
     473    1323       1;
     473    1596       1;
     473    2212       1;
     474      65       1;
     474     283       2;
     474    1054       1;
     474    2424       1;
     475      65       1;
     475     283       2;
     476     356       1;
     476     871       2;
     476    1010       1;
     476    1323       1;
     476    2198       2;
     476    2776       1;
     477     283       1;
     477     933       4;
     477    2822       1;
     478      98       1;
     478     354       1;
     478    1270       1;
     478    1303       1;
     479      65       1;
     479    1478       1;
     480     155       1;
     480    1604       2;
     480    2757       1;
     481      65       1;
     481     155       1;
     481     356       1;
     481    1599       1;
     481    1604       1;
     483     223       2;
     484     816       1;
     484    1373       1;
     484    1451       1;
     484    1520       2;
     484    1548       2;
     484    1698       1;
     486      65       1;
     486     248       1;
     486    1373       1;
     486    2320       1;
     486    2839       1;
     486    2925       1;
     487      65       1;
     487    1373       6;
     487    1523       1;
     487    2492       1;
     488     248       1;
     488     286       1;
     488    1270       1;
     488    1493       1;
     488    1604       2;
     488    2011       1;
     488    2062       1;
     488    2216       1;
     488    2567       1;
     488    2925       1;
     489     113       1;
     489     155       1;
     489     177       1;
     489    1008       2;
     489    1270       2;
     489    1309       1;
     489    1373       1;
     489    1440       1;
     489    1459       1;
     489    1599       1;
     489    1783       1;
     489    2243       2;
     489    2793       1;
     490     356       2;
     490     893       1;
     490    1270       1;
     490    2280       2;
     490    2710       1;
     491     850       1;
     491    1270       1;
     491    1373       1;
     491    1783       1;
     492    1596       1;
     493     155       3;
     493     177       1;
     493     356       1;
     493     874       2;
     493    1317       2;
     493    1596       2;
     493    1604       6;
     493    1699       1;
     493    2193       1;
     493    2904       1;
     494     223       1;
     494     885       1;
     494    1071       3;
     494    1373       1;
     494    1596       3;
     494    1604       1;
     495      65       1;
     495    1478       1;
     495    1596       1;
     495    2208       1;
     496     850       1;
     497     155       2;
     497     816       1;
     497     874       1;
     497    1373       1;
     497    1548       1;
     497    2193       3;
     497    2422       1;
     498     112       1;
     498     850       1;
     498    1373       1;
     498    1596       7;
     498    2424       1;
     499     177       1;
     499     271       1;
     499     433       1;
     499     438       1;
     499     533       1;
     499     933       1;
     499     967       1;
     499     979       1;
     499    1010       1;
     499    1270       2;
     499    1366       2;
     499    1459       1;
     499    1596       1;
     499    2521       1;
     499    2696       1;
     500    1309       2;
     500    2534       2;
     501    1005       1;
     501    1596       1;
     502      65       1;
     502     356       1;
     502     990       1;
     502    1270       1;
     502    2635       1;
     503      65       2;
     503    1270       1;
     503    1478       1;
     503    2296       1;
     504      49       1;
     504      65       1;
     504    2721       1;
     505    1366       1;
     506      65       1;
     506    1478       1;
     507    1783       1;
     508    1596       1;
     508    1783       1;
     508    2712       1;
     509     155       1;
     509     286       1;
     509    1459       1;
     509    1884       1;
     510     665       2;
     511     420       3;
     511     432       2;
     511    1309       1;
     511    1493       1;
     511    1599       1;
     511    1604       1;
     511    2930       8;
     512      87       1;
     512     816       3;
     512    1874       1;
     513     297       1;
     513     797       1;
     513     816       2;
     513    1054       1;
     513    1373       1;
     514      98       1;
     514    1040       2;
     514    1783       1;
     515     850       1;
     515     972       1;
     516    1310       1;
     517       5       1;
     517      65       1;
     517     283       2;
     517    1373       1;
     517    1604       1;
     517    2557       1;
     518    1010       2;
     518    1604       2;
     518    1695       1;
     518    1760       1;
     518    2406       1;
     519    1040       1;
     519    1373       8;
     519    1459       1;
     520      65       1;
     520     223       1;
     520     356       1;
     520     433       1;
     520    1127       1;
     520    1373       2;
     520    1412       1;
     520    1493       1;
     521       7       2;
     521     699       1;
     521    1372       1;
     521    2296       1;
     521    2721       1;
     521    2839       1;
     522     155       5;
     522     223       6;
     522     248       1;
     522    1309       1;
     522    1373       2;
     522    1548       1;
     522    1596       6;
     522    1599       2;
     522    1698       1;
     522    2273       2;
     522    2460       2;
     522    2788       1;
     523       7       4;
     523    1493       1;
     523    1596       6;
     524      65       1;
     524     155       3;
     524    1054       1;
     524    1317       1;
     524    1373       2;
     524    2129       2;
     525     155       3;
     525    1783       1;
     525    2925       1;
     526      65       1;
     526      99       1;
     526     177       1;
     526     356       1;
     526    1309       1;
     526    2280       1;
     526    2296       1;
     528     248       2;
     528    1373       1;
     528    1596       3;
     528    2273       1;
     529     111       2;
     529     354       1;
     529     356       1;
     529     499       1;
     529     893       2;
     529    1555       2;
     529    1572       1;
     529    1604       1;
     529    1636       1;
     529    2280       1;
     529    2635       1;
     529    2823       1;
     530    1010       1;
     530    1373       1;
     530    2494       1;
     530    2776       1;
     531      65       1;
     531     249       2;
     531     594       1;
     531    1040       1;
     531    1596       5;
     531    1783       1;
     531    2884       1;
     532     979       1;
     533     223       1;
     533    1270       1;
     533    1372       1;
     534     177       1;
     534    1548       2;
     535       7       1;
     535    1054       1;
     535    1323       1;
     535    1447       1;
     535    1523       1;
     536      99       1;
     536     156       1;
     536     393       3;
     536     703       2;
     536    1317       1;
     536    1373       1;
     536    1548       1;
     536    1596       2;
     536    1604       1;
     536    1916       3;
     536    2011       1;
     537    1596       1;
     538     155       1;
     538    1373       1;
     538    1493       1;
     538    1832       1;
     539     155       2;
     539     223       2;
     539     979       2;
     540      65       2;
     540     155       1;
     540     438       1;
     540    1270       1;
     540    1604       1;
     541     223       1;
     541     461       1;
     541    1373       1;
     541    1459       1;
     541    1596       3;
     541    1604       4;
     541    1642       1;
     542    1373       1;
     542    1493       1;
     542    1596       1;
     543    1446       4;
     544    1783       1;
     544    2193       1;
     545     933       1;
     546     152       1;
     546     155       2;
     546     816       2;
     547     816       1;
     547    1596       1;
     548    1054       3;
     548    1626       1;
     548    1783       1;
     548    2237       1;
     549     108       1;
     549     155       1;
     549    1783       2;
     549    2011       2;
     550     155       2;
     550     753       1;
     550    1076       1;
     550    1309       1;
     550    1783       1;
     551    1040       1;
     552      65       2;
     552     149       1;
     552    1270       1;
     552    2296       1;
     552    2925       1;
     553     155       1;
     553     223       1;
     553    1459       2;
     553    1596       4;
     554     155       6;
     554     816       1;
     554    1313       1;
     554    1317       1;
     554    1596       1;
     554    1636       1;
     554    2296       1;
     554    2406       1;
     555       7       3;
     555      65       1;
     555     155       1;
     555    1373       1;
     555    1596       2;
     556      89       1;
     556     223       1;
     556    1071       1;
     556    1101       1;
     556    1548       1;
     556    1596       4;
     556    2406       1;
     557    1040       1;
     557    1071       1;
     557    1493       1;
     557    1548       2;
     557    1596       1;
     558     893       1;
     558    1270       1;
     558    1317       1;
     558    1459       1;
     558    1916       2;
     559     155       3;
     559    1596       2;
     560     155       3;
     560     283       1;
     560     874       1;
     560    1054       2;
     560    1309       2;
     560    1783       1;
     560    2062       1;
     560    2193       1;
     560    2280       1;
     561      49       1;
     561     392       1;
     561    1459       1;
     561    1783       1;
     562      65       1;
     562     283       2;
     562     816       1;
     562    1548       2;
     562    2729       1;
     563     156       1;
     563     283       1;
     563     979       1;
     563     995       1;
     563    1002       1;
     563    1493       2;
     563    1783       2;
     563    2494       1;
     564     155      10;
     564     223       5;
     564     874       1;
     564     979       8;
     564    1373       1;
     564    1459       1;
     564    1912       2;
     564    2193       1;
     564    2721       1;
     565       8       1;
     565     155       2;
     565     223       3;
     565     283       4;
     565     979       5;
     565    2296       1;
     566       8       2;
     566     155       6;
     566     223       4;
     566     874       1;
     566     979       4;
     566    1596       1;
     566    2193       2;
     567     223       3;
     567    1373       1;
     568      65       1;
     568     816       1;
     568     874       1;
     568    1373       1;
     569      49       1;
     569     248       1;
     569     816       2;
     569     874       1;
     569     893       1;
     569    1596       3;
     569    1622       1;
     570     155       1;
     570     893       1;
     570    2721       1;
     571     155       5;
     571     816       1;
     571    1076       1;
     571    1373       1;
     571    1604       1;
     571    2296       1;
     571    2667       1;
     572     103       1;
     572     155       3;
     572     582       1;
     572    1373       2;
     572    1596       2;
     572    1615       1;
     572    1783       2;
     572    1920       1;
     572    2108       2;
     572    2198       1;
     572    2296       1;
     572    2492       1;
     572    2749       1;
     573     816       1;
     573    1054       1;
     573    1373       1;
     573    1493       2;
     573    1596       1;
     573    2726       1;
     574     156       1;
     574     248       1;
     574     874       1;
     574    1002       1;
     574    1317       1;
     574    1373       1;
     574    1447       1;
     574    1548       1;
     574    1596       2;
     574    1604       1;
     574    1642       1;
     574    1783       1;
     574    2406       1;
     575      65       2;
     575      99       1;
     575     103       1;
     575     155       1;
     575     248       1;
     575     461       1;
     575    1596       1;
     575    1604       2;
     575    1642       1;
     575    2062       1;
     576       8       1;
     576      95       2;
     576     155       1;
     576     356       4;
     576     461       2;
     576    1054       3;
     576    1309       1;
     576    1313       1;
     576    1446      13;
     576    1451       6;
     576    1459       1;
     576    1478       1;
     576    1493       1;
     576    1596       2;
     576    1604       3;
     576    1615       2;
     576    1783       3;
     576    2150       1;
     576    2776       1;
     576    2787       1;
     577       7       1;
     577     304       1;
     577    1002       1;
     577    1010       1;
     577    1270       1;
     577    1373       1;
     577    1596       2;
     577    2229       1;
     578     356       3;
     578    1054       1;
     578    1446       1;
     578    1451       2;
     578    1783       1;
     578    2024       1;
     579      65       1;
     579     354       1;
     579    1493       1;
     580     152       1;
     580     155       1;
     580    1373       1;
     580    1596       1;
     581    1373       1;
     581    1446       1;
     581    1783       1;
     582    1524       1;
     583      49       1;
     583    1005       1;
     583    1373       1;
     583    1493       1;
     583    1604       1;
     583    2406       1;
     584      65       1;
     584     155       2;
     584     354       1;
     584     871       1;
     584    2776       1;
     585     155       1;
     585    1513       1;
     585    1596       1;
     585    1783       1;
     585    1884       1;
     585    2406       1;
     586      65       1;
     586     195       1;
     586     933       1;
     586    1478       1;
     587      49       1;
     587     286       1;
     587    1373       1;
     587    1524       1;
     588      95       2;
     588     356       7;
     588    1054       4;
     588    1446      13;
     588    1451       8;
     588    1478       1;
     588    1783       4;
     588    2024       1;
     588    2150       1;
     588    2787       1;
     589      65       3;
     589    1040       1;
     589    1446       6;
     589    1451      11;
     589    2024       4;
     589    2150       1;
     589    2813       1;
     590      65       1;
     590     177       1;
     590    1446       3;
     591      95       1;
     591     248       1;
     591     420       1;
     591    1604       1;
     592     356       1;
     592    1446       1;
     592    2492       1;
     593      65       2;
     593     356       2;
     593     816       2;
     594    1373       1;
     594    1884       1;
     595      65       2;
     595     248       1;
     595    1373       1;
     595    1604       1;
     595    1912       1;
     595    2635       1;
     595    2925       1;
     596      65       1;
     599      65       1;
     599     816       1;
     599     996       1;
     599    1596       5;
     600     356       1;
     600     850       1;
     600     979       1;
     600    1054       1;
     600    1373       2;
     600    1548       1;
     600    2296       1;
     601     437       1;
     601     816       1;
     601    1040       1;
     601    1054       1;
     601    1071       2;
     601    1119       1;
     601    1459       1;
     602    1054       3;
     602    1310       1;
     602    1493       1;
     602    1989       1;
     603     693       1;
     603    1054       1;
     603    1459       1;
     603    1478       1;
     603    1695       1;
     603    2224       1;
     603    2534       2;
     603    2809       1;
     603    2813       1;
     604     874       2;
     604    1054       1;
     604    1459       1;
     605     223       3;
     605     248       1;
     605     979       1;
     605    1054       2;
     605    1596       1;
     605    2062       1;
     605    2280       1;
     606     155       1;
     606     356       2;
     606     816       2;
     606    1373       1;
     606    1523       2;
     606    1884       1;
     608      65       2;
     608    1739       1;
     608    2813       1;
     609    1596       2;
     610      65       1;
     610     816       1;
     610    1783       1;
     610    2296       1;
     611      65       1;
     611     283       1;
     611     816       1;
     611    1832       1;
     611    2822       1;
     612    1040       2;
     612    1783       1;
     613    1054       2;
     613    1783       1;
     613    2224       1;
     614     108       1;
     614    1054       2;
     614    1626       1;
     614    1783       1;
     614    2224       1;
     615    1054       1;
     616    2494       1;
     616    2840       1;
     617    1006       1;
     617    2273       1;
     617    2840       1;
     618      65       1;
     618      93       1;
     618    1548       1;
     620       5       7;
     620     108       1;
     620     393       1;
     620     441       2;
     620     874       1;
     620    1309       3;
     620    1921       1;
     620    2840       6;
     621    2840       4;
     622       5       1;
     622     701       1;
     622     710       1;
     622     874       1;
     622    1478       1;
     622    1884       1;
     622    2296       1;
     622    2840       7;
     623      65       2;
     623     124       1;
     623     155       5;
     623    1054       4;
     623    1220       1;
     623    2011       1;
     623    2635       1;
     623    2788       1;
     624      65       2;
     624     356       2;
     624     816       1;
     624     906       1;
     624    1548       1;
     624    2721       1;
     625     155       1;
     625     248       1;
     625     354       2;
     625     893       1;
     625    1548       1;
     625    1596       2;
     625    1604       2;
     626       7       1;
     626     582       1;
     626    1101       1;
     626    1596       3;
     626    1615       1;
     626    1646       1;
     626    1783       1;
     626    2776       1;
     627     266       1;
     627     394       1;
     627    2776       2;
     628      65       1;
     628     155       1;
     628    1548       1;
     628    2011       1;
     628    2062       1;
     628    2193       1;
     628    2635       6;
     629     223       2;
     629     356       1;
     629    1548       1;
     629    1604       1;
     630     156       1;
     630     283       1;
     630    1309       1;
     631     356       1;
     631     816       1;
     632     356       1;
     633     972       1;
     634    2193       1;
     634    2273       1;
     634    2635       1;
     635     155       2;
     635     223       5;
     635    2193       1;
     636     893       2;
     636    1459       2;
     636    2280       4;
     637     354       1;
     637     356       1;
     637    1447       2;
     638    1447       2;
     639    1783       1;
     640       8       1;
     640     103       1;
     640     687       1;
     640     939       1;
     640    1010       2;
     640    1373       1;
     640    1446       2;
     640    1498       1;
     640    1548       1;
     640    1783       2;
     641     266       3;
     641     354       1;
     641     874       1;
     641    1323       1;
     641    2406       1;
     642     223       3;
     642    1478       1;
     643     899       1;
     643    1493       1;
     644     208       1;
     644    1003       1;
     644    1270       1;
     644    1548       1;
     644    1783       1;
     644    2925       1;
     645      65       2;
     645     155       2;
     645     850       1;
     645    1071       1;
     645    1373       2;
     645    1504       1;
     645    1604       1;
     645    2521       1;
     645    2635       1;
     645    2898       1;
     646       8       1;
     646      65       1;
     646     155       4;
     646     223       4;
     646    1220       1;
     646    1317       1;
     646    1604       1;
     646    2635       3;
     647     266       1;
     648     266       2;
     648    1372       2;
     648    1884       1;
     649     248       1;
     649    1270       1;
     649    1493       1;
     649    1844       1;
     649    2296       1;
     649    2406       1;
     650     816       1;
     651     155       4;
     651     893       4;
     651     924       1;
     651    1447       2;
     651    1523       4;
     652      65       1;
     652     816       1;
     652     850       1;
     652    1493       1;
     653     152       1;
     653    1523       1;
     653    1783       1;
     654    1054       3;
     655     155       2;
     655     177       1;
     655     432       1;
     655    1596       1;
     656      65       1;
     656      99       1;
     656     103       2;
     656     248       1;
     656    1604       2;
     656    2280       1;
     657     223       1;
     657    1596       1;
     657    1783       1;
     657    2776       2;
     658      49       1;
     658     177       2;
     658     356       4;
     658    1054       1;
     658    1447       1;
     658    2011       1;
     658    2296       1;
     659     223       6;
     659    1071       2;
     660      65       1;
     660     156       1;
     660     177       1;
     660     356       1;
     660    1002       1;
     660    1270       2;
     660    1373       7;
     660    1783       1;
     661     108       2;
     661     155       5;
     661     420       1;
     661     816       1;
     661    1596       1;
     661    2534       1;
     662     155       8;
     662     874       2;
     662    1040       1;
     662    1373       2;
     662    1459       1;
     662    1596       4;
     662    1851       1;
     662    2460       1;
     663      65       1;
     663    1071       1;
     663    2296       1;
     664      65       1;
     664     283       1;
     665      65       2;
     665     582       2;
     665     816       1;
     665    1373       2;
     665    1441       1;
     665    1596       2;
     665    1604       3;
     666      65       1;
     666     155       3;
     666     356       1;
     666     816       1;
     666    1596       3;
     666    1688       1;
     666    2296       1;
     667      65       1;
     667     155       1;
     667     850       1;
     667    1373       1;
     667    1493       1;
     667    1783       2;
     667    1921       1;
     667    2296       1;
     667    2478       1;
     668     155       2;
     669    1071       4;
     669    1270       1;
     669    1447       4;
     669    2171       2;
     670     155       1;
     670     356       1;
     670    1596       1;
     671     283       1;
     671     356       1;
     671    1548       1;
     672    1310       2;
     672    1459       1;
     673     542       2;
     673     996       7;
     673    1309       2;
     673    1323       1;
     673    1599       1;
     673    2193       2;
     674    1447       1;
     675      49       1;
     675      98       1;
     675     356       1;
     675     816       1;
     675    1040       2;
     675    1054       2;
     675    1309       1;
     675    1451       2;
     675    1783       1;
     676    1447       1;
     677     297       1;
     677    1054       1;
     677    1270       1;
     677    1309       1;
     677    1373       2;
     677    1523       1;
     677    2925       1;
     678     297       1;
     679     297       1;
     679     356       1;
     679     816       2;
     679    1040       2;
     679    1054       1;
     679    1478       1;
     680      65       1;
     680     816       2;
     680    1054       2;
     680    1447       1;
     680    1783       1;
     681      65       2;
     681     177       1;
     681    1116       1;
     681    1447       1;
     681    1493       1;
     682     297       3;
     682    1054       2;
     682    1447       1;
     683       7       3;
     683      98       2;
     683     356       1;
     683     972       1;
     683    1071       1;
     683    1447       1;
     683    2729       1;
     684      89       1;
     684    2509       1;
     685     816       3;
     685    1447       2;
     685    1478       1;
     685    2193       2;
     685    2320       1;
     685    2492       1;
     686     356       1;
     686     816       5;
     686     850       1;
     686    1429       1;
     686    2193       1;
     686    2635       4;
     688      65       1;
     688    1054       2;
     688    1478       1;
     688    1596      10;
     688    2062       1;
     689     155       4;
     689     223       3;
     689    1459       1;
     689    1589       1;
     689    1596       1;
     689    2062       1;
     690     155       1;
     690     223       2;
     690     430       3;
     690    1373       1;
     690    1596       1;
     690    1783       1;
     690    2161       1;
     692     893       1;
     692    1459       1;
     692    2776       1;
     693     893       1;
     693    1459       1;
     693    2776       3;
     694       7       2;
     694    1636       1;
     694    2776       2;
     695    1459       3;
     695    1783       2;
     695    2424       1;
     695    2635       1;
     695    2813       5;
     696       7       1;
     696     297       4;
     696    1459       1;
     696    1572       1;
     696    2280       1;
     696    2492       1;
     697       7       1;
     697     893       2;
     697    1636       1;
     697    2280       1;
     698      99       1;
     698    1373       1;
     698    2062       1;
     699      93       1;
     699      99       1;
     699     149       1;
     699     297       2;
     699     356       1;
     699    1459       1;
     700      43       1;
     700     152       1;
     700     356       1;
     700    1116       1;
     700    1459       1;
     701      65       1;
     701      99       1;
     701     665       1;
     701    1447       2;
     701    2911       1;
     702    1447       1;
     703    1270       1;
     703    1323       1;
     704     112       1;
     704    1447       2;
     704    1884       1;
     704    1953       1;
     705       7       1;
     705     354       1;
     705    1054       3;
     705    1447       2;
     706       6       1;
     706     152       2;
     706     736       1;
     706    2729       1;
     707      65       1;
     707     152       1;
     707     816       1;
     707    1459       1;
     707    1884       1;
     707    2460       1;
     707    2534       2;
     708    1636       1;
     709     392       1;
     709    1309       2;
     709    1373       1;
     709    1459       1;
     709    2884       1;
     710       8       1;
     710      93       1;
     710     297       1;
     710     356       2;
     710     850       1;
     710    1373       2;
     710    2492       2;
     711     542       1;
     711    1373       1;
     711    1447       2;
     711    1783       1;
     711    2193       1;
     712     356       1;
     712    1373       1;
     712    1447       3;
     712    1478       1;
     712    1493       1;
     712    2062       2;
     713    1373       3;
     713    1459       3;
     714     108       1;
     714    1310       2;
     714    1373       1;
     714    1572       2;
     714    1596       1;
     715    1076       2;
     715    1366       2;
     716    1366       1;
     716    1622       1;
     716    1783       2;
     716    2908       1;
     717       5       1;
     717     433       2;
     717     542       3;
     717    1010       1;
     717    1373       5;
     717    1459       2;
     717    1596       2;
     717    2062       1;
     717    2193       1;
     718     286       2;
     718    1596       1;
     718    1636       2;
     718    1651       1;
     718    2502       1;
     718    2839       1;
     719     356       1;
     719    1459       1;
     719    1596       1;
     720      99       1;
     720     177       2;
     720     354       1;
     720     404       1;
     720    1636       1;
     720    2925       1;
     721     156       1;
     721     286       1;
     721     395       2;
     721     893       4;
     721    1373       2;
     721    1555       1;
     721    1783       1;
     721    2193       1;
     721    2273       1;
     722    1040       1;
     722    1548       1;
     722    1783       2;
     722    2011       1;
     723      65       1;
     723     286       1;
     724     850       1;
     724    1373       1;
     724    1439       1;
     724    1636       1;
     725     177       1;
     726      65       1;
     726    1783       1;
     727     816       2;
     727     850       1;
     727    1459       2;
     727    1783       2;
     727    1851       1;
     727    2492       1;
     728     996       1;
     729      65       3;
     729    1010       1;
     729    1220       1;
     729    1459       1;
     729    1493       1;
     729    1783       1;
     730      65       1;
     730     208       1;
     730     266       4;
     730     438       2;
     730    1373       1;
     730    2406       1;
     730    2776       4;
     731     899       2;
     731    1054       1;
     731    1270       5;
     731    1478       1;
     731    2776       1;
     732     496       1;
     732    1459       2;
     733      87       1;
     733     266       3;
     733    1270       1;
     733    2749       1;
     733    2925       1;
     734     266       2;
     734     727       2;
     734    1323       1;
     735     266       3;
     736      65       1;
     736     266       1;
     736    1077       1;
     736    2273       1;
     737     727       1;
     737     816       5;
     737    2273       1;
     738     354       1;
     738     933       1;
     738    1851       6;
     739      65       3;
     739    1040       1;
     739    1054       1;
     739    1270       2;
     739    1439       1;
     739    1548       1;
     739    1695       1;
     739    2062       1;
     739    2729       1;
     739    2839       1;
     740     223       2;
     740    1459       1;
     740    1548       1;
     741     223       1;
     741     874       2;
     742      65       1;
     742     223       1;
     742    1009       1;
     742    2778       1;
     743     789       1;
     743    1373       1;
     743    1783       1;
     744      65       2;
     744      76       1;
     744     223       1;
     745    2492       2;
     746     177       1;
     746     356       1;
     746    1071       1;
     746    1493       1;
     746    2320       3;
     747     942       1;
     747    1447       1;
     747    1548       1;
     747    1596       3;
     747    2273       1;
     747    2296       1;
     747    2721       1;
     747    2822       1;
     748     354       1;
     748    1270       1;
     748    1373       1;
     748    1447       2;
     748    2492       2;
     749      65       1;
     749     394       1;
     749     874       1;
     749    1373       1;
     749    1851       1;
     750     248       1;
     750    1572       3;
     750    1884       1;
     750    2273       1;
     750    2776       1;
     751     223       1;
     751    1555       1;
     751    2406       1;
     752     816       3;
     752    1478       2;
     753    1447       1;
     753    1459       3;
     753    1783       1;
     753    2041       1;
     754     155       3;
     754     223       4;
     754     893       2;
     754    2193       1;
     755     356       1;
     755     850       1;
     755     979       2;
     755    1317       4;
     756     155       1;
     756    1270       3;
     756    1459       1;
     756    1548       1;
     756    2167       1;
     756    2469       1;
     756    2809       1;
     756    2904       1;
     757      65       2;
     757    1040       1;
     757    1054       2;
     757    1446       1;
     757    1783       1;
     757    2280       1;
     758       7       3;
     758     996       2;
     758    1783       1;
     759     223       2;
     759     356       1;
     759     874       2;
     759    1373       1;
     759    1459       1;
     759    2062       1;
     760    1783       1;
     761     816       1;
     761    1783       1;
     761    2273       1;
     762      65       1;
     762    1372       1;
     762    1616       1;
     762    1845       1;
     763     223       4;
     764     693       1;
     764    1054       2;
     764    1309       2;
     765      65       1;
     765     223       2;
     765     266       2;
     765    1054       1;
     766     248       1;
     766     266       2;
     766     816       2;
     766    1054       1;
     766    1116       1;
     766    1379       2;
     767     155       1;
     767     156       1;
     767     420       1;
     767     753       3;
     767     967       1;
     767    1054       1;
     767    1071       1;
     767    1333       1;
     767    1478       1;
     767    1604       1;
     767    2273       1;
     767    2923       1;
     768    1555       1;
     768    1884       1;
     769    1040       1;
     770      65       1;
     770    1071       3;
     770    2296       1;
     771      65       1;
     771    1071       2;
     771    1270       1;
     771    1447       1;
     772     432       1;
     772    1451       1;
     772    1478       1;
     772    1783       1;
     773     155       2;
     773     248       2;
     773     690       1;
     773    2469       1;
     774       7       1;
     774    1447       1;
     775    1040       1;
     775    1447       1;
     775    1783       1;
     775    2062       1;
     776     223       2;
     776    1373       1;
     777    1010       1;
     777    1054       1;
     777    1323       1;
     777    1523       1;
     777    1783       1;
     777    2296       1;
     778    1270       1;
     778    2296       1;
     779       7       1;
     779      99       1;
     779     108       1;
     779     972       1;
     779    1054       1;
     779    1447       1;
     780     816       3;
     781    1373       2;
     781    1447       3;
     781    1459       2;
     781    1478       1;
     781    1493       1;
     781    1783       1;
     781    2320       2;
     782     392       1;
     782    1447       2;
     782    1493       1;
     782    1783       1;
     782    2492       1;
     783     297       1;
     783     996       4;
     783    1373       1;
     783    1447       1;
     783    1459       2;
     783    1695       2;
     784     155       4;
     784     223       4;
     784     893       3;
     784    1373       1;
     785     223       6;
     785     248       1;
     785     438       1;
     785    2273       1;
     786     223       9;
     787      99       1;
     787     223       7;
     787     283       1;
     788     223       5;
     788    1851       1;
     789     155       2;
     789     223       3;
     789     893       3;
     790     979       5;
     790     996       2;
     790    1447       1;
     790    1459       1;
     790    2296       1;
     790    2721       1;
     791    1447       1;
     792      65       2;
     792      93       1;
     792      98       1;
     792     108       1;
     792     177       1;
     792     344       1;
     792     356       6;
     792     816       1;
     792     906       1;
     792     979       1;
     792    1054       2;
     792    1076       1;
     792    1459       3;
     792    1548       2;
     792    1599       1;
     792    1652       1;
     792    1884       3;
     792    2729       1;
     792    2925       2;
     793      65       1;
     793    1040       3;
     793    1447       1;
     794     297       2;
     794     816       1;
     794    1040       2;
     794    1054       2;
     794    1373       1;
     794    1459       1;
     795     356       1;
     796    2062       1;
     797     108       1;
     797    1040       2;
     797    1054       1;
     797    1323       1;
     797    1373       2;
     797    1447       1;
     797    1548       1;
     797    1698       1;
     797    1783       1;
     797    2273       2;
     798      65       2;
     798     177       1;
     798     356       1;
     798     893       1;
     798    1010       1;
     798    1054       3;
     798    1220       1;
     798    1309       3;
     798    1369       1;
     798    1447       2;
     798    1459       1;
     798    1493       1;
     798    1599       1;
     798    1612       1;
     798    2224       1;
     798    2237       1;
     798    2296       2;
     798    2331       2;
     798    2478       1;
     798    2641       1;
     799      65       1;
     799     176       1;
     799     356       1;
     799    1309       1;
     799    1310       2;
     799    1447       1;
     799    1636       1;
     799    2011       1;
     800     223       2;
     800     248       1;
     800    1310       2;
     800    2296       1;
     801       7       1;
     801     103       1;
     801     223       4;
     801     356       1;
     801    1323       1;
     801    1596       5;
     801    1783       2;
     802     108       1;
     802     354       1;
     802     532       1;
     802    1071       2;
     802    1548       1;
     802    1596       3;
     802    2296       1;
     803     816       1;
     803    1040       1;
     803    1071       1;
     803    1076       1;
     803    1447       1;
     803    1596       7;
     804       7       2;
     804    1040       1;
     804    1071       1;
     804    1270       1;
     804    1373       1;
     804    1636       3;
     804    1783       1;
     804    2011       1;
     804    2406       1;
     804    2787       1;
     804    2809       1;
     805     874       1;
     805     996       3;
     805    1054       1;
     805    1695       1;
     805    1783       1;
     805    2091       1;
     806       7       2;
     806      65       1;
     806     996       5;
     806    1076       1;
     806    2565       1;
     807       7       1;
     807     996       3;
     808       7       2;
     808     816       1;
     808     850       1;
     808    1596       5;
     808    1615       1;
     809       7       2;
     809    1596       2;
     809    1615       1;
     810     996       4;
     810    1309       1;
     810    1493       1;
     810    2492       1;
     810    2565       2;
     810    2787       3;
     811       7       1;
     811      65       1;
     811     108       1;
     811    1317       1;
     811    1459       1;
     811    1596       3;
     811    2580       1;
     812     223       6;
     812     874       1;
     812    1447       1;
     813      65       2;
     813    1596       2;
     813    2062       1;
     814    1323       1;
     814    1373       1;
     814    1596       1;
     815       8       1;
     815     433       2;
     815    1309       2;
     815    1373       3;
     815    1459       3;
     815    1596       5;
     815    1884       1;
     815    2787       1;
     816    1373       2;
     816    1459       1;
     816    1596       7;
     816    1884       1;
     818      65       1;
     818      93       1;
     818     223       1;
     818    1054       1;
     819    1373       1;
     819    2805       2;
     820     850       2;
     820    1002       1;
     820    1373       3;
     820    1783       1;
     820    2925       1;
     821    1373       1;
     822      65       1;
     822     223       3;
     822     420       1;
     822     816       1;
     822     874       2;
     822    1783       2;
     822    1912       2;
     823     223       2;
     823     392       1;
     823    1373       1;
     824     392       1;
     824    1010       1;
     824    1373       1;
     824    1459       2;
     824    2296       1;
     824    2788       1;
     824    2884       1;
     825       8       1;
     825      65       1;
     825    1071       1;
     825    1270       1;
     825    1548       1;
     825    1653       1;
     826      87       1;
     826     246       1;
     826    2296       2;
     827     248       2;
     827     816       1;
     827    1002       2;
     827    1373       1;
     827    1783       1;
     827    2150       1;
     827    2492       1;
     827    2776       2;
     827    2788       1;
     828      49       1;
     828    1054       1;
     828    1373       2;
     828    1636       1;
     828    2406       1;
     829      65       1;
     829     874       1;
     829    1270       1;
     829    2193       2;
     830     248       1;
     830    1373       1;
     830    1688       1;
     830    1783       1;
     831     266       1;
     832    2776       4;
     833     753       1;
     833    1054       2;
     833    2237       1;
     834     354       1;
     835      65       1;
     835    1003       2;
     835    1045       1;
     835    2776       1;
     836      65       1;
     836     248       1;
     836    1783       1;
     836    1845       1;
     837      65       1;
     837     404       1;
     837     753       2;
     837    1116       1;
     837    1372       1;
     837    1373       2;
     837    2805       2;
     838       8       1;
     838      87       2;
     838     223       2;
     838    2925       1;
     839     223       7;
     839    1127       2;
     839    1270       1;
     839    1459       1;
     840      93       1;
     840     874       1;
     840    1054       2;
     840    1783       2;
     841      65       1;
     842     223       2;
     842    1010       1;
     842    1478       1;
     843      65       1;
     843     223       4;
     843    1010       1;
     843    1373       1;
     843    2710       1;
     844      65       1;
     844     223       5;
     844     816       2;
     844    1040       1;
     844    1270       1;
     844    1373       1;
     844    1434       1;
     845     223       9;
     845     532       1;
     845     816       2;
     845    1040       1;
     845    1555       1;
     846      65       1;
     846     223       5;
     846    2062       1;
     847      65       1;
     847     223       2;
     847    1040       1;
     847    1783       1;
     847    2788       1;
     848     223       1;
     848    1783       1;
     849      65       1;
     849     532       1;
     849    1459       1;
     849    1596       2;
     849    2492       1;
     850     223       1;
     851     223       1;
     851    1373       1;
     852     223       2;
     852     816       1;
     852    1373       1;
     852    2193       2;
     852    2911       1;
     853    1373       1;
     854     223       1;
     855     223       2;
     855    1459       1;
     856     266       4;
     856     404       1;
     856     816       1;
     856    1783       4;
     856    2011       1;
     856    2787       1;
     857     113       1;
     857     266       3;
     857     816       1;
     857    1783       1;
     857    2492       1;
     858     248       1;
     858    1054       1;
     858    1116       2;
     858    1379       3;
     859     816       4;
     859     996       1;
     859    1002       2;
     859    1379       1;
     859    1912       2;
     859    2193       1;
     860      65       1;
     860     152       1;
     860     996       1;
     860    1548       1;
     860    2296       1;
     861     155       2;
     861     432       1;
     862    1040       2;
     862    1783       1;
     862    2296       1;
     863     248       1;
     863    2788       1;
     864     223       1;
     865    1323       2;
     865    1373       3;
     865    1426       1;
     865    1783       1;
     865    2011       1;
     865    2813       1;
     866     753       2;
     866    1040       1;
     866    1054       1;
     866    1493       1;
     866    2813       2;
     867      65       1;
     867     108       2;
     867     850       1;
     867    1493       1;
     868     420       1;
     868    1010       1;
     868    1459       1;
     868    1523       1;
     868    1604       1;
     868    1884       1;
     869     108       1;
     869     112       1;
     869     152       5;
     869     155       3;
     869     420       1;
     869     496       1;
     869     753       1;
     869    1006       1;
     869    1323       1;
     869    1884       1;
     869    2273       1;
     869    2822       1;
     869    2925       1;
     870      65       1;
     870     753       1;
     870    2721       1;
     871     753       4;
     871    1459       1;
     871    2565       2;
     871    2847       1;
     872      65       1;
     872      89       1;
     872     155       5;
     872     304       1;
     872    1373       1;
     872    1548       1;
     872    2534       1;
     872    2787       1;
     873       8       1;
     873     152       1;
     873     155       5;
     873     582       1;
     873    2534       3;
     874     301       1;
     874     356       3;
     874    1054       1;
     874    1309       8;
     874    1884       1;
     874    2767       1;
     875    2320       1;
     876     356       2;
     876    1010       1;
     876    1548       1;
     876    1884       1;
     876    2822       1;
     877     297       1;
     878     112       1;
     878     356       2;
     878    1220       1;
     878    1309       1;
     879    1636       1;
     880     177       1;
     880     356       1;
     880     996       1;
     880    1309       1;
     880    1373       1;
     880    2224       1;
     881     441       1;
     881     871       1;
     881    1373       1;
     881    1493       1;
     881    1548       1;
     882     108       1;
     882    1555       1;
     882    2710       1;
     883     404       1;
     883     736       1;
     883    1412       1;
     883    1721       1;
     883    2805       1;
     884    1317       1;
     884    1783       1;
     885     223       1;
     886      87       1;
     886     158       1;
     886     266       2;
     886    1309       1;
     886    1596       1;
     887     266       1;
     887    1373       1;
     888      87       3;
     888     223       6;
     888     248       1;
     888     266       1;
     888     816       1;
     888    2273       1;
     889      65       1;
     889     156       1;
     889     223       4;
     889     266       1;
     889    1010       1;
     889    1054       3;
     889    1373       1;
     889    2710       2;
     889    2822       1;
     890     266       2;
     890     392       1;
     890    1493       1;
     891     208       1;
     891     223       6;
     891     248       1;
     891     354       1;
     891     816       1;
     891    1373       1;
     891    2273       2;
     892     177       1;
     892     736       1;
     892    1270       1;
     892    1636       1;
     892    1783       1;
     892    2839       1;
     893     354       1;
     893     735       1;
     893    1459       5;
     894      65       1;
     894     356       2;
     894    1459       1;
     894    1493       1;
     894    2492       1;
     895       7       2;
     895     248       1;
     895    2424       1;
     897     108       1;
     897    2273       1;
     897    2911       1;
     898     108       1;
     898     816       1;
     898    1459       1;
     899      65       1;
     899     155       1;
     899     177       1;
     899    1451       1;
     899    1548       1;
     899    1783       1;
     899    2296       1;
     901    1596       1;
     902     152       1;
     902     893       1;
     902    1636       1;
     902    1698       1;
     902    2296       1;
     902    2721       1;
     903      65       1;
     903     156       1;
     903    1054       1;
     903    1447       1;
     903    1783       1;
     904      65       1;
     904     356       1;
     904    1317       2;
     904    1459       8;
     904    2062       1;
     905     816       1;
     905     821       1;
     905    1459       5;
     905    1520       1;
     905    1636       1;
     905    2721       1;
     906     108       1;
     906     177       1;
     906    1636       1;
     906    2296       1;
     907     392       2;
     907     979       3;
     907    1493       1;
     907    1596       2;
     907    1636       1;
     907    1783       4;
     907    2787       1;
     908       8       1;
     908     837       1;
     908     850       1;
     908    1523       1;
     908    1555       1;
     909     177       1;
     909    1459       1;
     909    1548       1;
     910    1373       1;
     911    1309       1;
     911    1555       1;
     911    1783       1;
     911    1912       2;
     912     155       1;
     912     223       5;
     912     432       1;
     912     816       2;
     912    1317       2;
     912    1372       1;
     912    1783       2;
     912    2534       1;
     912    2557       1;
     913     286       2;
     913    1002       1;
     913    1851       1;
     913    2787       1;
     914     141       3;
     914     356       3;
     914     690       1;
     914    1220       1;
     914    1368       1;
     914    1429       1;
     914    1459       6;
     915     248       1;
     915    1366       1;
     916      65       1;
     916     354       1;
     916     816       1;
     916    1054       1;
     916    1596       1;
     916    2296       1;
     916    2424       1;
     917     283       1;
     917     392       1;
     917     816       1;
     917     990       1;
     917    1054       1;
     917    1373       1;
     917    1493       1;
     917    1783       1;
     917    2787       2;
     918     248       1;
     918     297       1;
     918    1596       1;
     919     248       1;
     919     297       1;
     919    1054       1;
     919    1270       1;
     919    1783       1;
     919    2842       2;
     921      65       1;
     921     156       1;
     921     177       3;
     921     248       1;
     921     354       1;
     921    1071       1;
     921    1447       2;
     921    1596       3;
     921    2911       1;
     922     816       1;
     922     979       1;
     922    1071       1;
     922    1373       1;
     922    1596       3;
     922    1615       1;
     923    1054       1;
     923    1596       6;
     923    2193       1;
     924     356       1;
     924    1447       2;
     924    1596       5;
     924    1953       1;
     924    2193       1;
     925     108       1;
     926     816       1;
     926    1010       1;
     926    2062       1;
     926    2472       1;
     927     223       1;
     927     283       1;
     927     432       1;
     927    1220       1;
     927    1373       1;
     927    1439       1;
     927    1478       1;
     927    1493       2;
     927    1596       9;
     927    2167       1;
     927    2478       1;
     928      65       2;
     928     223       4;
     928     816       1;
     928    1003       1;
     928    1373       4;
     928    1548       1;
     928    1783       1;
     928    2207       1;
     928    2273       1;
     928    2809       1;
     929     354       1;
     929    2511       1;
     930      65       1;
     930     354       1;
     930    1054       1;
     931    1270       1;
     932     223       1;
     932    2749       1;
     933      65       1;
     933     850       1;
     933    1002       1;
     933    1010       1;
     933    1054       1;
     933    1071       1;
     933    1309       1;
     933    1459       1;
     933    1844       1;
     933    1912       1;
     933    2280       1;
     933    2729       1;
     933    2839       1;
     934     885       1;
     934    1054       1;
     934    2478       1;
     934    2884       1;
     936     972       1;
     936    1054       1;
     936    2273       1;
     937      65       1;
     937     223       1;
     937     816       2;
     937    1270       1;
     937    2273       1;
     938    2062       1;
     939     438       1;
     939     582       1;
     939    1615       1;
     940      65       1;
     940    1054       1;
     941       7       1;
     941     283       1;
     941     392       1;
     941    1572       1;
     941    1783       2;
     941    2776       1;
     942       7       1;
     942     665       2;
     942    1010       1;
     942    1604       3;
     942    1783       1;
     942    2813       1;
     943     816       3;
     943     893       1;
     943    1373       1;
     943    1596       1;
     944     248       1;
     944    1054       1;
     944    2726       1;
     945      49       1;
     945     356       1;
     945    1310       1;
     945    2897       1;
     946       8       1;
     946    1493       1;
     946    1596       7;
     946    1615       2;
     946    2193       1;
     946    2635       1;
     947       8       1;
     947     542       2;
     947    1366       1;
     947    1373       3;
     947    1459       5;
     947    1596       2;
     947    1615       1;
     947    2635       3;
     948     996       1;
     948    1002       1;
     948    1116       1;
     948    1309       2;
     948    1493       1;
     949      49       1;
     949    1699       1;
     949    2979       1;
     950     753       2;
     950    1555       1;
     951     753       3;
     952      87       1;
     952     223       1;
     952     753       3;
     952    1373       1;
     952    1783       1;
     953    1783       1;
     954     223       4;
     954     354       1;
     954     816       1;
     955     103       1;
     955     223       2;
     955    1636       2;
     956     223       3;
     957      61       1;
     957    1270       1;
     957    1309       1;
     957    1783       1;
     958      65       1;
     958     286       1;
     958    1373       1;
     958    1459       1;
     958    1695       1;
     958    2478       1;
     959     155       5;
     959     874       1;
     959    1054       1;
     959    2167       1;
     960      65       2;
     960    1373       1;
     961     354       1;
     961     356       1;
     961     850       1;
     961    1309       1;
     962     155       7;
     962     283       1;
     962     323       1;
     962     874       1;
     962    1270       1;
     962    1446       1;
     962    1596       1;
     962    1691       1;
     962    1851       1;
     962    2193       1;
     962    2296       1;
     962    2822       1;
     963     155       1;
     963    1270       1;
     963    2534       2;
     964    1373       1;
     964    2273       1;
     964    2776       1;
     965      65       1;
     965    1373       1;
     965    1572       1;
     966      49       1;
     966     432       1;
     966    1270       1;
     966    1309       2;
     966    1596       3;
     966    1851       1;
     966    2492       1;
     966    2534       3;
     967      65       1;
     967     283       1;
     967    1309       1;
     967    1596       3;
     967    1604       1;
     967    1783       2;
     968       5       2;
     968     177       1;
     968     286       1;
     968     305       1;
     968     850       1;
     968    1373       1;
     968    1548       1;
     969    1373       2;
     969    1596       2;
     969    2406       1;
     970       7       1;
     970    1459       1;
     971       7       3;
     972       7       2;
     972    1459       1;
     972    1523       1;
     972    1912       1;
     973     223       2;
     973    1373       2;
     973    1851       1;
     974    1373       1;
     974    1604       3;
     974    1783       1;
     975      65       1;
     975     354       1;
     975    1459       1;
     975    1604       4;
     975    1783       1;
     975    2193       1;
     976     112       3;
     976     223       1;
     976     356       2;
     976     439       1;
     976     893       2;
     976    1317       6;
     976    1366       1;
     976    1373       1;
     976    1459       1;
     976    1548       1;
     976    1596      12;
     976    1615       1;
     976    1642       2;
     976    2767       1;
     976    2813       1;
     977      65       1;
     977     893       1;
     977     933       1;
     977     972       3;
     977    1323       1;
     977    1523       2;
     977    2011       1;
     978     152       1;
     978     223       1;
     978     816       1;
     978    1596       2;
     979     155       1;
     979     816       1;
     979     893       1;
     979    1071       1;
     979    1373       6;
     979    1596       1;
     979    2011       1;
     979    2280       1;
     980     152       2;
     980     155       2;
     980     816       5;
     980    1010       1;
     980    1884       1;
     980    2011       1;
     980    2710       1;
     981     152       1;
     981     155       1;
     981    1006       1;
     981    1032       1;
     981    1373       1;
     981    1596       1;
     982     323       1;
     982     356       1;
     982     816       4;
     982     874       1;
     982    1493       1;
     983     155       3;
     983    1317       1;
     983    1373       1;
     983    1548       1;
     983    1596       1;
     983    2296       1;
     984      95       1;
     984    2212       1;
     984    2897       3;
     985     286       2;
     985    1373       1;
     985    2212       2;
     985    2897       3;
     986      95       1;
     986     356       1;
     986     995       1;
     986    1373       1;
     986    1912       1;
     986    2024       1;
     986    2212       2;
     986    2897       1;
     987      95       1;
     987     356       1;
     987     420       1;
     987    1002       1;
     987    1220       1;
     987    1447       2;
     987    2171       1;
     987    2280       1;
     987    2897       1;
     988      95       1;
     988     365       1;
     988     995       1;
     989    2280       1;
     989    2930       1;
     990     356       1;
     990     850       1;
     990    2212       2;
     990    2897       1;
     991     356       1;
     991    1441       1;
     991    1596       5;
     991    1599       1;
     991    1783       3;
     991    2721       1;
     992     392       1;
     992     942       3;
     992    1373       1;
     992    1459       2;
     992    1596       9;
     992    2193       1;
     992    2296       1;
     992    2721       1;
     993       7       2;
     993    1373       2;
     993    1459       3;
     993    1596       5;
     993    1783       1;
     994     797       1;
     994    1373       1;
     994    1596       3;
     994    1783       1;
     994    2280       1;
     996     816       1;
     996    1373       1;
     996    1459       1;
     996    1493       1;
     996    1523       5;
     996    1783       1;
     996    1912       4;
     997       7       1;
     997    1459       2;
     997    1783       4;
     997    2492       1;
     998     248       1;
     998     356       1;
     998     737       1;
     998    1493       1;
     998    1604       2;
     999    1373      10;
     999    1459       1;
    1000     850       1;
    1000     933       1;
    1000    1366       1;
    1000    1459       4;
    1000    1493       1;
    1000    2776       1;
    1000    2884       1;
    1001     850       1;
    1001    1373       3;
    1001    1459       3;
    1001    1783       1;
    1002      65       1;
    1002     155       3;
    1002     223       1;
    1002     430       5;
    1002    1054       1;
    1002    1596       4;
    1002    1783       2;
    1002    2635       1;
    1003      65       1;
    1003    1459       2;
    1003    1604       5;
    1003    2193       1;
    1003    2635       2;
    1004       8       1;
    1004      65       1;
    1004     155       2;
    1004    1459       4;
    1004    1636       1;
    1004    2193       3;
    1004    2635       2;
    1005     979       1;
    1005    1006       1;
    1005    1373       1;
    1005    1459       1;
    1005    1596       3;
    1006    1309       1;
    1006    1447       1;
    1006    1459       1;
    1006    1596       3;
    1006    1604       1;
    1006    1783       1;
    1007     248       1;
    1007     283       1;
    1007    1459       1;
    1007    1604       2;
    1007    2635       4;
    1008    1373       1;
    1008    1459       1;
    1009      65       1;
    1009    1459       1;
    1009    1604       3;
    1009    2721       1;
    1010    1459       1;
    1010    1699       1;
    1011     356       1;
    1011    1373       1;
    1011    1459       1;
    1012     152       1;
    1012     753       4;
    1012     874       2;
    1012    1373       1;
    1012    1732       1;
    1013     753       5;
    1013    2424       1;
    1014     753       3;
    1014     952       1;
    1014    1373       1;
    1015     156       1;
    1015     354       1;
    1015     753       7;
    1015    1493       1;
    1015    2296       1;
    1016     156       1;
    1016     753       1;
    1017      93       1;
    1017     753       4;
    1017    1459       1;
    1017    1493       1;
    1017    1548       1;
    1017    2406       1;
    1018     438       1;
    1018     753       3;
    1018     850       1;
    1018    1127       2;
    1018    1783       1;
    1019      65       1;
    1019     156       1;
    1019     753       2;
    1019     850       1;
    1019    1548       1;
    1019    1732       1;
    1019    1783       1;
    1020     753       5;
    1020    1127       1;
    1020    1884       1;
    1021     223       2;
    1021     753       3;
    1021    1459       1;
    1022     223       3;
    1022     753       1;
    1022     816       1;
    1023     753       3;
    1024     753       6;
    1024    1002       1;
    1024    1003       1;
    1024    1372       1;
    1025     753       4;
    1025    1002       1;
    1025    1548       1;
    1025    1783       1;
    1025    2062       1;
    1025    2424       1;
    1026     152       1;
    1026     753       4;
    1027      65       1;
    1027     248       1;
    1027     283       1;
    1027     753       3;
    1027    1493       1;
    1028     152       6;
    1028     283       1;
    1028     753       9;
    1028    1373       1;
    1028    1459       1;
    1028    2787       2;
    1029     753       3;
    1029    1459       1;
    1029    1596       1;
    1030     753       1;
    1030    1002       1;
    1031      87       3;
    1031     753       1;
    1031     816       2;
    1031     972       1;
    1031    2721       1;
    1032      65       1;
    1032    1002       1;
    1032    1459       1;
    1033     438       1;
    1033    1373       1;
    1034      65       2;
    1034     438       2;
    1034     532       1;
    1034     753       3;
    1035      65       1;
    1035      87       4;
    1035     753       1;
    1035    1783       1;
    1035    2273       2;
    1036    1270       1;
    1037      65       1;
    1037    1372       1;
    1037    1459       1;
    1037    1493       1;
    1038     223       3;
    1038     816       2;
    1039      65       1;
    1039     223       3;
    1039     816       9;
    1039    1373       1;
    1039    1548       1;
    1039    2296       1;
    1040      65       1;
    1040     155       3;
    1040     156       1;
    1040     248       2;
    1040     432       1;
    1040     689       1;
    1040     939       1;
    1040    1309       1;
    1040    1317       2;
    1040    1373       2;
    1040    1523       2;
    1040    1596       4;
    1040    1599       1;
    1040    2062       1;
    1040    2492       1;
    1041     354       2;
    1041     816       1;
    1041    1197       1;
    1041    1220       1;
    1041    1270       1;
    1043     356       1;
    1043     816       2;
    1043    1373       1;
    1043    2776       1;
    1044      65       1;
    1044     223       1;
    1044     816       3;
    1044     899       1;
    1044    1548       1;
    1044    2273       1;
    1044    2822       1;
    1045     223       2;
    1046     223       6;
    1046    2273       2;
    1047      65       1;
    1047     156       1;
    1047     208       1;
    1047     223       1;
    1047     354       1;
    1047     432       1;
    1047     850       1;
    1047     972       2;
    1047    1054       1;
    1047    1459       2;
    1047    1596       1;
    1047    2424       1;
    1050     223       1;
    1051      65       1;
    1051     223       6;
    1051     356       1;
    1051    1127       2;
    1051    1439       1;
    1051    1459       2;
    1051    1493       1;
    1051    2296       1;
    1051    2925       1;
    1052     354       1;
    1052     753       1;
    1052    1778       1;
    1052    2296       1;
    1052    2406       1;
    1052    2636       1;
    1052    2839       1;
    1053     266       1;
    1053     354       1;
    1053     438       1;
    1053     816       1;
    1053    1459       4;
    1054     266       1;
    1054    1270       2;
    1054    1783       2;
    1054    2776       1;
    1054    2822       1;
    1056       8       1;
    1056     286       1;
    1056     354       1;
    1056     816       1;
    1056     850       1;
    1057     354       1;
    1057    1270       2;
    1057    1636       1;
    1057    1884       1;
    1057    2721       1;
    1058    1010       1;
    1059     354       1;
    1059     972       2;
    1059    1270       1;
    1059    1373       2;
    1059    2406       1;
    1060     266       1;
    1060     816       1;
    1060    1270       1;
    1060    1373       1;
    1060    1459       1;
    1061     354       3;
    1061    1149       1;
    1061    1373       1;
    1061    1446       1;
    1061    1523       2;
    1062      65       1;
    1062     223       1;
    1062    1596       4;
    1063     356       2;
    1063    1054       1;
    1063    1459       1;
    1063    1688       2;
    1064     297       4;
    1064     432       1;
    1064    1459       3;
    1064    1636       1;
    1064    2062       1;
    1064    2193       2;
    1064    2296       1;
    1064    2815       2;
    1065     286       1;
    1065    1446       1;
    1065    1596       1;
    1065    1636       1;
    1065    2273       1;
    1066     893       1;
    1066    1373       3;
    1066    1524       1;
    1066    2193       1;
    1066    2320       1;
    1067     223       1;
    1067     392       2;
    1067     438       1;
    1068      49       1;
    1068      93       1;
    1068     177       1;
    1068    1071       1;
    1068    1270       1;
    1069     223       2;
    1070      87       2;
    1071     208       1;
    1072      49       2;
    1072     283       1;
    1072     893       1;
    1072    1010       2;
    1072    1604       1;
    1072    1732       1;
    1072    2813       3;
    1073    1054       2;
    1074     223       1;
    1074    1596       4;
    1075    1596       5;
    1075    1599       1;
    1075    2150       1;
    1077    1373       1;
    1077    1604       3;
    1078     223       3;
    1078    1071       2;
    1078    1459       1;
    1078    1688       1;
    1079    1054       1;
    1079    2424       1;
    1079    2492       1;
    1080      65       1;
    1081      49       1;
    1081     223       2;
    1081    1040       1;
    1081    1688       2;
    1082     283       2;
    1082    1054       2;
    1082    1071       1;
    1082    1373       1;
    1082    1459       1;
    1082    1688       3;
    1082    2273       1;
    1082    2492       1;
    1083    1054       2;
    1083    2237       1;
    1084     223       2;
    1084    1071       2;
    1084    2406       1;
    1085    1373       1;
    1085    1688       2;
    1085    2776       3;
    1086    2776       1;
    1086    2822       1;
    1087     356       1;
    1087    1010       1;
    1087    1054       2;
    1087    1323       1;
    1087    1478       1;
    1087    2011       1;
    1087    2776       2;
    1088      65       1;
    1088     303       1;
    1088     356       2;
    1088    1054       2;
    1088    1548       1;
    1088    1783       1;
    1088    2106       1;
    1088    2776       4;
    1089     432       1;
    1089    1010       1;
    1089    1451       2;
    1089    2815       1;
    1089    2925       1;
    1090     857       1;
    1090    2164       1;
    1090    2224       1;
    1091    1459       1;
    1091    1555       1;
    1091    1636       1;
    1091    1689       1;
    1092     816       1;
    1092    1309       1;
    1092    1493       1;
    1092    1636       2;
    1092    2296       1;
    1093     356       1;
    1093     996       1;
    1093    1446       1;
    1093    1712       4;
    1094     906       2;
    1094    1459       2;
    1094    1599       1;
    1094    2011       1;
    1094    2062       1;
    1095     356       1;
    1095     432       1;
    1095     542       1;
    1095     996       1;
    1095    1459       1;
    1095    2193       2;
    1095    2925       1;
    1097     441       1;
    1097    1366       2;
    1097    2492       1;
    1098     783       1;
    1098    1447       1;
    1098    1699       3;
    1098    2171       1;
    1099     155       1;
    1099    1783       1;
    1100     223       1;
    1100    1699       1;
    1101    1555       1;
    1101    2193       1;
    1102    1446       2;
    1103     874       1;
    1103    1459       1;
    1103    1636       2;
    1103    2840       1;
    1104       8       1;
    1104      65       2;
    1104     155       2;
    1104     223       5;
    1104     688       1;
    1104    1459       1;
    1104    1596       5;
    1104    2062       3;
    1104    2193       4;
    1104    2273       1;
    1105     223       2;
    1105     432       1;
    1105     893       1;
    1105    1447       1;
    1105    1596       4;
    1105    1604       1;
    1106     155       1;
    1106     223       1;
    1106    1366       1;
    1106    1523       1;
    1106    1596       2;
    1106    1912       1;
    1107     155       5;
    1107    1373       1;
    1107    1459       2;
    1107    2193       1;
    1108    1054       1;
    1108    1309       1;
    1108    1478       1;
    1108    1523       1;
    1108    1596       5;
    1108    1783       1;
    1108    2062       1;
    1108    2208       1;
    1109      98       4;
    1109    1373       2;
    1109    1548       1;
    1109    1783       1;
    1110     356       1;
    1110     979       3;
    1110    1071       1;
    1110    1366       2;
    1110    1493       1;
    1110    2062       1;
    1111       7       1;
    1111     356       2;
    1111    1451       1;
    1111    1596       1;
    1111    1636       1;
    1111    2406       1;
    1112     223       1;
    1112     816       1;
    1112     972       1;
    1112    1373       1;
    1112    1596      10;
    1113     112       2;
    1113     850       1;
    1113    1373       1;
    1113    1555       1;
    1113    2494       2;
    1114     286       2;
    1114    1548       1;
    1114    1596       4;
    1114    2062       1;
    1114    2729       1;
    1114    2776       1;
    1115      65       1;
    1115     816       2;
    1115    1451       1;
    1115    2193       2;
    1115    2492       1;
    1116     223       4;
    1116     438       1;
    1116    1373       1;
    1117     223       3;
    1118     223       3;
    1119      93       1;
    1119     103       1;
    1119     223       4;
    1119     850       1;
    1119    1054       1;
    1119    1459       1;
    1119    2203       1;
    1119    2406       1;
    1120    1373       1;
    1121      93       1;
    1121     223       3;
    1121     850       1;
    1121    1373       1;
    1122      93       1;
    1122     223       5;
    1122    1003       1;
    1122    1523       1;
    1122    1548       2;
    1122    2296       2;
    1123     223       2;
    1124      65       1;
    1124     816       2;
    1124    1596       4;
    1125     354       1;
    1125    1054       1;
    1125    1636       1;
    1125    1893       1;
    1125    2296       1;
    1126     223       2;
    1127     816       1;
    1127    1884       1;
    1127    2318       1;
    1127    2787       1;
    1128    1783       1;
    1128    2296       1;
    1129      87       3;
    1129     208       1;
    1130     177       1;
    1130     223       4;
    1130     735       1;
    1131     686       1;
    1131    1270       1;
    1131    1439       1;
    1131    2788       1;
    1132      87       1;
    1132     223       1;
    1132    2292       1;
    1133      87       2;
    1133     108       1;
    1133     223       1;
    1134      65       1;
    1134     223       1;
    1134     816       1;
    1134     995       1;
    1134    1311       1;
    1134    1412       1;
    1134    1459       1;
    1134    1783       1;
    1134    2353       1;
    1134    2424       1;
    1134    2749       1;
    1135      65       1;
    1135     223       1;
    1135    1884       1;
    1136     156       1;
    1136     223       1;
    1136     816       1;
    1136    1695       1;
    1136    1783       1;
    1136    2273       2;
    1136    2353       1;
    1137     177       1;
    1137     223       1;
    1137     248       1;
    1137     905       1;
    1137    1270       3;
    1137    1373       1;
    1137    1459       1;
    1137    2198       3;
    1137    2822       1;
    1138     248       1;
    1138     905       1;
    1138    1270       1;
    1139    1604       2;
    1140    1596       1;
    1140    2283       2;
    1140    2580       1;
    1141      65       1;
    1141    2767       1;
    1142       7       2;
    1143    1010       1;
    1143    1604       3;
    1143    1699       1;
    1143    2925       2;
    1144     234       1;
    1144     979       2;
    1144    1002       1;
    1144    1009       2;
    1144    1204       1;
    1144    1373       1;
    1144    1783       1;
    1144    2815       1;
    1145     100       1;
    1145     223       2;
    1145    2406       1;
    1146     177       1;
    1146     223       2;
    1147       5       4;
    1147      65       2;
    1147     155       1;
    1147     356       2;
    1147     441       1;
    1147     532       1;
    1147    1076       2;
    1147    1373       1;
    1147    1548       1;
    1147    1596       7;
    1147    1604       1;
    1147    2296       2;
    1147    2389       1;
    1147    2822       1;
    1148     155       1;
    1148     405       2;
    1148     530       1;
    1149    1548       1;
    1149    1596       2;
    1150    2840       1;
    1151       7       2;
    1151     356       1;
    1151    1596       2;
    1151    2011       1;
    1152    1783       2;
    1153    1054       1;
    1153    1596       1;
    1153    1783       1;
    1153    2478       1;
    1154     156       1;
    1154     283       1;
    1154     816       1;
    1154    1010       1;
    1154    1054       1;
    1154    1447       1;
    1154    1548       1;
    1154    1783       1;
    1155     816       2;
    1155    1447       2;
    1155    2296       1;
    1156    1459       3;
    1156    2635       3;
    1157    1313       1;
    1157    1366       1;
    1157    1596       2;
    1157    2635       1;
    1158     155       1;
    1158     223       1;
    1158     836       1;
    1158    1323       1;
    1158    1636       1;
    1159     155       2;
    1159     223       3;
    1159     283       1;
    1159     979       1;
    1159    2635       1;
    1160     177       4;
    1160     356       1;
    1160    1604       1;
    1160    1636       1;
    1160    1783       1;
    1160    2839       1;
    1161      65       1;
    1161     155       3;
    1161    1054       1;
    1161    1317       1;
    1161    1596       1;
    1162     996       2;
    1162    2815       2;
    1162    2823       1;
    1163    2565       1;
    1163    2815       1;
    1164     234       1;
    1164     906       2;
    1164     996       2;
    1164    1054       2;
    1164    1783       2;
    1164    2193       1;
    1164    2815       1;
    1165     816       1;
    1165    2930       3;
    1166       9       1;
    1166    1317       3;
    1166    2815       1;
    1166    2930       1;
    1167     356       1;
    1167     857       2;
    1167    1220       1;
    1167    1309       1;
    1167    1459       2;
    1167    1783       2;
    1168     108       1;
    1168     432       1;
    1168    1689       2;
    1168    1691       2;
    1168    2930       1;
    1169      65       1;
    1169     356       2;
    1169     996       1;
    1169    1323       1;
    1169    1439       2;
    1169    1451       2;
    1169    1599       1;
    1169    1636       2;
    1169    2788       1;
    1169    2797       1;
    1169    2815       4;
    1169    2930       1;
    1170     108       1;
    1170    1054       1;
    1170    1451       1;
    1170    1636       1;
    1170    2815       2;
    1171     100       1;
    1171     223       2;
    1172      65       2;
    1172     100       2;
    1172     392       1;
    1172     816       1;
    1172    1912       1;
    1172    2193       1;
    1172    2273       1;
    1172    2347       1;
    1173     223       2;
    1173    1317       1;
    1173    1851       1;
    1175    1054       1;
    1175    1548       1;
    1175    1884       1;
    1176      87       3;
    1176     223       3;
    1176     789       1;
    1177      65       1;
    1177      87       1;
    1177     223       3;
    1178      87       3;
    1178     223       4;
    1178     850       1;
    1178    1439       1;
    1179     354       1;
    1179     582       2;
    1179    1364       1;
    1179    1493       1;
    1179    1596       6;
    1179    2062       1;
    1180     356       1;
    1180    1604       2;
    1180    1943       1;
    1180    2406       1;
    1181     248       1;
    1181     438       1;
    1181    1071       2;
    1181    1309       1;
    1181    1783       1;
    1182     223       1;
    1182     354       1;
    1182    1071       2;
    1182    1478       1;
    1183     223       1;
    1183     248       3;
    1183    2273       1;
    1184     156       1;
    1184     392       1;
    1184     438       1;
    1184     893       1;
    1184    1520       1;
    1184    1596       2;
    1184    1783       1;
    1184    2492       1;
    1184    2534       1;
    1185     155       5;
    1185     899       2;
    1185    1323       1;
    1185    1504       1;
    1185    1604       1;
    1185    2635       1;
    1186      65       1;
    1186    1071       1;
    1187      65       1;
    1187     177       1;
    1187    1002       1;
    1187    1010       1;
    1187    1040       1;
    1187    1101       3;
    1187    2406       1;
    1188     942       1;
    1188     979       1;
    1188    1040       2;
    1188    1373       1;
    1188    1596       3;
    1188    2424       1;
    1189       8       2;
    1189      65       1;
    1189     582       1;
    1189    1002       1;
    1189    1071       2;
    1189    1604       1;
    1190     392       1;
    1190    1010       1;
    1190    1373       1;
    1190    1459       1;
    1190    1604       2;
    1191     155       1;
    1191     223       2;
    1191    1373       1;
    1191    1459       1;
    1191    1615       1;
    1192     108       1;
    1192     155       3;
    1192     979       1;
    1192    1373       1;
    1193     354       3;
    1193     438       1;
    1193    1459       1;
    1193    1596       5;
    1193    1851       1;
    1194    1054       1;
    1194    1071       2;
    1194    1596       1;
    1194    1783       1;
    1194    2492       1;
    1194    2726       1;
    1195     111       1;
    1195     874       1;
    1195     893       2;
    1195    1555       2;
    1195    2193       1;
    1195    2296       1;
    1196    1459       1;
    1197     297       3;
    1197    1373       2;
    1197    1596       7;
    1198      65       1;
    1198     155       1;
    1198     582       4;
    1198     816       1;
    1198     850       1;
    1198    1373       3;
    1198    2904       1;
    1199      65       1;
    1199     155       1;
    1199    1054       1;
    1199    1373       1;
    1199    1459       1;
    1199    1504       1;
    1199    1604       3;
    1199    2193       3;
    1199    2635       2;
    1200     441       1;
    1201     816       5;
    1201    1002       2;
    1201    1003       1;
    1201    1596       6;
    1201    1783       1;
    1201    2193      11;
    1201    2208       2;
    1202      95       1;
    1202     248       1;
    1202     816       2;
    1202    1220       1;
    1202    1596       1;
    1202    1851       1;
    1202    2280       3;
    1202    2406       2;
    1203       7       1;
    1203     152       1;
    1203     354       1;
    1203     356       1;
    1203     801       1;
    1203    1459       1;
    1203    1604       1;
    1203    2280       1;
    1203    2721       1;
    1204     155       4;
    1204     354       1;
    1204    1076       1;
    1204    1366       1;
    1204    1373       1;
    1204    1459       1;
    1204    1604       1;
    1205       7       1;
    1205     494       1;
    1205    1010       1;
    1205    1116       1;
    1205    1447       1;
    1205    1548       1;
    1205    1783       1;
    1205    2062       1;
    1205    2280       1;
    1205    2637       1;
    1205    2746       1;
    1205    2813       1;
    1205    2925       1;
    1206     689       1;
    1206     990       1;
    1207       8       2;
    1207      65       2;
    1207     996       1;
    1207    2478       2;
    1207    2925       1;
    1208    1447       1;
    1208    2208       1;
    1209      65       1;
    1209     816       1;
    1209    1064       1;
    1209    1309       1;
    1209    1373       1;
    1209    1493       2;
    1209    1596       1;
    1209    2406       1;
    1210     432       1;
    1210    1071       2;
    1211    1220       1;
    1211    1596       1;
    1211    2011       1;
    1212      49       1;
    1212      65       1;
    1212     816       1;
    1212    1596       1;
    1212    2011       1;
    1213      65       1;
    1213     155       7;
    1213     582       1;
    1213     816       1;
    1213     979      10;
    1213    1054       1;
    1213    1373       1;
    1213    1596       1;
    1213    1783       1;
    1214     223       1;
    1214     753       2;
    1214    1596       4;
    1214    1688       1;
    1214    1783       1;
    1214    2904       1;
    1215     155       1;
    1215     816       1;
    1215    1076       1;
    1215    1548       1;
    1216    1373       1;
    1216    1523       4;
    1216    1783       1;
    1216    2193       1;
    1217      65       1;
    1217     155       1;
    1217    1076       1;
    1217    2354       1;
    1217    2534       1;
    1217    2908       1;
    1218     356       1;
    1218    1596       4;
    1218    1622       1;
    1218    2011       1;
    1218    2193       1;
    1218    2296       1;
    1219     356       2;
    1219    1783       1;
    1219    1960       1;
    1219    2776       1;
    1219    2908       1;
    1220       8       1;
    1220     297       2;
    1220     432       1;
    1220     689       1;
    1220     816       1;
    1220     893       2;
    1220     959       1;
    1220    1447       1;
    1220    2294       2;
    1220    2813       1;
    1221    1309       1;
    1221    1373       1;
    1221    1604       1;
    1221    2567       2;
    1222     155       2;
    1222    1447       2;
    1222    2296       1;
    1223      65       1;
    1223     906       1;
    1223    1459       2;
    1223    2193       1;
    1224    1323       2;
    1224    1447       1;
    1224    1596       3;
    1224    1783       1;
    1224    2406       1;
    1224    2557       1;
    1224    2776       1;
    1225      65       2;
    1225     689       2;
    1225     816       4;
    1225     893       1;
    1225    1373       1;
    1225    1447       1;
    1225    1459       2;
    1225    1493       1;
    1225    1599       4;
    1225    2721       1;
    1226     155       2;
    1226     283       2;
    1226    1310       2;
    1226    1504       2;
    1226    1604       2;
    1227     850       1;
    1228     248       1;
    1228     354       1;
    1228     850       1;
    1229     392       1;
    1229     816       1;
    1229     850       1;
    1229    1048       1;
    1229    1373       1;
    1229    1459       1;
    1229    2193       1;
    1229    2635       1;
    1230     248       5;
    1230     461       1;
    1230    1010       1;
    1230    1459       2;
    1230    1604       1;
    1230    1642       1;
    1231     979       2;
    1231    1596       2;
    1232      61       1;
    1232    1783       2;
    1233      22       1;
    1233     647       1;
    1233    1071       2;
    1233    1783       1;
    1233    2424       1;
    1233    2492       1;
    1234     223       2;
    1234    1071       2;
    1235    1373       1;
    1235    1688       1;
    1235    2195       2;
    1236     155       1;
    1236    1270       1;
    1237     155       1;
    1237     354       1;
    1237    1504       1;
    1237    1604       3;
    1237    2635       1;
    1238      65       1;
    1238     438       1;
    1238    1104       2;
    1238    1548       1;
    1238    1596       1;
    1238    2729       1;
    1239      65       1;
    1239     103       1;
    1239     893       1;
    1239    1116       1;
    1239    1373       1;
    1239    1493       1;
    1239    1548       1;
    1239    1596      19;
    1239    1783       3;
    1239    2296       1;
    1239    2721       2;
    1239    2822       2;
    1240     893       1;
    1240     933       1;
    1240    1596       1;
    1240    2280       1;
    1240    2406       1;
    1241     155       1;
    1241    1596       1;
    1241    1642       1;
    1241    2171       1;
    1241    2193       1;
    1242      65       1;
    1242     223       1;
    1242     354       1;
    1242    1010       1;
    1242    1373       5;
    1242    2884       1;
    1243    1596       6;
    1244     156       1;
    1244     356       2;
    1244     392       2;
    1244     614       1;
    1244     687       1;
    1244     736       1;
    1244     893       3;
    1244     995       2;
    1244    1003       1;
    1244    1604       1;
    1244    1912       3;
    1244    2296       2;
    1244    2424       1;
    1244    2534       1;
    1244    2557       3;
    1244    2839       1;
    1245      65       1;
    1245    1596       1;
    1245    1604       1;
    1245    1832       1;
    1245    2492       1;
    1246     356       1;
    1246    1373       1;
    1246    1447       1;
    1246    1695       1;
    1246    1783       1;
    1246    1953       1;
    1246    2424       1;
    1246    2925       1;
    1247    1596       8;
    1247    1615       2;
    1247    2354       1;
    1248     248       8;
    1248     354       1;
    1248     432       1;
    1248     850       1;
    1248    1040       1;
    1248    1054       1;
    1248    1373       1;
    1248    1596       2;
    1248    1604       1;
    1248    2492       2;
    1249     895       1;
    1249     972       1;
    1249    1604       1;
    1249    2884       1;
    1250     155       1;
    1250     356       1;
    1251      65       1;
    1251     283       1;
    1251     354       1;
    1251     432       1;
    1251    1071       2;
    1251    1323       1;
    1251    1783       1;
    1252       8       1;
    1252      65       1;
    1252     893       1;
    1252    1309       1;
    1252    1604       1;
    1253     223       1;
    1253    1054       1;
    1253    1071       1;
    1253    1596       1;
    1253    1783       1;
    1254     893       1;
    1254    2492       1;
    1255     108       1;
    1255     112       1;
    1255     155       1;
    1255     249       1;
    1255    1373       1;
    1255    1447       1;
    1255    1459       1;
    1255    1596       5;
    1255    1604       1;
    1255    2884       1;
    1256     223       2;
    1256    1851       1;
    1257      65       1;
    1257    2062       1;
    1258     155       4;
    1258     223       3;
    1258     874       1;
    1258    1054       1;
    1258    1373       1;
    1258    1615       1;
    1258    1783       2;
    1258    2904       1;
    1259     816       1;
    1259    1054       1;
    1259    1071       1;
    1259    1493       1;
    1259    1596       3;
    1259    2557       1;
    1260     248       1;
    1260     665       1;
    1260    1373       1;
    1260    1688       1;
    1260    2557       1;
    1261     323       1;
    1261     816       1;
    1261    1002       1;
    1261    1599       2;
    1261    2011       1;
    1261    2280       1;
    1262    1493       2;
    1262    1596       2;
    1263      65       2;
    1263     155       4;
    1263     223       1;
    1263     356       2;
    1263     461       1;
    1263    1054       1;
    1263    1127       1;
    1263    1317       1;
    1263    1373       1;
    1263    1596       4;
    1263    2296       2;
    1263    2925       1;
    1264     155       3;
    1264    1116       1;
    1264    1373       1;
    1264    1604       1;
    1264    1783       2;
    1264    2925       1;
    1265      65       1;
    1265      98       1;
    1265    1493       1;
    1265    2406       1;
    1266     816       1;
    1266    1478       1;
    1267     248       1;
    1267     816       1;
    1267    1071       1;
    1267    1783       1;
    1268     155       1;
    1268     356       1;
    1268    1523       1;
    1268    1548       1;
    1268    1596       1;
    1268    1604       3;
    1268    1732       1;
    1268    1783       1;
    1268    2201       1;
    1268    2494       1;
    1268    2813       2;
    1268    2925       1;
    1269     689       1;
    1269    1783       2;
    1270      95       2;
    1270     155       1;
    1270     996       1;
    1270    1230       1;
    1270    1317       1;
    1270    1459       1;
    1270    2011       1;
    1271      65       1;
    1271     223       1;
    1271     356       2;
    1271     438       1;
    1271    1076       1;
    1271    1447       1;
    1271    1783       1;
    1271    2424       1;
    1271    2635       1;
    1271    2897       1;
    1273      65       1;
    1273     972       1;
    1273    1104       1;
    1274     248       1;
    1274    1317       1;
    1274    1366       1;
    1274    1459       1;
    1274    1596       5;
    1274    1604       4;
    1274    2108       1;
    1275    1459       3;
    1276    1270       1;
    1277     392       1;
    1277     433       2;
    1277     893       1;
    1277    1373       1;
    1277    1459       2;
    1277    1783       3;
    1278      99       1;
    1278     816       3;
    1278    1270       1;
    1278    1373       1;
    1278    1493       1;
    1278    1523       3;
    1278    1548       2;
    1278    1783       2;
    1278    2729       1;
    1278    2813       1;
    1279      65       1;
    1279     286       2;
    1279     356       1;
    1279     441       1;
    1279    1010       1;
    1279    1310       1;
    1279    1323       1;
    1279    1596       2;
    1279    1783       1;
    1279    2534       1;
    1280      65       1;
    1280     108       1;
    1280     112       1;
    1280     297       3;
    1280     933       2;
    1280    1116       1;
    1280    1435       1;
    1280    1447       1;
    1280    1459       1;
    1280    2788       1;
    1281      65       1;
    1281     155       1;
    1281    1373       1;
    1281    1596       1;
    1281    1783       1;
    1282     122       1;
    1282     155       3;
    1282     356       1;
    1283     155       1;
    1283     223       2;
    1283    1459       1;
    1283    2923       1;
    1284     158       1;
    1284     816       1;
    1284     893       1;
    1284     942       1;
    1284    1373       1;
    1284    1636       1;
    1284    1783       1;
    1284    2273       3;
    1286     112       1;
    1286    1459       2;
    1286    1604       5;
    1287    1523       1;
    1288      65       1;
    1288    1054       1;
    1288    1604       1;
    1288    1783       1;
    1289     297       1;
    1289    1373       1;
    1289    1447       1;
    1289    1884       1;
    1289    2787       1;
    1289    2822       1;
    1290       8       1;
    1290     156       1;
    1290    1309       1;
    1290    1447       2;
    1290    1636       1;
    1290    1783       1;
    1291    1054       1;
    1291    1076       2;
    1292     223       1;
    1292     248       1;
    1292     392       1;
    1292     893       1;
    1292    1373       2;
    1292    1459       4;
    1292    2492       1;
    1293      87       1;
    1293     223       2;
    1293    1884       1;
    1294    1003       1;
    1294    1270       1;
    1294    1373       1;
    1294    1523       2;
    1294    2839       1;
    1295     177       1;
    1295     283       1;
    1295    1459       1;
    1295    1493       1;
    1295    1604       1;
    1295    1783       2;
    1295    2839       3;
    1296      65       1;
    1296     248       1;
    1296     354       1;
    1296     461       2;
    1296    1596       2;
    1296    1604       2;
    1296    1642       2;
    1296    2424       1;
    1297      99       1;
    1297     112       1;
    1297     248       2;
    1297     461       1;
    1297    1058       1;
    1297    1309       1;
    1297    1478       1;
    1297    1596       2;
    1298    1459       1;
    1300       8       1;
    1300      93       1;
    1300     155       2;
    1300     223       2;
    1300     893       4;
    1300    1548       2;
    1300    2062       1;
    1301      65       2;
    1301    1220       1;
    1301    1596       5;
    1301    1884       1;
    1302      65       4;
    1302      89       1;
    1302     816       3;
    1302    1373       1;
    1302    1884       1;
    1302    2062       1;
    1302    2167       1;
    1302    2280       1;
    1303     356       2;
    1303    1054       1;
    1303    1596       1;
    1304      65       1;
    1304    1006       1;
    1304    1596       3;
    1304    1783       1;
    1305     392       2;
    1305    1373       1;
    1305    1596       1;
    1306     979       1;
    1306    1646       1;
    1307     155       4;
    1307     223       1;
    1307     850       1;
    1307     979       2;
    1307    1373       4;
    1307    1615       1;
    1307    2273       1;
    1308    1373       1;
    1308    1439       1;
    1309     354       1;
    1309     356       1;
    1309     438       1;
    1309     582       2;
    1309     979       5;
    1309    1010       1;
    1309    1040       2;
    1309    1071       2;
    1309    1373       2;
    1309    1596       2;
    1309    1691       1;
    1309    1783       1;
    1310     156       1;
    1310     195       1;
    1310     223       1;
    1310     248       1;
    1310     392       1;
    1310     438       1;
    1310     797       1;
    1310     979       1;
    1310    1493       1;
    1310    1596       5;
    1310    1604       1;
    1310    2212       1;
    1310    2294       1;
    1310    2296       1;
    1310    2809       1;
    1311      65       1;
    1311    1373       1;
    1311    2296       2;
    1312    1604       4;
    1313      65       2;
    1313      93       1;
    1313     248       4;
    1313     836       1;
    1313    1002       1;
    1313    1493       1;
    1313    1548       1;
    1313    1604       2;
    1313    1622       1;
    1313    1636       2;
    1313    2417       1;
    1313    2822       1;
    1314    1783       1;
    1315     248       1;
    1315    1373       1;
    1315    1604       2;
    1316     441       1;
    1316     532       1;
    1316    1116       3;
    1316    1555       1;
    1316    1562       1;
    1316    1884       1;
    1316    2100       1;
    1316    2108       1;
    1316    2224       1;
    1316    2884       1;
    1318     152       1;
    1318    1116       2;
    1318    1596       1;
    1318    1604       1;
    1318    1615       1;
    1318    2108       2;
    1319     248       1;
    1319     532       1;
    1319    1317       1;
    1319    1366       1;
    1319    1459       1;
    1319    1596       5;
    1319    1604       4;
    1319    2108       1;
    1320       7       1;
    1320     208       1;
    1320     297       1;
    1320     356       1;
    1320     816       2;
    1320    1054       2;
    1320    1064       1;
    1320    1373       1;
    1320    1459       1;
    1320    2884       1;
    1321      65       1;
    1321     100       1;
    1321     356       1;
    1321     735       1;
    1321    1270       1;
    1321    1459       1;
    1321    1548       1;
    1322    2884       2;
    1323      98       1;
    1323     103       1;
    1323    2925       1;
    1324     103       1;
    1324     356       1;
    1324    1040       1;
    1324    1309       1;
    1324    1317       1;
    1324    1447       1;
    1324    2764       2;
    1325      98       8;
    1325     176       1;
    1325     356       1;
    1325     816       2;
    1325     850       1;
    1325    1317       2;
    1325    1323       1;
    1325    1493       1;
    1325    1773       2;
    1325    2062       1;
    1325    2610       1;
    1325    2805       9;
    1326     248       3;
    1326     893       1;
    1326    1002       1;
    1326    1220       1;
    1326    1555       1;
    1327    1054       1;
    1328    1447       2;
    1328    1596       5;
    1328    2721       1;
    1329      65       1;
    1329     286       1;
    1329    1040       2;
    1329    2710       1;
    1330      65       1;
    1330     152       3;
    1330     665       1;
    1330    1010       1;
    1330    1270       1;
    1330    1373       1;
    1330    1459       1;
    1330    2193       1;
    1330    2729       1;
    1331      65       1;
    1331     505       1;
    1331     996       2;
    1331    1373       1;
    1331    1459       1;
    1331    2320       1;
    1332     297       2;
    1332    1447       1;
    1332    1459       2;
    1332    2320       1;
    1333      65       2;
    1333      99       1;
    1333     149       2;
    1334     297       2;
    1334    1447       1;
    1334    1459       1;
    1334    2320       1;
    1335      65       1;
    1335     248       1;
    1335    1459       1;
    1335    1604       2;
    1335    1845       1;
    1335    2193       1;
    1335    2296       1;
    1336     703       1;
    1336    1040       1;
    1336    1054       1;
    1336    1149       1;
    1336    1451       1;
    1336    1493       1;
    1336    1596       1;
    1336    1783       2;
    1336    2478       2;
    1337     850       1;
    1337    1783       1;
    1338     356       4;
    1338    1323       2;
    1338    2193       3;
    1339     736       1;
    1339    1373       3;
    1339    1447       2;
    1339    2787       1;
    1340       8       1;
    1340     100       1;
    1340     816       1;
    1340    1040       1;
    1340    2296       1;
    1340    2805       4;
    1341       7       1;
    1341     356       7;
    1341    1071       1;
    1341    1373       1;
    1341    2193       1;
    1342      65       1;
    1342     108       1;
    1342     354       1;
    1342    1040       1;
    1342    1079       1;
    1342    1373       1;
    1342    1548       1;
    1342    1884       1;
    1342    1953       1;
    1343     356       1;
    1343    1001       1;
    1343    2193       1;
    1343    2721       1;
    1344    1054       1;
    1344    1076       1;
    1344    2193       5;
    1344    2534       2;
    1345    1912       3;
    1346       8       1;
    1346      65       1;
    1346     177       1;
    1346     356       2;
    1346     441       1;
    1346    1912       1;
    1347    1604       1;
    1347    2184       2;
    1347    2813       1;
    1347    2925       1;
    1348     155       1;
    1348    1548       1;
    1348    2273       1;
    1348    2296       1;
    1348    2534       1;
    1349     996       2;
    1349    1373       1;
    1349    1459       2;
    1349    1636       2;
    1350       7       1;
    1350    1596       2;
    1351     223       5;
    1351    1373       1;
    1351    1459       1;
    1351    1596       2;
    1351    1783       1;
    1352       8       1;
    1352    1373       3;
    1352    1596       4;
    1352    2062       1;
    1352    2167       1;
    1352    2492       1;
    1353     248       1;
    1353     816       1;
    1353    1523       3;
    1354     874       1;
    1354    1310       1;
    1354    1446       2;
    1354    2193       2;
    1355     155       2;
    1355     816       1;
    1355    2193       1;
    1355    2478       1;
    1356     356       2;
    1356     582       1;
    1356     999       1;
    1356    1116       1;
    1356    1373       1;
    1356    1596       1;
    1356    1615       2;
    1356    2721       1;
    1357     286       1;
    1358     286       1;
    1359     223       5;
    1359     286       2;
    1360     286       1;
    1360    1373       1;
    1361     392       1;
    1361    1003       1;
    1361    1523       3;
    1361    2320       1;
    1362     248       1;
    1362    1524       1;
    1362    2062       1;
    1362    2839       1;
    1363     850       2;
    1363    1054       3;
    1363    1820       1;
    1363    2729       2;
    1364     893       1;
    1364    1204       1;
    1364    1459       2;
    1364    2280       1;
    1364    2296       1;
    1365     283       1;
    1365     816       1;
    1365    1270       1;
    1365    1373       1;
    1365    2062       1;
    1366     155       4;
    1366     363       1;
    1366    1373       1;
    1366    2776       1;
    1367    1384       1;
    1367    2280       1;
    1368    2534       1;
    1369    1636       1;
    1369    1688       1;
    1369    2296       1;
    1370     103       2;
    1370     438       1;
    1370    1270       4;
    1370    1373       1;
    1370    1548       1;
    1370    1688       1;
    1370    2167       1;
    1371      65       1;
    1371    2212       1;
    1372      65       2;
    1372     283       4;
    1372     995       4;
    1372    1373       1;
    1372    1548       1;
    1372    1943       1;
    1373     354       2;
    1373     356       1;
    1373     721       1;
    1373     972       2;
    1373    1373       2;
    1373    1439       1;
    1373    1447       6;
    1373    1596       7;
    1373    1604       1;
    1373    2273       3;
    1373    2721       1;
    1373    2813       3;
    1374      65       1;
    1374     283       1;
    1374     356       1;
    1374     995       1;
    1374    1604       1;
    1374    2406       1;
    1374    2710       1;
    1375      65       1;
    1375    1010       1;
    1375    1054       1;
    1375    1373       2;
    1375    1604       2;
    1375    2011       1;
    1375    2534       3;
    1376     885       1;
    1377       7       1;
    1377    1447       1;
    1377    1523       1;
    1377    1596       2;
    1377    2776       1;
    1378    1459       1;
    1379     177       1;
    1379    1366       1;
    1379    1373       1;
    1379    2788       1;
    1380     906       1;
    1380     996       2;
    1380    1447       1;
    1380    1596       1;
    1380    1599       1;
    1380    2296       1;
    1380    2424       1;
    1380    2494       1;
    1380    2721       1;
    1381     155       2;
    1381     223       2;
    1381    1447       1;
    1381    1596       3;
    1381    2904       1;
    1382     223       2;
    1382    1054       1;
    1382    2280       2;
    1383     438       1;
    1383     736       1;
    1383    2062       1;
    1383    2280       1;
    1384     223       1;
    1384     850       1;
    1384    1270       1;
    1385     223       2;
    1385     354       1;
    1385     356       4;
    1385     816       1;
    1385    1054       1;
    1385    2813       1;
    1386     155       3;
    1386    1373       2;
    1386    1548       1;
    1386    1599       2;
    1387     266       5;
    1387     301       2;
    1387     899       2;
    1387    1548       1;
    1387    2296       1;
    1388    1523       2;
    1388    1695       1;
    1388    1783       1;
    1388    2822       1;
    1389    1054       1;
    1389    1270       2;
    1389    1912       2;
    1390       7       1;
    1390     434       1;
    1390    1054       1;
    1390    1071       1;
    1390    1373       1;
    1390    1447       3;
    1390    1596       2;
    1390    1615       2;
    1391      65       1;
    1391      89       1;
    1391     356       1;
    1391     816       1;
    1391    1010       1;
    1391    1076       1;
    1391    1373       1;
    1391    1596       3;
    1391    1688       1;
    1391    1783       1;
    1392     266       4;
    1392     899       3;
    1392    2296       2;
    1392    2776       1;
    1392    2884       1;
    1393     155       5;
    1393     356       2;
    1393    1447       1;
    1393    1596       6;
    1393    1615       2;
    1394      93       1;
    1394     155       3;
    1394     816       2;
    1394    1596       2;
    1394    1688       1;
    1394    2283       1;
    1394    2296       1;
    1394    2787       1;
    1395     155       3;
    1395     223       1;
    1395    1720       1;
    1396      65       1;
    1396     266       2;
    1397     286       1;
    1398    1064       1;
    1398    1270       2;
    1398    2062       1;
    1399      65       1;
    1399    2729       1;
    1400     286       2];

A = zeros(3000,1400);

for j = 1: 6511
    A(B(j,2),B(j,1)) = B(j,3);
end

s1 = 68.61089768224771;

