clear;
addpath('..');

disp(' ');
disp('==========================================================');
disp('    high rank matrices');
disp('----------------------------------------------------------');
disp('Demo:  Row Updating (rank increasing)');

disp(' ');
disp('     Generate A (1000x500) and B (30x500) by hrowup01 ..... ');
[A,B,tol] = hrowup01;
[r,~,C] = NumericalRank(A,tol);
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Update 30 rows ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,1)+1;
    vec = B(jj,:);
    [r,~,C] = NumericalRankUpdate(A,pth,vec,C,'row');
    A = [A;vec];
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Row Updating (rank invariant)');

disp(' ');
disp('     Generate A (1000x500) and B (30x500) by hrowup02 ..... ');
[A,B,tol] = hrowup02;
[r,~,C] = NumericalRank(A,tol);
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Update 30 rows ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,1)+1;
    vec = B(jj,:);
    [r,~,C] = NumericalRankUpdate(A,pth,vec,C,'row');
    A = [A;vec];
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Column Updating (rank increasing)');

disp(' ');
disp('     Generate A (1000x500) and B (1000x30) by hcolup01 ..... ');
[A,B,tol] = hcolup01;
[r,~,C] = NumericalRank(A,tol);
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Update 30 columns ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,2)+1;
    vec = B(:,jj);
    [r,~,C] = NumericalRankUpdate(A,pth,vec,C,'column');
    A = [A vec];
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Column Updating (rank invariant)');

disp(' ');
disp('     Generate A (1000x500) and B (1000x30) by hcolup02 ..... ');
[A,B,tol] = hcolup02;
[r,~,C] = NumericalRank(A,tol);
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Update 30 columns ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,2)+1;
    vec = B(:,jj);
    [r,~,C] = NumericalRankUpdate(A,pth,vec,C,'column');
    A = [A vec];
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');


disp('==========================================================');
disp(' ');
disp('   low rank matrices');
disp('----------------------------------------------------------');
disp('Demo:  Row Updating (rank increasing)');

disp(' ');
disp('     Generate A (1000x500) and B (30x500) by lrowup01 ..... ');
[A,B,tol] = lrowup01;
[r,~,C] = NumericalRank(A,tol,'low rank');
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Update 30 rows ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,1)+1;
    vec = B(jj,:);
    [r,~,C] = NumericalRankUpdate(A,pth,vec,C,'row');
    A = [A;vec];
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Row Updating (rank invariant)');

disp(' ');
disp('     Generate A (1000x500) and B (30x500) by lrowup02 ..... ');
[A,B,tol] = lrowup02;
[r,~,C] = NumericalRank(A,tol,'low rank');
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Update 30 rows ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,1)+1;
    vec = B(jj,:);
    [r,~,C] = NumericalRankUpdate(A,pth,vec,C,'row');
    A = [A;vec];
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Column Updating (rank increasing)');

disp(' ');
disp('     Generate A (1000x500) and B (1000x30) by lcolup01 ..... ');
[A,B,tol] = lcolup01;
[r,~,C] = NumericalRank(A,tol,'low rank');
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Update 30 columns ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,2)+1;
    vec = B(:,jj);
    [r,~,C] = NumericalRankUpdate(A,pth,vec,C,'column');
    A = [A vec];
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Column Updating (rank invariant)');

disp(' ');
disp('     Generate A (1000x500) and B (1000x30) by lcolup02 ..... ');
[A,B,tol] = lcolup02;
[r,~,C] = NumericalRank(A,tol,'low rank');
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Update 30 columns ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,2)+1;
    vec = B(:,jj);
    [r,~,C] = NumericalRankUpdate(A,pth,vec,C,'column');
    A = [A vec];
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('==========================================================');

