clear;
addpath('..');

disp(' ');
disp('==========================================================');
disp('Demo:    Sylvester');
disp('         Polynomials have no perturbation');
disp('         matrix size: 2n-by-2n (n = 100, 200, 400, 800)');
disp('         (numerical rank is 2n-10 w.r.t. threshold 1e-12)');

for k = 0:3

    n = 100*2^k;
    [A,Y,tol] = syl_gen(n,10);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; [r,Basis] = NumericalRank(A,tol); tt= etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('    kernel error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');
disp('Demo:    Sylvester');
disp('         Polynomials have perturbation 1e-10');
disp('         matrix size: 2n-by-2n (n = 100, 200, 400, 800)');
disp('         (numerical rank is 2n-10 w.r.t. threshold 1e-8)');

for k = 0:3

    n = 100*2^k;
    [A,Y,tol] = syl_gen(n,10,1e-10);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; [r,Basis] = NumericalRank(A,tol); tt= etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('    kernel error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');
disp('Demo:    Sylvester');
disp('         Polynomials have perturbation 1e-5');
disp('         matrix size: 2n-by-2n (n = 100, 200, 400, 800)');
disp('         (numerical rank is 2n-10 w.r.t. threshold 1e-3)');

for k = 0:3

    n = 100*2^k;
    [A,Y,tol] = syl_gen(n,10,1e-5);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; [r,Basis] = NumericalRank(A,tol); tt= etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('    kernel error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');

