clear;
addpath('..');

disp(' ');
disp('==========================================================');
disp('    high rank matrices');
disp('==========================================================');
disp('Demo:    hhnois');
disp('         matrix size: 2n-by-n (n = 200, 400, 800, 1600)');
disp('         (numerical rank is n-10 w.r.t. threshold 1e-3)');

for k = 1:4

    n = 100*2^k;
    [A,tol,Y] = hhnois(n);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; 
    [r,Basis] = NumericalRank(A,tol); 
    tt = etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('    kernel error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');
disp('Demo:    hmnois');
disp('         matrix size: 2n-by-n (n = 200, 400, 800, 1600)');
disp('         (numerical rank is n-10 w.r.t. threshold 1e-8)');

for k = 1:4

    n = 100*2^k;
    [A,tol,Y] = hmnois(n);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; 
    [r,Basis] = NumericalRank(A,tol); 
    tt = etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('    kernel error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');
disp('Demo:    hlnois');
disp('         matrix size: 2n-by-n (n = 200, 400, 800, 1600)');
disp('         (numerical rank is n-10 w.r.t. threshold 1e-12)');

for k = 1:4

    n = 100*2^k; 
    [A,tol,Y] = hlnois(n);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; 
    [r,Basis] = NumericalRank(A,tol); 
    tt = etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('    kernel error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');
disp(' ');
disp('    low rank matrices');
disp('==========================================================');
disp('Demo:    lhnois');
disp('         matrix size: 2n-by-n (n = 200, 400, 800, 1600)');
disp('         (numerical rank is 10 w.r.t. threshold 1e-3)');

for k = 1:4

    n = 100*2^k;
    [A,tol,Y] = lhnois(n);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; 
    [r,Basis] = NumericalRank(A,tol,'low rank'); 
    tt = etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('     range error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');
disp('Demo:    lmnois');
disp('         matrix size: 2n-by-n (n = 200, 400, 800, 1600)');
disp('         (numerical rank is 10 w.r.t. threshold 1e-8)');

for k = 1:4

    n = 100*2^k;
    [A,tol,Y] = lmnois(n);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; 
    [r,Basis] = NumericalRank(A,tol,'low rank'); 
    tt = etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('     range error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');
disp('Demo:    llnois');
disp('         matrix size: 2n-by-n (n = 200, 400, 800, 1600)');
disp('         (numerical rank is 10 w.r.t. threshold 1e-12)');

for k = 1:4

    n = 100*2^k; 
    [A,tol,Y] = llnois(n);

    disp(' ');disp('-------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    t0 = clock; 
    [r,Basis] = NumericalRank(A,tol,'low rank'); 
    tt = etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('     range error :      %4.3e\n',norm(Basis'*Y));
end

disp(' ');
disp('==========================================================');

