clear;
addpath('..');

disp('==========================================================');
disp('Demo:    Nogap');
disp('         matrix size: n-by-n (n = 200, 400, 800, 1600)');

tol = 1e-3;

for k = 1:4

    n = 100*2^k;

    [A,sv] = nogap(n);
    disp(' ');disp('--------------------------------------------');
    [m,n] = size(A);
    fprintf('  matrix size:   %i x %i \n', m, n);disp(' ');

    rnk = 20*2^k;
    fprintf('     sv(%3i)  =   %6.5e\n',rnk, sv(rnk));
    fprintf('     sv(%3i)  =   %6.5e\n',rnk+1, sv(rnk+1));
    fprintf('   gap ratio  =   %6.5e\n', sv(rnk)/sv(rnk+1));

    disp(' ');
    t0 = clock;
    [r,U] = NumericalRank(A,tol,'low rank');
    tt = etime(clock,t0);
    fprintf('    elapsed time :      %g\n',tt);
    fprintf('   computed rank :      %i\n',r);
    fprintf('  norm(%s) :      %4.3e\n','A - UU''A', norm(A-U*(U'*A)));
    fprintf('   norm(%s) :      %4.3e\n','I - U''U', norm(eye(r)-U'*U));
end
