clear;
addpath('..');

disp(' ');
disp('==========================================================');
disp('Demo:    imagemx      (image01.jpg   size: 640x480) ');
disp('         Remove  1%  noise');

[A,s1] = imagemx('image01.jpg','jpg');

tol = s1*0.01;
t0 = clock; [r,U] = NumericalRank(A,tol,'low rank'); tt= etime(clock,t0);

B = U*(U'*A);

sz = get(0,'ScreenSize');
figure(1); 
set(1,'Position',[1 sz(4)/4 sz(3)/3 sz(3)/4]);
colormap(gray); imagesc(A,[0 1]);
title('The Original Image (size: 640x480)');
figure(2); 
set(2,'Position',[10+sz(3)/3 sz(4)/4 sz(3)/3 sz(3)/4]);
colormap(gray); imagesc(B,[0 1]);
title('The Low Rank Approximation Image');

nrmE = norm(A-B);
disp(' ');
fprintf('     elapsed time :   %g\n',tt);
fprintf('    computed rank :   %i\n',r);
fprintf('    noise removed :   %3.1f %% \n',(nrmE/s1)*100);

pause(2);close(1);close(2);
disp(' ');
disp('==========================================================');
disp('Demo:    imagemx      (image02.jpg   size: 1024x768) ');
disp('         Remove  1%  noise');

[A,s1] = imagemx('image02.jpg','jpg');

tol = s1*0.01;
t0 = clock; [r,U] = NumericalRank(A,tol,'low rank'); tt= etime(clock,t0);

B = U*(U'*A);

sz = get(0,'ScreenSize');
figure(1);
set(1,'Position',[1 sz(4)/4 sz(3)/3 sz(3)/4]);
colormap(gray); imagesc(A,[0 1]);
title('The Original Image (size: 1024x768)');
figure(2); 
set(2,'Position',[10+sz(3)/3 sz(4)/4 sz(3)/3 sz(3)/4]);
colormap(gray); imagesc(B,[0 1]);
title('The Low Rank Approximation Image');

nrmE = norm(A-B);
disp(' ');
fprintf('     elapsed time :   %g\n',tt);
fprintf('    computed rank :   %i\n',r);
fprintf('    noise removed :   %3.1f %% \n',(nrmE/s1)*100);

pause(2);close(1);close(2);
disp(' ');
disp('==========================================================');
disp('Demo:    imagemx      (image03.jpg   size: 1600x1200) ');
disp('         Remove  0.4%  noise');

[A,s1] = imagemx('image03.jpg','jpg');
   
tol = s1*0.004;
t0 = clock; [r,U] = NumericalRank(A,tol,'low rank'); tt= etime(clock,t0);

B = U*(U'*A);

sz = get(0,'ScreenSize');
figure(1);
set(1,'Position',[1 sz(4)/4 sz(3)/3 sz(3)/4]);
colormap(gray); imagesc(A,[0 1]);
title('The Original Image (size: 1600x1200)');
figure(2); 
set(2,'Position',[10+sz(3)/3 sz(4)/4 sz(3)/3 sz(3)/4]);
colormap(gray); imagesc(B,[0 1]);
title('The Low Rank Approximation Image');

nrmE = norm(A-B);
disp(' ');
fprintf('     elapsed time :   %g\n',tt);
fprintf('    computed rank :   %i\n',r);
fprintf('    noise removed :   %3.1f %% \n',(nrmE/s1)*100);

disp(' ');
disp('==========================================================');

