clear;
addpath('..');

disp(' ');
disp('==========================================================');
disp('    high rank matrices');
disp('----------------------------------------------------------');
disp('Demo:  Row Downdating (rank decreasing)');

disp(' ');
disp('     Generate A (1030x500) by hrowdw01 ..... ');
[A,tol] = hrowdw01;
[r,~,C] = NumericalRank(A,tol);
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Downdate 30 rows ..... ');
t0 = clock;
for jj = 1:30
    pth = 1;
    [r,~,C] = NumericalRankDowndate(A,pth,C,'row');
    A = A(2:size(A,1),:);
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Row Downdating (rank invariant)');

disp(' ');
disp('     Generate A (1030x500) by hrowdw02 ..... ');
[A,tol] = hrowdw02;
[r,~,C] = NumericalRank(A,tol);
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Downdate 30 rows ..... ');
t0 = clock;
for jj = 1:30
    pth = 1;
    [r,~,C] = NumericalRankDowndate(A,pth,C,'row');
    A = A(2:size(A,1),:);
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Column Downdating (rank decreasing)');

disp(' ');
disp('     Generate A (1000x530) by hcoldw01 ..... ');
[A,tol] = hcoldw01;
[r,~,C] = NumericalRank(A,tol);
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Downdate 30 columns ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,2);
    [r,~,C] = NumericalRankDowndate(A,pth,C,'column');
    A = A(:,1:pth-1);
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Column Downdating (rank invariant)');

disp(' ');
disp('     Generate A (1000x530) by hcoldw02 ..... ');
[A,tol] = hcoldw02;
[r,~,C] = NumericalRank(A,tol);
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Downdate 30 columns ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,2);
    [r,~,C] = NumericalRankDowndate(A,pth,C,'column');
    A = A(:,1:pth-1);
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');


disp('==========================================================');
disp(' ');
disp('    low rank matrices');
disp('----------------------------------------------------------');
disp('Demo:  Row Downdating (rank decreasing)');

disp(' ');
disp('     Generate A (1030x500) by lrowdw01 ..... ');
[A,tol] = lrowdw01;
[r,~,C] = NumericalRank(A,tol,'low rank');
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Downdate 30 rows ..... ');
t0 = clock;
for jj = 1:30
    pth = 1;
    [r,~,C] = NumericalRankDowndate(A,pth,C,'row');
    A = A(2:size(A,1),:);
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Row Downdating (rank invariant)');

disp(' ');
disp('     Generate A (1030x500) by lrowdw02 ..... ');
[A,tol] = lrowdw02;
[r,~,C] = NumericalRank(A,tol,'low rank');
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Downdate 30 rows ..... ');
t0 = clock;
for jj = 1:30
    pth = 1;
    [r,~,C] = NumericalRankDowndate(A,pth,C,'row');
    A = A(2:size(A,1),:);
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Column Downdating (rank decreasing)');

disp(' ');
disp('     Generate A (1000x530) by lcoldw01 ..... ');
[A,tol] = lcoldw01;
[r,~,C] = NumericalRank(A,tol,'low rank');
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Downdate 30 columns ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,2);
    [r,~,C] = NumericalRankDowndate(A,pth,C,'column');
    A = A(:,1:pth-1);
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('----------------------------------------------------------');
disp(' ');
disp('Demo:  Column Downdating (rank invariant)');

disp(' ');
disp('     Generate A (1000x530) by lcoldw02 ..... ');
[A,tol] = lcoldw02;
[r,Basis,C] = NumericalRank(A,tol,'low rank');
fprintf('                the numerical rank :    %i\n',r);

disp(' ');
disp('     Downdate 30 columns ..... ');
t0 = clock;
for jj = 1:30
    pth = size(A,2);
    [r,Basis,C] = NumericalRankDowndate(A,pth,C,'column');
    A = A(:,1:pth-1);
end
tt = etime(clock,t0);

fprintf('                the numerical rank :    %i\n',r);
fprintf('                      elapsed time :    %g\n',tt);
disp(' ');
disp('==========================================================');

