clear;
addpath('..');

disp(' ');
disp('Demo:    cranfield     (matrix size: 3000x1400)');

[A,s1] = cranfield;

disp('==========================================================');
disp('       Remove  12%  noise');
disp(' ')

tol = s1*0.12;
t0 = clock; [r,U] = NumericalRank(A,tol,'low rank'); tt = etime(clock,t0);
nrmE = norm(A - U*(U'*A));
fprintf('     elapsed time :   %g\n',tt);
fprintf('    computed rank :   %i\n',r);
fprintf('    noise removed :   %3.1f %% \n',(nrmE/s1)*100);

disp('==========================================================');
disp('       Remove  10%  noise');
disp(' ')

tol = s1*0.10;
t0 = clock; [r,U] = NumericalRank(A,tol,'low rank'); tt = etime(clock,t0);
nrmE = norm(A - U*(U'*A));
fprintf('     elapsed time :   %g\n',tt);
fprintf('    computed rank :   %i\n',r);
fprintf('    noise removed :   %3.1f %% \n',(nrmE/s1)*100);

disp('==========================================================');
disp('       Remove  8%  noise');
disp(' ')

tol = s1*0.08;
t0 = clock; [r,U] = NumericalRank(A,tol,'low rank'); tt = etime(clock,t0);
nrmE = norm(A - U*(U'*A));
fprintf('     elapsed time :   %g\n',tt);
fprintf('    computed rank :   %i\n',r);
fprintf('    noise removed :   %3.1f %% \n',(nrmE/s1)*100);
disp('==========================================================');


