% Test script for the vector epsilon-algorithm of Wynn
% testVEAW
% This script show the use of the particular rule in the vector
% epsilon-algorithm of Wynn.

% Authors: Claude Brezinski, Michela Redivo-Zaglia
% V1.0 - December 2016
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clearVEAW
clear variables
format short e
format compact

% Initializations

% From the theory all eps_6^(n) will be the vector zero
MAXCOL = 6;
NBC = 11;

% NDIGIT = 10 No particular rule
% NDIGIT = 10;
% NDIGIT =  8 Particular rule
NDIGIT = 8;

% Set tolerance for denominators
TOL = 1e-20;

% Built the NBC terms of the vector sequence

v = [20, 16, 10, 8, 2]';
for n = 1:NBC
    switch n
        case 1
            Sn(:,n) = 1.59999999*v;
        case 2
            Sn(:,n) = 1.19999999*v;
        case 3
            Sn(:,n) = v;
        otherwise
            Sn(:,n) = Sn(:,n-1)/2 + Sn(:,n-2)/4 + Sn(:,n-3)/8;
    end
end
%

disp('************************************************** ')
disp('An example of the vector epsilon-algorithm of Wynn')
disp('with the use of the particular rule')
disp('************************************************** ')
disp(' ')

% Start the vector epsilon-algorithm

EPSINI = Sn(:,1); 
disp('S_0 = ')
disp(num2str(EPSINI,'%20.10e \n'));
[EPSINI,EPSVEC,NSING]=VEAW(EPSINI,[],MAXCOL,TOL,NDIGIT,0);
disp(['=== diagonal ', num2str(1,'%d'), ' computed ==='])
disp(' ')
for n = 1:NBC-1
   EPSINI = Sn(:,n+1);
   disp(['S_',num2str(n,'%d')]);
   disp(num2str(EPSINI(:),'%20.10e'));
   [EPSINI,EPSVEC,NSING]=VEAW(EPSINI,EPSVEC,MAXCOL,TOL,NDIGIT);
   disp(['=== diagonal ', num2str(n+1,'%d'), ' computed ==='])
   disp(cell2mat(EPSVEC))
   disp('epsilon = ')
   disp(num2str(EPSINI(:),'%20.10e'))
   disp(' ')
end 

% Summary

disp([' Number of terms of the vector sequence  = ',num2str(NBC,'%d')]);
disp([' Tolerance for vector epsilon algorithm  = ',num2str(TOL,'%6.1e')]);
disp([' Number of the common digits             = ',num2str(NDIGIT,'%d')]);
disp([' Maximum column                          = ',num2str(MAXCOL,'%d')]);
disp([' Total number of singularities found in the eps-array = ', ...
    num2str(NSING,'%d')]);