classdef  testVpa < matlab.unittest.TestCase
    %TESTVPA Test converstion to VPA class
    
    properties
        d
    end
    methods(TestMethodSetup)
        function setup(testCase)
            testCase.d = digits;
            digits(40);
        end
    end
    
    methods(Test)
        function testEmpty(testCase)
            p = polysym.empty;
            y = vpa(p);
            testCase.verifyTrue(isempty(y))
        end
        
        function testDefault(testCase)
            p = polysym;
            y = vpa(p);
            testCase.verifyTrue(double(y)==0) % conversion to double needed for R2011 and earlier
        end
        
        function testPi(testCase)
            % Conversions do not recover the exact value, but they are accurate to the
            % expected number of digits.
            x = polysym(vpa(pi));
            y = vpa(x);
            testCase.verifyTrue(abs(double(y-vpa(pi)))<10^(-digits+1))
        end
        
        function testI(testCase)
            x = polysym(1i);
            y = vpa(x);
            testCase.verifyTrue(logical(y==vpa(1i)))
        end
        
        function testStringReal(testCase)
            x = polysym('(1+sqrt(5))/2');
            y = vpa(x);
            testCase.verifyTrue(logical(y==vpa('(1+sqrt(5))/2')))
        end
        
        function testStringMixed(testCase)
            x = polysym('(1+sqrt(5))/2');
            x = [x x*1i];
            y = vpa(x);
            testCase.verifyTrue(all(y(1)==vpa('(1+sqrt(5))/2') && y(2)==1i*vpa('(1+sqrt(5))/2')))
        end
        
        function testArray(testCase)
            x = repmat(polysym('(1+sqrt(5))/2'),2,4);
            y = vpa(x);
            tf = y == repmat(vpa('(1+sqrt(5))/2'),2,4);
            testCase.verifyTrue(all(tf(:)))
        end
        
        function testRand(testCase)
            x = exp(1i*randn(3));
            y = vpa(polysym(x));
            tf = abs(double(y)-x) < eps*100;
            testCase.verifyTrue(all(tf(:)))
        end
        
        function testSetDigits(testCase)
            % Again, the conversions are not exact, but are good to the number of
            % digits expected (in this case, 3)
            x = polysym(pi);
            dd = 3;
            y = vpa(x,dd);
            testCase.verifyTrue(abs(double(y-vpa(pi)))<10^(-dd+1))
        end
    end
    
    methods(TestMethodTeardown)
        function teardown(testCase)
            digits(testCase.d)
        end
    end
end
