classdef  testVertcat < matlab.unittest.TestCase
    %TESTVERTCAT Test overloaded vertical concatenation
    
    methods(Test)
        
        function testEmpty(testCase)
            y = vertcat(polysym.empty);
            testCase.verifyTrue(isempty(y))
        end
        
        function testDefault(testCase)
            y = vertcat(polysym);
            testCase.verifyEqual(y,polysym)
        end
        
        function testRowVector(testCase)
            polysyms('x','y','z')
            w =  vertcat(x,y,z);
            testCase.verifyEqual(w,polysym({'x';'y';'z'}))
        end
        
        function testColumns(testCase)
            polysyms one two three four five six
            w = vertcat([one four],[two five],[three six]);
            testCase.verifyEqual(w,polysym({'one', 'four'; 'two', 'five'; 'three', 'six'}))
        end
        
        function testPartlyEmpty(testCase)
            e = polysym.empty;
            one = polysym('1');
            two = polysym('2');
            v = vertcat(e,one,two);
            testCase.verifyEqual(v,polysym([[]; 1; 2]))
        end
        
        function testPartlyEmptyMultipleRows(testCase)
            e = polysym.empty;
            one = polysym('1');
            two = polysym('2');
            v = [e, one; one; e; e, two];
            testCase.verifyEqual(v,polysym([[],1; 1, []; [], 2]))
        end
        
        function testMixedClass(testCase)
            p1 = polysym('x'); p2 = 'y';
            v = vertcat(p1,p2);
            testCase.verifyEqual(v,polysym({'x';'y'}))
            
        end
    end
end
