classdef  testTril < matlab.unittest.TestCase
    %TESTTRIL Test overloaded extraction of lower triangular part
    
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            testCase.verifyTrue(isempty(p.tril))
        end
        
        function testDefault(testCase)
            p = polysym;
            testCase.verifyEqual(p.tril,p)
        end
        
        function testMultipleChars(testCase)
            p = polysym('xyz');
            testCase.verifyEqual(p.tril,p)
        end
        
        function testNoSecondTerm(testCase)
            M = randi(100,3);
            p = polysym(M);
            testCase.verifyEqual(p.tril,polysym(tril(p)))
        end
        
        function testPositiveDiagonal(testCase)
            M = randi(100,5);
            k = 2;
            p = polysym(M);
            testCase.verifyEqual(tril(p,k),polysym(tril(p,k)))
        end
        
        function testNegativeDiagonal(testCase)
            M = randi(100,5);
            k = -2;
            p = polysym(M);
            testCase.verifyEqual(tril(p,k),polysym(tril(p,k)))
        end
    end
end
