classdef  testTrace < matlab.unittest.TestCase
    %TESTTRACE Test overloaded sum of diagonal elements
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            testCase.verifyTrue(isempty(trace(x)))
        end
        
        function testDefault(testCase)
            x = polysym;
            testCase.verifyEqual(trace(x),x)
        end
        
        function testScalar(testCase)
            x = polysym(pi);
            testCase.verifyEqual(trace(x),x)
        end
        
        function testUnequalDims(testCase)
            x = polysym('x',[1 3]);
            f = @() trace(x);
            testCase.verifyError(f,'polysym:trace:square')
        end
        
        function testMatrix(testCase)
            x = polysym('x',2);
            testCase.verifyEqual(trace(x),x(1,1)+x(2,2))
            
        end
    end
end