classdef  testSymvar < matlab.unittest.TestCase
    %TESTSYMVAR Test overloaded method to find symbolic variables in expression

    methods(Test)
        function testEmpty(testCase)
            vars = symvar(polysym.empty);
            testCase.verifyTrue(isempty(vars))
        end
        
        function testDefault(testCase)
            vars = symvar(polysym);
            testCase.verifyTrue(isempty(vars))
        end
        
        function testOneVar(testCase)
            x = polysym('x');
            vars = symvar(x);
            testCase.verifyEqual(vars,x)
        end
        
        function testMultipleVars(testCase)
            polysyms('x','y','z')
            p = x^2*y^2+y^2*z^2+z^2*x^2;
            vars = symvar(p);
            testCase.verifyEqual(vars,[x y z])
        end
        
        function testArray(testCase)
            p = polysym('M',2);
            vars = p.symvar;
            testCase.verifyEqual(vars,unique(p).')
        end
        
        function testLongerName(testCase)
            polysyms('do','the','twist')
            vars = symvar([twist twist do the]);
            testCase.verifyEqual(vars,[do the twist])
        end
        
        function testNumber(testCase)
            polysyms('x')
            vars = symvar(x*(1+1i));
            testCase.verifyEqual(vars,x)
        end
        
        function testExceptions(testCase)
            p = polysym('2.3*exp(pi*x) + sin(y) + cos(z) + e');
            vars = p.symvar;
            testCase.verifyEqual(vars,polysym({'x','y','z'}))
        end
        
        function testNumberWithExponential(testCase)
            p = polysym('1e10');
            vars = p.symvar;
            testCase.verifyTrue(isempty(vars))
        end
    end
end
