classdef  testSort < matlab.unittest.TestCase
    %TESTSORT Test overloaded sort method
    
    methods(Test)
        
        function testEmpty(testCase)
            [p,ix] = sort(polysym.empty);
            testCase.verifyEqual(p,polysym.empty)
            testCase.verifyEqual(ix,double.empty)
        end
        
        function testDefault(testCase)
            [p,ix] = sort(polysym);
            testCase.verifyEqual(p,polysym)
            testCase.verifyEqual(ix,1)
        end
        
        function testZeros(testCase)
            x = polysym([0 0]);
            [p,ix] = sort(x);
            testCase.verifyEqual(p,x);
            testCase.verifyEqual(ix,[1 2])
        end
        
        function testSortReverseVector(testCase)
            x = polysym(3:-1:1);
            [p,ix] = sort(x);
            testCase.verifyEqual(p,fliplr(x));
            testCase.verifyEqual(ix,[3 2 1])
        end
        
        function testMixedNumericAlphabetic(testCase)
            x = polysym({1, 'x', 2, 'y'});
            [p,ix] = sort(x);
            testCase.verifyEqual(p,x(ix));
            testCase.verifyEqual(ix,[1 3 2 4])
        end
        
        function testMatrix(testCase)
            x = polysym(eye(2));
            [p,ix] = sort(x);
            testCase.verifyEqual(ix,[2 1; 1 2])
            psort = polysym(zeros(2));
            for j = 1:2
                psort(:,j) = x(ix(:,j),j);
            end
            testCase.verifyEqual(psort,p)
            
        end
    end
end
