classdef  testSin < matlab.unittest.TestCase
    %TESTSIN Test overloaded sine function
    
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            testCase.verifyEqual(sin(p),polysym.empty)
        end
        
        function testDefault(testCase)
            % Recall that the default value is 0.
            p = polysym;
            testCase.verifyEqual(sin(p),polysym(0))
        end
        
        function testScalar(testCase)
            polysyms('x')
            p = sin(x);
            testCase.verifyEqual(p,polysym('sin(x)'))
        end
        
        function testVector(testCase)
            x = polysym('x',[1 2]);
            p = sin(x);
            testCase.verifyEqual(p,polysym({'sin(x1)','sin(x2)'}))
            
        end
    end
end
