% Test the method polysyms.real_imag
classdef  testReal_imag < matlab.unittest.TestCase
    methods(Test)
        
        function testValidNumber1(testCase)
            p = polysym('1.23498e-10*I');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym(0))
            testCase.verifyEqual(im,polysym('1.23498e-10'))
        end
        
        function testValidNumber2(testCase)
            p = polysym('10');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym(10))
            testCase.verifyEqual(im,polysym(0))
        end
        
        function testValidNumber3(testCase)
            p = polysym('3.23234*I');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym(0))
            testCase.verifyEqual(im,polysym('3.23234'))
        end
        
        function testValidNumber4(testCase)
            p = polysym('-4');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym(-4))
            testCase.verifyEqual(im,polysym(0))
        end
        
        function testValidNumber5(testCase)
            p = polysym('1e-24 - 10 * I');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym(1e-24))
            testCase.verifyEqual(im,polysym(-10))
        end
        
        function testValidNumber6(testCase)
            p = polysym('1e-24 + 10*I');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym(1e-24))
            testCase.verifyEqual(im,polysym('+10'))
        end
        
        function testValidNumber7(testCase)
            p = polysym(0.0000234i);
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym(0))
            testCase.verifyEqual(im,polysym(0.0000234))
        end
        
        function testValidNumber8(testCase)
            p = polysym('1.234E10');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym('1.234E10'))
            testCase.verifyEqual(im,polysym(0))
        end
        
        function testValidNumber9(testCase)
            p = polysym('1.e10');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym('1.e10'))
            testCase.verifyEqual(im,polysym(0))
        end
        
        function testValidNumber10(testCase)
            p = polysym('.1e10* I');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym(0))
            testCase.verifyEqual(im,polysym('.1e10'))
        end
        
        function testValidNumber11(testCase)
            p = polysym('.1');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym('.1'))
            testCase.verifyEqual(im,polysym(0))
        end
        
        function testValidNumber12(testCase)
            p = polysym('- 1e10');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym('-1e10'))
            testCase.verifyEqual(im,polysym(0))
        end
        
        function testValidNumber13(testCase)
            p = polysym('.10234 + 10.3324e10*I');
            [re,im] = p.real_imag;
            testCase.verifyEqual(re,polysym('.10234'))
            testCase.verifyEqual(im,polysym('+10.3324e10'))
        end
        
        function testInvalidNumber1(testCase)
            p = polysym('e10 *I');
            f = @() p.real_imag;
            testCase.verifyError(f,'polysym:write_number:notNumber')
        end
        
        function testInvalidNumber2(testCase)
            p = polysym('.23e*I');
            f = @() p.real_imag;
            testCase.verifyError(f,'polysym:write_number:notNumber')
        end
        
        function testTooManyImag(testCase)
            p = polysym('.1*I + .2*I');
            f = @() p.real_imag;
            testCase.verifyError(f,'polysym:write_number:tooMany')
        end
        
        function testTooManyReal(testCase)
            p = polysym('.1 + .2 + 3.14*I');
            f = @() p.real_imag;
            testCase.verifyError(f,'polysym:write_number:tooMany')
        end
    end
end
