classdef  testRdivide < matlab.unittest.TestCase
    %TESTRDIVIDE Test overloaded right matrix divide
    
    methods(Test)
        
        function testZeroDividedByReal(testCase)
            x = polysym(0);
            y = polysym(rand);
            z = x./y;
            testCase.verifyTrue(z.Value=='0');
        end
        
        function testZeroDividedByChar(testCase)
            x = polysym(0);
            y = polysym('y');
            z = x./y;
            testCase.verifyTrue(z.Value=='0');
        end
        
        function testZeroDividedByZero(testCase)
            x = polysym(0);
            f = @() x./0;
            testCase.verifyError(f,'polysym:rdivide:DivideByZero')
        end
        
        function testCharDividedByZero(testCase)
            x = polysym('x');
            f = @() x./0;
            testCase.verifyError(f,'polysym:rdivide:DivideByZero')
        end
        
        function testCharDividedByInteger(testCase)
            x = polysym('x');
            z = x./5;
            testCase.verifyEqual(z.Value,'x/5');
        end
        
        function testCharDividedByReal(testCase)
            x = polysym('x');
            y = polysym(pi);
            z = x./y;
            testCase.verifyEqual(z.Value,['x/',y.Value]);
        end
        
        function testRealDividedByChar(testCase)
            x = polysym(pi);
            y = polysym('y');
            z = x./y;
            testCase.verifyEqual(z.Value,[x.Value,'/y']);
        end
        
        function testScalarDividedByVector(testCase)
            x = polysym('x');
            y = polysym(1:3);
            z = x./y;
            testCase.verifyEqual(z(1).Value,'x');
            testCase.verifyEqual(z(2).Value,'x/2');
            testCase.verifyEqual(z(3).Value,'x/3');
        end
        
        function testVectorDividedByVector(testCase)
            x = polysym({'x','y'});
            y = polysym({'u','w'});
            z = x./y;
            testCase.verifyEqual(z(1).Value,'x/u');
            testCase.verifyEqual(z(2).Value,'y/w');
        end
        
        function testDivDiv(testCase)
            % NOTE: This result is undesirable.
            x = polysym('x');
            y = polysym('4/y');
            z = x./y;
            testCase.verifyEqual(z.Value,'x/4/y');
            
        end
    end
end
