classdef  testPower < matlab.unittest.TestCase
    %TESTPOWER Test overloaded matrix power
    
    methods(Test)
        
        function testZeroToZeroPower(testCase)
            % This behavior is consistent with that of MATLAB numbers (0.^0 = 1).
            x = polysym(0);
            z = x.^0;
            testCase.verifyTrue(isone(z));
        end
        
        function testZeroToFirstPower(testCase)
            x = polysym(0);
            z = x.^1;
            testCase.verifyTrue(iszero(z))
        end
        
        function testZeroToSecondPower(testCase)
            x = polysym(0);
            z = x.^2;
            testCase.verifyTrue(iszero(z))
        end
        
        function testOneToPowerGreaterThanOne(testCase)
            x = polysym(1);
            z = x.^2;
            testCase.verifyTrue(isone(z))
        end
        
        function testZeroToPolysymPower(testCase)
            % Only accepts integer for power.
            x = polysym(0);
            f = @() x.^polysym('y');
            testCase.verifyError(f,'MATLAB:power:invalidType')
        end
        
        function testZeroToRealPower(testCase)
            x = polysym(0);
            f = @() x.^pi;
            testCase.verifyError(f,'MATLAB:power:expectedInteger')
        end
        
        function testRealtoZeroPower(testCase)
            r = rand;
            y = polysym(r);
            z = y.^0;
            testCase.verifyTrue(isone(z));
        end
        
        function testChartoZeroPower(testCase)
            % This behavior is consistent with that of MATLAB numbers (0.^0 = 1).
            x = polysym('x');
            z = x.^0;
            testCase.verifyTrue(isone(z));
        end
        
        function testCharMpowerNonzeroInteger(testCase)
            x = polysym('x');
            z = x.^5;
            testCase.verifyEqual(z.Value,'x^5');
        end
        
        function testCharToPowerOne(testCase)
            x = polysym('x');
            z = x.^1;
            testCase.verifyEqual(x.Value,z.Value)
        end
        
        function testRealToPowerOne(testCase)
            r = rand;
            x = polysym(r);
            z = x.^1;
            testCase.verifyEqual(x.Value,z.Value)
        end
        
        function testScalarMpowerVector(testCase)
            x = polysym('x');
            z = x.^(0:2);
            testCase.verifyEqual(z(1).Value,'1')
            testCase.verifyEqual(z(2).Value,'x')
            testCase.verifyEqual(z(3).Value,'x^2')
        end
        
        function testMatrixMpowerZero(testCase)
            % Gives the identity matrix
            x = polysym({'x','y';'u','w'});
            y = x.^0;
            testCase.verifyTrue(isone(y(1)))
            testCase.verifyTrue(isone(y(2)))
            testCase.verifyTrue(isone(y(3)))
            testCase.verifyTrue(isone(y(4)))
        end
        
        function testMpowerOfRowVector(testCase)
            x = polysym({'x','y'});
            z =x.^2;
            testCase.verifyEqual(z(1).Value,'x^2')
            testCase.verifyEqual(z(2).Value,'y^2')
        end
        
        function testMpowerOfColumnVector(testCase)
            x = polysym({'x','y'}');
            z = x.^2;
            testCase.verifyEqual(z(1).Value,'x^2')
            testCase.verifyEqual(z(2).Value,'y^2')
        end
        
        function testMatrixMpowerOne(testCase)
            x = polysym({'x','y';'u','w'});
            z = x.^2;
            testCase.verifyEqual(z(1).Value,'x^2')
            testCase.verifyEqual(z(2).Value,'u^2')
            testCase.verifyEqual(z(3).Value,'y^2')
            testCase.verifyEqual(z(4).Value,'w^2')
        end
    end
end
