classdef  testPlus < matlab.unittest.TestCase
    %TESTPLUS Test overloaded addition
    
    methods(Test)
        
        function testZeros(testCase)
            x = polysym(0);
            y = polysym(0);
            z = x+y;
            testCase.verifyEqual(z.Value,'0');
        end
        
        function testOneZero(testCase)
            x = polysym(0);
            y = polysym('y');
            z = x+y;
            testCase.verifyEqual(z.Value,'y');
        end
        
        function testZeroPlusReal(testCase)
            x = polysym(0);
            y = polysym(pi);
            z = x+y;
            testCase.verifyEqual(z,y);
        end
        
        function testRealPlusChar(testCase)
            x = polysym('x');
            y = polysym(5);
            z = x+y;
            testCase.verifyEqual(z.Value,'x+5');
        end
        
        function testScalarPlusVector(testCase)
            x = polysym('x');
            y = polysym(1:3);
            z = x+y;
            testCase.verifyEqual(z(1).Value,'x+1');
            testCase.verifyEqual(z(2).Value,'x+2');
            testCase.verifyEqual(z(3).Value,'x+3');
        end
        
        function testVectorPlusVector(testCase)
            x = polysym({'x','y'});
            y = polysym({'u','w'});
            z = x+y;
            testCase.verifyEqual(z(1).Value,'x+u');
            testCase.verifyEqual(z(2).Value,'y+w');
        end
        
        function testAssociative1(testCase)
            x = polysym('x');
            y = polysym('4+y');
            z = x+y;
            testCase.verifyEqual(z.Value,'x+4+y');
        end
        
        function testAssociative2(testCase)
            x = polysym('x');
            y = polysym('4*y');
            z = x+y;
            testCase.verifyEqual(z.Value,'x+4*y');
            
        end
    end
end
