classdef  testMpower < matlab.unittest.TestCase
    %TESTMPOWER Test overloaded matrix power
    
    methods(Test)
        
        function testZeroToZeroPower(testCase)
            % This behavior is consistent with that of MATLAB numbers (0^0 = 1).
            x = polysym(0);
            z = x^0;
            testCase.verifyTrue(isone(z));
        end
        
        function testZeroToFirstPower(testCase)
            x = polysym(0);
            z = x^1;
            testCase.verifyTrue(iszero(z))
        end
        
        function testZeroToSecondPower(testCase)
            x = polysym(0);
            z = x^2;
            testCase.verifyTrue(iszero(z))
        end
        
        function testZeroToPolysymPower(testCase)
            % Only accepts integer for power.
            x = polysym(0);
            f = @() x^polysym('y');
            testCase.verifyError(f,'MATLAB:mpower:invalidType')
        end
        
        function testZeroToRealPower(testCase)
            x = polysym(0);
            f = @() x^pi;
            testCase.verifyError(f,'MATLAB:mpower:expectedInteger')
        end
        
        function testOneToPowerGreaterThanOne(testCase)
            x = polysym(1);
            z = x^2;
            testCase.verifyTrue(isone(z))
        end
        
        function testRealtoZeroPower(testCase)
            r = rand;
            y = polysym(r);
            z = y^0;
            testCase.verifyTrue(isone(z));
        end
        
        function testChartoZeroPower(testCase)
            % This behavior is consistent with that of MATLAB numbers (0^0 = 1).
            x = polysym('x');
            z = x^0;
            testCase.verifyTrue(isone(z));
        end
        
        function testCharMpowerNonzeroInteger(testCase)
            x = polysym('x');
            z = x^5;
            testCase.verifyEqual(z.Value,'x^5');
        end
        
        function testCharToPowerOne(testCase)
            x = polysym('x');
            z = x^1;
            testCase.verifyEqual(x.Value,z.Value)
        end
        
        function testRealToPowerOne(testCase)
            r = rand;
            x = polysym(r);
            z = x^1;
            testCase.verifyEqual(x.Value,z.Value)
        end
        
        function testScalarMpowerVector(testCase)
            x = polysym('x');
            f = @() x^(0:2);
            testCase.verifyError(f,'MATLAB:mpower:expectedScalar')
        end
        
        function testMatrixMpowerZero(testCase)
            % Gives the identity matrix
            x = polysym({'x','y';'u','w'});
            y = x^0;
            testCase.verifyTrue(isone(y(1)))
            testCase.verifyTrue(iszero(y(2)))
            testCase.verifyTrue(iszero(y(3)))
            testCase.verifyTrue(isone(y(4)))
        end
        
        function testMpowerOfRowVector(testCase)
            x = polysym({'x','y'});
            f = @() x^2;
            testCase.verifyError(f,'polysym:mpower:notScalarAndSquareMatrix')
        end
        
        function testMpowerOfColumnVector(testCase)
            x = polysym({'x','y'}');
            f = @() x^2;
            testCase.verifyError(f,'polysym:mpower:notScalarAndSquareMatrix')
        end
        
        function testMatrixMpowerOne(testCase)
            x = polysym({'x','y';'u','w'});
            z = x^2;
            testCase.verifyEqual(z(1).Value,'x*x+y*u')
            testCase.verifyEqual(z(2).Value,'u*x+w*u')
            testCase.verifyEqual(z(3).Value,'x*y+y*w')
            testCase.verifyEqual(z(4).Value,'u*y+w*w')
        end
    end
end