classdef  testDouble < matlab.unittest.TestCase
    %TESTDOUBLE Test double conversion
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            y = double(x);
            testCase.verifyTrue(isempty(y))
        end
        
        function testDefault(testCase)
            x = polysym;
            y = double(x);
            testCase.verifyTrue(y==0)
        end
        
        function testPi(testCase)
            x = polysym(pi);
            y = double(x);
            testCase.verifyEqual(y,pi,'AbsTol',eps*100)
        end
        
        function testI(testCase)
            x = polysym(1i);
            y = double(x);
            testCase.verifyEqual(y,1i)
        end
        
        function testStringReal(testCase)
            x = polysym('(1+sqrt(5))/2');
            y = double(x);
            testCase.verifyEqual(y,(1+sqrt(5))/2,'AbsTol',eps*100)
        end
        
        function testStringMixed(testCase)
            x = polysym('(1+sqrt(5))/2');
            x = [x x*1i];
            y = double(x);
            testCase.verifyEqual(y,[1 1i]*(1+sqrt(5))/2,'AbsTol',eps*100)
        end
        
        function testArray(testCase)
            x = repmat(polysym('(1+sqrt(5))/2'),2,4);
            y = double(x);
            testCase.verifyEqual(y,repmat((1+sqrt(5))/2,2,4),'AbsTol',eps*100)
        end
        
        function testRand(testCase)
            x = exp(1i*randn(3));
            y = double(polysym(x));
            testCase.verifyEqual(y,x,'AbsTol',eps*100)
        end
        
        function testImpliedConversion(testCase)
            x = ones(2);
            x(1) = polysym;
            testCase.verifyEqual(x,[0 1; 1 1])
            
        end
    end
end