classdef  testDiff < matlab.unittest.TestCase
    %TESTDIFF Test overloaded diff
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            testCase.verifyTrue(isempty(diff(x)))
        end
        
        function testDefault(testCase)
            x = polysym;
            testCase.verifyTrue(isempty(diff(x)))
        end
        
        function testScalar(testCase)
            x = polysym(pi);
            testCase.verifyTrue(isempty(diff(x)))
        end
        
        function testRowVector(testCase)
            polysyms x y z
            testCase.verifyEqual(diff([x y z]),[y-x z-y])
        end
        
        function testColumnVector(testCase)
            polysyms x y z
            testCase.verifyEqual(diff([x; y; z]),[y-x; z-y])
        end
        
        function testHigherDiff(testCase)
            polysyms x y z
            testCase.verifyEqual(diff([x; y; z],2),(z-y)-(y-x))
        end
        
        function testEvenHigherDiff(testCase)
            polysyms x y z
            testCase.verifyTrue(isempty(diff([x; y; z],3)))
        end
        
        function testInvalidDifferenceOrder(testCase)
            x = polysym('x',[1 3]);
            f = @() diff(x,-1,2);
            testCase.verifyError(f,'MATLAB:polysym:diff:expectedPositive')
        end
        
        function testInvalidDimension(testCase)
            polysyms x
            f = @() diff(x,1,3);
            testCase.verifyError(f,'MATLAB:polysym:diff:notLess')
            
        end
    end
end