classdef  testDiag < matlab.unittest.TestCase
    %TESTDIAG Test overloaded diag
    
    methods(Test)
        
        function testScalar(testCase)
            expected = polysym('0');
            actual = diag(expected);
            testCase.verifyEqual(expected,actual)
        end
        
        function testDiagDiag(testCase)
            expected = polysym('x',[3 1]);
            actual = diag(diag(expected));
            testCase.verifyEqual(expected,actual)
        end
        
        function testVectorDefault(testCase)
            p = polysym('x',[3 1]);
            actual = diag(p);
            expected = polysym({'x1','0','0'; '0','x2','0';'0','0','x3'});
            testCase.verifyEqual(expected,actual)
        end
        
        function testVectorZeroK(testCase)
            p = polysym('x',[3 1]);
            actual = diag(p,0);
            expected = polysym({'x1','0','0'; '0','x2','0';'0','0','x3'});
            testCase.verifyEqual(expected,actual)
        end
        
        function testVectorPositiveK(testCase)
            p = polysym('x',[2 1]);
            actual = diag(p,1);
            expected = polysym({'0','x1','0'; '0','0','x2';'0','0','0'});
            testCase.verifyEqual(expected,actual)
        end
        
        function testVectorNegativeK(testCase)
            p = polysym('x',[2 1]);
            actual = diag(p,-1);
            expected = polysym({'0','0','0'; 'x1','0','0';'0','x2','0'});
            testCase.verifyEqual(expected,actual)
            
        end
    end
end