classdef  testCumsum < matlab.unittest.TestCase
    %TESTCUMSUM Test overloaded cumulative sum
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            testCase.verifyTrue(isempty(cumsum(x)))
        end
        
        function testDefault(testCase)
            x = polysym;
            testCase.verifyTrue(iszero(cumsum(x)))
        end
        
        function testRealScalar(testCase)
            x = polysym(pi);
            testCase.verifyEqual(cumsum(x),x);
        end
        
        function testCharScalar(testCase)
            x = polysym('x');
            testCase.verifyEqual(cumsum(x),x);
        end
        
        function testArrayOfOnes(testCase)
            x = polysym(ones(3,1));
            testCase.verifyEqual(cumsum(x),[x(1); x(1)+x(2); x(1)+x(2)+x(3)])
        end
        
        function testArrayOfZeros(testCase)
            x = polysym(zeros(3,1));
            testCase.verifyEqual(cumsum(x),x)
        end
        
        function testRealVectorWithZero(testCase)
            x = polysym(0:2);
            testCase.verifyEqual(cumsum(x),[x(1) x(2) x(2)+x(3)]);
        end
        
        function testCharColumnVector(testCase)
            x = polysym('x',[3 1]);
            testCase.verifyEqual(cumsum(x),[x(1); x(1)+x(2); x(1)+x(2)+x(3)]);
        end
        
        function testMatrix(testCase)
            x = polysym('x',2);
            testCase.verifyEqual(cumsum(x),[x(1,:); x(1,:)+x(2,:)]);
        end
        
        function testMatrixSecondDim(testCase)
            x = polysym('x',2);
            testCase.verifyEqual(cumsum(x,2),[x(:,1) x(:,1)+x(:,2)]);
        end
        
        function testDimTooLarge(testCase)
            polysyms('x')
            f = @() x.cumsum(3);
            testCase.verifyError(f,'MATLAB:polysym:diff:notLess')
        end
        
        function testDimTooSmall(testCase)
            polysyms('x')
            f = @() x.cumsum(0);
            testCase.verifyError(f,'MATLAB:polysym:diff:notGreater')
            
        end
    end
end
