classdef  testCumprod < matlab.unittest.TestCase
    %TESTCUMPROD Test overloaded cumulative product
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            testCase.verifyTrue(isempty(cumprod(x)))
        end
        
        function testDefault(testCase)
            x = polysym;
            testCase.verifyTrue(iszero(cumprod(x)))
        end
        
        function testRealScalar(testCase)
            x = polysym(pi);
            testCase.verifyEqual(cumprod(x),x);
        end
        
        function testCharScalar(testCase)
            x = polysym('x');
            testCase.verifyEqual(cumprod(x),x);
        end
        
        function testArrayOfOnes(testCase)
            x = polysym(ones(3,1));
            testCase.verifyEqual(cumprod(x),x)
        end
        
        function testRealVectorWithUnity(testCase)
            x = polysym(1:3);
            testCase.verifyEqual(cumprod(x),[x(1) x(2) x(2)*x(3)]);
            
        end
        
        function testCharColumnVector(testCase)
            x = polysym('x',[3 1]);
            testCase.verifyEqual(cumprod(x),[x(1); x(1)*x(2); x(1)*x(2)*x(3)]);
        end
        
        function testMatrix(testCase)
            x = polysym('x',2);
            testCase.verifyEqual(cumprod(x),[x(1,:); x(1,:).*x(2,:)]);
        end
        
        function testMatrixSecondDim(testCase)
            x = polysym('x',2);
            testCase.verifyEqual(cumprod(x,2),[x(:,1) x(:,1).*x(:,2)]);
        end
        
        function testDimTooLarge(testCase)
            polysyms('x')
            f = @() x.cumprod(3);
            testCase.verifyError(f,'MATLAB:polysym:diff:notLess')
        end
        
        function testDimTooSmall(testCase)
            polysyms('x')
            f = @() x.cumprod(0);
            testCase.verifyError(f,'MATLAB:polysym:diff:notGreater')
            
        end
    end
end