classdef  testCos < matlab.unittest.TestCase
    %TESTCOS Test overloaded cosinee
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            y = cos(x);
            testCase.verifyTrue(isempty(y))
        end
        
        function testDefault(testCase)
            x = polysym;
            y = cos(x);
            testCase.verifyEqual(y.Value,'1');
        end
        
        function testZero(testCase)
            x = polysym(0);
            y = cos(x);
            testCase.verifyEqual(y.Value,'1');
        end
        
        function testZeroArray(testCase)
            x = polysym(zeros(1,3));
            y = cos(x);
            testCase.verifyEqual(y(1).Value,'1');
            testCase.verifyEqual(y(2).Value,'1');
            testCase.verifyEqual(y(3).Value,'1');
        end
        
        function testRandReal(testCase)
            r = rand;
            x = polysym(r);
            y = cos(x);
            testCase.verifyEqual(y.Value,['cos(',x.Value,')']);
            
        end
    end
end